/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.filter.FilterServiceHelper;
import kd.bos.util.StringUtils;

public class BillStatsListConfigPlugin
extends AbstractFormPlugin {
    public static final String FORMNAME = "formname";
    public static final String FORMNUM = "formnum";
    public static final String FILTERSCHEMA = "filterschema";
    public static final String APPNUM = "appnum";
    public static final String NUMTITLE = "numtitle";
    public static final String NUMCOLOR = "numcolor";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String MENUID = "menuid";
    private static Log logger = LogFactory.getLog(BillStatsListConfigPlugin.class);
    private static final String COLSECALLBACK_ID_SELBILLFORM = "SelectBillForm";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn_close = (Button)this.getControl("btn_close");
        btn_close.addClickListener((ClickListener)this);
        Button btn_finish = (Button)this.getControl("btn_finish");
        btn_finish.addClickListener((ClickListener)this);
        TextEdit formname = (TextEdit)this.getControl(FORMNAME);
        formname.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "formnum": {
                this.entityChanged((String)newValue);
                this.updatePreview();
                break;
            }
            case "filterschema": {
                if (newValue == null) {
                    return;
                }
                if (newValue.equals("new_schema")) {
                    if (this.getModel().getValue(FORMNUM) == null) {
                        return;
                    }
                    String formNum = (String)this.getModel().getValue(FORMNUM);
                    String appNum = (String)this.getModel().getValue(APPNUM);
                    this.openBillListPage(appNum, formNum, "shema");
                    this.getView().close();
                    return;
                }
                Map schemaMap = null;
                String shemaStr = this.getPageCache().get("shemas");
                schemaMap = (Map)SerializationUtils.fromJsonString((String)shemaStr, Map.class);
                this.getModel().setValue(NUMTITLE, schemaMap.get(newValue));
                this.updatePreview();
                break;
            }
            case "numtitle": {
                this.updatePreview();
                break;
            }
            case "numcolor": {
                this.updatePreview();
                break;
            }
        }
    }

    private void updatePreview() {
        String numtitle = null;
        String numcolor = null;
        if (this.getModel().getValue(NUMTITLE) != null) {
            numtitle = this.getModel().getValue(NUMTITLE).toString();
        }
        if (this.getModel().getValue(NUMCOLOR) != null) {
            numcolor = this.getModel().getValue(NUMCOLOR).toString();
        }
        if (!StringUtils.isEmpty(numcolor)) {
            HashMap<String, String> ctrl = new HashMap<String, String>();
            ctrl.put("fc", numcolor);
            this.getView().updateControlMetadata("labelap1", ctrl);
        }
        Label labSchmemaName = (Label)this.getControl("labfilter");
        if (!StringUtils.isEmpty((String)numtitle)) {
            labSchmemaName.setText(numtitle);
        } else {
            labSchmemaName.setText(ResManager.loadKDString((String)"\u8fc7\u6ee4\u65b9\u6848", (String)"BillStatsListConfigPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void entityChanged(String entityNum) {
        ComboEdit filterSchema = (ComboEdit)this.getControl(FILTERSCHEMA);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        if (StringUtils.isEmpty((String)entityNum)) {
            filterSchema.setComboItems(items);
            this.getModel().setValue(NUMTITLE, null);
            Label labSchmemaName = (Label)this.getControl("labfilter");
            labSchmemaName.setText(ResManager.loadKDString((String)"\u8fc7\u6ee4\u65b9\u6848", (String)"BillStatsListConfigPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        List schemas = FilterServiceHelper.getSchemeList((String)entityNum);
        String local = RequestContext.get().getLang().name();
        HashMap<String, String> schemaMap = new HashMap<String, String>(schemas.size());
        for (int i = 0; i < schemas.size(); ++i) {
            FilterScheme schema = (FilterScheme)schemas.get(i);
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(local, schema.getSchemeName()));
            item.setValue(schema.getId());
            items.add(item);
            schemaMap.put(schema.getId(), schema.getSchemeName());
        }
        ComboItem item = new ComboItem();
        item.setCaption(new LocaleString(local, ResManager.loadKDString((String)"\u65b0\u5efa\u65b9\u6848", (String)"BillStatsListConfigPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])));
        item.setValue("new_schema");
        items.add(item);
        filterSchema.setComboItems(items);
        this.getPageCache().put("shemas", SerializationUtils.toJsonString(schemaMap));
    }

    public void click(EventObject e) {
        super.click(e);
        String key = null;
        Object source = e.getSource();
        if (source instanceof Control) {
            key = ((Control)source).getKey();
        }
        if ("btn_finish".equals(key)) {
            this.setReturnData();
        } else if (FORMNAME.equals(key)) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, COLSECALLBACK_ID_SELBILLFORM));
            fsp.setFormId("bos_card_billselect");
            this.getView().showForm(fsp);
        }
    }

    private void setReturnData() {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("cardType", "bos_card_billstats_list");
        if (this.getModel().getValue(FORMNUM) == null || this.getModel().getValue(FILTERSCHEMA) == null || this.getModel().getValue(NUMTITLE) == null || StringUtils.isEmpty((String)this.getModel().getValue(NUMTITLE).toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5f55\u5165\u4e0d\u5b8c\u6574\uff01", (String)"BillStatsListConfigPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String formNum = (String)this.getModel().getValue(FORMNUM);
        String appNum = (String)this.getModel().getValue(APPNUM);
        String filterschema = this.getModel().getValue(FILTERSCHEMA).toString();
        String numtitle = this.getModel().getValue(NUMTITLE).toString();
        String numcolor = this.getModel().getValue(NUMCOLOR).toString();
        String filterclass = (String)this.getModel().getValue("filterclass");
        String menuid = this.getPageCache().get(MENUID);
        returnMap.put(APPNUM, appNum);
        returnMap.put("entityid", formNum);
        returnMap.put(FILTERSCHEMA, filterschema);
        returnMap.put(NUMTITLE, numtitle);
        returnMap.put(NUMCOLOR, numcolor);
        returnMap.put("filterclass", filterclass);
        returnMap.put(MENUID, menuid);
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (COLSECALLBACK_ID_SELBILLFORM.equals(actionId)) {
            Map retData = (Map)e.getReturnData();
            if (retData == null) {
                return;
            }
            String appNum = (String)retData.get("cache_sel_appNum");
            String formNum = (String)retData.get("cache_sel_formnum");
            String menuid = (String)retData.get("cache_sel_menuid");
            this.getModel().setValue(APPNUM, (Object)appNum);
            this.getModel().setValue(FORMNUM, (Object)formNum);
            String formName = FormMetadataCache.getFormConfig((String)formNum).getCaption().getLocaleValue();
            this.getModel().setValue(FORMNAME, (Object)formName);
            this.getPageCache().put(MENUID, menuid);
        }
    }

    private void openBillListPage(String appNum, String entityNumber, String schemaId) {
        if (StringUtils.isNotEmpty((String)schemaId)) {
            AppInfo appInfo = null;
            try {
                appInfo = AppMetadataCache.getAppInfo((String)appNum);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5e94\u7528\u83b7\u53d6\u4e0d\u5230\u8fd0\u884c\u671f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u662f\u5426\u542f\u7528\u6216\u53ef\u89c1\u3002", (String)"BillStatsListConfigPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), appNum));
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("view", this.getView());
            map.put("appname", appInfo.getName().getLocaleValue());
            String formNum = appInfo.getHomeNum();
            map.put("appmainnumber", formNum);
            map.put("formnumber", entityNumber);
            map.put("parametertype", "ListShowParameter");
            JSONObject parameter = new JSONObject();
            parameter.put("filterSchemeId", (Object)schemaId);
            map.put("parameter", parameter);
            OpenPageUtils.openApp(appNum, schemaId, map, this.getView());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u67e5\u8be2\u65b9\u6848\u3002", (String)"BillStatsListConfigPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }
}

