/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.model.CardCountType;
import kd.bos.portal.model.CountErrorCode;
import kd.bos.portal.model.CountRst;
import kd.bos.portal.model.UnitEnum;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.portal.util.BillCountCardUtils;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.operation.RecordSaveFormServiceHelper;
import kd.bos.util.StringUtils;

public class BillStatsPlugin
extends GridCardPlugin {
    private static Log logger = LogFactory.getLog(BillStatsPlugin.class);
    public static final String LBL_TITLE = "title";
    public static final String LBL_NUM = "label_num";
    public static final String LBL_UNIT = "label_unit";
    public static final String LBL_FIELDNAME = "label_fieldname";
    public static final String FLEX_PANEL = "flexpanelap";
    public static final String KEY_REFRESHCOUNT = "refreshcount";
    public static final String LBL_UPDATETIME = "label_updatetime";
    public static final String IMAGE_IMAGEAP = "imageap";
    public static final String IMAGE_URL = "/images/pc/other/xtfw_loading_32_32.gif";
    public static final String IMAGE_IMAGELOADING = "loadingimg";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        Vector freshControl;
        Label lab_fieldName;
        Label lab_unit;
        super.registerListener(e);
        Label lab_num = (Label)this.getControl(LBL_NUM);
        if (lab_num != null) {
            lab_num.addClickListener((ClickListener)this);
        }
        if ((lab_unit = (Label)this.getControl(LBL_UNIT)) != null) {
            lab_unit.addClickListener((ClickListener)this);
        }
        if ((lab_fieldName = (Label)this.getControl(LBL_FIELDNAME)) != null) {
            lab_fieldName.addClickListener((ClickListener)this);
        }
        if ((freshControl = (Vector)this.getControl(KEY_REFRESHCOUNT)) != null) {
            freshControl.addClickListener((ClickListener)this);
        }
        this.addClickListeners(new String[]{FLEX_PANEL});
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.setloadingImage(Boolean.TRUE);
            this.sendActionReFresh(Boolean.FALSE);
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (e == null || StringUtils.isEmpty((String)e.getName())) {
            return;
        }
        if (e.getName().startsWith("reFresh")) {
            String[] names = e.getName().split("_");
            Boolean isReFresh = Boolean.parseBoolean(names[1]);
            this.reFreshCount(isReFresh);
        }
    }

    @Override
    public void click(EventObject e) {
        super.click(e);
        String key = "";
        Object source = e.getSource();
        if (source instanceof Control) {
            key = ((Control)source).getKey();
        }
        if (key.equals(LBL_FIELDNAME) || key.equals(LBL_NUM) || key.equals(FLEX_PANEL) || key.equals(LBL_UNIT)) {
            if (this.isDesignMode()) {
                this.showConfigForm();
                return;
            }
            String cardStr = this.getPageCache().get("cardMap");
            if (StringUtils.isEmpty((String)cardStr)) {
                return;
            }
            Map cardMap = (Map)SerializationUtils.fromJsonString((String)cardStr, Map.class);
            String entityNumber = (String)cardMap.get("entityid");
            String schemaId = (String)cardMap.get("filterschema");
            String appNum = this.getAppNum(cardMap);
            if (StringUtils.isEmpty((String)appNum)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5361\u7247\u7684\u5e94\u7528ID\u4e3a\u7a7a\uff0c\u5efa\u8bae\u91cd\u65b0\u914d\u7f6e\u3002", (String)"BillStatsPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
                return;
            }
            this.openBillListPage(appNum, entityNumber, schemaId, cardMap);
        }
        if (key.equals(KEY_REFRESHCOUNT)) {
            this.sendActionReFresh(Boolean.TRUE);
        }
    }

    private String getAppNum(Map<String, String> cardMap) {
        String appNum = cardMap.get("appnum");
        if (StringUtils.isNotEmpty((String)appNum)) {
            return appNum;
        }
        String appId = cardMap.get("appid");
        if (StringUtils.isNotEmpty((String)appId)) {
            appNum = AppMetadataCache.getAppNumberById((String)appId);
            return appNum;
        }
        appNum = this.getView().getFormShowParameter().getAppId();
        return appNum;
    }

    private void reFreshCount(Boolean isRefresh) {
        this.setloadingImage(Boolean.FALSE);
        String cardStr = this.getPageCache().get("cardMap");
        if (StringUtils.isEmpty((String)cardStr)) {
            return;
        }
        Map cardMap = (Map)SerializationUtils.fromJsonString((String)cardStr, Map.class);
        String numColor = (String)cardMap.get("numcolor");
        String dataType = (String)cardMap.get("datatype");
        String unit = (String)cardMap.get("unit");
        String scale = (String)cardMap.get("scale");
        BillCountCardUtils billCountCardUtils = new BillCountCardUtils(this.getView(), this.getPageCache(), this.getModel(), logger);
        CountRst countRst = StringUtils.isEmpty((String)dataType) || dataType.equals("count") ? billCountCardUtils.getBillCountWithCache(cardMap, isRefresh, CardCountType.COUNT) : billCountCardUtils.getBillCountWithCache(cardMap, isRefresh, CardCountType.SUM);
        String billCount = countRst.getCount();
        String updatetime = countRst.getTimeStamp();
        BigDecimal billCountBigDecimal = null;
        try {
            billCountBigDecimal = new BigDecimal(billCount);
        }
        catch (Exception exception) {
            logger.info("\u5355\u636e\u7edf\u8ba1\u8fd4\u56de\u9519\u8bef\uff0c\u8f6c\u6362\u5931\u8d25\uff0c\u7ed3\u679c\uff1a" + billCount);
        }
        boolean isEnd = false;
        if (billCountBigDecimal == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LBL_UNIT});
            isEnd = true;
        }
        String errorCode = countRst.getErrorCode();
        if (billCountBigDecimal != null && BigDecimal.ZERO.compareTo(billCountBigDecimal) == 0 || CountErrorCode.SCHEMEDELETE.name().equals(errorCode)) {
            numColor = "#bbbbbb";
            billCount = CountErrorCode.SCHEMEDELETE.name().equals(errorCode) ? countRst.getCount() : "0";
            this.getView().setVisible(Boolean.FALSE, new String[]{LBL_UNIT});
            isEnd = true;
        }
        if (!isEnd && billCountBigDecimal != null && billCountBigDecimal.compareTo(BigDecimal.ZERO) != 0) {
            if (StringUtils.isNotEmpty((String)dataType) && !dataType.equals("count")) {
                if (StringUtils.isNotEmpty((String)unit) && !"1".equals(unit)) {
                    billCountBigDecimal = billCountBigDecimal.divide(new BigDecimal(unit));
                    String unitName = UnitEnum.getName(Integer.valueOf(unit));
                    this.getView().setVisible(Boolean.TRUE, new String[]{LBL_UNIT});
                    Label unitLabel = (Label)this.getControl(LBL_UNIT);
                    unitLabel.setText(unitName);
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{LBL_UNIT});
                }
                if (StringUtils.isNotEmpty((String)scale)) {
                    DecimalFormat df = new DecimalFormat(",##" + scale);
                    billCount = df.format(billCountBigDecimal);
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{LBL_UNIT});
            }
        }
        Label numLabel = (Label)this.getControl(LBL_NUM);
        numLabel.setText(billCount);
        HashMap<String, String> prop = new HashMap<String, String>(1);
        prop.put("fc", numColor);
        if (CountErrorCode.SCHEMEDELETE.name().equals(errorCode)) {
            prop.put("fs", "18px");
        } else {
            prop.put("fs", "60px");
        }
        this.getView().updateControlMetadata(LBL_NUM, prop);
        this.setloadingImage(Boolean.FALSE);
        this.expireTimeUpdate(updatetime, cardMap);
    }

    public void openBillListPage(String appNum, String entityNumber, String schemaId, Map<String, String> cardMap) {
        AppMenuInfo menu;
        AppInfo appInfo = null;
        try {
            appInfo = AppMetadataCache.getAppInfo((String)appNum);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5e94\u7528\u83b7\u53d6\u4e0d\u5230\u8fd0\u884c\u671f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u662f\u5426\u542f\u7528\u6216\u53ef\u89c1\u3002", (String)"BillStatsPlugin_1", (String)"bos-portal-plugin", (Object[])new Object[0]), appNum));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String menuId = cardMap.get("menuid");
        JSONObject parameter = new JSONObject();
        if (StringUtils.isNotEmpty((String)menuId) && Objects.nonNull(menu = AppMetadataCache.getAppMenuInfo((String)appNum, (String)menuId))) {
            map.put("menuname", menu.getName());
            map.put("openType", menu.getOpenType());
            map.put("permItem", menu.getPermission());
            if (Objects.nonNull(menu.getParams())) {
                JSONObject menuParamJson = JSONObject.parseObject((String)menu.getParams());
                parameter.putAll((Map)menuParamJson);
            }
        }
        map.put("view", this.getView());
        map.put("appname", appInfo.getName().getLocaleValue());
        String formNum = appInfo.getHomeNum();
        map.put("appmainnumber", formNum);
        map.put("formnumber", entityNumber);
        map.put("parametertype", "ListShowParameter");
        parameter.put("filterSchemeId", (Object)schemaId);
        map.put("parameter", parameter);
        if (StringUtils.isEmpty((String)menuId)) {
            menuId = CardUtils.findMenuId(appNum, entityNumber);
            if (StringUtils.isEmpty((String)menuId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5361\u7247\u627e\u4e0d\u5230\u83dc\u5355ID\u7684\u4fe1\u606f\uff0c\u5efa\u8bae\u91cd\u65b0\u914d\u7f6e\u5361\u7247\u3002", (String)"BillStatsPlugin_2", (String)"bos-portal-plugin", (Object[])new Object[0]));
                return;
            }
            boolean isAllUserApp = appInfo.isAllUserApp();
            if (isAllUserApp) {
                parameter.put("IsolationOrg", (Object)"false");
            }
        } else {
            boolean isolationOrg = CardUtils.getIsolationOrg(appNum, menuId);
            if (!isolationOrg) {
                parameter.put("IsolationOrg", (Object)"false");
            }
        }
        OpenPageUtils.openAppForCardCount(appNum, menuId, map, this.getView());
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getActionId().equals("Card_Config")) {
            Map retData = (Map)e.getReturnData();
            Map cardInfo = this.getAllConfigMap();
            if (retData == null || retData.size() == 0) {
                return;
            }
            if ("true".equals(retData.get("edit"))) {
                retData.remove("edit");
                if (StringUtils.isEmpty((String)((String)retData.get("appnum")))) {
                    String appnum = cardInfo.get("appnum");
                    retData.put("appnum", appnum);
                }
                if (StringUtils.isEmpty((String)((String)retData.get("menuid")))) {
                    String menuid = (String)cardInfo.get("menuid");
                    retData.put("menuid", menuid);
                }
                cardInfo = retData;
                this.updateAllConfigMap(cardInfo);
                this.refreshCard(cardInfo);
            } else {
                return;
            }
        }
    }

    @Override
    protected void refreshCard(Map<String, String> cardMap) {
        super.refreshCard(cardMap);
        boolean isDesignMode = this.isDesignMode();
        String cardTitleMapEntryStr = cardMap.get("cardtitle");
        String numTitleMapEntryStr = cardMap.get("numtitle");
        String numColor = cardMap.get("numcolor");
        String dataType = cardMap.get("datatype");
        this.setloadingImage(true);
        String billCount = "--";
        numColor = "#bbbbbb";
        HashMap<String, String> prop = new HashMap<String, String>(1);
        prop.put("fc", numColor);
        this.getView().updateControlMetadata(LBL_NUM, prop);
        if (isDesignMode) {
            HashMap<String, Boolean> clickableProp = new HashMap<String, Boolean>(1);
            clickableProp.put("clickable", false);
            this.getView().updateControlMetadata(FLEX_PANEL, clickableProp);
        }
        Label titleLabel = (Label)this.getControl(LBL_TITLE);
        Label numLabel = (Label)this.getControl(LBL_NUM);
        Label nameLabel = (Label)this.getControl(LBL_FIELDNAME);
        LocaleString lsCardTitle = CardUtils.getLocaleStrFromMapEntryStr(cardTitleMapEntryStr);
        if (lsCardTitle == null) {
            titleLabel.setText(cardTitleMapEntryStr);
        } else {
            titleLabel.setText(lsCardTitle.getLocaleValue());
        }
        numLabel.setText(billCount);
        LocaleString lsNumTitle = CardUtils.getLocaleStrFromMapEntryStr(numTitleMapEntryStr);
        if (lsNumTitle == null) {
            nameLabel.setText(numTitleMapEntryStr);
        } else {
            nameLabel.setText(lsNumTitle.getLocaleValue());
        }
        this.getPageCache().put("cardMap", SerializationUtils.toJsonString(cardMap));
        this.setloadingImage(Boolean.TRUE);
        Object isFreshClick = this.getView().getFormShowParameter().getCustomParam("isFreshClick");
        if (isFreshClick != null && Boolean.parseBoolean(isFreshClick.toString())) {
            this.sendActionReFresh(Boolean.TRUE);
        } else {
            this.sendActionReFresh(Boolean.FALSE);
        }
        RecordSaveFormServiceHelper.recordForm((String)cardMap.get("entityid"));
    }

    private void expireTimeUpdate(String updateTime, Map<String, String> cardMap) {
        String useCache = RecordSaveFormServiceHelper.getProptyByTenant((String)"portal.card.use.cache.enable");
        if (StringUtils.isNotEmpty((String)useCache) && !Boolean.parseBoolean(useCache)) {
            return;
        }
        String entityId = cardMap.get("entityid");
        String updateTimeRedisCache = RecordSaveFormServiceHelper.getFormUpdateTimeCache((String)entityId);
        if (StringUtils.isNotEmpty((String)updateTime) && StringUtils.isNotEmpty((String)updateTimeRedisCache) && Long.parseLong(updateTime) < Long.parseLong(updateTimeRedisCache)) {
            this.sendActionReFresh(Boolean.TRUE);
        }
    }

    private void showConfigForm() {
        FormShowParameter fsp = new FormShowParameter();
        Map<String, String> allConfigMap = this.getAllConfigMap();
        String configJson = SerializationUtils.toJsonString(allConfigMap);
        fsp.setCustomParam("configJson", (Object)configJson);
        fsp.setCustomParam("edit", (Object)"true");
        fsp.setCustomParam("source", (Object)"billstats");
        fsp.setFormId("bos_card_billstatsconfig");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setShowTitle(true);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "Card_Config"));
        this.getView().showForm(fsp);
    }

    private void setFreshImage(Boolean isVisible) {
        HashMap<String, Boolean> prop = new HashMap<String, Boolean>(1);
        prop.put("vi", isVisible);
        this.getView().updateControlMetadata(IMAGE_IMAGEAP, prop);
        if (isVisible.booleanValue()) {
            Image icon = (Image)this.getControl(IMAGE_IMAGEAP);
            icon.setUrl(IMAGE_URL);
        }
    }

    private void setloadingImage(Boolean isVisible) {
        HashMap<String, Boolean> prop = new HashMap<String, Boolean>(1);
        prop.put("vi", isVisible);
        this.getView().updateControlMetadata(IMAGE_IMAGELOADING, prop);
        if (isVisible.booleanValue()) {
            Image icon = (Image)this.getControl(IMAGE_IMAGELOADING);
            icon.setUrl(IMAGE_URL);
        }
        HashMap<String, Boolean> propNum = new HashMap<String, Boolean>(1);
        propNum.put("vi", isVisible == false);
        this.getView().updateControlMetadata(LBL_NUM, propNum);
        HashMap<String, Boolean> propUnit = new HashMap<String, Boolean>(1);
        propUnit.put("vi", isVisible == false);
        this.getView().updateControlMetadata(LBL_UNIT, propUnit);
    }

    private void sendActionReFresh(Boolean isFresh) {
        if (isFresh.booleanValue()) {
            this.setloadingImage(isFresh);
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("name", "reFresh_" + isFresh.toString());
        param.put("duration", 0);
        param.put("async", true);
        proxy.addAction("addClientCallBack", param);
    }
}

