/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.QRCode;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.cache.LoginCacheService;
import kd.bos.login.cloudplatform.model.CloudPlatformConfigInfo;
import kd.bos.login.cloudplatform.model.CloudPlatformResult;
import kd.bos.login.cloudplatform.utils.CloudPlatformUtils;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.utils.sms.LoginMessageUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.util.PhoneValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.DisCardUtil;
import kd.bos.util.JSONUtils;

public class BindingCloudAccountPlugin
extends AbstractFormPlugin {
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private LoginCacheService cache = new LoginCacheService("BindingCloudAccount");
    private static final String GETCODETIMES = "getcodetimes";
    private static final String VERIFY_TIMES = "verifyTimes";
    private static final String SENDPHONECODE = "sendphonecode";
    private static final String PHONECOUNTOWNAP = "phonecountdownap";
    private static final String PHONELABELAP = "phonelabelap";
    private static final String PHONESECONDLABEL = "phonesecondlabel";
    private static final String SENDEMAILCODE = "sendemailcode";
    private static final String EMAILCOUNTOWNAP = "emailcountdownap";
    private static final String EMAILLABELAP = "emaillabelap";
    private static final String EMAILSECONDLABEL = "emailsecondlabel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"useragreement", "privacy", "btnbindaccount", SENDPHONECODE, SENDEMAILCODE, "btnbinding", "btniknow"});
        this.addCountDownListener(SENDPHONECODE, PHONECOUNTOWNAP, PHONELABELAP, PHONESECONDLABEL);
        this.addCountDownListener(SENDEMAILCODE, EMAILCOUNTOWNAP, EMAILLABELAP, EMAILSECONDLABEL);
    }

    private void addCountDownListener(final String btnKey, final String countdownap, final String ... lableap) {
        CountDown phoneNewCountDown = (CountDown)this.getControl(countdownap);
        phoneNewCountDown.addCountDownListener(new CountDownListener(){

            public void onCountDownEnd(CountDownEvent evt) {
                BindingCloudAccountPlugin.this.getView().setVisible(Boolean.TRUE, new String[]{btnKey});
                BindingCloudAccountPlugin.this.getView().setVisible(Boolean.FALSE, new String[]{countdownap});
                for (String s : lableap) {
                    BindingCloudAccountPlugin.this.getView().setVisible(Boolean.FALSE, new String[]{s});
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        try {
            String config = DefaultParameterService.getDefaultValueByKey((String)"cloud_customer_service_config");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)config)) {
                return;
            }
            Map configData = (Map)JSONUtils.cast((String)config, HashMap.class);
            CloudPlatformConfigInfo cloudPlatformConfigInfo = new CloudPlatformConfigInfo();
            cloudPlatformConfigInfo.setServiceUrl((String)configData.get("serviceUrl"));
            config = DefaultParameterService.getDefaultValueByKey((String)"login_sms_app_config");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)config)) {
                return;
            }
            configData = (Map)JSONUtils.cast((String)config, HashMap.class);
            cloudPlatformConfigInfo.setSeedId((String)configData.get("seed_app"));
            cloudPlatformConfigInfo.setSeedStr((String)configData.get("seed_app_str"));
            cloudPlatformConfigInfo.setUrl(DefaultParameterService.getDefaultValueByKey((String)"cloud_platform_mcapi_url"));
            if (this.checkInternet(cloudPlatformConfigInfo)) {
                this.getView().getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6388\u6743\u63d0\u9192", (String)"BindingCloudAccountPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnbindaccount"});
            } else {
                this.showTab("scancodetab");
                QRCode code = (QRCode)this.getView().getControl("qrcodeap");
                Map<String, Object> body = this.wrapData(cloudPlatformConfigInfo);
                code.setUrl(CloudPlatformUtils.createQRcode(cloudPlatformConfigInfo, body));
            }
        }
        catch (Exception ex) {
            DisCardUtil.discard();
        }
    }

    private boolean checkInternet(CloudPlatformConfigInfo cloudPlatformConfigInfo) {
        try {
            CloudPlatformResult cloudPlatformResult = CloudPlatformUtils.checkNetWork(cloudPlatformConfigInfo, "1398075987678");
        }
        catch (Exception e) {
            DisCardUtil.discard();
            return false;
        }
        return true;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "useragreement": {
                this.getView().openUrl("https://account.kdcloud.com/privacy?id=3515726087781072896");
                break;
            }
            case "privacy": {
                this.getView().openUrl("https://account.kdcloud.com/privacy?id=3515729708820185088");
                break;
            }
            case "btnbindaccount": {
                this.showTab("verifytab");
                this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u7ed1\u5b9a\u4e91\u8d26\u53f7", (String)"BindingCloudAccountPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])));
                break;
            }
            case "sendphonecode": {
                this.sendPhoneCode();
                break;
            }
            case "sendemailcode": {
                this.sendEmailCode();
                break;
            }
            case "btnbinding": {
                this.bindingCloudAccount();
                break;
            }
        }
    }

    private void sendPhoneCode() {
        try {
            String phone = (String)this.getModel().getValue("phone");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)phone)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u624b\u673a\u53f7\u3002", (String)"BindingCloudAccountPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            PhoneValidator phoneValidator = new PhoneValidator(phone, false);
            String errorMsg = phoneValidator.getErrorMsg();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7\u683c\u5f0f", (String)"PersonInformationPlugin_90", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if (this.sendMessage(phone)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f\u3002", (String)"BindingCloudAccountPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
                this.startCountDown(SENDPHONECODE, PHONECOUNTOWNAP, PHONELABELAP, PHONESECONDLABEL);
            }
        }
        catch (Exception e) {
            this.getView().showSuccessNotification(e.getMessage(), Integer.valueOf(2000));
            return;
        }
    }

    private void sendEmailCode() {
        try {
            String email = (String)this.getModel().getValue("email");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)email)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u90ae\u7bb1\u8d26\u53f7\u3002", (String)"BindingCloudAccountPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            boolean isEmail = StringUtils.isEmail((String)email);
            if (!isEmail) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u90ae\u7bb1\u683c\u5f0f\u3002", (String)"PersonInformationPlugin_101", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if (this.sendMessage(email)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f\u3002", (String)"BindingCloudAccountPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
                this.startCountDown(SENDEMAILCODE, EMAILCOUNTOWNAP, EMAILLABELAP, EMAILSECONDLABEL);
            }
        }
        catch (Exception e) {
            this.getView().showSuccessNotification(e.getMessage(), Integer.valueOf(2000));
            return;
        }
    }

    private void startCountDown(String btnKey, String countdownap, String ... lableap) {
        CountDown countDown = (CountDown)this.getControl(countdownap);
        Account correctAccount = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId());
        int msgTimeout = LoginMessageUtils.getMsgTimeout((Account)correctAccount);
        countDown.setDuration(msgTimeout - 1);
        this.getView().setVisible(Boolean.FALSE, new String[]{btnKey});
        this.getView().setVisible(Boolean.TRUE, new String[]{countdownap});
        for (String s : lableap) {
            this.getView().setVisible(Boolean.TRUE, new String[]{s});
        }
    }

    private void showTab(String key) {
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab(key);
    }

    private boolean sendMessage(String phoneOrEmail) throws Exception, InterruptedException {
        int limitTimes;
        Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        int msgTimeout = LoginMessageUtils.getMsgTimeout((Account)account);
        String sendCodeKey = "sendcode_" + phoneOrEmail;
        String codeCache = this.cache.get(sendCodeKey);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)codeCache)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u79d2\u5185\u4e0d\u80fd\u91cd\u590d\u53d1\u9001\u9a8c\u8bc1\u7801\u3002", (String)"BindingCloudAccountPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), msgTimeout), Integer.valueOf(2000));
            return false;
        }
        String limitTimeCacheKey = phoneOrEmail + GETCODETIMES;
        String total = this.cache.get(limitTimeCacheKey);
        int totalCount = 0;
        if (total != null && (totalCount = Integer.parseInt(total)) >= (limitTimes = 10)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d85\u8fc7\u6bcf\u65e5\u53d1\u9001\u9a8c\u8bc1\u7801\u6b21\u6570\u9650\u5236\u3002", (String)"BindingCloudAccountPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
            return false;
        }
        this.cache.put(limitTimeCacheKey, String.valueOf(++totalCount), this.getSecondsNextDay());
        this.cache.remove(this.getVerifyTimeKey(phoneOrEmail));
        boolean result = this.doSendMessage(phoneOrEmail);
        if (result) {
            this.cache.put(sendCodeKey, "true", msgTimeout);
        }
        return true;
    }

    private String getVerifyTimeKey(String key) {
        return key + VERIFY_TIMES;
    }

    private int getSecondsNextDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(6, 1);
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        long seconds = (cal.getTimeInMillis() - System.currentTimeMillis()) / 1000L;
        return (int)seconds;
    }

    private boolean doSendMessage(String phoneOrEmail) throws Exception, InterruptedException {
        String accountType = (String)this.getModel().getValue("accounttyperadio");
        HashMap<String, Object> body = new HashMap<String, Object>(8);
        body.put("type", "ERP_ACCOUNT_BIND");
        if ("1".equals(accountType)) {
            String phone = (String)this.getModel().getValue("phone");
            body.put("infoType", "PHONE");
            body.put("ccode", "86");
            body.put("phone", BindingCloudAccountPlugin.getPhone(phone));
        } else if ("2".equals(accountType)) {
            String email = (String)this.getModel().getValue("email");
            body.put("infoType", "EMAIL");
            body.put("email", email);
        }
        String config = DefaultParameterService.getDefaultValueByKey((String)"cloud_customer_service_config");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)config)) {
            return false;
        }
        Map configData = (Map)JSONUtils.cast((String)config, HashMap.class);
        CloudPlatformConfigInfo cloudPlatformConfigInfo = new CloudPlatformConfigInfo();
        cloudPlatformConfigInfo.setServiceId((String)configData.get("serviceId"));
        cloudPlatformConfigInfo.setAppId((String)configData.get("app"));
        cloudPlatformConfigInfo.setAppStr((String)configData.get("app_str"));
        if (!configData.containsKey("app") || !configData.containsKey("app_str")) {
            cloudPlatformConfigInfo.setUrl(DefaultParameterService.getDefaultValueByKey((String)"cloud_platform_mcapi_url"));
            cloudPlatformConfigInfo = this.createAppSecretByCloudPlatform(cloudPlatformConfigInfo);
        }
        cloudPlatformConfigInfo.setServiceUrl((String)configData.get("serviceUrl"));
        CloudPlatformResult cloudPlatformResult = CloudPlatformUtils.sendVcodeByCloudPlatform(cloudPlatformConfigInfo, body);
        return cloudPlatformResult.isSuccess();
    }

    private void bindingCloudAccount() {
        try {
            boolean result = this.verifyCode();
            if (result) {
                this.showTab("bindsuccesstab");
                String value = "";
                String accountType = (String)this.getModel().getValue("accounttyperadio");
                value = "1".equals(accountType) ? this.getModel().getValue("phone") + "" : this.getModel().getValue("email") + "";
                Label label = (Label)this.getView().getControl("successtips");
                label.setText(ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\uff08%1$s\uff09\u5df2\u7ecf\u7ed1\u5b9a\u4e91\u8d26\u53f7\uff08%2$s\uff09\uff0c\u60a8\u53ef\u5728\u4ea7\u54c1\u7aef\u8bbf\u95ee\u76f8\u5173\u4e91\u670d\u52a1\u3002", (String)"BindingCloudAccountPlugin_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[]{RequestContext.get().getUserName(), value}));
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage(), Integer.valueOf(2000));
        }
    }

    private boolean verifyCode() throws Exception, InterruptedException {
        int limitTime;
        String code = "";
        String value = "";
        String accountType = (String)this.getModel().getValue("accounttyperadio");
        HashMap<String, Object> body = new HashMap<String, Object>(8);
        if ("1".equals(accountType)) {
            value = (String)this.getModel().getValue("phone");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u624b\u673a\u53f7\u3002", (String)"BindingCloudAccountPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
                return false;
            }
            code = (String)this.getModel().getValue("verifyphonecode");
            body.put("phone", BindingCloudAccountPlugin.getPhone(value));
            body.put("ccode", "86");
        } else if ("2".equals(accountType)) {
            value = (String)this.getModel().getValue("email");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u90ae\u7bb1\u8d26\u53f7\u3002", (String)"BindingCloudAccountPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
                return false;
            }
            code = (String)this.getModel().getValue("verifyemailcode");
            body.put("email", value);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)code)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801\u3002", (String)"BindingCloudAccountPlugin_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        int totalTimes = 0;
        String times = this.cache.get(this.getVerifyTimeKey(value));
        if (times != null && (totalTimes = Integer.parseInt(times)) >= (limitTime = 3)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u53d1\u9001\u9a8c\u8bc1\u7801\u3002", (String)"BindingCloudAccountPlugin_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
            return false;
        }
        String config = DefaultParameterService.getDefaultValueByKey((String)"cloud_customer_service_config");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)config)) {
            return false;
        }
        Map configData = (Map)JSONUtils.cast((String)config, HashMap.class);
        CloudPlatformConfigInfo cloudPlatformConfigInfo = new CloudPlatformConfigInfo();
        cloudPlatformConfigInfo.setAppId((String)configData.get("app"));
        cloudPlatformConfigInfo.setAppStr((String)configData.get("app_str"));
        cloudPlatformConfigInfo.setServiceUrl((String)configData.get("serviceUrl"));
        body.put("dc", RequestContext.get().getAccountId());
        Map productInfo = LicenseServiceHelper.getProductInfo();
        if (productInfo == null) {
            return false;
        }
        body.put("code", productInfo.get("productNo"));
        body.put("erpId", RequestContext.get().getCurrUserId());
        body.put("erpAccount", RequestContext.get().getUserName());
        body.put("username", RequestContext.get().getUserName());
        body.put("vcode", code);
        CloudPlatformResult cloudPlatformResult = CloudPlatformUtils.getBindCodeByCloudPlatform(cloudPlatformConfigInfo, body);
        if (!cloudPlatformResult.isSuccess()) {
            this.cache.put(this.getVerifyTimeKey(value), ++totalTimes + "");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u3002", (String)"BindingCloudAccountPlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        this.cache.remove(this.getVerifyTimeKey(value));
        Object data = cloudPlatformResult.getData();
        Map<String, String> result = new HashMap(8);
        if (data != null) {
            result = (Map)JSONUtils.cast((String)data.toString(), HashMap.class);
            body.put("bindCode", result.get("bindCode"));
            cloudPlatformResult = CloudPlatformUtils.bindCloudAccountByCloudPlatform(cloudPlatformConfigInfo, body);
            if (cloudPlatformResult.isSuccess()) {
                data = cloudPlatformResult.getData();
                result = (Map)JSONUtils.cast((String)data.toString(), HashMap.class);
                this.saveCloudUserRelation(result, value);
            }
            return cloudPlatformResult.isSuccess();
        }
        return false;
    }

    private void saveCloudUserRelation(Map<String, String> result, String value) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        qFilterList.add(new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId()));
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bos_cloud_user_relation", (String)"user,uid,identity,registeraccount", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
        DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"bos_cloud_user_relation");
        if (array != null && array.length > 0) {
            data = array[0];
        }
        data.set("user", (Object)RequestContext.get().getCurrUserId());
        data.set("uid", (Object)result.get("uid"));
        data.set("identity", (Object)result.get("identity"));
        data.set("registeraccount", (Object)value);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)result.get("uid"))) {
            user.set("fuid", (Object)Long.parseLong(result.get("uid")));
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{user});
        }
    }

    private static String getPhone(String phone) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)phone) && phone.contains("-") && phone.split("-").length > 1) {
            return phone.split("-")[1];
        }
        return phone;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"checkboxfield", (CharSequence)fieldKey)) {
            Object flag = this.getModel().getValue("checkboxfield");
            if (flag != null && Boolean.parseBoolean(flag.toString())) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"btnbindaccount"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnbindaccount"});
            }
        }
    }

    private CloudPlatformConfigInfo createAppSecretByCloudPlatform(CloudPlatformConfigInfo cloudPlatformConfigInfo) throws Exception, InterruptedException {
        Map productInfo = LicenseServiceHelper.getProductInfo();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(8);
        if (productInfo == null) {
            return cloudPlatformConfigInfo;
        }
        list.add(productInfo);
        String createAppId = this.cache.get("x-acgw-create-appid_sales");
        CloudPlatformResult cloudPlatformResult = new CloudPlatformResult();
        cloudPlatformConfigInfo.setUrl(DefaultParameterService.getDefaultValueByKey((String)"cloud_platform_mcapi_url"));
        String config = DefaultParameterService.getDefaultValueByKey((String)"login_sms_app_config");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)config)) {
            Map map = (Map)JSONUtils.cast((String)config, HashMap.class);
            cloudPlatformConfigInfo.setSeedId(map.get("seed_app") + "");
            cloudPlatformConfigInfo.setSeedStr(map.get("seed_app_str") + "");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)createAppId)) {
            cloudPlatformResult = CloudPlatformUtils.createAppSecretByCloudPlatform(cloudPlatformConfigInfo, list);
            if (!cloudPlatformResult.isSuccess()) {
                throw new Exception(cloudPlatformResult.getMessage());
            }
            createAppId = cloudPlatformResult.getData() + "";
            this.cache.put("x-acgw-create-appid_sales", createAppId, 600);
            Thread.sleep(3000L);
        }
        if (!(cloudPlatformResult = CloudPlatformUtils.getAppSecretByCloudPlatform(cloudPlatformConfigInfo, createAppId)).isSuccess()) {
            throw new Exception(cloudPlatformResult.getMessage());
        }
        Object data = cloudPlatformResult.getData();
        if (data != null) {
            Map result = (Map)JSONUtils.cast((String)data.toString(), HashMap.class);
            String appId = (String)result.get("appId");
            String appSrt = CloudPlatformUtils.decryptGCM(cloudPlatformConfigInfo.getSeedStr(), (String)result.get("appSrt"));
            cloudPlatformConfigInfo.setAppId(appId);
            cloudPlatformConfigInfo.setAppStr(appSrt);
            Map params = (Map)JSONUtils.cast((String)DefaultParameterService.getDefaultValueByKey((String)"cloud_customer_service_config"), HashMap.class);
            params.put("app", appId);
            params.put("app_str", appSrt);
            params.put("prodInstCode", productInfo.get("prodInstCode"));
            DefaultParameterService.updateDefaultParamsConfig((Account)AccountUtils.getAccountById((String)RequestContext.get().getAccountId()), (String)"cloud_customer_service_config", (String)JSONUtils.toString((Object)params));
        }
        return cloudPlatformConfigInfo;
    }

    private Map<String, Object> wrapData(CloudPlatformConfigInfo cloudPlatformConfigInfo) {
        HashMap<String, Object> body = new HashMap<String, Object>(8);
        body.put("dc", RequestContext.get().getAccountId());
        Map productInfo = LicenseServiceHelper.getProductInfo();
        if (productInfo == null) {
            body.put("code", "UNKNOW");
        } else {
            body.put("code", productInfo.get("productNo"));
        }
        body.put("erpId", RequestContext.get().getCurrUserId());
        body.put("erpAccount", RequestContext.get().getUserName());
        body.put("username", RequestContext.get().getUserName());
        body.put("appId", cloudPlatformConfigInfo.getSeedId());
        return body;
    }
}

