/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.model.AdminType;
import kd.bos.portal.constant.SchemeType;
import kd.bos.portal.constant.scheme.GroupSchemeRel;
import kd.bos.portal.constant.scheme.OrgSchemeRel;
import kd.bos.portal.constant.scheme.RoleSchemeRel;
import kd.bos.portal.constant.scheme.SchemeRel;
import kd.bos.portal.constant.scheme.UserSchemeRel;
import kd.bos.portal.constant.scheme.UserTypeSchemeRel;
import kd.bos.portal.model.CardCountType;
import kd.bos.portal.model.CountRst;
import kd.bos.portal.plugin.ICardCustomFilter;
import kd.bos.portal.util.BillCountCardUtils;
import kd.bos.portal.util.PortalLogUtils;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.filter.FilterServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.model.YzjConfig;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CardUtils {
    public static final String CARD_NAME = "groupname";
    public static final String EVENT_RTN_ADDCARD = "event_rtn_addcard";
    public static final String CARDINDEX_QUICKLAUNCH = "1";
    public static final String CARDINDEX_BILLSTATSCONFIG = "2";
    public static final String CARDINDEX_BILLSTATS_LIST = "3";
    public static final String CARDINDEX_YZJ_SUBSCRIBE_CONFIG = "4";
    public static final String CARDINDEX_MSGCENTER = "5";
    public static final String CARDINDEX_QING_CONFIG = "6";
    public static final String CARDINDEX_CUSTOM_CONFIG = "7";
    public static final String CARDINDEX_USERCENTER_CONFIG = "8";
    public static final String PAGETYPE_MAINPAGE = "main";
    public static final String PAGETYPE_APP = "app";
    public static final String PAGETYPE_CUSTOM_MAINPAGE = "main_";
    public static final String PAGETYPE_CUSTOM = "custom";
    public static final String CONFIG = "config";
    public static final String SCHEME = "scheme.";
    public static final String SCHEME1 = "scheme";
    public static final String PROTAL_SCHEME_GROUP_REL = "protal_scheme_group_rel";
    public static final String ID_DESC = "id desc";
    public static final String ZH_CN = "zh_CN";
    public static final String EN_US = "en_US";
    public static final String NUMTITLE = "numtitle";
    public static final String CARD_UTILS_3 = "CardUtils_3";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String FILTERSCHEMA = "filterschema";
    public static final String ENTITYID = "entityid";
    public static final String FORM_SERVICE = "FormService";
    private IFormView iFormView = null;
    private IPageCache iPageCache = null;
    private IDataModel iDataModel = null;
    public static final String PGCACHE_CURRENT_SCHEME = "pgCache_currentScheme";
    public static final String PGCACHE_CURRENT_SCHEME_TYPE = "pgCache_currentSchemeType";
    public static final String PGCACHE_GRID_LAYOUT = "pgCache_grid_layout";
    public static final String PGCACHE_HIDECARDIDS = "pgCache_hideCardIds";
    public static final String PGCACHE_PERMFILTERCARDINFO = "pgCache_permFilterCardInfo";
    public static final String PREFIX_FIELD = "f:";
    public static final String SHOWABLE_MENULIST = "childMenuList";
    public static final String CTRL_GRIDCONTAINER = "gridcontainerap";
    public static final String CARD_TITLE = "cardtitle";
    private static Log log = LogFactory.getLog(CardUtils.class);

    public CardUtils() {
    }

    public CardUtils(IFormView pFormView, IPageCache pPageCache, IDataModel pDataModel, Log plogger) {
        this.iFormView = pFormView;
        this.iPageCache = pPageCache;
        this.iDataModel = pDataModel;
    }

    public static boolean checkCurSchemeOwner(Long userId, Long schemeId) {
        if (schemeId == null) {
            return false;
        }
        try {
            DynamicObject schemeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"portal_scheme", (String)"id,creator");
            if (schemeObj == null) {
                return false;
            }
            DynamicObject userDynamicObject = schemeObj.getDynamicObject("creator");
            Long creatorId = userDynamicObject.getLong("id");
            if (creatorId.equals(userId)) {
                return true;
            }
        }
        catch (Exception e) {
            log.info("checkCurSchemeOwner error", (Object)e);
        }
        return false;
    }

    public static boolean checkCurSchemeIsEdit(Long schemeId) {
        if (schemeId == null) {
            return false;
        }
        DynamicObject schemeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"portal_scheme", (String)"id,isedit");
        if (schemeObj == null) {
            return false;
        }
        return schemeObj.getBoolean("isedit");
    }

    public static boolean checkCurSchemeCustomable(String schemeId) {
        return CardUtils.checkCurSchemeCustomable(schemeId, null);
    }

    public static boolean checkCurSchemeCustomable(String schemeId, IFormView view) {
        return CardUtils.checkCurSchemeCustomable(schemeId, view, true);
    }

    public static boolean checkCurSchemeCustomable(String schemeId, IFormView view, boolean showTips) {
        Long userId = RequestContext.get().getCurrUserId();
        if (StringUtils.isNotEmpty((String)schemeId)) {
            block9: {
                try {
                    DynamicObject schemeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(schemeId), (String)"portal_scheme", (String)"id,isedit,creator,enable ");
                    if (schemeObj == null) break block9;
                    boolean enable = schemeObj.getBoolean("enable");
                    if (!enable) {
                        if (view != null && showTips) {
                            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"CardUtils_17", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                        }
                        return false;
                    }
                    boolean isedit = schemeObj.getBoolean("isedit");
                    if (!isedit) {
                        boolean canEdit;
                        DynamicObject creatorDy = schemeObj.getDynamicObject("creator");
                        boolean bl = canEdit = creatorDy != null && userId.equals(creatorDy.getLong("id"));
                        if (canEdit) {
                            return true;
                        }
                        break block9;
                    }
                    return true;
                }
                catch (Exception e) {
                    if (view != null && showTips) {
                        view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u53ef\u80fd\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"CardUtils_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    }
                    return false;
                }
            }
            if (view != null && showTips) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e0d\u652f\u6301\u4e2a\u6027\u4fee\u6539\u3002", (String)"CardUtils_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean checkCurSchemeEditable(String schemeId, IFormView view, boolean hasCheckPerm) {
        Long userId = RequestContext.get().getCurrUserId();
        if (StringUtils.isNotEmpty((String)schemeId)) {
            try {
                DynamicObject schemeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(schemeId), (String)"portal_scheme", (String)"id,ispreset");
                boolean isPreset = schemeObj.getBoolean("ispreset");
                if (!isPreset) {
                    if (hasCheckPerm) {
                        return true;
                    }
                    if (CardUtils.checkHasModifySchemeRight(userId)) {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u53ef\u80fd\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"CardUtils_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e3a\u9884\u7f6e\u65b9\u6848\uff0c\u4e0d\u53ef\u4fee\u6539\u3002", (String)"CardUtils_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
        return false;
    }

    public static DynamicObject[] loadAllMainPageCardConfig(Long mainPageLayoutId) {
        String selFields = "id,cardid,config,cardtype,cardtitle,customname";
        Map mainPageCardConfigs = BusinessDataServiceHelper.loadFromCache((String)"bos_mainpagecardconfig", (String)selFields, (QFilter[])new QFilter[]{new QFilter("mainpagelayout", "=", (Object)mainPageLayoutId)});
        if (mainPageCardConfigs == null || mainPageCardConfigs.size() == 0) {
            return new DynamicObject[0];
        }
        HashMap<String, DynamicObject> validCardConfigMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject curDObj : mainPageCardConfigs.values()) {
            long curCardConfigId;
            if (curDObj == null) continue;
            String cardId = curDObj.getString("cardid");
            DynamicObject cardConfigDObj = (DynamicObject)validCardConfigMap.get(cardId);
            if (cardConfigDObj == null) {
                validCardConfigMap.put(cardId, curDObj);
                continue;
            }
            long inMapCardConfigId = cardConfigDObj.getLong("id");
            if (inMapCardConfigId >= (curCardConfigId = curDObj.getLong("id"))) continue;
            validCardConfigMap.put(cardId, curDObj);
        }
        Collection validCardConfigDObjs = validCardConfigMap.values();
        if (CollectionUtils.isEmpty(validCardConfigDObjs)) {
            return new DynamicObject[0];
        }
        for (DynamicObject dObj : validCardConfigDObjs) {
            CardUtils.replaceSomeCardConfigForLangLoad(dObj);
        }
        return validCardConfigDObjs.toArray(new DynamicObject[0]);
    }

    public static List<Long> getCardIdsFromLayout(String layout) {
        ArrayList<Long> cardIdList = new ArrayList<Long>();
        if (StringUtils.isEmpty((String)layout)) {
            return cardIdList;
        }
        JSONArray jsonArr = JSON.parseArray((String)layout);
        for (Object object : jsonArr) {
            JSONObject jsonObj = (JSONObject)object;
            String cardId = jsonObj.getString("i");
            if (StringUtils.isEmpty((String)cardId)) continue;
            long lCardId = 0L;
            try {
                lCardId = Long.parseLong(cardId);
            }
            catch (Exception e) {
                continue;
            }
            cardIdList.add(lCardId);
        }
        return cardIdList;
    }

    public static long getSuperAdmin() {
        QFilter[] filter = null;
        filter = new QFilter[]{new QFilter("type", "=", (Object)10), new QFilter("admintype", "=", (Object)AdminType.Administrator)};
        DynamicObject[] userObjects = null;
        userObjects = BusinessDataServiceHelper.load((String)"perm_admin", (String)"user", (QFilter[])filter);
        if (userObjects.length > 0) {
            return userObjects[0].getLong("user_id");
        }
        return -1L;
    }

    public static Long loadSchemeId(SchemeType schemeType, Long userId, boolean isMainPage, IFormView view) {
        String selFields = "id";
        DynamicObject schemeObj = CardUtils.loadScheme(schemeType, userId, selFields, isMainPage, view);
        if (schemeObj != null) {
            return schemeObj.getLong("id");
        }
        return null;
    }

    public static String getAppIdFromView(IFormView view) {
        String appId = view.getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)appId)) {
            appId = (String)view.getFormShowParameter().getCustomParam("appid");
        }
        String bizAppId = null;
        if (StringUtils.isNotEmpty((String)appId)) {
            AppInfo app = AppMetadataCache.getAppInfo((String)appId);
            bizAppId = app != null ? app.getId() : appId;
        }
        return bizAppId;
    }

    public static DynamicObject loadScheme(SchemeType schemeType, Long userId, String selFields, boolean isMainPage, IFormView view) {
        return CardUtils.loadScheme(schemeType, userId, selFields, null, isMainPage, view);
    }

    public static DynamicObject loadScheme(SchemeType schemeType, Long userId, String selFields, List<QFilter> otherQFilters, boolean isMainPage, IFormView view) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (isMainPage) {
            qFilters.add(new QFilter("schemetype", "=", (Object)schemeType.getValue()));
            qFilters.add(new QFilter("pagetype", "=", (Object)PAGETYPE_MAINPAGE));
            if (schemeType == SchemeType.UserScheme) {
                qFilters.add(new QFilter("creator", "=", (Object)userId));
            }
        } else {
            String pageType = CardUtils.getPageType(view);
            if (PAGETYPE_APP.equals(pageType)) {
                String bizAppId = CardUtils.getAppIdFromView(view);
                qFilters.add(new QFilter("schemetype", "=", (Object)schemeType.getValue()));
                qFilters.add(new QFilter("bizapp", "=", (Object)bizAppId));
                qFilters.add(new QFilter("pagetype", "=", (Object)PAGETYPE_APP));
                if (schemeType == SchemeType.UserScheme) {
                    qFilters.add(new QFilter("creator", "=", (Object)userId));
                }
            } else {
                qFilters.add(new QFilter("schemetype", "=", (Object)schemeType.getValue()));
                qFilters.add(new QFilter("pagetype", "=", (Object)PAGETYPE_CUSTOM));
                qFilters.add(new QFilter("formnum", "=", (Object)view.getEntityId()));
                if (schemeType == SchemeType.UserScheme) {
                    qFilters.add(new QFilter("creator", "=", (Object)userId));
                }
            }
        }
        qFilters.add(new QFilter("enable", "=", (Object)CARDINDEX_QUICKLAUNCH));
        if (!CollectionUtils.isEmpty(otherQFilters)) {
            qFilters.addAll(otherQFilters);
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)"portal_scheme", (String)selFields, (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    @Deprecated
    public static DynamicObject loadMainPageLayout(Long userId, boolean isMainPage, IFormView view) {
        QFilter[] arrQFilter = null;
        if (isMainPage) {
            arrQFilter = new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("pagetype", "=", (Object)PAGETYPE_MAINPAGE)};
        } else {
            String pageType = CardUtils.getPageType(view);
            if (PAGETYPE_APP.equals(pageType)) {
                String bizAppId = CardUtils.getAppIdFromView(view);
                arrQFilter = new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("bizapp", "=", (Object)bizAppId), new QFilter("pagetype", "=", (Object)PAGETYPE_APP)};
            } else {
                arrQFilter = new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("pagetype", "=", (Object)PAGETYPE_CUSTOM), new QFilter("formnum", "=", (Object)view.getEntityId())};
            }
        }
        String selFields = "id,layout,user,pagetype";
        DynamicObject userMainPageLayout = null;
        userMainPageLayout = BusinessDataServiceHelper.loadSingleFromCache((String)"portal_scheme", (String)selFields, (QFilter[])arrQFilter);
        return userMainPageLayout;
    }

    public static HashMap<String, Object> getLayoutForNewCard(String layout, int width, int height) {
        return CardUtils.getLayoutForNewCard(layout, width, height, 12);
    }

    public static HashMap<String, Object> getLayoutForNewCard(String layout, int width, int height, int gridCols) {
        int y;
        int x;
        int y2;
        if (StringUtils.isEmpty((String)layout)) {
            return new HashMap<String, Object>(0);
        }
        List cardList = (List)SerializationUtils.fromJsonString((String)layout, List.class);
        int maxRow = 0;
        Map cardMap = null;
        for (int i = 0; i < cardList.size(); ++i) {
            cardMap = (Map)cardList.get(i);
            y2 = (Integer)cardMap.get("y");
            int h = (Integer)cardMap.get("h");
            int x2 = (Integer)cardMap.get("x");
            int w = (Integer)cardMap.get("w");
            if (y2 > maxRow) {
                maxRow = y2;
            }
            if (y2 + h > maxRow + 1) {
                maxRow = y2 + h;
            }
            if (gridCols >= x2 + w) continue;
            gridCols = x2 + w;
        }
        int[][] gridValue = new int[maxRow + 1][gridCols];
        for (y2 = 0; y2 < maxRow; ++y2) {
            for (x = 0; x < gridCols; ++x) {
                gridValue[y2][x] = 0;
            }
        }
        for (int i = 0; i < cardList.size(); ++i) {
            cardMap = (Map)cardList.get(i);
            x = (Integer)cardMap.get("x");
            y = (Integer)cardMap.get("y");
            int ww = (Integer)cardMap.get("w");
            int hh = (Integer)cardMap.get("h");
            for (int indexY = y; indexY < y + hh; ++indexY) {
                for (int indexX = x; indexX < x + ww; ++indexX) {
                    gridValue[indexY][indexX] = 1;
                }
            }
        }
        if (width > gridCols || width < 1) {
            width = 4;
        }
        if (height <= 0 || height > 5) {
            height = 1;
        }
        int xx = -1;
        int yy = -1;
        for (y = 0; y < maxRow + 1; ++y) {
            for (int x3 = 0; x3 < gridCols && x3 <= gridCols - width; ++x3) {
                int sum = 0;
                for (int wy = y; wy < y + height; ++wy) {
                    if (wy > maxRow) continue;
                    for (int wx = x3; wx < x3 + width; ++wx) {
                        if (gridValue[wy][wx] <= 0) continue;
                        sum = 1;
                        break;
                    }
                    if (sum > 0) break;
                }
                if (sum != 0) continue;
                xx = x3;
                yy = y;
                break;
            }
            if (yy > -1) break;
        }
        if (xx == -1) {
            xx = 0;
        }
        if (yy == -1) {
            yy = maxRow + 1;
        }
        HashMap<String, Object> layoutMap = new HashMap<String, Object>(16);
        layoutMap.put("x", xx);
        layoutMap.put("y", yy);
        layoutMap.put("w", width);
        layoutMap.put("h", height);
        return layoutMap;
    }

    public static void showModifyCaptionForm(IFormView fv, IFormPlugin formPlugin, String cardTitleMapEntryStr) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("bos_card_modifycaption");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setShowTitle(true);
        fsp.setCloseCallBack(new CloseCallBack(formPlugin, "ModifyCardCaption"));
        fsp.setCustomParam(CARD_NAME, (Object)cardTitleMapEntryStr);
        fv.showForm(fsp);
    }

    public static QFilter getCustomFilter(Log logger, IPageCache iPageCache, IFormView formView, IDataModel dataModel, String filterClass, List<QFilter> pSchemaFilter, Map<String, String> pCardMap) {
        QFilter customFilter = null;
        if (StringUtils.isNotEmpty((String)filterClass)) {
            try {
                Class<?> cls = Class.forName(filterClass);
                Method mtd = cls.getMethod("getCustomFilter", new Class[0]);
                ICardCustomFilter cardCustomFilter = (ICardCustomFilter)cls.newInstance();
                boolean isReplaceSchemaFilter = cardCustomFilter.isReplaceSchemaFilter();
                if (pSchemaFilter != null) {
                    cardCustomFilter.setSchemaFilter(pSchemaFilter);
                }
                if (pCardMap != null && pCardMap.size() > 0) {
                    cardCustomFilter.setConfigMap(pCardMap);
                }
                cardCustomFilter.setPageCache(iPageCache);
                cardCustomFilter.setFormView(formView);
                cardCustomFilter.setDataModel(dataModel);
                customFilter = (QFilter)mtd.invoke((Object)cardCustomFilter, new Object[0]);
                if (!isReplaceSchemaFilter) {
                    customFilter = customFilter.and(CardUtils.getQFilterFromFilters(pSchemaFilter));
                }
            }
            catch (Exception e) {
                logger.info("\u5361\u7247\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u7c7b\u53cd\u5c04\u8c03\u7528\u5931\u8d25\uff1a" + e.getLocalizedMessage(), (Object)e);
            }
        }
        if (customFilter == null) {
            return CardUtils.getQFilterFromFilters(pSchemaFilter);
        }
        return customFilter;
    }

    public static List<QFilter> getCustomQFilterList(Log logger, IPageCache iPageCache, IFormView formView, IDataModel dataModel, String filterClass, List<QFilter> pSchemaFilter, Map<String, String> pCardMap) {
        ArrayList<QFilter> customFilters = null;
        if (StringUtils.isNotEmpty((String)filterClass)) {
            try {
                Class<?> cls = Class.forName(filterClass);
                Method mtd = cls.getMethod("getCustomFilterList", new Class[0]);
                ICardCustomFilter cardCustomFilter = (ICardCustomFilter)cls.newInstance();
                boolean isReplaceSchemaFilter = cardCustomFilter.isReplaceSchemaFilter();
                if (pSchemaFilter != null) {
                    cardCustomFilter.setSchemaFilter(pSchemaFilter);
                }
                if (pCardMap != null && pCardMap.size() > 0) {
                    cardCustomFilter.setConfigMap(pCardMap);
                }
                cardCustomFilter.setPageCache(iPageCache);
                cardCustomFilter.setFormView(formView);
                cardCustomFilter.setDataModel(dataModel);
                customFilters = (List)mtd.invoke((Object)cardCustomFilter, new Object[0]);
                if (!isReplaceSchemaFilter) {
                    if (customFilters == null) {
                        customFilters = new ArrayList<QFilter>();
                    }
                    customFilters.add(CardUtils.getQFilterFromFilters(pSchemaFilter));
                }
            }
            catch (Exception e) {
                logger.info("\u5361\u7247\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u7c7b\u53cd\u5c04\u8c03\u7528\u5931\u8d25\uff1a" + e.getLocalizedMessage(), (Object)e);
            }
        }
        if (customFilters != null && !customFilters.isEmpty()) {
            customFilters.add(CardUtils.getQFilterFromFilters(pSchemaFilter));
        }
        return customFilters;
    }

    public static boolean getIsolationOrg(String appNum, String menuId) {
        AppInfo appInfo;
        boolean isAllUserApp;
        boolean isolationOrg = true;
        if (StringUtils.isNotEmpty((String)menuId)) {
            JSONObject jsonObj;
            String strIsolationOrg;
            String falseStr;
            AppMenuInfo menuInfo = AppMetadataCache.getAppMenuInfo((String)appNum, (String)menuId);
            if (menuInfo == null) {
                return isolationOrg;
            }
            String params = menuInfo.getParams();
            if (StringUtils.isNotEmpty((String)params) && (falseStr = "false").equals(strIsolationOrg = (jsonObj = JSON.parseObject((String)params)).getString("IsolationOrg"))) {
                isolationOrg = false;
            }
        } else if (StringUtils.isNotEmpty((String)appNum) && (isAllUserApp = (appInfo = AppMetadataCache.getAppInfo((String)appNum)).isAllUserApp())) {
            isolationOrg = false;
        }
        return isolationOrg;
    }

    public static String getEntityNumByFormNum(String formNum) {
        String entityNumber = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
        String empty = "empty";
        if (StringUtils.isEmpty((String)entityNumber) || empty.equals(entityNumber)) {
            entityNumber = formNum;
        }
        return entityNumber;
    }

    @Deprecated
    public String getBillSum(Map<String, String> cardMap) {
        CountRst countRst = this.getBillCountRst(cardMap, Boolean.TRUE, CardCountType.SUM);
        if (countRst != null) {
            return countRst.getCount();
        }
        return null;
    }

    @Deprecated
    public CountRst getBillSumtWithCache(Map<String, String> cardMap, Boolean isRefresh) {
        CountRst countRst = this.getBillCountRst(cardMap, isRefresh, CardCountType.SUM);
        return countRst;
    }

    @Deprecated
    public String getBillCount(Map<String, String> cardMap) {
        CountRst countRst = this.getBillCountRst(cardMap, Boolean.TRUE, CardCountType.COUNT);
        if (countRst != null) {
            return countRst.getCount();
        }
        return null;
    }

    private CountRst getBillCountRst(Map<String, String> cardMap, Boolean isRefresh, CardCountType cardCountType) {
        if (this.iFormView == null || this.iPageCache == null || this.iDataModel == null) {
            return null;
        }
        BillCountCardUtils billCountCardUtils = new BillCountCardUtils(this.iFormView, this.iPageCache, this.iDataModel, log);
        CountRst countRst = billCountCardUtils.getBillCountWithCache(cardMap, isRefresh, cardCountType);
        return countRst;
    }

    @Deprecated
    public CountRst getBillCountWithCache(Map<String, String> cardMap, Boolean isRefresh) {
        return this.getBillCountRst(cardMap, isRefresh, CardCountType.COUNT);
    }

    public static boolean isHaveSchemeRecord(String schemeId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FSCHEMEID", 12, (Object)schemeId)};
        String sql = "SELECT COUNT(1) FROM T_BAS_FILTERSCHEME T1 WHERE T1.FSCHEMEID =?";
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next() && rs.getInt(1) > 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        boolean isHaveRecord = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)action);
        return isHaveRecord;
    }

    public static QFilter getQFilterFromFilters(List<QFilter> pFilters) {
        QFilter resultFilter = null;
        for (QFilter qf : pFilters) {
            if (qf == null) continue;
            if (resultFilter == null) {
                resultFilter = qf.copy();
                continue;
            }
            resultFilter = resultFilter.and(qf);
        }
        return resultFilter;
    }

    public static String getMainViewFormId(IFormView fv) {
        IFormView mainView = fv.getMainView();
        String mainPageFormId = null;
        if (mainView == null) {
            mainPageFormId = "pc_main_console";
        } else {
            mainPageFormId = mainView.getEntityId();
            if (StringUtils.isEmpty((String)mainPageFormId)) {
                mainPageFormId = "pc_main_console";
            }
        }
        return mainPageFormId;
    }

    public static boolean isMainPage(IFormView mainFormView) {
        String entityId = mainFormView.getEntityId();
        String mainPageFormId = CardUtils.getMainViewFormId(mainFormView);
        return mainPageFormId.equals(entityId);
    }

    public static boolean isAppPage(IFormView formView) {
        String entityNum = formView.getEntityId();
        String appNum = formView.getFormShowParameter().getAppId();
        if (appNum == null) {
            return false;
        }
        String homePageNum = AppMetadataCache.getAppInfo((String)appNum).getHomeNum();
        return entityNum.equals(homePageNum);
    }

    public static boolean isCustomMainPage(IPageCache pPageCache) {
        String isCustomMainPage = pPageCache.get("pgCache_IsCustomMainPage");
        String trueStr = "true";
        return trueStr.equalsIgnoreCase(isCustomMainPage);
    }

    public static String getPageType(IFormView curFormView) {
        String pageType = null;
        pageType = CardUtils.isMainPage(curFormView) ? PAGETYPE_MAINPAGE : (CardUtils.isAppPage(curFormView) ? PAGETYPE_APP : PAGETYPE_CUSTOM);
        return pageType;
    }

    public static LocaleString getLocaleStrFromMapEntryStr(String mapEntryStr) {
        if (StringUtils.isEmpty((String)mapEntryStr)) {
            return null;
        }
        int leftStartIdx = mapEntryStr.indexOf("[");
        int rightStartIdx = mapEntryStr.indexOf("]");
        if (leftStartIdx == -1 || rightStartIdx == -1) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        String entryContentStr = mapEntryStr.substring(leftStartIdx + 1, rightStartIdx);
        if (StringUtils.isEmpty((String)entryContentStr)) {
            return null;
        }
        String[] entryMapArr = entryContentStr.split(",");
        for (int i = 0; i < entryMapArr.length; ++i) {
            String[] keyValueArr;
            if (StringUtils.isEmpty((String)entryMapArr[i]) || (keyValueArr = entryMapArr[i].split("=")) == null || keyValueArr.length == 1) continue;
            map.put(keyValueArr[0].trim(), entryMapArr[i].substring(keyValueArr[0].length() + 1).trim());
        }
        LocaleString ls = LocaleString.fromMap(map);
        return ls;
    }

    public static String getMapEntryStrFromLocaleString(LocaleString lstr) {
        String result = null;
        if (lstr == null) {
            return result;
        }
        StringBuilder sb = new StringBuilder("[");
        int entryCount = lstr.entrySet().size();
        int i = 0;
        for (Map.Entry entry : lstr.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            sb.append(key).append("=").append(value);
            if (i != entryCount - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static String getMapEntryStrFromOrmLocaleValue(OrmLocaleValue olv) {
        String mapEntryStr = olv.entrySet().toString();
        return mapEntryStr;
    }

    public static String findMenuId(String appNum, String entityNum) {
        List appMenusInfoByAppId = AppMetadataCache.getAppMenusInfoByAppId((String)appNum);
        for (AppMenuInfo appMenuInfo : appMenusInfoByAppId) {
            if (!entityNum.equals(appMenuInfo.getFormId())) continue;
            return appMenuInfo.getId();
        }
        return null;
    }

    public static Map<String, Object> getDetailConfigMap(Map<String, String> cardInfo) {
        String configObj = cardInfo.get(CONFIG);
        Map configMap = null;
        if (configObj instanceof String) {
            String config = configObj;
            if (StringUtils.isEmpty((String)config)) {
                return null;
            }
            config = CardUtils.convertToPureJson(config);
            configMap = (Map)SerializationUtils.fromJsonString((String)config, Map.class);
        } else {
            configMap = (Map)((Object)configObj);
        }
        return configMap;
    }

    public static List<Long> getShareSchemeIds(Long userId, IFormView view) {
        String pageType = CardUtils.getPageType(view);
        long start = System.currentTimeMillis();
        List<Long> shareSchemeIds = CardUtils.getShareSchemeIds(userId, view, pageType);
        log.info("getShareSchemeIds cost:" + (System.currentTimeMillis() - start));
        return shareSchemeIds;
    }

    @Deprecated
    public static void removeShareIdsCache(String appId) {
    }

    public static List<Long> getShareSchemeIds(Long userId, IFormView view, String pageType) {
        List<Long> groupSchemeIds = CardUtils.getGroupSchemeIds(userId, view);
        List<Long> orgSchemeIds = CardUtils.getOrgSchemeIds(userId, view);
        List<Long> userSchemeIds = CardUtils.getUserSchemeIds(userId, pageType, view);
        List<Long> roleSchemeIds = CardUtils.getRoleSchemeIds(userId, pageType, view);
        List<Long> usertypeSchemeIds = CardUtils.getUserTypeSchemeIds(userId, pageType, view);
        ArrayList<Long> allShareSchemeIds = new ArrayList<Long>(10);
        if (groupSchemeIds != null) {
            allShareSchemeIds.addAll(groupSchemeIds);
        }
        if (orgSchemeIds != null) {
            allShareSchemeIds.addAll(orgSchemeIds);
        }
        if (userSchemeIds != null) {
            allShareSchemeIds.addAll(userSchemeIds);
        }
        if (roleSchemeIds != null) {
            allShareSchemeIds.addAll(roleSchemeIds);
        }
        if (usertypeSchemeIds != null) {
            allShareSchemeIds.addAll(usertypeSchemeIds);
        }
        return allShareSchemeIds.stream().distinct().sorted(Comparator.comparing(Long::longValue).reversed()).collect(Collectors.toList());
    }

    private static List<Long> getUserTypeSchemeIds(Long userId, String pageType, IFormView view) {
        List<QFilter> qFilters = CardUtils.initBaseFilter(pageType, view);
        List<Long> userTypes = CardUtils.getUserTypeByUserid(userId);
        if (userTypes != null && !userTypes.isEmpty()) {
            qFilters.add(new QFilter("usertypes", "in", userTypes));
            Map schemes = BusinessDataServiceHelper.loadFromCache((String)UserTypeSchemeRel.MAIN_ENTITY_TYPE, (String)SCHEME1, (QFilter[])qFilters.toArray(new QFilter[0]), (String)ID_DESC);
            List<Long> schemeId = schemes.values().stream().map(v -> v.getLong("scheme_id")).distinct().collect(Collectors.toList());
            return schemeId;
        }
        return Collections.emptyList();
    }

    private static List<Long> getUserTypeByUserid(Long userId) {
        DynamicObject load = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"usertypes");
        if (load == null) {
            return Collections.emptyList();
        }
        DynamicObjectCollection usertypes = (DynamicObjectCollection)load.get("usertypes");
        if (usertypes == null || usertypes.isEmpty()) {
            return Collections.emptyList();
        }
        return usertypes.stream().map(CardUtils::getPkIdFromUserType).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Long getPkIdFromUserType(DynamicObject data) {
        if (data == null) {
            return null;
        }
        DynamicObject userTypeData = (DynamicObject)data.get("fbasedataid");
        if (userTypeData == null) {
            return null;
        }
        return (Long)userTypeData.getPkValue();
    }

    private static List<Long> getRoleSchemeIds(Long userId, String pageType, IFormView view) {
        List<QFilter> qFilters = CardUtils.initBaseFilter(pageType, view);
        Set roleIds = PermissionServiceHelper.getRolesByUser((Long)userId);
        if (roleIds != null && !roleIds.isEmpty()) {
            qFilters.add(new QFilter("roles", "in", (Object)roleIds));
            Map schemes = BusinessDataServiceHelper.loadFromCache((String)RoleSchemeRel.MAIN_ENTITY_TYPE, (String)SCHEME1, (QFilter[])qFilters.toArray(new QFilter[0]), (String)ID_DESC);
            List<Long> schemeId = schemes.values().stream().map(v -> v.getLong("scheme_id")).distinct().collect(Collectors.toList());
            return schemeId;
        }
        return Collections.emptyList();
    }

    private static List<Long> getUserSchemeIds(Long userId, String pageType, IFormView view) {
        List<QFilter> qfList = CardUtils.initBaseFilter(pageType, view);
        qfList.add(new QFilter(UserSchemeRel.PROP_USER, "=", (Object)userId));
        Map schemes = BusinessDataServiceHelper.loadFromCache((String)UserSchemeRel.MAIN_ENTITY_TYPE, (String)SCHEME1, (QFilter[])qfList.toArray(new QFilter[0]), (String)ID_DESC);
        List<Long> schemeId = schemes.values().stream().map(v -> v.getLong("scheme_id")).distinct().collect(Collectors.toList());
        return schemeId;
    }

    private static List<QFilter> initBaseFilter(String pageType, IFormView view) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("scheme.pagetype", "=", (Object)pageType));
        qfList.add(new QFilter("scheme.schemetype", "=", (Object)SchemeType.GroupScheme.getValue()));
        qfList.add(new QFilter("scheme.enable", "=", (Object)CARDINDEX_QUICKLAUNCH));
        if (PAGETYPE_APP.equals(pageType)) {
            String bizAppId = CardUtils.getAppIdFromView(view);
            qfList.add(new QFilter("scheme.bizapp", "=", (Object)bizAppId));
        } else if (PAGETYPE_CUSTOM.equals(pageType)) {
            String formNum = view.getEntityId();
            qfList.add(new QFilter("scheme.formnum", "=", (Object)formNum));
        }
        String modeType = CardUtils.convertModeType();
        QFilter isMultiOrgFilter = new QFilter("scheme.ismultiorg", "=", (Object)modeType);
        qfList.add(isMultiOrgFilter);
        return qfList;
    }

    public static List<Long> getGroupSchemeIds(Long userId, IFormView view) {
        Map groupUsers = BusinessDataServiceHelper.loadFromCache((String)"portal_group_user_rel", (String)"group", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
        String pageType = CardUtils.getPageType(view);
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        QFilter groupUserFilter = new QFilter("scheme.creator", "=", (Object)userId);
        if (groupUsers != null && groupUsers.size() > 0) {
            ArrayList<Long> groupIds = new ArrayList<Long>(groupUsers.size());
            for (DynamicObject group : groupUsers.values()) {
                groupIds.add(group.getLong("group_id"));
            }
            groupUserFilter.or(new QFilter("group", "in", groupIds));
        }
        qfList.add(groupUserFilter);
        qfList.add(new QFilter("scheme.pagetype", "=", (Object)pageType));
        qfList.add(new QFilter("scheme.schemetype", "=", (Object)SchemeType.GroupScheme.getValue()));
        qfList.add(new QFilter("scheme.enable", "=", (Object)CARDINDEX_QUICKLAUNCH));
        if (PAGETYPE_APP.equals(pageType)) {
            String bizAppId = CardUtils.getAppIdFromView(view);
            qfList.add(new QFilter("scheme.bizapp", "=", (Object)bizAppId));
        } else if (PAGETYPE_CUSTOM.equals(pageType)) {
            String formNum = view.getEntityId();
            qfList.add(new QFilter("scheme.formnum", "=", (Object)formNum));
        }
        String modeType = CardUtils.convertModeType();
        QFilter isMultiOrgFilter = new QFilter("scheme.ismultiorg", "=", (Object)modeType);
        qfList.add(isMultiOrgFilter);
        Map schemeGroups = BusinessDataServiceHelper.loadFromCache((String)PROTAL_SCHEME_GROUP_REL, (String)SCHEME1, (QFilter[])qfList.toArray(new QFilter[0]), (String)ID_DESC);
        if (schemeGroups != null && schemeGroups.size() > 0) {
            ArrayList<Long> resultList = new ArrayList<Long>(schemeGroups.size());
            for (DynamicObject schemeGroup : schemeGroups.values()) {
                resultList.add(schemeGroup.getLong("scheme_id"));
            }
            return resultList;
        }
        return null;
    }

    public static List<Long> getOrgSchemeIds(Long userId, IFormView view) {
        List<Long> orgIds = CardUtils.getOrgIds(userId);
        if (CollectionUtils.isEmpty(orgIds)) {
            return null;
        }
        String pageType = CardUtils.getPageType(view);
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("org", "in", orgIds));
        qfList.add(new QFilter("scheme.pagetype", "=", (Object)pageType));
        qfList.add(new QFilter("scheme.schemetype", "=", (Object)SchemeType.GroupScheme.getValue()));
        qfList.add(new QFilter("scheme.enable", "=", (Object)CARDINDEX_QUICKLAUNCH));
        if (PAGETYPE_APP.equals(pageType)) {
            String bizAppId = CardUtils.getAppIdFromView(view);
            qfList.add(new QFilter("scheme.bizapp", "=", (Object)bizAppId));
        } else if (PAGETYPE_CUSTOM.equals(pageType)) {
            String formNum = view.getEntityId();
            qfList.add(new QFilter("scheme.formnum", "=", (Object)formNum));
        }
        String modeType = CardUtils.convertModeType();
        QFilter isMultiOrgFilter = new QFilter("scheme.ismultiorg", "=", (Object)modeType);
        qfList.add(isMultiOrgFilter);
        Map schemeGroups = BusinessDataServiceHelper.loadFromCache((String)"bos_orgmainpage_rel", (String)SCHEME1, (QFilter[])qfList.toArray(new QFilter[0]), (String)ID_DESC);
        ArrayList<Long> resultList = new ArrayList<Long>();
        if (schemeGroups != null && schemeGroups.size() > 0) {
            for (DynamicObject schemeGroup : schemeGroups.values()) {
                resultList.add(schemeGroup.getLong("scheme_id"));
            }
            return resultList;
        }
        return null;
    }

    public static List<Long> getOrgIds(Long userId) {
        try {
            ArrayList<Long> orgIds = new ArrayList<Long>(5);
            String selectFields = "id, ispartjob, dpt, position,entryentity";
            QFilter idFilter = new QFilter("id", "=", (Object)userId);
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter[] filters = new QFilter[]{idFilter, enableFilter};
            Map userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)selectFields, (QFilter[])filters);
            if (userMap == null || userMap.isEmpty()) {
                return null;
            }
            for (DynamicObject userObj : userMap.values()) {
                DynamicObjectCollection entryCol = userObj.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryCol) {
                    DynamicObject dpt = (DynamicObject)entry.get("dpt");
                    if (dpt == null) continue;
                    orgIds.add(Long.parseLong(dpt.getPkValue().toString()));
                }
            }
            return orgIds;
        }
        catch (NumberFormatException e) {
            log.info("\u83b7\u53d6\u4eba\u5458\u7ec4\u7ec7\u5f02\u5e38\uff1a", (Object)e);
            return null;
        }
    }

    public static Long getGroupSchemeId(Long userId, IFormView view) {
        List<Long> groupSchemeIds = CardUtils.getShareSchemeIds(userId, view);
        if (groupSchemeIds == null || groupSchemeIds.isEmpty()) {
            return null;
        }
        return groupSchemeIds.get(0);
    }

    public static String replaceBackSlach(String layout) {
        String splitStr = "\\\"";
        while (layout.contains(splitStr)) {
            layout = layout.replaceAll("\\\\\"", "\"");
        }
        return layout;
    }

    private Long saveMainPageLayout(SchemeType schemeType, String layout, Long curSchemeId, DynamicObject saveAsSchemeObj) {
        ORM orm = ORM.create();
        Long userId = RequestContext.get().getCurrUserId();
        String appNum = this.iFormView.getFormShowParameter().getAppId();
        String appId = appNum == null ? null : AppMetadataCache.getAppInfo((String)appNum).getId();
        String formNum = this.iFormView.getEntityId();
        String pageType = CardUtils.getPageType(this.iFormView);
        DynamicObject queryScheme = null;
        String modeType = CardUtils.convertModeType();
        QFilter isMultiOrgDelFilter = new QFilter("mainpagelayout.ismultiorg", "=", (Object)modeType);
        QFilter isMultiOrgQueryFilter = new QFilter("ismultiorg", "=", (Object)modeType);
        String selFields = "id,layout,user,modifier,modifytime,number,name,enable,isedit,ismultiorg";
        ArrayList<QFilter> delQfList = new ArrayList<QFilter>();
        ArrayList<QFilter> queryQfList = new ArrayList<QFilter>();
        ArrayList<QFilter> finalDelQfList_MultiOrg = new ArrayList<QFilter>();
        ArrayList<QFilter> finalQueryQfList_MultiOrg = new ArrayList<QFilter>();
        if (curSchemeId == null) {
            if (schemeType == SchemeType.SysDefScheme || schemeType == SchemeType.UserScheme) {
                delQfList.add(new QFilter("mainpagelayout.enable", "=", (Object)true));
                delQfList.add(new QFilter("mainpagelayout.pagetype", "=", (Object)pageType));
                queryQfList.add(new QFilter("enable", "=", (Object)true));
                queryQfList.add(new QFilter("pagetype", "=", (Object)pageType));
                if (PAGETYPE_APP.equals(pageType)) {
                    delQfList.add(new QFilter("mainpagelayout.bizapp", "=", (Object)appId));
                    queryQfList.add(new QFilter("bizapp", "=", (Object)appId));
                } else if (PAGETYPE_CUSTOM.equals(pageType)) {
                    delQfList.add(new QFilter("mainpagelayout.formnum", "=", (Object)formNum));
                    queryQfList.add(new QFilter("formnum", "=", (Object)formNum));
                }
                if (schemeType == SchemeType.SysDefScheme) {
                    delQfList.add(new QFilter("mainpagelayout.schemetype", "=", (Object)SchemeType.SysDefScheme.getValue()));
                    queryQfList.add(new QFilter("schemetype", "=", (Object)SchemeType.SysDefScheme.getValue()));
                } else if (schemeType == SchemeType.UserScheme) {
                    delQfList.add(new QFilter("mainpagelayout.schemetype", "=", (Object)SchemeType.UserScheme.getValue()));
                    delQfList.add(new QFilter("mainpagelayout.creator", "=", (Object)userId));
                    queryQfList.add(new QFilter("schemetype", "=", (Object)SchemeType.UserScheme.getValue()));
                    queryQfList.add(new QFilter("creator", "=", (Object)userId));
                }
                finalDelQfList_MultiOrg.addAll(delQfList);
                finalDelQfList_MultiOrg.add(isMultiOrgDelFilter);
                finalQueryQfList_MultiOrg.addAll(queryQfList);
                finalQueryQfList_MultiOrg.add(isMultiOrgQueryFilter);
                queryScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"portal_scheme", (String)selFields, (QFilter[])finalQueryQfList_MultiOrg.toArray(new QFilter[0]));
                if (queryScheme != null) {
                    DeleteServiceHelper.delete((String)"bos_mainpagecardconfig", (QFilter[])finalDelQfList_MultiOrg.toArray(new QFilter[0]));
                }
            }
        } else {
            delQfList.add(isMultiOrgDelFilter);
            queryQfList.add(isMultiOrgQueryFilter);
            queryQfList.add(new QFilter("id", "=", (Object)curSchemeId));
            queryScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"portal_scheme", (String)selFields, (QFilter[])queryQfList.toArray(new QFilter[0]));
            if (queryScheme != null) {
                delQfList.add(new QFilter("mainpagelayout", "=", (Object)curSchemeId));
                DeleteServiceHelper.delete((String)"bos_mainpagecardconfig", (QFilter[])delQfList.toArray(new QFilter[0]));
            }
        }
        if (schemeType == SchemeType.GroupScheme && curSchemeId != null && queryScheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u67e5\u627e\u4e0d\u5230\u5f53\u524d\u65b9\u6848ID\uff0c\u53ef\u80fd\u7f13\u5b58\u6709\u95ee\u9898\uff0c\u8bf7\u5c1d\u8bd5\u5237\u65b0\u9875\u9762\u3002", (String)"CardUtils_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
        if (queryScheme == null) {
            queryScheme = BusinessDataServiceHelper.newDynamicObject((String)"portal_scheme");
            queryScheme.set("ismultiorg", (Object)modeType);
            queryScheme.set("creator", (Object)userId);
            queryScheme.set("pagetype", (Object)pageType);
            queryScheme.set("createtime", (Object)new Date());
            if (schemeType == SchemeType.SysDefScheme) {
                queryScheme.set("schemetype", (Object)SchemeType.SysDefScheme.getValue());
                queryScheme.set("isedit", (Object)CARDINDEX_QUICKLAUNCH);
            } else if (schemeType == SchemeType.GroupScheme) {
                queryScheme.set("schemetype", (Object)SchemeType.GroupScheme.getValue());
                queryScheme.set("isedit", (Object)saveAsSchemeObj.getBoolean("isedit"));
                queryScheme.set("number", (Object)saveAsSchemeObj.getString("number"));
            } else {
                queryScheme.set("schemetype", (Object)SchemeType.UserScheme.getValue());
                queryScheme.set("isedit", (Object)CARDINDEX_QUICKLAUNCH);
            }
            if (PAGETYPE_APP.equals(pageType)) {
                queryScheme.set("bizapp", (Object)appId);
            }
            if (PAGETYPE_CUSTOM.equals(pageType)) {
                queryScheme.set("formnum", (Object)formNum);
            }
            queryScheme.set("user", (Object)0L);
            if (StringUtils.isEmpty((String)queryScheme.getString("number"))) {
                String schemeNum = CodeRuleServiceHelper.getNumber((String)"portal_scheme", (DynamicObject)queryScheme, null);
                if (StringUtils.isEmpty((String)schemeNum)) {
                    Long lnum = orm.genLongId("portal_scheme");
                    schemeNum = Long.toString(lnum);
                }
                queryScheme.set("number", (Object)schemeNum);
            }
            String pageTypeName = "";
            if (PAGETYPE_APP.equals(pageType)) {
                pageTypeName = ResManager.loadKDString((String)"\u5e94\u7528\u9996\u9875", (String)"CardUtils_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            } else if (PAGETYPE_MAINPAGE.equals(pageType)) {
                pageTypeName = ResManager.loadKDString((String)"\u7cfb\u7edf\u9996\u9875", (String)"CardUtils_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            } else if (PAGETYPE_CUSTOM.equals(pageType)) {
                pageTypeName = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6805\u683c\u5e03\u5c40", (String)"CardUtils_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            }
            String userName = "";
            if (schemeType == SchemeType.UserScheme) {
                Map userInfoByID = UserServiceHelper.getUserInfoByID((long)userId);
                userName = userInfoByID.get("name") + "";
            }
            String schemeName = null;
            String appName = "";
            if (StringUtils.isNotEmpty((String)appId)) {
                appName = AppMetadataCache.getAppInfo((String)appNum).getName().getLocaleValue();
            }
            if (appName.length() > 40) {
                appName = appName.substring(0, 40);
            }
            if (schemeType == SchemeType.SysDefScheme) {
                schemeName = String.format(ResManager.loadKDString((String)"%1$s%2$s\u9ed8\u8ba4\u65b9\u6848", (String)"CardUtils_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), appName, pageTypeName);
            } else if (schemeType == SchemeType.GroupScheme) {
                schemeName = saveAsSchemeObj.getString("name");
            } else {
                if (userName.length() > 40) {
                    userName = userName.substring(0, 40);
                }
                schemeName = String.format(ResManager.loadKDString((String)"%1$s\u7684%2$s%3$s\u4e2a\u6027\u65b9\u6848", (String)"CardUtils_11", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), userName, appName, pageTypeName);
            }
            String langName = RequestContext.get().getLang().name();
            LocaleString scheme = null;
            switch (langName) {
                case "zh_CN": {
                    scheme = new LocaleString(ZH_CN, schemeName);
                    break;
                }
                case "zh_TW": {
                    scheme = new LocaleString("zh_TW", schemeName);
                    break;
                }
                case "en_US": {
                    scheme = new LocaleString(EN_US, schemeName);
                    break;
                }
                default: {
                    scheme = new LocaleString(EN_US, schemeName);
                }
            }
            queryScheme.set("name", (Object)scheme);
            queryScheme.set("enable", (Object)CARDINDEX_QUICKLAUNCH);
            queryScheme.set("ismultiorg", (Object)modeType);
        } else {
            queryScheme.set("modifier", (Object)userId);
            queryScheme.set("modifytime", (Object)new Date());
        }
        queryScheme.set("layout", (Object)layout);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{queryScheme});
        Long schemeId = (Long)queryScheme.getPkValue();
        if (schemeType == SchemeType.GroupScheme && saveAsSchemeObj != null) {
            this.saveMainPageRel(saveAsSchemeObj.getDynamicObjectCollection("groupids"), schemeId, new GroupSchemeRel());
            this.saveMainPageRel(saveAsSchemeObj.getDynamicObjectCollection("orgids"), schemeId, new OrgSchemeRel());
            this.saveMainPageRel(saveAsSchemeObj.getDynamicObjectCollection("userids"), schemeId, new UserSchemeRel());
            this.saveMainPageRel(saveAsSchemeObj.getDynamicObjectCollection("roleids"), schemeId, new RoleSchemeRel());
            this.saveMainPageRel(saveAsSchemeObj.getDynamicObjectCollection("usertypeids"), schemeId, new UserTypeSchemeRel());
        }
        return schemeId;
    }

    private void saveMainPageRel(DynamicObjectCollection usertypeids, Long schemeId, SchemeRel type) {
        ArrayList<DynamicObject> relations = new ArrayList<DynamicObject>();
        for (DynamicObject id : usertypeids) {
            DynamicObject groupBean = (DynamicObject)id.get(1);
            DynamicObject schemeGroupRel = BusinessDataServiceHelper.newDynamicObject((String)type.getEntityName());
            schemeGroupRel.set(type.getFieldName(), groupBean.getPkValue());
            schemeGroupRel.set(SCHEME1, (Object)schemeId);
            relations.add(schemeGroupRel);
        }
        SaveServiceHelper.save((DynamicObject[])relations.toArray(new DynamicObject[0]));
    }

    private void saveMainPageAllCardConfig(SchemeType schemeType, Long schemeId, String layout, Map<String, String> allCardConfigMap) {
        List<Long> cardIds = CardUtils.getCardIdsFromLayout(layout);
        DeleteServiceHelper.delete((String)"bos_mainpagecardconfig", (QFilter[])new QFilter[]{new QFilter("mainpagelayout", "=", (Object)schemeId)});
        ArrayList<DynamicObject> newDObjs = new ArrayList<DynamicObject>(1);
        for (Long cardId : cardIds) {
            String cardConfigStr = allCardConfigMap.get(String.valueOf(cardId));
            if (StringUtils.isEmpty((String)cardConfigStr)) continue;
            Map oneCardConfigMap = (Map)SerializationUtils.fromJsonString((String)cardConfigStr, Map.class);
            String cardType = (String)oneCardConfigMap.get("cardType");
            boolean isSetDefault = schemeType == SchemeType.SysDefScheme || schemeType == SchemeType.GroupScheme;
            String configStr = SerializationUtils.toJsonString((Object)oneCardConfigMap);
            configStr = CardUtils.convertToPureJson(configStr);
            Map configMap = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
            LocaleString lsCardTitle = this.replaceCardTitleConfigForLangSave(configMap);
            LocaleString lsCustomName = this.replaceSomeCardConfigForLangSave(cardType, configMap);
            configStr = SerializationUtils.toJsonString((Object)configMap);
            configStr = CardUtils.convertToPureJson(configStr);
            DynamicObject newDObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_mainpagecardconfig");
            newDObj.set("cardid", (Object)cardId);
            newDObj.set("user", (Object)0L);
            newDObj.set("cardtype", (Object)cardType);
            newDObj.set(CONFIG, (Object)configStr);
            newDObj.set("mainpagelayout", (Object)schemeId);
            newDObj.set(CARD_TITLE, (Object)lsCardTitle);
            newDObj.set("customname", (Object)lsCustomName);
            newDObjs.add(newDObj);
        }
        if (newDObjs != null && newDObjs.size() > 0) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)newDObjs.get(0)).getDataEntityType(), (Object[])newDObjs.toArray(new Object[0]));
        }
    }

    private static boolean isBillPreSchema(String entityId, String schemaId) {
        List schemeList = FilterServiceHelper.getPreSchemeList((String)entityId);
        ArrayList<String> schemeIdList = new ArrayList<String>();
        if (schemeList != null && schemeList.size() > 0) {
            for (FilterScheme scheme : schemeList) {
                schemeIdList.add(scheme.getId());
            }
            return schemeIdList.contains(schemaId);
        }
        return false;
    }

    public boolean saveMainPageInfo(SchemeType schemeType, String layout, Map<String, String> allCardConfigMap, Long curSchemeId, DynamicObject saveAsObj) {
        if (StringUtils.isEmpty((String)layout)) {
            return false;
        }
        try (TXHandle txHandle = TX.required();){
            try {
                Long schemeId = this.saveMainPageLayout(schemeType, layout, curSchemeId, saveAsObj);
                this.saveMainPageAllCardConfig(schemeType, schemeId, layout, allCardConfigMap);
                this.iPageCache.put(PGCACHE_CURRENT_SCHEME, String.valueOf(schemeId));
                this.iPageCache.put(PGCACHE_CURRENT_SCHEME_TYPE, schemeType.getValue());
                DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"portal_scheme");
                String schemeName = schemeObj.getString("name");
                if (schemeId.equals(curSchemeId)) {
                    PortalLogUtils.addLog("portal_scheme", "2deb950100005dac", "save", new MultiLangEnumBridge("\u4fdd\u5b58", "CardUtils_9", BOS_PORTAL_PLUGIN), new MultiLangEnumBridge("%s\u4fdd\u5b58\u6210\u529f\u3002", "CardUtils_14", BOS_PORTAL_PLUGIN), schemeName);
                } else {
                    PortalLogUtils.addLog("portal_scheme", "2deb950100005dac", "save", new MultiLangEnumBridge("\u4fdd\u5b58", "CardUtils_9", BOS_PORTAL_PLUGIN), new MultiLangEnumBridge("\u4fdd\u5b58%1$s\uff1a%2$s\u3002", "CardUtils_15", BOS_PORTAL_PLUGIN), schemeType.getName(), schemeName);
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                String errorInfo = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25:", (String)"CardUtils_16", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                log.info(errorInfo, (Object)e);
                this.iFormView.showErrorNotification(errorInfo + e.getMessage());
                boolean bl = false;
                if (txHandle != null) {
                    if (var7_7 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    public static String getNewLayout(IFormView mainPageFormView, String gridContainerKey) {
        String newLayout = "";
        try {
            IPageCache mainPageCache = (IPageCache)mainPageFormView.getService(IPageCache.class);
            String controlstates = mainPageCache.get("controlstates");
            JSONObject object = (JSONObject)JSONObject.parse((String)controlstates);
            String string = newLayout = object == null || object.getJSONObject(gridContainerKey) == null ? null : object.getJSONObject(gridContainerKey).getString("layout");
            if (StringUtils.isEmpty((String)newLayout)) {
                newLayout = mainPageCache.get(PGCACHE_GRID_LAYOUT);
            } else {
                mainPageCache.put(PGCACHE_GRID_LAYOUT, newLayout);
            }
        }
        catch (Exception e) {
            log.info("getNewLayout: ", (Object)e);
        }
        return newLayout;
    }

    public static String getNewLayoutInMainpageCache(IFormView mainPageFormView) {
        IPageCache mainPageCache = (IPageCache)mainPageFormView.getService(IPageCache.class);
        String newLayout = mainPageCache.get(PGCACHE_GRID_LAYOUT);
        return newLayout;
    }

    public static boolean checkHasModifySchemeRight(Long userId) {
        String appIdPortal = "3CB4=UTSOT52";
        String setDefaultLayoutEnittyNum = "bos_portal_setlayout";
        int hasPerm = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)0L, (String)appIdPortal, (String)setDefaultLayoutEnittyNum, (String)"4715a0df000000ac");
        log.info(String.format("checkPermission:%s, userid:%s", hasPerm, userId));
        return hasPerm == 1;
    }

    public static String convertToPureJson(String configStr) {
        configStr = CardUtils.replaceBackSlach(configStr);
        configStr = configStr.replaceAll("\"\\{", "\\{").replaceAll("\\}\"", "\\}");
        return configStr;
    }

    private LocaleString replaceSomeCardConfigForLangSave(String cardType, Map<String, Object> configMap) {
        LocaleString result = null;
        if ("bos_card_billstats".equals(cardType)) {
            String numtitle = (String)configMap.get(NUMTITLE);
            result = CardUtils.getLocaleStrFromMapEntryStr(numtitle);
            if (result == null) {
                result = new LocaleString(ZH_CN, numtitle);
            }
            configMap.put(NUMTITLE, "f:customname");
        } else if ("bos_card_billstats_list".equals(cardType)) {
            Object detailConfigObj = configMap.get(CONFIG);
            Map detailConfigMap = null;
            if (detailConfigObj instanceof Map) {
                detailConfigMap = (Map)detailConfigObj;
            } else if (detailConfigObj instanceof String) {
                detailConfigMap = (Map)SerializationUtils.fromJsonString((String)((String)detailConfigObj), Map.class);
            }
            if (detailConfigMap == null) {
                return new LocaleString();
            }
            ArrayList<LocaleString> list = new ArrayList<LocaleString>(1);
            for (Map.Entry entry : detailConfigMap.entrySet()) {
                Object oneItemObj = entry.getValue();
                Map<String, String> oneItemMap = new HashMap(2);
                if (oneItemObj instanceof Map) {
                    oneItemMap = (Map)oneItemObj;
                } else if (oneItemObj instanceof String) {
                    oneItemMap = (Map)SerializationUtils.fromJsonString((String)((String)oneItemObj), Map.class);
                }
                String strNumTitle = (String)oneItemMap.get(NUMTITLE);
                LocaleString lsNumTitle = CardUtils.getLocaleStrFromMapEntryStr(strNumTitle);
                if (lsNumTitle == null) {
                    lsNumTitle = new LocaleString(ZH_CN, strNumTitle);
                }
                list.add(lsNumTitle);
                oneItemMap.put(NUMTITLE, "f:customname");
            }
            result = new LocaleString();
            for (LocaleString lStr : list) {
                for (Map.Entry entry : lStr.entrySet()) {
                    String key = (String)entry.getKey();
                    result.put(key, (Object)"");
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                LocaleString lStr;
                lStr = (LocaleString)list.get(i);
                for (String key : result.keySet()) {
                    String value = (String)lStr.get((Object)key);
                    String oldValue = (String)result.get((Object)key);
                    if (StringUtils.isEmpty((String)value)) {
                        value = "";
                    }
                    if (i == 0) {
                        result.put(key, (Object)value);
                        continue;
                    }
                    result.put(key, (Object)(oldValue + "," + value));
                }
            }
        }
        return result;
    }

    private static void replaceSomeCardConfigForLangLoad(DynamicObject cardConfigObj) {
        String cardType = cardConfigObj.getString("cardtype");
        String configStr = cardConfigObj.getString(CONFIG);
        if (StringUtils.isEmpty((String)(configStr = CardUtils.convertToPureJson(configStr)))) {
            return;
        }
        Map configMap = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
        if ("bos_card_billstats".equals(cardType)) {
            ILocaleString localeStr;
            String numtitleValue = (String)configMap.get(NUMTITLE);
            String numTitleFieldName = "";
            if (numtitleValue.startsWith(PREFIX_FIELD) && (numTitleFieldName = numtitleValue.substring(PREFIX_FIELD.length())).equals("customname") && (localeStr = cardConfigObj.getLocaleString("customname")) instanceof OrmLocaleValue) {
                OrmLocaleValue olv = (OrmLocaleValue)localeStr;
                String mapEntryStr = olv.entrySet().toString();
                configMap.put(NUMTITLE, mapEntryStr);
                configStr = SerializationUtils.toJsonString((Object)configMap);
                cardConfigObj.set(CONFIG, (Object)configStr);
            }
        } else if ("bos_card_billstats_list".equals(cardType)) {
            Object detailConfigObj = configMap.get(CONFIG);
            if (detailConfigObj == null) {
                return;
            }
            if (detailConfigObj instanceof Map) {
                Map detailConfigMap = (Map)detailConfigObj;
                int statsItemCount = detailConfigMap.size();
                if (statsItemCount == 0) {
                    return;
                }
                ILocaleString localeStr = cardConfigObj.getLocaleString("customname");
                LocaleString[] lstrArr = new LocaleString[statsItemCount];
                if (localeStr instanceof OrmLocaleValue) {
                    OrmLocaleValue olv = (OrmLocaleValue)localeStr;
                    for (Map.Entry entry : olv.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        if (StringUtils.isEmpty((String)value)) continue;
                        String[] valueArr = value.split(",");
                        if (lstrArr.length < valueArr.length) {
                            String[] valueArrNew = new String[lstrArr.length];
                            System.arraycopy(valueArr, 0, valueArrNew, 0, lstrArr.length);
                            valueArr = valueArrNew;
                        }
                        for (int i = 0; i < valueArr.length; ++i) {
                            if (lstrArr[i] == null) {
                                lstrArr[i] = new LocaleString();
                                lstrArr[i].setItem(key, (Object)valueArr[i]);
                                continue;
                            }
                            lstrArr[i].setItem(key, (Object)valueArr[i]);
                        }
                    }
                }
                int i = 0;
                for (Map.Entry entry : detailConfigMap.entrySet()) {
                    Object oneItemObj = entry.getValue();
                    Map oneItemMap = (Map)oneItemObj;
                    String numberTitle = CardUtils.getMapEntryStrFromLocaleString(lstrArr[i]);
                    if (StringUtils.isNotEmpty((String)numberTitle)) {
                        oneItemMap.put(NUMTITLE, numberTitle);
                    }
                    ++i;
                }
                configStr = SerializationUtils.toJsonString((Object)configMap);
                cardConfigObj.set(CONFIG, (Object)configStr);
            }
        }
    }

    private LocaleString replaceCardTitleConfigForLangSave(Map<String, Object> configMap) {
        String cardTitleString = null;
        LocaleString lsCardTitle = null;
        Object cardTitle = configMap.get(CARD_TITLE);
        if (cardTitle instanceof String) {
            cardTitleString = (String)configMap.remove(CARD_TITLE);
            lsCardTitle = CardUtils.getLocaleStrFromMapEntryStr(cardTitleString);
        } else {
            LocaleString localeString = lsCardTitle = cardTitle == null ? null : LocaleString.fromMap((Map)((Map)cardTitle));
        }
        if (lsCardTitle == null) {
            lsCardTitle = new LocaleString(ZH_CN, cardTitleString);
        }
        return lsCardTitle;
    }

    public static List<String> getCurShowableMenuList(IPageCache mainPageCache) {
        List<String> result = new ArrayList<String>();
        String menuJson = mainPageCache.get(SHOWABLE_MENULIST);
        if (StringUtils.isEmpty((String)menuJson)) {
            return result;
        }
        result = (List)SerializationUtils.fromJsonString((String)menuJson, List.class);
        return result;
    }

    public static void setCurShowableMenuList(IPageCache mainPageCache, List<String> menuList) {
        mainPageCache.put(SHOWABLE_MENULIST, SerializationUtils.toJsonString(menuList));
    }

    public static void showCardInGridContainer(IFormView fv, String formNum, String cardId, String gridContainerKey, boolean ifDesignMode) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(formNum);
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        if (StringUtils.isEmpty((String)cardId)) {
            long lNewCardId = ORM.create().genLongId("bos_mainpagecardconfig");
            cardId = String.valueOf(lNewCardId);
        }
        if (StringUtils.isEmpty((String)gridContainerKey)) {
            gridContainerKey = CTRL_GRIDCONTAINER;
        }
        fsp.getOpenStyle().setTargetKey(gridContainerKey);
        HashMap<String, String> map = fsp.getOpenStyle().getCustParam();
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put("cardId", cardId);
        map.put("ifDesignMode", String.valueOf(ifDesignMode));
        fsp.getOpenStyle().setCustParam(map);
        fv.showForm(fsp);
    }

    @Deprecated
    public static boolean isMultiOrgMode() {
        int orgmanageMode = OrgUnitServiceHelper.getOrgmanageMode();
        return orgmanageMode == 2 || orgmanageMode == 3;
    }

    public static String convertModeType() {
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modeType = licenseService.getModeType();
        if (modeType == 1) {
            return "0";
        }
        if (modeType == 2) {
            return CARDINDEX_BILLSTATSCONFIG;
        }
        return CARDINDEX_QUICKLAUNCH;
    }

    public static List<String> getHideMenus() {
        ArrayList<String> hideMenus = new ArrayList<String>();
        YzjConfig yzjConfig = YzjConfigServiceHelper.getParameterConfig();
        if (!yzjConfig.isEnable()) {
            hideMenus.add("18XQT0JJ0JMG");
            hideMenus.add("/90RRNI+R8G0");
            hideMenus.add("/Z3FWD66YIIB");
        }
        if (OrgUnitServiceHelper.getOrgmanageMode() != 1 || !PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId()) || !RunModeServiceHelper.isGalaxyMode()) {
            hideMenus.add("06XYF4U+6QN1");
        }
        return hideMenus;
    }

    public static List<String> getProductBlackMenus(String appid) {
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        return service.getAppMenuBlackList(appid);
    }

    public static void setDefaultMainPageLayout(Long schemeId, String pageType, String bizappId, String entityId) {
        Long userId = RequestContext.get().getCurrUserId();
        String selectProperties = "id,scheme.id, scheme.schemetype, scheme.pagetype, scheme.enable,scheme.bizapp,scheme.formnum";
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        filterList.add(userFilter);
        if (PAGETYPE_MAINPAGE.equals(pageType)) {
            QFilter mainPageFilter = new QFilter("scheme.pagetype", "=", (Object)PAGETYPE_MAINPAGE);
            filterList.add(mainPageFilter);
        } else if (PAGETYPE_APP.equals(pageType)) {
            if (StringUtils.isNotEmpty((String)bizappId)) {
                QFilter bizAppFilter = new QFilter("scheme.bizapp", "=", (Object)bizappId);
                filterList.add(bizAppFilter);
            }
            QFilter appPageFilter = new QFilter("scheme.pagetype", "=", (Object)PAGETYPE_APP);
            filterList.add(appPageFilter);
        } else {
            QFilter formNumFilter = new QFilter("scheme.formnum", "=", (Object)entityId);
            filterList.add(formNumFilter);
            QFilter customPageFilter = new QFilter("scheme.pagetype", "=", (Object)PAGETYPE_CUSTOM);
            filterList.add(customPageFilter);
        }
        QFilter[] filters = filterList.toArray(new QFilter[0]);
        DynamicObjectCollection userScthemeCol = QueryServiceHelper.query((String)"portal_scheme_user_rel", (String)selectProperties, (QFilter[])filters);
        if (userScthemeCol == null || userScthemeCol.size() == 0) {
            CardUtils.addOrUpdateSctheme(null, userId, schemeId, Boolean.TRUE);
        } else {
            DynamicObject dyobj = (DynamicObject)userScthemeCol.get(0);
            CardUtils.addOrUpdateSctheme(dyobj.getLong("id"), userId, schemeId, Boolean.FALSE);
        }
        DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"portal_scheme");
        String schemeName = schemeObj.getString("name");
        PortalLogUtils.addLog("portal_scheme", "2deb950100005dac", "setDefault", new MultiLangEnumBridge("\u8bbe\u4e3a\u9ed8\u8ba4", "CardUtils_12", BOS_PORTAL_PLUGIN), new MultiLangEnumBridge("%s\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u3002", "CardUtils_13", BOS_PORTAL_PLUGIN), schemeName);
    }

    public static Long getDefaultSchemeId(String pageType, String bizappId, String entityId) {
        return CardUtils.getDefaultSchemeId(pageType, bizappId, entityId, null);
    }

    public static Long getDefaultSchemeId(String pageType, String bizappId, String entityId, IFormView formView) {
        Long userId = RequestContext.get().getCurrUserId();
        String selectProperties = "id,scheme, scheme.schemetype, scheme.pagetype, scheme.enable,scheme.bizapp,scheme.formnum";
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        filterList.add(userFilter);
        QFilter enableFilter = new QFilter("scheme.enable", "=", (Object)Boolean.TRUE);
        filterList.add(enableFilter);
        if (PAGETYPE_MAINPAGE.equals(pageType)) {
            QFilter mainPageFilter = new QFilter("scheme.pagetype", "=", (Object)PAGETYPE_MAINPAGE);
            filterList.add(mainPageFilter);
        } else if (PAGETYPE_APP.equals(pageType)) {
            if (StringUtils.isNotEmpty((String)bizappId)) {
                QFilter bizAppFilter = new QFilter("scheme.bizapp", "=", (Object)bizappId);
                filterList.add(bizAppFilter);
            }
            QFilter appPageFilter = new QFilter("scheme.pagetype", "=", (Object)PAGETYPE_APP);
            filterList.add(appPageFilter);
        } else {
            QFilter formNumFilter = new QFilter("scheme.formnum", "=", (Object)entityId);
            filterList.add(formNumFilter);
            QFilter customPageFilter = new QFilter("scheme.pagetype", "=", (Object)PAGETYPE_CUSTOM);
            filterList.add(customPageFilter);
        }
        QFilter modelTypeFilter = new QFilter("scheme.ismultiorg", "=", (Object)CardUtils.convertModeType());
        filterList.add(modelTypeFilter);
        QFilter[] filters = filterList.toArray(new QFilter[filterList.size()]);
        DynamicObject dyobj = BusinessDataServiceHelper.loadSingleFromCache((String)"portal_scheme_user_rel", (String)selectProperties, (QFilter[])filters);
        if (dyobj != null) {
            String schemeType = dyobj.getString("scheme.schemetype");
            DynamicObject schemeDyObj = dyobj.getDynamicObject(SCHEME1);
            Long schemeId = schemeDyObj.getLong("id");
            if (SchemeType.GroupScheme.getValue().equals(schemeType) && formView != null) {
                boolean isOwner = CardUtils.checkCurSchemeOwner(userId, schemeId);
                if (isOwner) {
                    return schemeId;
                }
                List<Long> schemeIds = CardUtils.getShareSchemeIds(userId, formView);
                if (schemeIds != null && schemeIds.contains(schemeId)) {
                    return schemeId;
                }
            } else {
                return schemeId;
            }
        }
        return null;
    }

    private static void addOrUpdateSctheme(Long id, Long userId, Long schemeId, Boolean isAdd) {
        ArrayList<DynamicObject> newDObjs = new ArrayList<DynamicObject>(1);
        DynamicObject newDObj = BusinessDataServiceHelper.newDynamicObject((String)"portal_scheme_user_rel");
        newDObj.set("user", (Object)userId);
        newDObj.set(SCHEME1, (Object)schemeId);
        if (isAdd.booleanValue()) {
            newDObjs.add(newDObj);
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)newDObjs.get(0)).getDataEntityType(), (Object[])newDObjs.toArray(new Object[0]));
        } else {
            newDObj.set("id", (Object)id);
            newDObjs.add(newDObj);
            SaveServiceHelper.update((DynamicObject)newDObj);
        }
    }

    public static boolean isOutAdmin() {
        List bizPartners;
        Long userId = RequestContext.get().getCurrUserId();
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        Map types = UserServiceHelper.getUserBaseTypeByIds(userIds);
        if (types == null || types.size() <= 0) {
            return false;
        }
        Integer type = (Integer)types.get(userId);
        return "200".equals(String.valueOf(type)) && (bizPartners = UserServiceHelper.getInChargeOfBizPartnerByUserId((long)userId)) != null && bizPartners.size() > 0;
    }

    public static boolean checkCanEditAndShowTip(IFormView formView, String schemeId, boolean showTip) {
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = CardUtils.checkHasModifySchemeRight(userId);
        if (hasPerm) {
            return true;
        }
        return CardUtils.checkCurSchemeCustomable(schemeId, formView, showTip);
    }
}

