/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.config.YzjTokenHelper;
import kd.bos.yzj.model.YzjConfig;

public class CloudHubSubscribeConfigPlugin
extends AbstractFormPlugin {
    private static final String YZJ_SHARE_FINDSSBMSGPUB = "/imsdk/pub/findSsbMsgPub.do?";
    public static final String BTN_OK = "btn_ok";
    public static final String BTN_PRE = "btn_pre";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String PUBID = "pubid";
    public static final String PUBNAME = "pubname";
    private static Log log = LogFactory.getLog(CloudHubSubscribeConfigPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_PRE});
    }

    public void click(EventObject e) {
        String ctrlKey;
        super.click(e);
        Control ctrl = (Control)e.getSource();
        switch (ctrlKey = ctrl.getKey()) {
            case "btn_ok": {
                EntryGrid eg = (EntryGrid)this.getControl("entryentity");
                int[] selRows = eg.getSelectRows();
                if (selRows == null || selRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u8ba2\u9605\u53f7\u3002", (String)"CloudHubSubscribeConfigPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                ArrayList returnList = new ArrayList(1);
                for (int idx : selRows) {
                    String pubId = (String)this.getModel().getValue(PUBID, idx);
                    String pubName = (String)this.getModel().getValue(PUBNAME, idx);
                    HashMap<String, String> returnMap = new HashMap<String, String>();
                    returnMap.put("cardType", "bos_card_yzj_subscribe");
                    returnMap.put(PUBID, pubId);
                    returnMap.put(PUBNAME, pubName);
                    String cardTitleMapEntryStr = "[zh_CN=" + pubName + "]";
                    returnMap.put("cardtitle", cardTitleMapEntryStr);
                    returnList.add(returnMap);
                }
                this.getView().returnDataToParent(returnList);
                this.getView().close();
                break;
            }
            case "btn_pre": {
                HashMap<String, String> returnMap = new HashMap<String, String>();
                returnMap.put("event_rtn_addcard", "4");
                this.getView().returnDataToParent(returnMap);
                this.getView().close();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        RequestContext requestContext = RequestContext.get();
        if (StringUtils.isEmpty((String)requestContext.getUserOpenId())) {
            String errorInfo = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u7684\u4e91\u4e4b\u5bb6OpenID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CloudHubSubscribeConfigPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorInfo);
            return;
        }
        String publicAcctListStr = null;
        JSONArray jsonArr = null;
        try {
            publicAcctListStr = this.getUserSubscribePubAcctList();
            jsonArr = JSON.parseArray((String)publicAcctListStr);
        }
        catch (Exception ee) {
            log.info("\u83b7\u53d6\u8ba2\u9605\u53f7\u4fe1\u606f\u51fa\u9519\uff01", (Object)ee);
            return;
        }
        if (jsonArr == null || jsonArr.size() == 0) {
            return;
        }
        int arrSize = jsonArr.size();
        this.getModel().batchCreateNewEntryRow("entryentity", arrSize);
        IClientViewProxy cvProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        for (int i = 0; i < arrSize; ++i) {
            Object arrObj = jsonArr.get(i);
            JSONObject jsonObj = (JSONObject)arrObj;
            String photourl = jsonObj.getString("photourl");
            String pubname = jsonObj.getString(PUBNAME);
            String pubid = jsonObj.getString(PUBID);
            this.getModel().setValue(PUBID, (Object)pubid, i);
            this.getModel().setValue(PUBNAME, (Object)pubname, i);
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>();
            propertiesMap.put("src", photourl);
            pmap.put("photourl", propertiesMap);
            cvProxy.invokeControlMethod("entryentity", "setCustomProperties", new Object[]{i, pmap});
        }
    }

    private String getUserSubscribePubAcctList() {
        YzjConfig config = YzjConfigServiceHelper.getConfig();
        if (!config.isEnable()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u672a\u542f\u7528\u3002", (String)"CloudHubSubscribeConfigPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_OK});
            return null;
        }
        String yzjHost = config.getUrl();
        Map<String, String> header = this.getHttpRequestHeaderForm();
        try {
            String yzjTicket = YzjTokenHelper.getToken((YzjConfig)config, (String)"ticket");
            String sHttpResponse = HttpClientUtils.post((String)(yzjHost + YZJ_SHARE_FINDSSBMSGPUB + "ticket=" + yzjTicket), header, null);
            return sHttpResponse;
        }
        catch (Exception e) {
            log.info("getUserSubscribePubAcctList", (Object)e);
            return null;
        }
    }

    private Map<String, String> getHttpRequestHeaderForm() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
        return header;
    }
}

