/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;

public class CustomCardConfigPlugin
extends AbstractFormPlugin {
    public static final String TEXT_CARDFORMNAME = "cardformname";
    public static final String TEXT_CARDFORMNUM = "cardformnum";
    public static final String TEXT_CARDTITLE = "cardtitle";
    public static final String FORM_CUSTCARDFORMLIST = "bos_card_custformlist";
    public static final String CLOSECALLBACK_CARDFORMLIST = "cardformlist";
    public static final String BTN_OK = "btn_ok";
    public static final String BTN_PRE = "btn_pre";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{TEXT_CARDFORMNAME, BTN_OK, BTN_PRE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals(TEXT_CARDFORMNAME)) {
            this.showFormList();
        } else if (key.equals(BTN_OK)) {
            if (this.validateValue()) {
                HashMap<String, String> returnMap = new HashMap<String, String>();
                returnMap.put("cardType", "bos_card_custom");
                returnMap.put(TEXT_CARDFORMNAME, (String)this.getModel().getValue(TEXT_CARDFORMNAME));
                returnMap.put(TEXT_CARDFORMNUM, (String)this.getModel().getValue(TEXT_CARDFORMNUM));
                returnMap.put(TEXT_CARDTITLE, ((OrmLocaleValue)this.getModel().getValue(TEXT_CARDTITLE)).entrySet().toString());
                this.getView().returnDataToParent(returnMap);
                this.getView().close();
            }
        } else if (key.equals(BTN_PRE)) {
            HashMap<String, String> returnMapPre = new HashMap<String, String>();
            returnMapPre.put("event_rtn_addcard", "7");
            this.getView().returnDataToParent(returnMapPre);
            this.getView().close();
        }
    }

    private boolean validateValue() {
        OrmLocaleValue cardTitle = (OrmLocaleValue)this.getModel().getValue(TEXT_CARDTITLE);
        String cardFormName = (String)this.getModel().getValue(TEXT_CARDFORMNAME);
        if (cardTitle == null || StringUtils.isEmpty((String)cardTitle.toString())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5361\u7247\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CustomCardConfigPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((String)cardFormName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5361\u7247\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CustomCardConfigPlugin_1", (String)"bos-portal-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void showFormList() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(FORM_CUSTCARDFORMLIST);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_CARDFORMLIST));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (CLOSECALLBACK_CARDFORMLIST.equals(e.getActionId())) {
            Map returnMap = (Map)e.getReturnData();
            if (returnMap == null) {
                return;
            }
            String formNum = (String)returnMap.get("formNum");
            String formName = (String)returnMap.get("formName");
            this.getModel().setValue(TEXT_CARDFORMNUM, (Object)formNum);
            this.getModel().setValue(TEXT_CARDFORMNAME, (Object)formName);
        }
    }
}

