/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.param.CustomParam;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.PortalUsableFuncUtil;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class CustomCardFormListPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static Log logger = LogFactory.getLog(CustomCardFormListPlugin.class);
    public static final String BILLLIST = "billlistap";
    public static final String BTN_OK = "btn_ok";
    public static final String FSP_NOAPPFILTER = "FormShowParam_NoAppFilter";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBilllist(null);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnOk = (Button)this.getControl(BTN_OK);
        btnOk.addClickListener((ClickListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.getItems();
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void initialize() {
        BillList billList = (BillList)this.getControl(BILLLIST);
        Object customParam = this.getView().getFormShowParameter().getCustomParam(FSP_NOAPPFILTER);
        if (customParam == null) {
            String appNum = this.getView().getFormShowParameter().getAppId();
            List formIds = null;
            if (StringUtils.isNotEmpty((String)appNum) && this.getSysParam()) {
                String appId = AppMetadataCache.getAppInfo((String)appNum).getId();
                formIds = BizAppServiceHelp.getFormsIdByAppId((String)appId);
                QFilter idFilter = new QFilter("id", "in", (Object)formIds);
                billList.getFilterParameter().getQFilters().add(idFilter);
            } else {
                Long userId = Long.valueOf(RequestContext.get().getUserId());
                boolean isAdmin = PermissionServiceHelper.isAdminUser((long)userId);
                if (!isAdmin) {
                    PortalUsableFuncUtil portalUsableFuncUtil = new PortalUsableFuncUtil(logger);
                    Set<String> hasPermAppIds = portalUsableFuncUtil.getUserHasPerAppIds();
                    QFilter appUserTypeFilter = new QFilter("bizappid", "in", hasPermAppIds);
                    billList.getFilterParameter().getQFilters().add(appUserTypeFilter);
                }
            }
        }
        QFilter specFormFilter = new QFilter("inheritpath", "like", (Object)"/910EZ6ZX680%");
        billList.getFilterParameter().getQFilters().add(specFormFilter);
        QFilter notShowExtFormFilter = new QFilter("type", "!=", (Object)"2");
        billList.getFilterParameter().getQFilters().add(notShowExtFormFilter);
    }

    private boolean getSysParam() {
        CustomParam customParam = new CustomParam();
        HashSet<String> keys = new HashSet<String>();
        keys.add("cross_app_cardconfig_enable");
        customParam.setSearchKeySet(keys);
        Map parameterMap = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        String data = (String)parameterMap.get("cross_app_cardconfig_enable");
        return !"true".equals(data);
    }

    public void search(SearchEnterEvent event) {
        this.refreshBilllist(event);
    }

    private void refreshBilllist(SearchEnterEvent event) {
        BillList billList = (BillList)this.getControl(BILLLIST);
        if (event != null && StringUtils.isNotEmpty((String)event.getText())) {
            String searchStr = event.getText();
            QFilter searchFilter = new QFilter("number", "like", (Object)("%" + searchStr + "%")).or(new QFilter("name", "like", (Object)("%" + searchStr + "%")));
            billList.getFilterParameter().getQFilters().add(searchFilter);
        }
        billList.refresh();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals(BTN_OK)) {
            BillList billList = (BillList)this.getControl(BILLLIST);
            ListSelectedRow lsr = billList.getCurrentSelectedRowInfo();
            if (lsr == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"CustomCardFormListPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            String formNum = lsr.getNumber();
            String formName = lsr.getName();
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("formNum", formNum);
            returnMap.put("formName", formName);
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }
}

