/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.service.PortalSchemeService;
import kd.bos.portal.service.dto.CardResult;
import kd.bos.portal.service.factory.PortalSchemeServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class GridCardPlugin
extends AbstractFormPlugin {
    public static final String CONFIGKEY_CARDTITLE = "cardtitle";
    public static final String PGCACHE_CARDTITLE_MAPENTRY = "cardTitleMapEntry";
    public static final String LBL_CARD_TITLE = "title";
    protected String TITLE_MAPENTRYSTR_DEFAULT = "";
    protected String TITLE_DEFAULT = "";
    public static final String CLSBCK_MODIFYCARDCAPTION = "ModifyCardCaption";
    protected LocaleString lstrDefaultTitle = null;
    public static final String VECTOR_MODIFY_CARDTITLE = "vectorap";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String CONFIGKEY_CARDTYPE = "cardType";
    private PortalSchemeService portalSchemeService = PortalSchemeServiceFactory.createPortalSchemeService();
    private static Log logger = LogFactory.getLog(GridCardPlugin.class);

    public void initialize() {
        super.initialize();
    }

    protected IPageCache getParentPageCache() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            return (IPageCache)parentView.getService(IPageCache.class);
        }
        return null;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map<String, String> cardConfigMap = this.getAllConfigMap();
        try {
            this.portalSchemeService.filterCardConfig(this.getAllPermCardInfo(), this.getCardId(), cardConfigMap);
        }
        catch (Exception ex) {
            logger.error("filterCardConfig error", (Throwable)ex);
        }
        this.refreshCard(cardConfigMap);
    }

    private Map<String, CardResult> getAllPermCardInfo() {
        String allPermCardInfoStr;
        IPageCache parentPageCache = this.getParentPageCache();
        Map<String, CardResult> allPermCardInfoMap = new HashMap<String, CardResult>();
        if (parentPageCache != null && StringUtils.isNotEmpty((String)(allPermCardInfoStr = parentPageCache.get("pgCache_permFilterCardInfo")))) {
            allPermCardInfoMap = (Map)SerializationUtils.deSerializeFromBase64((String)allPermCardInfoStr);
        }
        return allPermCardInfoMap;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{VECTOR_MODIFY_CARDTITLE});
    }

    protected void refreshCard(Map<String, String> allConfigMap) {
        if (this.getControl(VECTOR_MODIFY_CARDTITLE) != null) {
            this.getView().setVisible(Boolean.valueOf(this.isDesignMode()), new String[]{VECTOR_MODIFY_CARDTITLE});
        }
    }

    public String getCardId() {
        Map custParam = this.getView().getFormShowParameter().getOpenStyle().getCustParam();
        if (custParam == null) {
            return null;
        }
        return (String)custParam.get("cardId");
    }

    public boolean isDesignMode() {
        Map custParam = this.getView().getFormShowParameter().getOpenStyle().getCustParam();
        if (custParam == null) {
            return false;
        }
        custParam.get("ifDesignMode");
        String strIfDesignMode = (String)custParam.get("ifDesignMode");
        if ("1".equals(strIfDesignMode)) {
            return true;
        }
        if ("0".equals(strIfDesignMode)) {
            return false;
        }
        return false;
    }

    public Map<String, String> getAllCardConfigMap() {
        String allCardConfigStr;
        IPageCache parentPageCache = this.getParentPageCache();
        Map<String, String> allCardConfigMap = new HashMap<String, String>();
        if (parentPageCache != null && StringUtils.isNotEmpty((String)(allCardConfigStr = parentPageCache.get("cache_allCardConfig")))) {
            allCardConfigMap = (Map)SerializationUtils.fromJsonString((String)allCardConfigStr, Map.class);
        }
        return allCardConfigMap;
    }

    public Map<String, String> getAllConfigMap() {
        String cardId = this.getCardId();
        if (StringUtils.isEmpty((String)cardId)) {
            return null;
        }
        Map<String, String> allCardConfigMap = this.getAllCardConfigMap();
        Map<String, String> cardConfigMap = new HashMap<String, String>();
        String curCardConfigMap = allCardConfigMap.get(cardId);
        if (StringUtils.isNotEmpty((String)curCardConfigMap)) {
            cardConfigMap = (Map)SerializationUtils.fromJsonString((String)curCardConfigMap, Map.class);
        }
        return cardConfigMap;
    }

    public void updateAllConfigMap(Map<String, String> allConfigMap) {
        if (allConfigMap == null) {
            allConfigMap = new HashMap<String, String>();
        }
        String cardId = this.getCardId();
        Map<String, String> allCardConfigMap = this.getAllCardConfigMap();
        allCardConfigMap.put(cardId, SerializationUtils.toJsonString(allConfigMap));
        IPageCache parentPageCache = this.getParentPageCache();
        parentPageCache.put("cache_allCardConfig", SerializationUtils.toJsonString(allCardConfigMap));
        parentPageCache.saveChanges();
    }

    protected void copyDefaultCardToUser(boolean isMainPage, IFormView view) {
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        DynamicObject defaultLayout = CardUtils.loadMainPageLayout(userId, isMainPage, view);
        if (defaultLayout != null) {
            return;
        }
        long superAdminId = CardUtils.getSuperAdmin();
        defaultLayout = CardUtils.loadMainPageLayout(superAdminId, isMainPage, view);
        if (defaultLayout == null) {
            return;
        }
        DynamicObject layoutObj = BusinessDataServiceHelper.newDynamicObject((String)"portal_scheme");
        layoutObj.set("user", (Object)userId);
        if (isMainPage) {
            layoutObj.set("pagetype", (Object)"main");
        } else {
            String appNum = this.getView().getFormShowParameter().getAppId();
            String appId = AppMetadataCache.getAppInfo((String)appNum).getId();
            String pageType = CardUtils.getPageType(view);
            layoutObj.set("pagetype", (Object)pageType);
            layoutObj.set("bizapp", (Object)appId);
        }
        Long defaultMainPageId = defaultLayout.getLong("id");
        String layoutStr = defaultLayout.getString("layout");
        layoutStr = CardUtils.replaceBackSlach(layoutStr);
        layoutObj.set("layout", (Object)layoutStr);
        SaveServiceHelper.save((IDataEntityType)layoutObj.getDataEntityType(), (Object[])new Object[]{layoutObj});
        Long layoutId = (Long)layoutObj.getPkValue();
        DynamicObject[] cardInfos = CardUtils.loadAllMainPageCardConfig(defaultMainPageId);
        DynamicObject newDObj = null;
        ArrayList<DynamicObject> newDObjs = new ArrayList<DynamicObject>(cardInfos.length);
        for (DynamicObject cardInfo : cardInfos) {
            newDObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_mainpagecardconfig");
            newDObj.set("cardid", cardInfo.get("cardid"));
            newDObj.set("user", (Object)userId);
            newDObj.set("cardtype", cardInfo.get("cardtype"));
            newDObj.set("config", cardInfo.get("config"));
            newDObj.set("mainpagelayout", (Object)layoutId);
            newDObj.set(CONFIGKEY_CARDTITLE, cardInfo.get(CONFIGKEY_CARDTITLE));
            newDObjs.add(newDObj);
        }
        if (newDObjs != null && newDObjs.size() > 0) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)newDObjs.get(0)).getDataEntityType(), (Object[])newDObjs.toArray(new Object[0]));
        }
    }

    protected void showModifyCaptionForm() {
        String cardTitleMapEntry = this.getPageCache().get(PGCACHE_CARDTITLE_MAPENTRY);
        if (StringUtils.isEmpty((String)cardTitleMapEntry)) {
            cardTitleMapEntry = this.TITLE_MAPENTRYSTR_DEFAULT;
        }
        CardUtils.showModifyCaptionForm(this.getView(), (IFormPlugin)this, cardTitleMapEntry);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map<String, String> allConfigMap = this.getAllConfigMap();
        if (allConfigMap == null || allConfigMap.isEmpty()) {
            return;
        }
        String cardTitleMapEntryStr = allConfigMap.get(CONFIGKEY_CARDTITLE);
        String cardType = allConfigMap.get(CONFIGKEY_CARDTYPE);
        LocaleString ls = CardUtils.getLocaleStrFromMapEntryStr(cardTitleMapEntryStr);
        Label lblTitle = (Label)this.getControl(LBL_CARD_TITLE);
        if (lblTitle == null) {
            return;
        }
        if (ls != null && ls.size() > 0) {
            if ("bos_card_quicklaunch".equals(cardType) && !ls.keySet().contains("en_US")) {
                String quickTitle = ResManager.loadKDString((String)"\u5feb\u901f\u53d1\u8d77", (String)"QuickLaunchPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                ls.put("en_US", (Object)quickTitle);
            }
            String titleStr = ls.getLocaleValue();
            this.getPageCache().put(PGCACHE_CARDTITLE_MAPENTRY, cardTitleMapEntryStr);
            lblTitle.setText(titleStr);
        } else {
            if (StringUtils.isNotEmpty((String)cardTitleMapEntryStr) && !"[]".equals(cardTitleMapEntryStr)) {
                lblTitle.setText(cardTitleMapEntryStr);
                cardTitleMapEntryStr = "[zh_CN=" + cardTitleMapEntryStr + "]";
                allConfigMap.put(CONFIGKEY_CARDTITLE, cardTitleMapEntryStr);
            } else if (StringUtils.isNotEmpty((String)this.TITLE_DEFAULT)) {
                lblTitle.setText(this.TITLE_DEFAULT);
                allConfigMap.put(CONFIGKEY_CARDTITLE, this.TITLE_MAPENTRYSTR_DEFAULT);
            }
            this.getPageCache().put(PGCACHE_CARDTITLE_MAPENTRY, this.TITLE_MAPENTRYSTR_DEFAULT);
            this.updateAllConfigMap(allConfigMap);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (CLSBCK_MODIFYCARDCAPTION.equals(actionId) && e.getReturnData() != null) {
            String titleMapEntryStr = e.getReturnData().toString();
            LocaleString lsTitle = CardUtils.getLocaleStrFromMapEntryStr(titleMapEntryStr);
            Label title = (Label)this.getControl(LBL_CARD_TITLE);
            title.setText(lsTitle.getLocaleValue());
            Map<String, String> cardInfo = this.getAllConfigMap();
            cardInfo.put(CONFIGKEY_CARDTITLE, titleMapEntryStr);
            this.getPageCache().put(PGCACHE_CARDTITLE_MAPENTRY, titleMapEntryStr);
            this.updateAllConfigMap(cardInfo);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        String key = "";
        Object source = e.getSource();
        if (source instanceof Control) {
            key = ((Control)source).getKey();
        }
        if (key.equals(VECTOR_MODIFY_CARDTITLE)) {
            this.showModifyCaptionForm();
        }
    }
}

