/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.mvc.list.ListView;
import kd.bos.portal.pluginnew.common.BizAppHomeAbstract;
import kd.bos.portal.service.enums.PageHelpMenuEnum;
import kd.bos.portal.util.DateUtils;
import kd.bos.portal.util.ImageUtil;
import kd.bos.portal.util.ModeTypeUtils;
import kd.bos.portal.util.ShortCutUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.svc.control.HomePageSideBar;
import kd.svc.control.events.HomePageSideBarEvent;
import kd.svc.control.events.HomePageSideBarListener;

public class HomePageSideBarPlugin
extends BizAppHomeAbstract
implements HomePageSideBarListener {
    private static final String HOMEPAGESIDEBARAP = "homepagesidebarap";
    private static final String SUBMAINTAB = "_submaintab_";
    private static Log logger = LogFactory.getLog(HomePageSideBarPlugin.class);
    public static final String SHARE_FORM_ID = "shareFormId";
    public static final String SHARE_PK_ID = "sharePkId";
    public static final String SHARE_BILL_NAME = "shareBillName";
    public static final String TO_SHARE_FORM = "toShareForm";
    public static final String USERNAME = "username";
    public static final String PICTUREFIELD = "picturefield";
    public static final String SHOW_TEAM_WORK = "showTeamWork";
    public static final String PAGE_ID = "pageId";
    public static final String APPMIANTAB = "appmiantab";
    public static final String BILL_FORM_ID = "billFormId";
    public static final String TITLE = "title";
    public static final String TYPE_NAME = "typeName";
    public static final String SHOW_INSIGHT = "showInsight";
    public static final String IS_ENABLE_AI_INSIGHT = "is_enable_ai_insight";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        HomePageSideBar homePageSideBar = (HomePageSideBar)this.getControl(HOMEPAGESIDEBARAP);
        if (homePageSideBar != null) {
            homePageSideBar.addHomePageSideBarListener((HomePageSideBarListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(8);
        Object isSearch = BaseAppParameterServiceHelper.getParameterFromCache((String)"knowledge_search");
        if (isSearch == null || Boolean.parseBoolean(isSearch.toString())) {
            map.put("showHelp", Boolean.TRUE);
        }
        Account currentCenter = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        Map params = ParametersUtils.getCommonParameters((Account)currentCenter);
        map.put(SHOW_TEAM_WORK, Boolean.FALSE);
        map.put(SHOW_INSIGHT, Boolean.FALSE);
        if (params != null) {
            boolean oemEnv;
            if (params.get("is_enable_team_work") instanceof Boolean && ((Boolean)params.get("is_enable_team_work")).booleanValue()) {
                map.put(SHOW_TEAM_WORK, Boolean.TRUE);
            }
            if (!(oemEnv = DevVerifyServiceHelper.isOEMEnv()) && (params.get(IS_ENABLE_AI_INSIGHT) == null || params.get(IS_ENABLE_AI_INSIGHT) instanceof Boolean && ((Boolean)params.get(IS_ENABLE_AI_INSIGHT)).booleanValue())) {
                map.put(SHOW_INSIGHT, Boolean.TRUE);
            }
        }
        try {
            if (null != this.getView().getFormShowParameter() && StringUtils.isNotEmpty((String)this.getView().getFormShowParameter().getAppId()) && "ssc".equals(this.getView().getFormShowParameter().getAppId())) {
                map.put(SHOW_INSIGHT, Boolean.FALSE);
            }
        }
        catch (Exception e1) {
            logger.info("getFormShowParameter", (Object)e1);
        }
        this.getView().updateControlMetadata(HOMEPAGESIDEBARAP, map);
    }

    public void homePageSideBarclick(HomePageSideBarEvent event) {
        Map paramsMap = event.getArgs();
        if (null != paramsMap) {
            Object controlKey = paramsMap.get("controlKey");
            if (controlKey == null) {
                return;
            }
            if ("pageHelp".equals(controlKey)) {
                this.getHelpInfo("knowledge");
                this.getPageHelpCustomMenu(HOMEPAGESIDEBARAP);
                this.hideOemGuide();
            } else if ("pageTeamWork".equals(controlKey)) {
                Tab appTab = (Tab)this.getView().getControl("tabap");
                String currentTab = appTab.getCurrentTab();
                IFormView view = this.getView().getViewNoPlugin(currentTab);
                if (view != null) {
                    logger.info("pageTeamWork" + view.getEntityId());
                } else {
                    logger.info("pageTeamWorkis null");
                }
                if (view != null && "wf_msg_center".equals(view.getEntityId())) {
                    return;
                }
                this.showTeamWork();
            } else if ("pageInsight".equals(controlKey)) {
                this.showInsight();
            } else if ("clickShare".equals(controlKey)) {
                this.showShareForm();
            } else if ("newGuide".equals(controlKey)) {
                if (ModeTypeUtils.isGalaxyMode()) {
                    return;
                }
                this.showGuideForm(ResManager.loadKDString((String)"\u65b0\u95e8\u6237\u4f7f\u7528\u6307\u5f15", (String)"MainPageNewPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u672c\u6b21\u6539\u7248\u5bf9\u6574\u4f53\u6846\u67b6\u8fdb\u884c\u4e86\u5168\u65b0\u8bbe\u8ba1\uff0c\u4e3a\u4e86\u5e2e\u52a9\u60a8\u66f4\u5feb\u9002\u5e94\u65b0\u7248\u672c\uff0c\u8bf7\u8ddf\u968f\u6211\u5f00\u59cb\u672c\u6b21\u4f53\u9a8c\u4e4b\u65c5\u3002", (String)"MainPageNewPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), "/images/pc/other/xsyd_ks_368_96.png", Boolean.TRUE);
            } else if ("shortcutsSetting".equals(controlKey)) {
                ShortCutUtils.showAdvancesetting(this.getView());
            } else if ("helpArticle".equals(controlKey)) {
                this.doCustomHelpClick((String)paramsMap.get("number"));
            }
            this.pageHelpCustomMenuClick(controlKey.toString());
        }
    }

    private void hideOemGuide() {
        boolean oemEnv = DevVerifyServiceHelper.isOEMEnv();
        if (!oemEnv) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", HOMEPAGESIDEBARAP);
        HashSet<String> hiddenItem = new HashSet<String>();
        hiddenItem.add(PageHelpMenuEnum.NEWGUIDE.getNumber());
        map.put("hiddenitem", hiddenItem);
        proxy.addAction("pageHelpCustomMenus", map);
    }

    private void showGuideForm(String title, String content, String imageUrl, Boolean isStart) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("bos_newportal_guide");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setShowTitle(false);
        fsp.setShowClose(false);
        HashMap<String, Object> customMap = new HashMap<String, Object>();
        customMap.put(TITLE, title);
        customMap.put("content", content);
        customMap.put("imageUrl", imageUrl);
        customMap.put("isStart", isStart);
        fsp.setCustomParams(customMap);
        this.getView().showForm(fsp);
    }

    private void showShareForm() {
        String shareFormStr = this.getPageCache().get(TO_SHARE_FORM);
        if (StringUtils.isBlank((String)shareFormStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u5355\u636e", (String)"BizAppHomePlugin_14", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Map shareForm = (Map)SerializationUtils.fromJsonString((String)shareFormStr, Map.class);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("bos_share_form");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParams(shareForm);
        this.getView().showForm(fsp);
    }

    private void showInsight() {
        IFormView view = this.getCurrentView();
        String billFormId = null;
        String bizDataId = null;
        String bizPageId = null;
        if (view != null) {
            billFormId = this.getBillFormId(view);
            bizPageId = view.getPageId();
            Object pkId = null;
            try {
                pkId = view.getModel().getDataEntity().getPkValue();
            }
            catch (KDException e) {
                logger.info("BizAppHomePlugin--showInsight getpkid error");
            }
            if (null != pkId) {
                bizDataId = pkId.toString();
            }
        }
        HashMap<String, String> result = new HashMap<String, String>(8);
        result.put("entityNumber", billFormId);
        result.put("bizDataId", bizDataId);
        result.put(PAGE_ID, bizPageId);
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put(PAGE_ID, view == null ? this.getView().getPageId() : view.getPageId());
        params.put("data", result);
        Account currentCenter = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        Map sysParams = ParametersUtils.getCommonParameters((Account)currentCenter);
        String aiInsightForm = "idi_float_layer";
        if (sysParams != null && sysParams.get("ai_insight_form") != null) {
            aiInsightForm = sysParams.get("ai_insight_form").toString();
        }
        params.put("formId", aiInsightForm);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction(SHOW_INSIGHT, params);
    }

    private void getHelpInfo(String title) {
        this.knowledgeSearch();
    }

    @Override
    protected String getBillFormId() {
        IFormView view = this.getCurrentView();
        String billFormId = null;
        if (view != null) {
            Tab submaintab = (Tab)view.getControl(SUBMAINTAB);
            if (submaintab != null) {
                String currentTab = submaintab.getCurrentTab();
                if (APPMIANTAB.equals(currentTab)) {
                    billFormId = "";
                }
            } else {
                billFormId = this.getBillFormId(view);
            }
        }
        return billFormId;
    }

    @Override
    protected void showHotQuestion(Object result, String entityUrl) {
        IFormView view = this.getCurrentView();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> o = new HashMap<String, Object>();
        o.put(PAGE_ID, view == null ? this.getView().getPageId() : view.getPageId());
        o.put("data", result);
        o.put("entityUrl", entityUrl);
        o.put("hideGuide", ModeTypeUtils.isGalaxyMode());
        proxy.addAction("showHotQuestion", o);
    }

    @Override
    protected IFormView getCurrentView() {
        Tab appTab = (Tab)this.getView().getControl("tabap");
        String currentTab = appTab.getCurrentTab();
        IFormView view = this.getView().getViewNoPlugin(currentTab);
        if (view == null) {
            return view;
        }
        Tab submaintab = (Tab)view.getControl(SUBMAINTAB);
        if (submaintab == null) {
            return view;
        }
        String pageId = submaintab.getCurrentTab();
        if (!APPMIANTAB.equals(pageId)) {
            view = view.getViewNoPlugin(pageId);
        }
        return view;
    }

    private String getBillFormId(IFormView view) {
        String billFormId = null;
        billFormId = view instanceof ListView ? ((ListView)view).getBillFormId() : (String)view.getFormShowParameter().getCustomParams().get(BILL_FORM_ID);
        if (billFormId == null) {
            billFormId = view.getFormShowParameter().getFormId();
        }
        return billFormId;
    }

    private void showTeamWork() {
        IFormView view = this.getCurrentView();
        Map<Object, Object> parseResult = new HashMap(8);
        if (view != null) {
            String billFormId = this.getBillFormId(view);
            String appId = FormMetadataCache.getFormConfig((String)billFormId).getBizAppNumber();
            parseResult = this.getTeamWorkData(view, billFormId);
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PAGE_ID, view == null ? this.getView().getPageId() : view.getPageId());
        params.put("data", parseResult);
        proxy.addAction(SHOW_TEAM_WORK, params);
    }

    private Map<String, Object> getTeamWorkData(IFormView view, String billFormId) {
        Map<String, Object> parseResult = new HashMap<String, Object>(8);
        String bizDataId = null;
        String appId = System.getProperty("YZJAppID");
        StringBuilder authCode = new StringBuilder();
        if (view instanceof ListView) {
            billFormId = ((ListView)view).getBillFormId();
        } else {
            parseResult = this.fillBillInfoData(view, billFormId, parseResult, bizDataId, appId, authCode);
        }
        parseResult = this.fillUserInfo(billFormId, parseResult, bizDataId);
        return parseResult;
    }

    private Map<String, Object> fillUserInfo(String billFormId, Map<String, Object> parseResult, String bizDataId) {
        StringBuilder authCode = new StringBuilder();
        if (!ObjectUtils.isEmpty(parseResult) && null != parseResult.get("authCode")) {
            authCode.append(parseResult.get("authCode"));
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(RequestContext.get().getCurrUserId());
        List userInfoList = UserServiceHelper.get(userIds, (String[])new String[]{"id", "eid", USERNAME, PICTUREFIELD, "name"}, null);
        if (StringUtils.isEmpty((String)bizDataId) || "0".equals(bizDataId)) {
            bizDataId = billFormId == null ? ((Long)userIds.get(0)).toString() : billFormId;
            StringBuilder temp = new StringBuilder(bizDataId).append(RequestContext.get().getAccountId());
            authCode.append((CharSequence)temp);
        }
        if (null != userInfoList && userInfoList.size() > 0) {
            parseResult.put("userId", ((Map)userInfoList.get(0)).get("id"));
            parseResult.put("eid", ((Map)userInfoList.get(0)).get("eid"));
            OrmLocaleValue nameLocalVal = (OrmLocaleValue)((Map)userInfoList.get(0)).get("name");
            String name = nameLocalVal.get((Object)"zh_CN");
            parseResult.put(USERNAME, name);
            String imageUrl = ImageUtil.getCurrentUserAvatarPath(true);
            parseResult.put(PICTUREFIELD, imageUrl);
        }
        parseResult.put("oid", RequestContext.get().getUserOpenId());
        parseResult.put("authCode", authCode);
        return parseResult;
    }

    private Map<String, Object> fillBillInfoData(IFormView view, String billFormId, Map<String, Object> parseResult, String bizDataId, String appId, StringBuilder authCode) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billFormId);
        if (mainEntityType != null && mainEntityType.getDisplayName() != null && StringUtils.isNotEmpty((String)mainEntityType.getDisplayName().getLocaleValue())) {
            parseResult.put("billName", mainEntityType.getDisplayName().getLocaleValue());
        }
        Object pkId = null;
        try {
            pkId = view.getModel().getDataEntity().getPkValue();
        }
        catch (KDException e) {
            logger.info("BizAppHomePlugin--showTeamWork getpkid error");
        }
        String pkIdStr = null;
        if (null != pkId) {
            pkIdStr = pkId.toString();
        }
        if (StringUtils.isNotEmpty(pkIdStr) && !"0".equals(pkIdStr)) {
            bizDataId = pkIdStr;
            authCode.append(bizDataId);
            DynamicObject obj = null;
            try {
                obj = BusinessDataServiceHelper.loadSingle((Object)bizDataId, (String)billFormId);
            }
            catch (KDException e) {
                logger.info(String.format("BizAppHomePlugin--showTeamWork loaddata error, pkid:%s, formId:%s", bizDataId, billFormId));
                bizDataId = null;
            }
            if (obj != null) {
                DynamicObject creator;
                Date createTime;
                String billno = null;
                DynamicPropertyCollection property = (DynamicPropertyCollection)obj.getDataEntityType().getProperties();
                if (property.containsKey((Object)"createtime") && (createTime = obj.getDate("createtime")) != null) {
                    authCode.append(createTime.getTime());
                    parseResult.put("createDate", DateUtils.formatDate(createTime, "yyyyMMdd"));
                    parseResult.put("createTime", DateUtils.formatDate(createTime, "HHmmss"));
                }
                if (property.containsKey((Object)"billno")) {
                    billno = obj.getString("billno");
                }
                if (property.containsKey((Object)"creator") && (creator = obj.getDynamicObject("creator")) != null) {
                    authCode.append(creator.get("masterid"));
                    parseResult.put("creatorId", creator.get("masterid"));
                    OrmLocaleValue nameLocalVal = (OrmLocaleValue)creator.get("name");
                    String name = nameLocalVal.get((Object)"zh_CN");
                    parseResult.put(USERNAME, name);
                    parseResult.put("creatorName", name);
                }
                if (StringUtils.isNotEmpty((String)billno)) {
                    parseResult.put("billName", parseResult.get("billName") + "-" + billno);
                }
                HashMap<String, Object> data = new HashMap<String, Object>(16);
                data.put(SHARE_PK_ID, bizDataId);
                data.put(SHARE_FORM_ID, billFormId);
                data.put(SHARE_BILL_NAME, parseResult.get("billName"));
                this.getPageCache().put(TO_SHARE_FORM, SerializationUtils.toJsonString(data));
            }
            if (bizDataId != null) {
                String domainUrl = UrlService.getDomainContextUrl();
                if (StringUtils.isNotEmpty((String)domainUrl) && domainUrl.endsWith("/")) {
                    domainUrl = domainUrl.substring(0, domainUrl.length() - 1);
                }
                parseResult.put("billLink", domainUrl + "/index.html?pkId=" + bizDataId + "&formId=" + billFormId + "&appId=" + appId + "&accountId=" + RequestContext.get().getAccountId());
            }
        }
        parseResult.put("bizDataId", bizDataId);
        parseResult.put("dataCenterId", RequestContext.get().getAccountId());
        parseResult.put("appId", appId);
        parseResult.put("authCode", authCode);
        return parseResult;
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        if ("system_menu_click".equals(key)) {
            this.systemMenuClick(e);
        }
    }

    private void systemMenuClick(CustomEventArgs e) {
        try {
            String args = e.getEventArgs();
            List data = (List)SerializationUtils.fromJsonString((String)args, List.class);
            if (data != null && data.size() > 0) {
                String formId = (String)((Map)data.get(0)).get("eventKey");
                this.showSlideForm(formId);
            }
        }
        catch (Exception ex) {
            logger.info("showSlideForm error", (Object)e);
        }
    }

    private void showSlideForm(String formId) {
        if (StringUtils.isEmpty((String)formId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e8b\u4ef6\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"HomePageSideBarPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> o1 = new HashMap<String, Object>(1);
        o1.put("direction", "right");
        o1.put("formId", formId);
        o1.put("visualStyle", "newDesign");
        HashMap<String, Integer> offset = new HashMap<String, Integer>();
        offset.put("top", 49);
        offset.put("right", 28);
        o1.put("offsetInAllDC", offset);
        HashMap<String, String> borderRadius = new HashMap<String, String>();
        borderRadius.put("boxShadow", "0px 9px 24px 6px rgb(0 0 0 / 10%)");
        o1.put("style", borderRadius);
        proxy.addAction("setSlideBillFormId", o1);
        HashMap<String, String> o = new HashMap<String, String>(1);
        o.put("formId", formId);
        proxy.addAction("showSlideBill", o);
    }
}

