/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.util.DelTagsUtil;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.MessagePushUtils;

public class MessagePushPlugin
extends AbstractTreeListPlugin
implements IBillWebApiPlugin {
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static Log logger = LogFactory.getLog(MessagePushPlugin.class);
    private static final String BOS_MSG_PUSH = "bos_messagepushlayput";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("MEASSGEPUSH", new DistributeCacheHAPolicy(true, true));

    public ApiResult doCustomService(Map<String, Object> params) {
        if (CollectionUtils.isEmpty(params)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"MessagePushPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), (String)"500");
        }
        List<String> msgs = this.valid(params);
        if (!CollectionUtils.isEmpty(msgs)) {
            return ApiResult.fail((String)StringUtils.join((Object[])msgs.toArray(), (String)","), (String)"500");
        }
        String message = (String)params.get("message");
        String title = (String)params.get("title");
        if (!DelTagsUtil.validHtmlContent((String)message) || !DelTagsUtil.validHtmlContent((String)title)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff0c\u5185\u5bb9\u5305\u542b\u5b89\u5168\u654f\u611f\u8bcd\u3002", (String)"MessagePushPlugin_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
        message = this.replaceIllegalTag(message);
        title = this.replaceIllegalTag(title);
        String sendTime = (String)params.get("sendTime");
        String endTime = (String)params.get("endTime");
        String msgCode = (String)params.get("msgCode");
        String accountIds = (String)params.get("accountIds");
        logger.info(String.format("MessagePushPlugin.doCustomService.msgCode:%s,message:%s,sendTime:%s,endTime:%s,accountIds:%s", msgCode, message, sendTime, endTime, accountIds));
        String[] accountIdArray = accountIds.split(",");
        try {
            long timeOutSecond = this.getTimeOutSecond(sendTime, endTime);
            for (String accountId : accountIdArray) {
                MessagePushUtils.sendMessage(message, BOS_MSG_PUSH, title);
                this.putCache(accountId, timeOutSecond, message, title);
            }
            return ApiResult.success((Object)ResManager.loadKDString((String)"\u6d88\u606f\u63a8\u9001\u6210\u529f\u3002", (String)"MessagePushPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.info("\u6d88\u606f\u63a8\u9001\u51fa\u73b0\u9519\u8bef\uff1a" + e.getMessage(), (Object)e);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff0c%s\u3002", (String)"MessagePushPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage()));
        }
    }

    private List<String> valid(Map<String, Object> params) {
        ArrayList<String> msgs = new ArrayList<String>(0);
        String message = (String)params.get("message");
        String title = (String)params.get("title");
        String sendTime = (String)params.get("sendTime");
        String endTime = (String)params.get("endTime");
        String accountIds = (String)params.get("accountIds");
        try {
            if (kd.bos.util.StringUtils.isEmpty((String)message)) {
                msgs.add(ResManager.loadKDString((String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MessagePushPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            if (kd.bos.util.StringUtils.isEmpty((String)title)) {
                msgs.add(ResManager.loadKDString((String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MessagePushPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            if (kd.bos.util.StringUtils.isEmpty((String)accountIds)) {
                msgs.add(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MessagePushPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            if (kd.bos.util.StringUtils.isEmpty((String)sendTime)) {
                msgs.add(ResManager.loadKDString((String)"\u53d1\u9001\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MessagePushPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            if (kd.bos.util.StringUtils.isEmpty((String)endTime)) {
                msgs.add(ResManager.loadKDString((String)"\u6d88\u606f\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MessagePushPlugin_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.info("MessagePushPlugin--valid--error", (Object)e);
            msgs.add(e.getMessage());
        }
        return msgs;
    }

    private void putCache(String accountId, long timeOutSecond, String message, String tittle) {
        cache.put(Instance.getClusterName() + accountId + "_msgPush", (Object)message, (int)timeOutSecond);
        cache.put(Instance.getClusterName() + accountId + "_msgTitlePush", (Object)tittle, (int)timeOutSecond);
    }

    private long getTimeOutSecond(String sendTime, String endTime) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.SIMPLIFIED_CHINESE);
        Date sendDate = null;
        Date endDate = null;
        sendDate = sdf.parse(sendTime);
        endDate = sdf.parse(endTime);
        long miliS = endDate.getTime() - sendDate.getTime();
        if (miliS < 0L) {
            throw new KDException(new ErrorCode("getTimeOutSecond error", ResManager.loadKDString((String)"\u5931\u6548\u65f6\u95f4\u65e9\u4e8e\u53d1\u9001\u65f6\u95f4\u3002", (String)"MessagePushPlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])), new Object[0]);
        }
        long sec = miliS / 1000L;
        return sec;
    }

    private String replaceIllegalTag(String value) {
        if (value == null) {
            return value;
        }
        return value.replaceAll("<embed", "&lt;embed").replaceAll("<iframe", "&lt;iframe").replaceAll("<object", "&lt;object");
    }
}

