/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.util.EventObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.util.StringUtils;

public class ModifyCardCaptionPlugin
extends AbstractFormPlugin {
    private static final String[] fbsArr = new String[]{"\"", "'", "&", "<", ">"};

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        String lsCardTitle = (String)this.getView().getFormShowParameter().getCustomParam("groupname");
        LocaleString ls = CardUtils.getLocaleStrFromMapEntryStr(lsCardTitle);
        this.getModel().setValue("groupname", (Object)ls);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if ("btnok".equals(key)) {
            this.confirm();
        } else if ("btncancel".equals(key)) {
            this.cancel();
        }
    }

    private void confirm() {
        String cardTitleLocaleStr = ((OrmLocaleValue)this.getModel().getValue("groupname")).entrySet().toString();
        if (StringUtils.isEmpty((String)cardTitleLocaleStr)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5361\u7247\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ModifyCardCaptionPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
            return;
        }
        if (this.isContainSpecialChar(cardTitleLocaleStr)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5361\u7247\u6807\u9898\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u3002", (String)"ModifyCardCaptionPlugin_1", (String)"bos-portal-plugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)cardTitleLocaleStr);
        this.getView().close();
    }

    private void cancel() {
        this.getView().close();
    }

    private boolean isContainSpecialChar(String cardTitleLocaleStr) {
        for (String key : fbsArr) {
            if (!cardTitleLocaleStr.contains(key)) continue;
            return true;
        }
        return false;
    }
}

