/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.constant.scheme.GroupSchemeRel;
import kd.bos.portal.constant.scheme.OrgSchemeRel;
import kd.bos.portal.constant.scheme.RoleSchemeRel;
import kd.bos.portal.constant.scheme.SchemeRel;
import kd.bos.portal.constant.scheme.UserSchemeRel;
import kd.bos.portal.constant.scheme.UserTypeSchemeRel;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;

public class PortalSchemeConfigEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String ENTRYFIELD_GROUPID = "groupid";
    private static final String ENTRYFIELD_ORGID = "orgid";
    private static final String OP_SAVE = "save";
    private static final String SCHEME_ADMIN_USER = "1,2,3,10";
    private static final Log logger = LogFactory.getLog(PortalSchemeConfigEditPlugin.class);
    public static final String USERID = "userid";
    public static final String IN = "in";
    public static final String OUT = "out";
    public static final String ROLEID = "roleid";
    public static final String USERTYPEID = "usertypeid";
    private static final String USERTYPE = "usertype";
    private String userType = "in";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bde = (BasedataEdit)this.getControl(ENTRYFIELD_GROUPID);
        bde.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bdeOrg = (BasedataEdit)this.getControl(ENTRYFIELD_ORGID);
        bdeOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit userid = (BasedataEdit)this.getControl(USERID);
        userid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit role = (BasedataEdit)this.getControl(ROLEID);
        role.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit userType = (BasedataEdit)this.getControl(USERTYPEID);
        userType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private List<Long> getUserIdByPartner(List<Long> partnerByUserId, String userType) {
        QFilter qFilter = null;
        if (userType != null) {
            String[] types;
            for (String type : types = userType.split(",")) {
                if (qFilter == null) {
                    qFilter = new QFilter(USERTYPE, "=", (Object)type);
                    qFilter.or(USERTYPE, "like", (Object)(type + ",%")).or(USERTYPE, "like", (Object)("%," + type));
                    continue;
                }
                qFilter.or(USERTYPE, "=", (Object)type).or(USERTYPE, "like", (Object)(type + ",%")).or(USERTYPE, "like", (Object)("%," + type));
            }
        }
        if (qFilter == null) {
            qFilter = new QFilter("bizpartner", IN, partnerByUserId);
        } else {
            qFilter.and("bizpartner", IN, partnerByUserId);
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_bizpartneruser", (String)"user", (QFilter[])new QFilter[]{qFilter});
        return query.stream().map(v -> v.getLong("user")).collect(Collectors.toList());
    }

    private void setUserFilter(List<QFilter> qFilterList) {
        Long userId = RequestContext.get().getCurrUserId();
        if ("200".equals(String.valueOf(this.getType()))) {
            this.userType = OUT;
            List partnerByUserId = UserServiceHelper.getBizPartnerByUserId((long)userId);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_bizpartneruser", (String)USERTYPE, (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
            String userType = null;
            if (query != null) {
                userType = ((DynamicObject)query.get(0)).getString(USERTYPE);
            }
            List<Long> users = this.getUserIdByPartner(partnerByUserId, userType);
            QFilter qFilter = new QFilter("id", IN, users);
            qFilterList.add(qFilter);
            return;
        }
        String adminUser = SystemPropertyUtils.getProptyByTenant((String)"scheme_admin_user", (String)RequestContext.get().getTenantId());
        if (StringUtils.isEmpty((String)adminUser)) {
            adminUser = SCHEME_ADMIN_USER;
        }
        boolean adminFlag = false;
        for (String s : adminUser.split(",")) {
            if (!s.equals(userId + "")) continue;
            adminFlag = true;
            break;
        }
        if (StringUtils.isNotEmpty((String)(userId + "")) && !adminFlag) {
            this.userType = IN;
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_user", (String)"id,name,entryentity.dpt", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userId)}, null);
            List orgIds = query.stream().map(v -> v.getLong("entryentity.dpt")).collect(Collectors.toList());
            List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"01", orgIds, (boolean)true);
            orgIds.addAll(subOrgIds);
            if (orgIds.size() > 0) {
                QFilter qFilter = new QFilter("entryentity.dpt", IN, orgIds);
                qFilter.or(new QFilter("entryentity.dpt", "is null", null));
                qFilterList.add(qFilter);
            }
        }
    }

    private Integer getType() {
        Long userId = RequestContext.get().getCurrUserId();
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        Map types = UserServiceHelper.getUserBaseTypeByIds(userIds);
        return types != null && types.size() > 0 ? (Integer)types.get(userId) : null;
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.refreshTabData();
    }

    private void refreshTabData() {
        List<SchemeRel> schemeRels = this.getSchemeRels();
        for (SchemeRel schemeRel : schemeRels) {
            this.refreshTabData(schemeRel);
        }
    }

    private List<SchemeRel> getSchemeRels() {
        ArrayList<SchemeRel> list = new ArrayList<SchemeRel>(10);
        list.add(new GroupSchemeRel());
        list.add(new OrgSchemeRel());
        list.add(new UserSchemeRel());
        list.add(new RoleSchemeRel());
        list.add(new UserTypeSchemeRel());
        return list;
    }

    private void refreshTabData(SchemeRel schemeRel) {
        Long pkId = (Long)this.getModel().getDataEntity().getPkValue();
        DynamicObjectCollection schemeGroupRelCol = QueryServiceHelper.query((String)schemeRel.getEntityName(), (String)schemeRel.getFieldName(), (QFilter[])QFilter.of((String)"scheme = ?", (Object[])new Object[]{pkId}).toArray());
        if (CollectionUtils.isEmpty((Collection)schemeGroupRelCol)) {
            return;
        }
        this.getModel().deleteEntryData(schemeRel.getEntry());
        int size = schemeGroupRelCol.size();
        this.getModel().beginInit();
        int[] newIndexArr = this.getModel().batchCreateNewEntryRow(schemeRel.getEntry(), size);
        this.getModel().endInit();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(schemeRel.getEntry());
        for (int i = 0; i < size; ++i) {
            DynamicObject relationObj = (DynamicObject)schemeGroupRelCol.get(i);
            DynamicObject rowObj = (DynamicObject)entryEntity.get(newIndexArr[i]);
            if (relationObj == null) continue;
            rowObj.set(schemeRel.getField() + "_id", relationObj.get(schemeRel.getFieldName()));
        }
        BusinessDataReader.loadRefence((Object[])entryEntity.toArray((Object[])new DynamicObject[size]), (IDataEntityType)entryEntity.getDynamicObjectType());
        this.getView().updateView(schemeRel.getEntry());
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        Object source = evt.getSource();
        if (!(source instanceof FormOperate)) {
            return;
        }
        FormOperate op = (FormOperate)source;
        if (OP_SAVE.equals(op.getOperateKey())) {
            Long pkId = (Long)this.getModel().getDataEntity().getPkValue();
            try (TXHandle h = TX.required();){
                try {
                    List<SchemeRel> schemeRels = this.getSchemeRels();
                    for (SchemeRel schemeRel : schemeRels) {
                        this.saveScheme(pkId, schemeRel);
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                    evt.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7528\u6237\u7ec4\u4fdd\u5b58\u5931\u8d25\u3002", (String)"PortalSchemeConfigEditPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
                    logger.info("\u4fdd\u5b58\u5931\u8d25", (Object)e);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (OP_SAVE.equals(operateKey)) {
            this.refreshTabData();
        }
    }

    private void saveScheme(Long pkId, SchemeRel schemeRel) {
        int entryRowCount = this.getModel().getEntryRowCount(schemeRel.getEntry());
        DeleteServiceHelper.delete((String)schemeRel.getEntityName(), (QFilter[])QFilter.of((String)"scheme = ?", (Object[])new Object[]{pkId}).toArray());
        ArrayList<DynamicObject> newObjs = new ArrayList<DynamicObject>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(schemeRel.getEntry());
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        for (DynamicObject rowObj : entryEntity) {
            if (rowObj == null) continue;
            DynamicObject group = rowObj.getDynamicObject(schemeRel.getField());
            DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)schemeRel.getEntityName());
            newObj.set("scheme", (Object)pkId);
            newObj.set(schemeRel.getFieldName(), group.get("id"));
            newObjs.add(newObj);
        }
        if (entryRowCount > 0) {
            SaveServiceHelper.save((DynamicObject[])newObjs.toArray(new DynamicObject[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        FormShowParameter fsp = e.getFormShowParameter();
        if (fsp instanceof ListShowParameter) {
            String controlKey;
            ListShowParameter lsp = (ListShowParameter)fsp;
            switch (controlKey = fsp.getCloseCallBack().getControlKey()) {
                case "groupid": {
                    this.setSchemeFilter(new GroupSchemeRel(), lsp);
                    break;
                }
                case "orgid": {
                    this.setSchemeFilter(new OrgSchemeRel(), lsp);
                    break;
                }
                case "userid": {
                    this.setUserParams(lsp);
                    this.setSchemeFilter(new UserSchemeRel(), lsp);
                    break;
                }
                case "roleid": {
                    this.setSchemeFilter(new RoleSchemeRel(), lsp);
                    break;
                }
                case "usertypeid": {
                    this.setSchemeFilter(new UserTypeSchemeRel(), lsp);
                    break;
                }
            }
        }
    }

    private void setUserParams(ListShowParameter lsp) {
        if (IN.equals(this.userType)) {
            lsp.setF7Style(3);
            lsp.setCustomParam("externalUserType", (Object)"all");
        } else if (OUT.equals(this.userType)) {
            lsp.setF7Style(3);
            lsp.setCustomParam("isOnlyShowExternalUser", (Object)true);
        }
    }

    private void setSchemeFilter(SchemeRel schemeRel, ListShowParameter lsp) {
        ArrayList<QFilter> qList = new ArrayList<QFilter>();
        List<Object> allIds = this.getAllSelectedId(schemeRel);
        qList.add(new QFilter("id", "not in", allIds));
        if (schemeRel instanceof UserSchemeRel) {
            this.setUserFilter(qList);
        }
        lsp.setListFilterParameter(new ListFilterParameter(qList, ""));
    }

    private List<Object> getAllSelectedId(SchemeRel schemeRel) {
        ArrayList<Object> result = new ArrayList<Object>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(schemeRel.getEntry());
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return result;
        }
        for (DynamicObject rowObj : entryEntity) {
            DynamicObject groupId = rowObj.getDynamicObject(schemeRel.getField());
            if (groupId == null) continue;
            result.add(groupId.getPkValue());
        }
        return result;
    }
}

