/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.mvc.export.ExportProgressImpl;
import kd.bos.portal.util.PortalSchemeExportUtils;
import kd.bos.schedule.executor.AbstractTask;
import org.apache.commons.lang3.StringUtils;

public class PortalSchemeExportTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(PortalSchemeExportTask.class);
    private IFormView parentView;
    private Map<String, Object> params = new HashMap<String, Object>();
    private static final String CUSTPARAM_PARENTPAGEID = "parentpageid";
    private ExportProgress exportProgress;

    private IFormView getParentView() {
        if (this.parentView == null) {
            String parentPageId = (String)this.params.get(CUSTPARAM_PARENTPAGEID);
            if (StringUtils.isBlank((CharSequence)parentPageId)) {
                throw new KDException(new ErrorCode("fail", "parentPageId is empty"), new Object[0]);
            }
            this.parentView = SessionManager.getCurrent().getView(parentPageId);
        }
        return this.parentView;
    }

    private ExportProgress getExportProgress() {
        if (this.exportProgress == null) {
            this.exportProgress = new ExportProgressImpl(this.taskId);
        }
        return this.exportProgress;
    }

    public void execute(RequestContext rc, Map<String, Object> map) throws KDBizException {
        try {
            logger.info("kd.bos.portal.pluginnew.PortalSchemeExportTask export start ---------");
            if (map != null) {
                this.params.putAll(map);
            }
            BillList billList = (BillList)this.getParentView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Object[] pkKeyValues = selectedRows.getPrimaryKeyValues();
            this.getExportProgress().feedbackProgress(selectedRows.size(), 0);
            Long[] pkKeys = (Long[])Arrays.stream(pkKeyValues).map(obj -> (Long)obj).toArray(Long[]::new);
            String downloadUrl = PortalSchemeExportUtils.exportScheme(pkKeys, this.getExportProgress());
            downloadUrl = this.appendAppIdAndFormId(downloadUrl);
            this.getExportProgress().feedbackFileUrl(downloadUrl);
            this.getExportProgress().complete();
        }
        catch (Exception e) {
            logger.info("execute error", (Object)e);
            this.getExportProgress().fail(e.getMessage());
            this.getExportProgress().complete();
        }
    }

    private String appendAppIdAndFormId(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        String splitStr = "&";
        if (!url.contains("?")) {
            splitStr = "?";
        }
        try {
            FormShowParameter fsp = this.getParentView().getFormShowParameter();
            String appId = fsp.getAppId();
            String fId = ((ListShowParameter)fsp).getBillFormId();
            return url + splitStr + String.format("appId=%s&fId=%s", appId, fId);
        }
        catch (Exception e) {
            logger.info("appendAppIdAndFormId error", (Object)e);
            return url;
        }
    }
}

