/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PortalSchemeGroupSettingPlugin
extends AbstractBasePlugIn {
    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        AbstractOperate oper;
        if (event.getSource() instanceof AbstractOperate && (oper = (AbstractOperate)event.getSource()).getOperateKey().equals("save")) {
            Long userId = (Long)this.getModel().getDataEntity().getPkValue();
            QFilter[] qfArr = new QFilter[]{new QFilter("user", "=", (Object)userId)};
            DynamicObjectCollection col = QueryServiceHelper.query((String)"portal_group_user_rel", (String)"id, group", (QFilter[])qfArr);
            ArrayList<DynamicObject> rels = new ArrayList<DynamicObject>();
            DynamicObject relation = null;
            DynamicObjectCollection userGroups = (DynamicObjectCollection)this.getModel().getValue("group");
            try (TXHandle h = TX.required();){
                try {
                    ArrayList<Long> forDelIds = new ArrayList<Long>();
                    if (col != null) {
                        for (DynamicObject dObj : col) {
                            forDelIds.add(dObj.getLong("id"));
                        }
                        DeleteServiceHelper.delete((String)"portal_group_user_rel", (QFilter[])new QFilter[]{new QFilter("id", "in", forDelIds)});
                    }
                    if (userGroups != null && userGroups.size() > 0) {
                        for (DynamicObject userGroup : userGroups) {
                            if (userGroup == null) continue;
                            relation = BusinessDataServiceHelper.newDynamicObject((String)"portal_group_user_rel");
                            relation.set("group", (Object)userGroup.getLong("fbasedataid_id"));
                            relation.set("user", (Object)userId);
                            rels.add(relation);
                        }
                        SaveServiceHelper.save((DynamicObject[])rels.toArray(new DynamicObject[0]));
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                }
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        QFilter[] qfArr = new QFilter[]{new QFilter("user", "=", this.getModel().getDataEntity().getPkValue())};
        DynamicObjectCollection col = QueryServiceHelper.query((String)"portal_group_user_rel", (String)"id, group", (QFilter[])qfArr);
        if (col.size() > 0) {
            ArrayList<Long> list = new ArrayList<Long>();
            for (DynamicObject dObj : col) {
                Long userGroupId = dObj.getLong("group");
                list.add(userGroupId);
            }
            this.getModel().setValue("group", (Object)list.toArray());
            this.getModel().setDataChanged(false);
        }
    }
}

