/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.AbstractTreeListView;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.UserScopeResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.pluginnew.PortalSchemeGroupTreeListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class PortalSchemeGroupTreeListPlugin
extends StandardTreeListPlugin {
    private static final String ID_ROOTNODE = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String BOS_USERTREELISTF7 = "bos_usertreelistf7";
    private static final String TREE_USERGROUP = "treeview";
    private static final String USER_LIST = "billlistap";
    private static final String PGCACHE_FILTER = "pgCache_initFilter";
    private static final String CACHEVALUE_NOFILTER = "noFilter";
    private static final String BARITEM_ADD = "btn_add";
    private static final String BARITEM_DELETE = "btn_delete";
    private static final String BARITEM_REFRESH = "btn_refresh";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final String CTRL_SEARCH = "searchap";
    private static final String CALLBACKID_DEL = "delete_comfirm";
    private static final String CALLBACKID_GROUP_DEL = "group_bar_del";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private PortalSchemeGroupTreeListView treeListView = new PortalSchemeGroupTreeListView();

    public void createTreeListView(CreateTreeListViewEvent e) {
        super.createTreeListView(e);
        e.setView((AbstractTreeListView)this.treeListView);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_NEW, BTN_EDIT, BTN_DEL, CTRL_SEARCH, BARITEM_REFRESH});
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String itemkey = evt.getOperateKey();
        OperationResult opResult = evt.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        BillList billList = (BillList)this.getView().getControl(USER_LIST);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "adduser": {
                TreeView tree = (TreeView)this.getControl(TREE_USERGROUP);
                Map gourpmap = tree.getTreeState().getFocusNode();
                if (gourpmap == null || ID_ROOTNODE.equals(gourpmap.get("id"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u7ec4\u3002", (String)"PortalSchemeGroupTreeListPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                Long userId = Long.valueOf(RequestContext.get().getUserId());
                boolean isAdmin = PermissionServiceHelper.isAdminUser((long)userId);
                boolean hasPerm = CardUtils.checkHasModifySchemeRight(userId);
                if (isAdmin || hasPerm) {
                    this.showUserF7TreeList(isAdmin);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u6743\u6dfb\u52a0\u7528\u6237\u3002", (String)"PortalSchemeGroupTreeListPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                break;
            }
            case "deleteuser": {
                if (rows == null || rows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u5220\u9664\u7684\u7528\u6237\u3002", (String)"PortalSchemeGroupTreeListPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u5206\u7ec4\u4e0b\u7684%s\u4e2a\u7528\u6237\u5417\uff1f", (String)"PortalSchemeGroupTreeListPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), rows.size()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_DEL, (IFormPlugin)this));
                break;
            }
            case "refresh": {
                billList.clearSelection();
                billList.refresh();
                this.refreshTreeList();
                break;
            }
        }
    }

    private void refreshTreeList() {
        QFilter filter = new QFilter("id", "<>", (Object)641718110033824768L);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"portal_scheme_group", (QFilter[])new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Map)dynamicObjectMap)) {
            return;
        }
        TreeNode node = this.treeListView.getRoot();
        if (node == null) {
            return;
        }
        ArrayList childNodes = new ArrayList();
        dynamicObjectMap.forEach((id, dynamicObject) -> {
            String number = dynamicObject.getString("number");
            ILocaleString name = dynamicObject.getLocaleString("name");
            TreeNode childNode = new TreeNode();
            childNode.setParentid(node.getId());
            childNode.setId(id + "");
            childNode.setText(name.getLocaleValue());
            childNode.setLongText(name.getLocaleValue());
            childNode.setLongNumber(number);
            childNodes.add(childNode);
        });
        node.setChildren(childNodes);
        this.treeListView.getTreeView().updateNode(node);
    }

    private void showUserF7TreeList(boolean isAdmin) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
        ArrayList<QFilter> rangeFilterList = new ArrayList<QFilter>();
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        rangeFilterList.add(enableFilter);
        lsp.setListFilterParameter(new ListFilterParameter(rangeFilterList, null));
        lsp.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
        lsp.setCustomParam("externalUserType", (Object)"all");
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BOS_USERTREELISTF7));
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void setFilter(SetFilterEvent e) {
        QFilter staffFilter = new QFilter("user.id", "!=", (Object)1L);
        QFilter enableFilter = new QFilter("user.enable", "=", (Object)true);
        staffFilter = staffFilter.and(enableFilter);
        e.getQFilters().add(staffFilter);
    }

    protected QFilter nodeClickFilter() {
        QFilter resultFilter = super.nodeClickFilter();
        TreeView userGroupTree = (TreeView)this.getControl(TREE_USERGROUP);
        String focusNodeIdStr = userGroupTree.getTreeState().getFocusNodeId();
        if (StringUtils.isNotEmpty((String)focusNodeIdStr) && !ID_ROOTNODE.equals(focusNodeIdStr)) {
            long focusNodeId = Long.parseLong(focusNodeIdStr);
            QFilter groupFilter = new QFilter("group.id", "in", (Object)focusNodeId);
            resultFilter = resultFilter == null ? groupFilter : resultFilter.and(groupFilter);
        } else {
            resultFilter = new QFilter("group.id", "<>", (Object)641718110033824768L);
        }
        return resultFilter;
    }

    private QFilter getAdminChargeUserQFilter() {
        QFilter adminChargeUserQFilter = null;
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        boolean isSuperAdmin = true;
        if (isSuperAdmin) {
            this.getPageCache().put(PGCACHE_FILTER, CACHEVALUE_NOFILTER);
            return adminChargeUserQFilter;
        }
        UserScopeResult userScopeResult = PermissionServiceHelper.getAdminChargeUser((Long)userId);
        if (!userScopeResult.isAllUser()) {
            List adminChargeUsers = userScopeResult.getUserIDs();
            adminChargeUserQFilter = adminChargeUsers != null ? (adminChargeUsers.size() == 0 ? new QFilter("id", "in", null) : new QFilter("id", "in", (Object)adminChargeUsers)) : new QFilter("id", "in", null);
            this.getPageCache().put(PGCACHE_FILTER, adminChargeUserQFilter.toSerializedString());
        } else {
            this.getPageCache().put(PGCACHE_FILTER, CACHEVALUE_NOFILTER);
        }
        return adminChargeUserQFilter;
    }

    public void treeToolbarClick(EventObject e) {
        TreeView userGroupTree = (TreeView)this.getControl(TREE_USERGROUP);
        String focusNodeId = userGroupTree.getTreeState().getFocusNodeId();
        if (focusNodeId == null) {
            focusNodeId = ID_ROOTNODE;
        }
        Control ctl = (Control)e.getSource();
        String btnKey = ctl.getKey();
        if (focusNodeId.equals(ID_ROOTNODE) && !btnKey.equals(BTN_NEW)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7528\u6237\u7ec4\u8282\u70b9\u3002", (String)"PortalSchemeGroupTreeListPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getTreeModel().setCurrentNodeId((Object)focusNodeId);
        super.treeToolbarClick(e);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (!(e.getReturnData() instanceof ListSelectedRowCollection)) {
            return;
        }
        ListSelectedRowCollection userIdS = (ListSelectedRowCollection)e.getReturnData();
        if (userIdS == null || userIdS.size() <= 0) {
            return;
        }
        switch (actionId) {
            case "bos_usertreelistf7": {
                this.addNewUserToGroup(userIdS, true);
                break;
            }
        }
    }

    private void addNewUserToGroup(ListSelectedRowCollection userIdS, boolean b) {
        TreeView tree = (TreeView)this.getControl(TREE_USERGROUP);
        Map gourpmap = tree.getTreeState().getFocusNode();
        int insertNum = 0;
        try (TXHandle h = TX.required();){
            DynamicObjectCollection insertDoc = new DynamicObjectCollection();
            long groupId = Long.parseLong(gourpmap.get("id").toString());
            List<Object> userIds = new ArrayList(10);
            DynamicObject[] userGroup = BusinessDataServiceHelper.load((String)"portal_group_user_rel", (String)"user", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)groupId)});
            if (userGroup != null) {
                userIds = Stream.of(userGroup).map(dy -> {
                    Long uid = 0L;
                    DynamicObject userDy = dy.getDynamicObject("user");
                    if (userDy != null) {
                        uid = Long.valueOf(userDy.get("id").toString());
                    }
                    return uid;
                }).collect(Collectors.toList());
            }
            try {
                for (ListSelectedRow userIdRow : userIdS) {
                    DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"portal_group_user_rel");
                    Long userId = Long.valueOf(userIdRow.getPrimaryKeyValue().toString());
                    object.set("user", (Object)userId);
                    object.set("group", (Object)groupId);
                    if (userIds.contains(userId)) continue;
                    insertDoc.add((Object)object);
                    ++insertNum;
                }
                SaveServiceHelper.save((DynamicObject[])((DynamicObject[])insertDoc.toArray((Object[])new DynamicObject[0])));
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        if (insertNum == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7528\u6237\u5df2\u5b58\u5728\u3002", (String)"PortalSchemeGroupTreeListPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PortalSchemeGroupTreeListPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2000));
        }
        this.refreshTreeView((String)gourpmap.get("id"));
        this.treeListView.setFocusNode();
    }

    private void deleteUserFromGroup() {
        BillList billList = (BillList)this.getView().getControl(USER_LIST);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        List ids = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        int delNum = ids.size();
        DeleteServiceHelper.delete((String)"portal_group_user_rel", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (delNum == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u7528\u6237\u5df2\u5b58\u5728\u3002", (String)"PortalSchemeGroupTreeListPlugin_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        } else {
            String message = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%s\u4e2a\u7528\u6237\u3002", (String)"PortalSchemeGroupTreeListPlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), delNum);
            this.getView().showSuccessNotification(message, Integer.valueOf(2000));
        }
        billList.clearSelection();
        billList.refresh();
        this.treeListView.setFocusNode();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes && CALLBACKID_DEL.equals(event.getCallBackId())) {
            this.deleteUserFromGroup();
        } else if (event.getResult() == MessageBoxResult.Yes && CALLBACKID_GROUP_DEL.equals(event.getCallBackId())) {
            String strNodeId = (String)this.getTreeModel().getCurrentNodeId();
            if (!this.canDelUserGroup(strNodeId)) {
                return;
            }
            Long nodeId = Long.parseLong(strNodeId);
            IOperationResult result = this.getTreeModel().deleteGroup(new Object[]{nodeId});
            if (result.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"PortalSchemeGroupTreeListPlugin_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            } else {
                this.getView().showOperationResult((OperationResult)result, ResManager.loadKDString((String)"\u5220\u9664", (String)"PortalSchemeGroupTreeListPlugin_11", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            if (!result.getSuccessPkIds().isEmpty()) {
                TreeNode node = this.getTreeModel().getRoot().getTreeNode(strNodeId, 10);
                this.getTreeModel().deleteNode(node, false);
                TreeNode parentNode = this.getTreeModel().getRoot().getTreeNode(node.getParentid(), 10);
                if (parentNode != null) {
                    this.treeListView.refreshTreeNode(parentNode.getId());
                    this.treeListView.getTreeView().treeNodeClick(parentNode.getParentid(), parentNode.getId());
                }
                this.getView().updateView();
            }
        }
    }

    public void refreshTreeView(String strNodeId) {
        TreeNode node = this.getTreeModel().getRoot().getTreeNode(strNodeId, 10);
        if (node != null) {
            this.treeListView.refreshTreeNode(node.getId());
            this.treeListView.getTreeView().treeNodeClick(node.getParentid(), node.getId());
        }
    }

    private boolean canDelUserGroup(String nodeIdStr) {
        QFilter enableFilter;
        long nodeId = Long.parseLong(nodeIdStr);
        QFilter nodeFilter = new QFilter("group", "=", (Object)nodeId);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"portal_group_user_rel", (String)"id, user", (QFilter[])new QFilter[]{nodeFilter, enableFilter = new QFilter("user.enable", "=", (Object)true)});
        if (null != doc && doc.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u5b58\u5728\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"PortalSchemeGroupTreeListPlugin_12", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        DeleteServiceHelper.delete((String)"portal_group_user_rel", (QFilter[])new QFilter[]{nodeFilter});
        return true;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
    }
}

