/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.stmt.SqlDeleteStmt;
import kd.bos.ksql.dom.stmt.SqlInsertStmt;
import kd.bos.ksql.dom.stmt.SqlSelectStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.dom.stmt.SqlUpdateStmt;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.parser.SqlStmtParser;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.mvc.export.ExportProgressImpl;
import kd.bos.portal.model.PortalSchemeImportData;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.service.upgrade.DeployService;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptWriter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.DisCardUtil;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PortalSchemeImportTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(PortalSchemeImportTask.class);
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private Map<String, Object> params = new HashMap<String, Object>();
    private ExportProgress exportProgress;
    private final long LIMITSIZ = 0x1400000L;
    private static final String DBSCHEMA = "dbschema";
    private static final String PREINSDATA = "preinsdata";
    private static final List<String> portalSchemeTables = Stream.of("t_bas_mainpagelayout", "t_bas_mainpagelayout_l", "t_bas_cardconfig", "t_bas_cardconfig_l").collect(Collectors.toList());

    private String getSuccessMsg() {
        return ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"PortalSchemeImportTask_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    public void execute(RequestContext rc, Map<String, Object> map) throws KDException {
        try {
            logger.info("kd.bos.portal.pluginnew.PortalSchemeImportTask import start ---------");
            if (map != null) {
                this.params.putAll(map);
            }
            this.importScheme();
        }
        catch (Exception e) {
            logger.info("execute error", (Object)e);
            this.getExportProgress().fail(e.getMessage());
            this.getExportProgress().complete();
        }
    }

    private ExportProgress getExportProgress() {
        if (this.exportProgress == null) {
            this.exportProgress = new ExportProgressImpl(this.taskId);
        }
        return this.exportProgress;
    }

    private void importScheme() {
        Object urlArr = this.params.get("urlArr");
        if (urlArr == null) {
            this.getExportProgress().fail(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9996\u9875\u65b9\u6848\u6587\u4ef6\u3002", (String)"PortalSchemeImportTask_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            this.getExportProgress().complete();
            return;
        }
        List urlDatas = (List)SerializationUtils.fromJsonString(urlArr.toString(), List.class);
        if (urlDatas == null || urlDatas.isEmpty()) {
            this.getExportProgress().fail(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9996\u9875\u65b9\u6848\u6587\u4ef6\u3002", (String)"PortalSchemeImportTask_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            this.getExportProgress().complete();
            return;
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (Map urlData : urlDatas) {
            urlData.forEach((urlName, url) -> {
                logger.info("importScheme url:" + url);
                int schemeCount = this.initProgress((String)url);
                if (schemeCount == 0 || schemeCount > 100) {
                    return;
                }
                this.getExportProgress().feedbackProgress(schemeCount, 0);
                TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                try (InputStream inStream = cache.getInputStream(url);
                     ZipInputStream zipIn = new ZipInputStream(inStream, Charset.forName("gbk"));){
                    ZipEntry zipEntry;
                    int rate = 0;
                    while ((zipEntry = zipIn.getNextEntry()) != null) {
                        if (zipEntry.isDirectory()) continue;
                        String metaName = zipEntry.getName();
                        if ((metaName = metaName.replace(File.separator, "/")).endsWith(".zip") && metaName.startsWith("dm")) {
                            PortalSchemeImportData portalSchemeImportData = this.parseSchemeZip(zipIn);
                            String name = metaName.substring(3);
                            List<Map<String, String>> executeResult = this.executeSchemeData(portalSchemeImportData, name);
                            result.addAll(executeResult);
                        }
                        this.getExportProgress().feedbackProgress(schemeCount, ++rate);
                    }
                }
                catch (Exception e) {
                    this.getExportProgress().fail(e.getMessage());
                    this.getExportProgress().complete();
                }
            });
        }
        this.dealResult(result);
    }

    private void dealResult(List<Map<String, String>> result) {
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        Map<String, List<Map>> codeMap = result.stream().collect(Collectors.groupingBy(map -> (String)map.get("code")));
        List<Map> successList = codeMap.get("success");
        List<Map> errorList = codeMap.get("error");
        ArrayList<String> titleList = new ArrayList<String>();
        StringBuilder successMsg = new StringBuilder();
        if (CollectionUtils.isNotEmpty(successList)) {
            String value = String.format(ResManager.loadKDString((String)"%s\u4e2a\u65b9\u6848\u5bfc\u5165\u6210\u529f", (String)"PortalSchemeImportTask_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), successList.size());
            titleList.add(value);
            successMsg.append(value).append(":\n");
            successList.forEach(map -> successMsg.append((String)map.get("schemeName")).append("\n"));
            successMsg.append("\n");
        }
        StringBuilder errorMsg = new StringBuilder();
        if (CollectionUtils.isNotEmpty(errorList)) {
            String value = String.format(ResManager.loadKDString((String)"%s\u4e2a\u65b9\u6848\u5bfc\u5165\u5931\u8d25", (String)"PortalSchemeImportTask_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), errorList.size());
            titleList.add(value);
            errorMsg.append(value).append(":\n");
            errorList.forEach(map -> errorMsg.append((String)map.get("schemeName")).append((String)map.get("msg")).append("\n"));
        }
        String title = String.join((CharSequence)"\uff0c", titleList) + "\u3002";
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("message", title);
        map2.put("detail", successMsg.append((CharSequence)errorMsg).toString());
        this.getExportProgress().feedbackCustData(map2);
        this.getExportProgress().complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PortalSchemeImportData parseSchemeZip(ZipInputStream zipIn) throws IOException {
        int readLength;
        HashMap<String, String> preInfo = new HashMap<String, String>();
        ArrayList<String> dataModelList = new ArrayList<String>();
        ArrayList<Map<String, String>> appXMLList = new ArrayList<Map<String, String>>();
        HashMap<String, InputStream> pageSchemeInfo = new HashMap<String, InputStream>();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[0x1400000];
        while ((readLength = zipIn.read(buf, 0, buf.length)) != -1) {
            bos.write(buf, 0, readLength);
        }
        byte[] ret = bos.toByteArray();
        try (ZipInputStream appZipIn = new ZipInputStream((InputStream)new ByteArrayInputStream(ret), Charset.forName("gbk"));){
            while (true) {
                ZipEntry appZipEntry;
                if ((appZipEntry = appZipIn.getNextEntry()) != null) {
                    if (appZipEntry.isDirectory()) continue;
                    String appMetaName = appZipEntry.getName();
                    boolean flag = this.getMetadataContent(appMetaName, appZipIn, preInfo, dataModelList, appXMLList, pageSchemeInfo);
                    if (flag) continue;
                    PortalSchemeImportData portalSchemeImportData = null;
                    return portalSchemeImportData;
                    continue;
                }
                break;
            }
        }
        finally {
            try {
                bos.close();
            }
            catch (Exception e) {
                DisCardUtil.discard();
            }
        }
        return new PortalSchemeImportData(preInfo, dataModelList, appXMLList, pageSchemeInfo);
    }

    private List<Map<String, String>> executeSchemeData(PortalSchemeImportData data, String schemeName) throws Exception {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        if (data == null) {
            return result;
        }
        for (String dataModelXmlContent : data.getDataModelList()) {
            ByteArrayInputStream dminputStream = new ByteArrayInputStream(dataModelXmlContent.getBytes(StandardCharsets.UTF_8));
            SAXReader reader = new SAXReader();
            reader.setEncoding("utf-8");
            Document document = reader.read((InputStream)dminputStream);
            String cloudName = document.getRootElement().attributeValue("name");
            String version = document.getRootElement().element("ver").getText();
            List elements = document.getRootElement().element("app").elements();
            for (Element element : elements) {
                String name = element.attributeValue("name");
                String appname = cloudName + "-" + name;
                if (appname.length() > 10) {
                    appname = name;
                }
                String pkname = element.attributeValue("pkname");
                for (Map<String, String> appXmlMap : data.getAppXMLList()) {
                    for (String value : appXmlMap.values()) {
                        ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes());
                        SAXReader xmlReader = new SAXReader();
                        xmlReader.setEncoding("utf-8");
                        Document xmlDoc = xmlReader.read((InputStream)is);
                        List sqlElements = xmlDoc.getRootElement().elements();
                        if (sqlElements == null || sqlElements.size() <= 0) continue;
                        List<Map<String, String>> exeSqlResult = this.exeSql(sqlElements, data.getPreInfo(), version, appname, pkname, schemeName);
                        result.addAll(exeSqlResult);
                    }
                }
            }
            Map<String, InputStream> pageSchemeInfo = data.getPageSchemeInfo();
            if (pageSchemeInfo.isEmpty()) continue;
            this.exePageScheme(pageSchemeInfo);
        }
        return result;
    }

    private int initProgress(String url) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        logger.info("cache=" + cache.toString());
        int schemeCount = 0;
        int fileCount = 0;
        try (InputStream inStream = cache.getInputStream(url);
             ZipInputStream zipIn = new ZipInputStream(inStream, Charset.forName("gbk"));){
            ZipEntry zipEntry;
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                String metaName = zipEntry.getName();
                if (zipEntry.isDirectory()) continue;
                ++fileCount;
                if (!(metaName.startsWith("dm/") || metaName.startsWith("dm\\") || metaName.endsWith(".zip"))) {
                    schemeCount = 0;
                    break;
                }
                ++schemeCount;
            }
            if (fileCount == 0) {
                this.getExportProgress().fail(ResManager.loadKDString((String)"\u5bfc\u5165\u4e3a\u7a7a\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"PortalSchemeImportTask_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                this.getExportProgress().complete();
            } else if (schemeCount == 0) {
                this.getExportProgress().fail(ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u5bfc\u51fa\u6587\u4ef6\u683c\u5f0f\u5bfc\u5165\u3002", (String)"PortalSchemeImportTask_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                this.getExportProgress().complete();
            } else if (schemeCount > 100) {
                this.getExportProgress().fail(ResManager.loadKDString((String)"\u5355\u6b21\u6700\u591a\u5bfc\u5165100\u4e2a\u65b9\u6848\uff0c\u8bf7\u51cf\u5c11\u65b9\u6848\u6570\u91cf\u540e\u518d\u64cd\u4f5c\u3002", (String)"PortalSchemeImportTask_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                this.getExportProgress().complete();
            }
        }
        catch (Exception e) {
            logger.info("check zip error", (Object)e);
        }
        return schemeCount;
    }

    private void exePageScheme(Map<String, InputStream> pageSchemeInfo) {
        PreInsDataScriptWriter preInsDataScriptWriter = new PreInsDataScriptWriter();
        for (Map.Entry<String, InputStream> entry : pageSchemeInfo.entrySet()) {
            try {
                InputStream pageSchemeStream = entry.getValue();
                Throwable throwable = null;
                try {
                    preInsDataScriptWriter.insertPreInsData(pageSchemeStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pageSchemeStream == null) continue;
                    if (throwable != null) {
                        try {
                            pageSchemeStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pageSchemeStream.close();
                }
            }
            catch (Exception e) {
                logger.info("ImportSchemePlugin exePageScheme:", (Object)e);
            }
        }
    }

    private String getMetadataContext(ZipInputStream zipIn) throws IOException {
        int readLength;
        int len = 0;
        byte[] buf = new byte[0x1400000];
        while ((readLength = zipIn.read()) != -1) {
            buf[len] = (byte)readLength;
            ++len;
        }
        return new String(buf, 0, len, StandardCharsets.UTF_8);
    }

    private boolean getMetadataContent(String metaName, ZipInputStream zipIn, Map<String, String> preInfo, List<String> dataModelList, List<Map<String, String>> appXMLList, Map<String, InputStream> pageSchemeInfo) throws IOException {
        if (metaName.contains(PREINSDATA) && metaName.endsWith("sql")) {
            String content = this.getMetadataContext(zipIn);
            preInfo.put(metaName, content);
        } else if (metaName.endsWith(".xml") && !metaName.contains("t_bas_cardconfig") && !"appInfo.xml".equals(metaName)) {
            if (metaName.endsWith("datamodel.xml")) {
                String content = this.getMetadataContext(zipIn);
                dataModelList.add(content);
            } else {
                HashMap<String, String> appXmlMap = new HashMap<String, String>();
                String content = this.getMetadataContext(zipIn);
                appXmlMap.put(metaName, content);
                appXMLList.add(appXmlMap);
            }
        } else if (metaName.contains("t_bas_cardconfig") && metaName.endsWith(".xml")) {
            int readLength;
            int xmlIndex = metaName.indexOf("xml");
            String pageSchemeName = metaName.substring(xmlIndex + 4);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[0x1400000];
            while ((readLength = zipIn.read(buf, 0, buf.length)) != -1) {
                bos.write(buf, 0, readLength);
            }
            byte[] ret = bos.toByteArray();
            ByteArrayInputStream pageSchemeStream = new ByteArrayInputStream(ret);
            pageSchemeInfo.put(pageSchemeName, pageSchemeStream);
        }
        return true;
    }

    private List<Map<String, String>> exeSql(List<Element> sqlElements, Map<String, String> sqlInfo, String version, String appName, String pkname, String schemeName) throws IOException {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        ArrayList<String> executedSqlList = new ArrayList<String>();
        for (Element element : sqlElements) {
            String errorLevel;
            String type = element.attributeValue("Type");
            String separator = element.attributeValue("Separator");
            if (separator == null) {
                separator = ";";
            }
            if ((errorLevel = element.attributeValue("ErrorLevel")) == null) {
                errorLevel = "";
            }
            String dbKey = element.attributeValue("dbkey");
            String plugin = element.attributeValue("Plugin");
            String sql = element.getText();
            for (Map.Entry<String, String> entry : sqlInfo.entrySet()) {
                if (!entry.getKey().contains(sql)) continue;
                executedSqlList.add(entry.getKey());
                String sqlContext = sqlInfo.get(entry.getKey());
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("type", type);
                params.put("dbkey", dbKey);
                params.put("el", errorLevel);
                sql = element.getText();
                if (sql.contains(DBSCHEMA)) {
                    sql = sql.substring(DBSCHEMA.length() + 1);
                } else if (entry.getKey().contains(PREINSDATA)) {
                    sql = sql.substring(PREINSDATA.length() + 1);
                }
                params.put("ksqlname", sql);
                params.put("version", version);
                params.put("appname", appName);
                params.put("pkname", pkname);
                if (StringUtils.isNotBlank((CharSequence)plugin)) {
                    params.put("plugin", plugin);
                }
                Map exexMap = new HashMap();
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(sqlContext.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
                    Throwable throwable = null;
                    try {
                        List<String> sqlList = this.readerSql(br, separator);
                        if (CollectionUtils.isEmpty(sqlList)) {
                            result.add(this.wrapResult("error", schemeName, ResManager.loadKDString((String)"SQL\u4e3a\u7a7a\uff0c\u6267\u884c\u5931\u8d25\u3002", (String)"PortalSchemeImportTask_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])));
                            continue;
                        }
                        exexMap = ((DeployService)ServiceFactory.getService(DeployService.class)).deploySql(params, sqlList);
                        logger.info("exeSql exexMap:" + JSON.toJSONString(exexMap));
                        if (((Boolean)exexMap.get("success")).booleanValue()) {
                            String errorInfo = (String)exexMap.get("errorinfo");
                            String checkInfo = (String)exexMap.get("checkinfo");
                            if (StringUtils.isBlank((CharSequence)errorInfo) && StringUtils.isBlank((CharSequence)checkInfo)) {
                                result.add(this.wrapResult("success", schemeName, ""));
                                continue;
                            }
                            if (!StringUtils.isNotBlank((CharSequence)checkInfo)) continue;
                            if (checkInfo.contains(ResManager.loadKDString((String)"\u5df2\u88ab\u6267\u884c\u8fc7", (String)"PortalSchemeImportTask_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])) || checkInfo.contains(sql)) {
                                result.add(this.wrapResult("error", schemeName, ResManager.loadKDString((String)"\u5df2\u5bfc\u5165\uff0c\u65e0\u9700\u91cd\u590d\u5bfc\u5165\u3002", (String)"PortalSchemeImportTask_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])));
                                continue;
                            }
                            result.add(this.wrapResult("success", schemeName, this.getSuccessMsg() + checkInfo));
                            continue;
                        }
                        String resString = JSON.toJSONString(exexMap);
                        result.add(this.wrapResult("error", schemeName, resString));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (br == null) continue;
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        br.close();
                    }
                }
                catch (Exception ex) {
                    String infoMsg = "exeSql error";
                    if (exexMap != null && !exexMap.isEmpty()) {
                        infoMsg = infoMsg + JSON.toJSONString(exexMap);
                    }
                    logger.info(infoMsg, (Object)ex);
                    result.add(this.wrapResult("error", schemeName, ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5408\u6cd5\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"PortalSchemeImportTask_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])));
                }
            }
        }
        if (sqlInfo != null && sqlInfo.size() > 0) {
            for (String executedSql : executedSqlList) {
                sqlInfo.remove(executedSql);
            }
        }
        return result;
    }

    private Map<String, String> wrapResult(String code, String schemeName, String msg) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        map.put("schemeName", schemeName);
        map.put("msg", msg);
        return map;
    }

    private List<String> readerSql(BufferedReader br, String separator) throws Exception {
        String line;
        ArrayList<String> sqlList = new ArrayList<String>();
        boolean isFirstLine = true;
        StringBuilder sb = new StringBuilder();
        boolean commentLine = false;
        while ((line = br.readLine()) != null) {
            String sql;
            if (line.length() <= 0) continue;
            if (isFirstLine && line.charAt(0) == '\ufeff') {
                line = line.substring(1);
                isFirstLine = false;
            }
            String temp = line.trim();
            if (commentLine) {
                if (!temp.endsWith("*/")) continue;
                commentLine = false;
                continue;
            }
            if (temp.startsWith("/*")) {
                if (temp.endsWith("*/")) continue;
                commentLine = true;
                continue;
            }
            if (temp.startsWith("--")) continue;
            if (!(temp.endsWith(separator) && "GO".equals(separator) || StringUtils.isBlank((CharSequence)temp))) {
                sb.append(" ").append(line).append(" ");
            }
            if (!temp.endsWith(separator)) continue;
            String curSql = sb.toString();
            if (curSql.contains("INSERT INTO t_bas_cardconfig") && curSql.contains("'bos_card_qing'")) {
                int startIndex = curSql.indexOf("'{");
                int endIndex = curSql.lastIndexOf("}'");
                String configJsonStr = curSql.substring(startIndex + 1, endIndex + 1);
                String resultStr = this.invokeBOSService(configJsonStr);
                sb.replace(startIndex + 1, endIndex + 1, resultStr);
            }
            if (this.checkPortalSchemeSql(sql = sb.toString())) {
                sqlList.add(sql);
            }
            sb = new StringBuilder();
        }
        return sqlList;
    }

    private boolean checkPortalSchemeSql(String sql) throws ParserException {
        String[] sqlArr;
        if (StringUtils.isBlank((CharSequence)sql)) {
            return true;
        }
        for (String oneSql : sqlArr = sql.split(";")) {
            String tableName;
            if (StringUtils.isBlank((CharSequence)oneSql)) continue;
            SqlStmtParser sqlStmtParser = new SqlStmtParser(oneSql);
            SqlStmt sqlStmt = sqlStmtParser.stmt();
            if (sqlStmt instanceof SqlDeleteStmt) {
                SqlDeleteStmt sqlDeleteStmt = (SqlDeleteStmt)sqlStmt;
                SqlTableSource sts = (SqlTableSource)sqlDeleteStmt.delete.tableSource;
                tableName = sts.name;
            } else if (sqlStmt instanceof SqlInsertStmt) {
                SqlInsertStmt sqlInsertStmt = (SqlInsertStmt)sqlStmt;
                tableName = sqlInsertStmt.insert.tableName;
            } else if (sqlStmt instanceof SqlUpdateStmt) {
                SqlUpdateStmt sqlUpdateStmt = (SqlUpdateStmt)sqlStmt;
                tableName = sqlUpdateStmt.update.updateTable.name;
            } else if (sqlStmt instanceof SqlSelectStmt) {
                SqlSelectStmt sqlSelectStmt = (SqlSelectStmt)sqlStmt;
                SqlSelect sqlSelect = (SqlSelect)sqlSelectStmt.select;
                SqlTableSource sqlTableSource = (SqlTableSource)sqlSelect.tableSource;
                tableName = sqlTableSource.name;
            } else {
                throw new KDException(new ErrorCode("checkPortalSchemeSql error", "Illega sql"), new Object[0]);
            }
            if (portalSchemeTables.contains(tableName.toLowerCase())) continue;
            throw new KDException(new ErrorCode("checkPortalSchemeSql fail", "Illega sql"), new Object[0]);
        }
        return true;
    }

    private String invokeBOSService(String configJsonStr) {
        return (String)DispatchServiceHelper.invokeBOSService((String)"qing", (String)"QingService", (String)"switchHomepageCardPathToId", (Object[])new Object[]{configJsonStr});
    }
}

