/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.AdminAppResult;
import kd.bos.portal.constant.SchemeType;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.util.MainPageSchemeUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class PortalSchemeListPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener {
    private static final String NODESUFFIX_CLOUD = "#cloud";
    private static final String NODESUFFIX_APP = "#app";
    private static final String PNL_TREEBTN = "flexpanel_treebtn";
    private static final String CTRL_TREEVIEW = "treeview";
    private static final String PGCACHE_CLOUDAPPMAP = "pgCache_CloudAppMap";
    private static final String USER_LIST = "billlistap";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String TBLENABLE = "tblenable";
    private static final String ENABLE_STATUS = "2";
    private static Log logger = LogFactory.getLog(PortalSchemeListPlugin.class);
    private static final String IMPORTSCHEME = "importscheme";
    private static final String EXPORT_SCHEME = "exportscheme";
    private static final String INSTALLAPP_SCHEME = "bos_installapp_scheme";

    private String getSysSchemeTipMsg() {
        return ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u542f\u7528\u4e00\u4e2a\u5168\u5c40\u65b9\u6848\u3002", (String)"PortalSchemeListPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private String getUserSchemeTipMsg() {
        return ResManager.loadKDString((String)"\u540c\u4e00\u7528\u6237\uff0c\u53ea\u5141\u8bb8\u542f\u7528\u4e00\u4e2a\u4e2a\u6027\u65b9\u6848\u3002", (String)"PortalSchemeListPlugin_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        if (TBLENABLE.equals(itemkey)) {
            BillList billList = (BillList)this.getView().getControl(USER_LIST);
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (rows.size() <= 0) {
                return;
            }
            Object[] pkValues = rows.getPrimaryKeyValues();
            boolean checkSysSchemeEnable = this.checkSysSchemeEnable(pkValues, SchemeType.SysDefScheme.getValue());
            if (!checkSysSchemeEnable) {
                this.getView().showTipNotification(this.getSysSchemeTipMsg());
                evt.setCancel(true);
                return;
            }
            boolean checkUserSchemeEnable = this.checkUserSchemeEnable(pkValues, SchemeType.UserScheme.getValue());
            if (!checkUserSchemeEnable) {
                this.getView().showTipNotification(this.getUserSchemeTipMsg());
                evt.setCancel(true);
            }
        }
    }

    private boolean checkSysSchemeEnable(Object[] pkValues, String schemeType) {
        DynamicObject[] protalSchemaObject = this.getSchemeByIds(pkValues, schemeType);
        if (protalSchemaObject == null || protalSchemaObject.length <= 0) {
            return true;
        }
        boolean hasMultiEnableSysScheme = this.hasMultiEnableSysScheme(protalSchemaObject, schemeType);
        if (hasMultiEnableSysScheme) {
            return false;
        }
        boolean hasMultiEnableBizScheme = this.hasMultiEnableBizScheme(protalSchemaObject, schemeType);
        return !hasMultiEnableBizScheme;
    }

    private boolean checkUserSchemeEnable(Object[] pkValues, String schemeType) {
        DynamicObject[] protalSchemaObject = this.getSchemeByIds(pkValues, schemeType);
        if (protalSchemaObject == null || protalSchemaObject.length <= 0) {
            return true;
        }
        boolean hasMultiEnableSysScheme = this.hasMultiEnableUserScheme(protalSchemaObject, schemeType);
        if (hasMultiEnableSysScheme) {
            return false;
        }
        boolean hasMultiEnableBizScheme = this.hasMultiEnableUserBizScheme(protalSchemaObject, schemeType);
        return !hasMultiEnableBizScheme;
    }

    private boolean hasMultiEnableSysScheme(DynamicObject[] protalSchemaObject, String schemeType) {
        List sysMainSchemes = Arrays.stream(protalSchemaObject).filter(scheme -> "main".equals(scheme.get("pagetype"))).collect(Collectors.toList());
        if (sysMainSchemes.size() > 1) {
            return true;
        }
        for (DynamicObject scheme2 : sysMainSchemes) {
            String pageType;
            Long id = scheme2.getLong("id");
            boolean exist = this.hasSameTypeScheme(id, pageType = scheme2.getString("pagetype"), null, schemeType, null);
            if (!exist) continue;
            return true;
        }
        return false;
    }

    private boolean hasMultiEnableBizScheme(DynamicObject[] protalSchemaObject, String schemeType) {
        Map<String, List<DynamicObject>> schemeGroup = Arrays.stream(protalSchemaObject).filter(scheme -> "app".equals(scheme.get("pagetype"))).collect(Collectors.groupingBy(scheme -> {
            DynamicObject bizApp = scheme.getDynamicObject("bizapp");
            if (bizApp != null) {
                return bizApp.get("number").toString();
            }
            return "";
        }));
        long count = schemeGroup.values().stream().filter(datas -> datas.size() > 1).count();
        if (count > 0L) {
            return true;
        }
        for (Map.Entry<String, List<DynamicObject>> entry : schemeGroup.entrySet()) {
            String pageType;
            String bizapp = entry.getKey();
            List<DynamicObject> schemes = entry.getValue();
            DynamicObject scheme2 = schemes.get(0);
            Long id = scheme2.getLong("id");
            boolean exist = this.hasSameTypeScheme(id, pageType = scheme2.getString("pagetype"), bizapp, schemeType, null);
            if (!exist) continue;
            return true;
        }
        return false;
    }

    private boolean hasMultiEnableUserScheme(DynamicObject[] protalSchemaObject, String schemeType) {
        Map<Long, List<DynamicObject>> userMainSchemeGroup = Arrays.stream(protalSchemaObject).filter(scheme -> "main".equals(scheme.get("pagetype"))).collect(Collectors.groupingBy(scheme -> {
            DynamicObject creator = scheme.getDynamicObject("creator");
            if (creator != null) {
                return creator.getLong("id");
            }
            return 0L;
        }));
        long count = userMainSchemeGroup.values().stream().filter(datas -> datas.size() > 1).count();
        if (count > 0L) {
            return true;
        }
        for (Map.Entry<Long, List<DynamicObject>> entry : userMainSchemeGroup.entrySet()) {
            String pageType;
            Long creatorId = entry.getKey();
            List<DynamicObject> schemes = entry.getValue();
            DynamicObject scheme2 = schemes.get(0);
            Long id = scheme2.getLong("id");
            boolean exist = this.hasSameTypeScheme(id, pageType = scheme2.getString("pagetype"), null, schemeType, creatorId);
            if (!exist) continue;
            return true;
        }
        return false;
    }

    private boolean hasMultiEnableUserBizScheme(DynamicObject[] protalSchemaObject, String schemeType) {
        Map<String, List<DynamicObject>> bizUserSchemeGroup = Arrays.stream(protalSchemaObject).filter(scheme -> "app".equals(scheme.get("pagetype"))).collect(Collectors.groupingBy(scheme -> {
            DynamicObject bizApp = scheme.getDynamicObject("bizapp");
            String appNum = "";
            if (bizApp != null) {
                appNum = bizApp.get("number").toString();
            }
            DynamicObject creator = scheme.getDynamicObject("creator");
            long creatorid = 0L;
            if (creator != null) {
                creatorid = creator.getLong("id");
            }
            return appNum + "," + creatorid;
        }));
        long count = bizUserSchemeGroup.values().stream().filter(datas -> datas.size() > 1).count();
        if (count > 0L) {
            return true;
        }
        for (Map.Entry<String, List<DynamicObject>> entry : bizUserSchemeGroup.entrySet()) {
            String pageType;
            String key = entry.getKey();
            String[] appAndUser = key.split(",");
            String bizapp = appAndUser[0];
            Long creator = Long.valueOf(appAndUser[1]);
            List<DynamicObject> schemes = entry.getValue();
            DynamicObject scheme2 = schemes.get(0);
            Long id = scheme2.getLong("id");
            boolean exist = this.hasSameTypeScheme(id, pageType = scheme2.getString("pagetype"), bizapp, schemeType, creator);
            if (!exist) continue;
            return true;
        }
        return false;
    }

    private DynamicObject[] getSchemeByIds(Object[] pkValues, String schemeType) {
        String selectFields = "id,number,name,schemetype,bizapp,pagetype,creator";
        QFilter qId = new QFilter("id", "in", (Object)pkValues);
        QFilter schemeTypeFilter = new QFilter("schemetype", "=", (Object)schemeType);
        QFilter ismultiorg = new QFilter("ismultiorg", "=", (Object)CardUtils.convertModeType());
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.FALSE);
        QFilter[] filters = new QFilter[]{qId.and(schemeTypeFilter).and(ismultiorg).and(enableFilter)};
        return BusinessDataServiceHelper.load((String)"portal_scheme", (String)selectFields, (QFilter[])filters);
    }

    private boolean hasSameTypeScheme(Long id, String pageType, String bizApp, String schemeType, Long creatorId) {
        Map schemes;
        QFilter idFilter = new QFilter("id", "!=", (Object)id);
        QFilter schemeTypeFilter = new QFilter("schemetype", "=", (Object)schemeType);
        QFilter ismultiorg = new QFilter("ismultiorg", "=", (Object)CardUtils.convertModeType());
        QFilter enable = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter pageTypeFilter = new QFilter("pagetype", "=", (Object)pageType);
        QFilter filters = idFilter.and(schemeTypeFilter).and(ismultiorg).and(enable).and(pageTypeFilter);
        if (bizApp != null) {
            QFilter bizAppFilter = new QFilter("bizapp.number", "=", (Object)bizApp);
            filters.and(bizAppFilter);
        }
        if (SchemeType.UserScheme.getValue().equals(schemeType)) {
            QFilter userFilter = new QFilter("creator", "=", (Object)creatorId);
            filters.and(userFilter);
        }
        return (schemes = BusinessDataServiceHelper.loadFromCache((String)"portal_scheme", (String)"id", (QFilter[])new QFilter[]{filters})) != null && schemes.size() > 0;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (operate == null) {
            return;
        }
        String key = operate.getOperateKey();
        if ("disableedit".equals(key) || "enableedit".equals(key)) {
            DynamicObject[] dynamicObjects;
            BillList billList = (BillList)this.getView().getControl(USER_LIST);
            ListSelectedRowCollection rows = billList.getSelectedRows();
            Object[] rowPkArr = rows.getPrimaryKeyValues();
            QFilter idFilter = new QFilter("id", "in", Stream.of(rowPkArr).collect(Collectors.toList()));
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"portal_scheme", (String)"schemetype", (QFilter[])new QFilter[]{idFilter})) {
                String schemeType = dynamicObject.getString("schemetype");
                if (!SchemeType.UserScheme.getValue().equals(schemeType)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u65b9\u6848\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c\u3002", (String)"PortalSchemeListPlugin_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String itemkey = evt.getOperateKey();
        OperationResult opResult = evt.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "importscheme": {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(INSTALLAPP_SCHEME);
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(fsp);
                break;
            }
            case "exportscheme": {
                BillList billList = (BillList)this.getView().getControl(USER_LIST);
                ListSelectedRowCollection rows = billList.getSelectedRows();
                Object[] pkValues = rows.getPrimaryKeyValues();
                if (pkValues.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PortalSchemeListPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (pkValues.length > 100) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u6b21\u6700\u591a\u5bfc\u51fa100\u4e2a\u65b9\u6848\uff0c\u8bf7\u51cf\u5c11\u65b9\u6848\u6570\u91cf\u540e\u518d\u64cd\u4f5c\u3002", (String)"PortalSchemeListPlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                this.showProgressForm();
                break;
            }
            case "disableedit": {
                this.changeIsEdit(false);
                break;
            }
            case "enableedit": {
                this.changeIsEdit(true);
                break;
            }
        }
    }

    private void showProgressForm() {
        String entityNumber = ((ListView)this.getView()).getBillFormId();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_portal_schexpprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map customParams = showParameter.getCustomParams();
        customParams.put("ServiceAppId", this.getView().getFormShowParameter().getServiceAppId());
        customParams.put("entitynumber", entityNumber);
        String caption = this.getView().getFormShowParameter().getCaption();
        customParams.put("entityname", StringUtils.isBlank((CharSequence)caption) ? this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue() : caption);
        customParams.put("achieveKey", this.getAchieveKey());
        customParams.put("routeKey", this.getRouteKey());
        this.getView().showForm(showParameter);
    }

    private boolean isBillView() {
        return this.getView() instanceof IBillView;
    }

    private String getAchieveKey() {
        if (!this.isBillView()) {
            IListView listview = (IListView)this.getView();
            BillList billList = (BillList)listview.getControl(USER_LIST);
            String achiveKey = billList.getListModel().getAchiveKey();
            return achiveKey;
        }
        return null;
    }

    private String getRouteKey() {
        if (!this.isBillView()) {
            IListView listview = (IListView)this.getView();
            BillList billList = (BillList)listview.getControl(USER_LIST);
            String routeKey = billList.getListModel().getRouteKey();
            return routeKey;
        }
        return null;
    }

    private void changeIsEdit(boolean isEdit) {
        DynamicObject[] dynamicObjects;
        BillList billList = (BillList)this.getView().getControl(USER_LIST);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        Object[] pkValues = rows.getPrimaryKeyValues();
        QFilter idFilter = new QFilter("id", "in", Stream.of(pkValues).collect(Collectors.toList()));
        QFilter editFilter = new QFilter("isedit", "=", (Object)(!isEdit ? 1 : 0));
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"portal_scheme", (String)"id, isedit", (QFilter[])new QFilter[]{idFilter, editFilter})) {
            dynamicObject.set("isedit", (Object)isEdit);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        ((ListView)this.getView()).refresh();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tv = (TreeView)this.getControl(CTRL_TREEVIEW);
        if (tv != null) {
            tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TreeView treeView = (TreeView)this.getControl(CTRL_TREEVIEW);
        if (treeView != null) {
            treeView.focusNode(this.getTreeModel().getRoot());
        }
        if (MainPageSchemeUtil.isIgnoreSql().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{IMPORTSCHEME});
        }
    }

    public void initializeTree(EventObject e) {
        TreeNode root = this.getTreeModel().createRootNode();
        String rootId = root.getId();
        List<TreeNode> forAddTreeNodes = this.getChildNode(rootId);
        root.addChildren(forAddTreeNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
    }

    public List<TreeNode> getChildNode(String curNodeId) {
        List<TreeNode> forAddTreeNodes = new ArrayList<TreeNode>();
        Map<String, List<String>> cloudAppMap = new HashMap<String, List<String>>(16);
        if (StringUtils.isBlank((CharSequence)curNodeId)) {
            return new ArrayList<TreeNode>();
        }
        ArrayList<String> allDistinctAppIdInScheme = new ArrayList(10);
        if (curNodeId.equals("8609760E-EF83-4775-A9FF-CCDEC7C0B689") || curNodeId.endsWith(NODESUFFIX_CLOUD)) {
            allDistinctAppIdInScheme = this.getAllDistinctAppIdInScheme();
        }
        if (curNodeId.equals("8609760E-EF83-4775-A9FF-CCDEC7C0B689")) {
            DynamicObjectCollection allBizClouds = BizCloudServiceHelp.getAllBizClouds();
            Map<String, List<TreeNode>> cloudAppNodes = this.getCloudAppNodes(cloudAppMap, allDistinctAppIdInScheme);
            for (DynamicObject cloud : allBizClouds) {
                String cloudId = cloud.getString("id");
                String cloudName = cloud.getString("name");
                TreeNode cloudNode = new TreeNode();
                cloudNode.setParentid(curNodeId);
                String cloudNodeId = cloudId + NODESUFFIX_CLOUD;
                cloudNode.setId(cloudNodeId);
                cloudNode.setText(cloudName);
                List<TreeNode> appNodes = cloudAppNodes.get(cloudId);
                if (appNodes == null || appNodes.size() == 0) continue;
                cloudNode.addChildren(appNodes);
                forAddTreeNodes.add(cloudNode);
            }
            this.getPageCache().put(PGCACHE_CLOUDAPPMAP, SerializationUtils.toJsonString(cloudAppMap));
        } else if (curNodeId.endsWith(NODESUFFIX_CLOUD)) {
            String cloudId = curNodeId.substring(0, curNodeId.indexOf(35));
            ArrayList<String> appIds = new ArrayList<String>();
            forAddTreeNodes = this.getAppNodes(cloudId, appIds, allDistinctAppIdInScheme);
            cloudAppMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_CLOUDAPPMAP), Map.class);
            cloudAppMap.put(cloudId, appIds);
            this.getPageCache().put(PGCACHE_CLOUDAPPMAP, SerializationUtils.toJsonString(cloudAppMap));
        } else if (curNodeId.endsWith(NODESUFFIX_APP)) {
            return new ArrayList<TreeNode>();
        }
        return forAddTreeNodes;
    }

    private Map<String, List<TreeNode>> getCloudAppNodes(Map<String, List<String>> cloudAppMap, List<String> allDistinctAppIdInScheme) {
        HashMap<String, List<TreeNode>> cloudAppNodes = new HashMap<String, List<TreeNode>>(16);
        JSONArray allAppsInSystem = BizAppServiceHelp.getAllAppInfo();
        if (allAppsInSystem == null || allAppsInSystem.size() == 0) {
            return cloudAppNodes;
        }
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        Long userId = RequestContext.get().getCurrUserId();
        AdminAppResult appResult = PermissionServiceHelper.getAdminApps((Long)userId);
        HashMap appIdAndNameMap = new HashMap();
        allAppsInSystem.forEach(appArray -> {
            JSONArray cloudAndApp = (JSONArray)appArray;
            JSONObject cloud = (JSONObject)cloudAndApp.get(0);
            if (cloud == null) {
                return;
            }
            String cloudId = cloud.getString("id");
            ArrayList appIds = new ArrayList();
            ArrayList appTreeNodes = new ArrayList();
            cloudAndApp.forEach(cloudOrApp -> {
                JSONObject app = (JSONObject)cloudOrApp;
                if (app.get((Object)"iscloud") != null) {
                    return;
                }
                String appId = app.getString("id");
                if (appResult.needAdminAppRange() && !appResult.getAppIds().contains(appId)) {
                    return;
                }
                if (!allDistinctAppIdInScheme.contains(appId) || disabledAppIds.contains(appId)) {
                    return;
                }
                JSONObject appNameJSONObject = app.getJSONObject("name");
                String appName = "";
                if (appNameJSONObject != null) {
                    appName = appNameJSONObject.getString(RequestContext.get().getLang().name());
                }
                if (StringUtils.isBlank((CharSequence)appName)) {
                    return;
                }
                TreeNode appNode = new TreeNode();
                appNode.setParentid(cloudId + NODESUFFIX_CLOUD);
                appNode.setId(appId + NODESUFFIX_APP);
                appNode.setText(appName);
                appIdAndNameMap.put(appId, appName);
                appTreeNodes.add(appNode);
                appIds.add(appId);
            });
            if (appIds.size() > 0) {
                cloudAppMap.put(cloudId, appIds);
            }
            cloudAppNodes.put(cloudId, appTreeNodes);
        });
        if (appIdAndNameMap.size() > 0) {
            this.getPageCache().put(appIdAndNameMap);
        }
        return cloudAppNodes;
    }

    private List<TreeNode> getAppNodes(String cloudId, List<String> appIds, List<String> allDistinctAppIdInScheme) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        DynamicObjectCollection allBizApps = BizAppServiceHelp.getAllBizAppsByCloudID((String)cloudId);
        if (allBizApps.size() == 0) {
            return result;
        }
        for (DynamicObject app : allBizApps) {
            String appId = app.getString("id");
            String appName = app.getString("name");
            boolean visible = app.getBoolean("visible");
            String deployStatus = app.getString("deploystatus");
            if (!visible || !ENABLE_STATUS.equals(deployStatus) || !allDistinctAppIdInScheme.contains(appId)) continue;
            TreeNode appNode = new TreeNode();
            appNode.setParentid(cloudId + NODESUFFIX_CLOUD);
            appNode.setId(appId + NODESUFFIX_APP);
            appNode.setText(appName);
            if (appIds != null) {
                appIds.add(appId);
            }
            result.add(appNode);
        }
        return result;
    }

    private List<String> getAllDistinctAppIdInScheme() {
        final ArrayList<String> allAppIds = new ArrayList<String>();
        String sql = "select distinct fbizappid from t_bas_mainpagelayout";
        DB.query((DBRoute)DBRoute.basedata, (String)sql, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    if (StringUtils.isBlank((CharSequence)appId)) continue;
                    allAppIds.add(appId);
                }
                return null;
            }
        });
        return allAppIds;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        QFilter subOrgFilter = this.generateTreeListFilter(e.getNodeId().toString());
        if (subOrgFilter != null) {
            e.addQFilter(subOrgFilter);
        }
    }

    public void initTreeToolbar(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PNL_TREEBTN});
    }

    public void refreshNode(RefreshNodeEvent e) {
        String curNodeId = (String)e.getNodeId();
        e.setChildNodes(this.getChildNode(curNodeId));
    }

    private QFilter generateTreeListFilter(String nodeId) {
        QFilter filter = null;
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return filter;
        }
        Map cloudAppMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PGCACHE_CLOUDAPPMAP), Map.class);
        List<String> appIds = null;
        if (nodeId.endsWith(NODESUFFIX_APP)) {
            String appId = nodeId.substring(0, nodeId.indexOf(35));
            appIds = new ArrayList<String>();
            appIds.add(appId);
        } else if (nodeId.endsWith(NODESUFFIX_CLOUD)) {
            String cloudId = nodeId.substring(0, nodeId.indexOf(35));
            appIds = (List)cloudAppMap.get(cloudId);
        }
        if (appIds != null) {
            filter = new QFilter("bizapp", "in", appIds);
        }
        return filter;
    }

    public void setFilter(SetFilterEvent e) {
        List appIds;
        Long userId;
        AdminAppResult appResult;
        super.setFilter(e);
        String modeType = CardUtils.convertModeType();
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("ismultiorg", "=", (Object)modeType));
        String value = (String)this.getView().getFormShowParameter().getCustomParam("schemeSwitchF7");
        if ("true".equals(value)) {
            return;
        }
        DynamicObjectCollection allBizApps = BizAppServiceHelp.getAllBizApps();
        Set allAppIds = allBizApps.stream().filter(app -> {
            boolean visible = app.getBoolean("visible");
            String deployStatus = app.getString("deploystatus");
            return visible && ENABLE_STATUS.equals(deployStatus);
        }).map(appObj -> appObj.getString("id")).collect(Collectors.toSet());
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        if (!CollectionUtils.isEmpty((Collection)disabledAppIds)) {
            allAppIds.removeAll(disabledAppIds);
        }
        if ((appResult = PermissionServiceHelper.getAdminApps((Long)(userId = Long.valueOf(RequestContext.get().getCurrUserId())))).needAdminAppRange() && !CollectionUtils.isEmpty((Collection)(appIds = appResult.getAppIds()))) {
            allAppIds.retainAll(appIds);
        }
        QFilter qFilter = new QFilter("bizapp", "in", allAppIds);
        QFilter mainPageTypeFilter = new QFilter("pagetype", "=", (Object)"main");
        qFilter.or(mainPageTypeFilter);
        qFilters.add(qFilter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                for (DynamicObject row : rows) {
                    DynamicObject bizApp = row.getDynamicObject("bizapp");
                    if (bizApp == null) continue;
                    String appId = bizApp.getString("id");
                    String name = PortalSchemeListPlugin.this.getView().getPageCache().get(appId);
                    ILocaleString nameLocal = bizApp.getLocaleString("name");
                    String curName = "";
                    if (nameLocal != null) {
                        curName = nameLocal.getLocaleValue();
                    }
                    if (curName == null || curName.equals(name)) continue;
                    row.set("bizapp.name", (Object)name);
                }
                return rows;
            }
        });
    }
}

