/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.event.ClickEventArgs;

public class PortalSchemeTaskClick
extends AbstractTaskClick {
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";

    public void click(ClickEventArgs e) {
        super.click(e);
        TaskInfo taskInfo = this.queryTask();
        if (taskInfo == null) {
            return;
        }
        if (!taskInfo.isTaskEnd()) {
            this.showProgress();
        } else {
            this.complete(taskInfo);
            e.setClearTask(true);
        }
        IFormView view = this.getParentView();
        if (view != null && !StringUtils.equals((CharSequence)this.getMainView().getPageId(), (CharSequence)view.getPageId())) {
            this.getMainView().sendFormAction(view);
        }
    }

    private void showProgress() {
        if (this.isExistProgressForm()) {
            return;
        }
        IFormView view = this.getParentView();
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (view == null || jobFormInfo == null) {
            this.getMainView().showMessage(ResManager.loadKDString((String)"\u542f\u52a8\u4efb\u52a1\u7684\u5217\u8868\u754c\u9762\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u518d\u6253\u5f00\u5bfc\u51fa\u8fdb\u5ea6\u754c\u9762\u3002", (String)"PortalSchemeTaskClick_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Map params = jobFormInfo.getJobInfo().getParams();
        Object progressType = params.get("progressType");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("export".equals(progressType) ? "bos_portal_schexpprogress" : "bos_portal_schimpprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().putAll(jobFormInfo.getParams());
        showParameter.getCustomParams().put("export_jobforminfo", SerializationUtils.toJsonString((Object)jobFormInfo));
        showParameter.getCustomParams().put("export_taskid", this.getTaskId());
        view.showForm(showParameter);
        this.setProgressPageId(showParameter.getPageId());
    }

    private void complete(TaskInfo taskInfo) {
        IFormView view = this.getParentView();
        if (view == null) {
            view = this.getMainView();
        }
        String strData = taskInfo.getData();
        if (taskInfo.isFailure()) {
            this.showFailMessage(view, taskInfo.getFailureReason());
            return;
        }
        if (StringUtils.isBlank((CharSequence)strData)) {
            return;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
        if (data.get("message") != null) {
            view.getParentView().showMessage(data.get("message").toString(), data.get("detail").toString(), MessageTypes.Permission);
            view.sendFormAction(view.getParentView());
        }
        if (data.containsKey("fail") && data.containsKey("failmessage")) {
            boolean fail = (Boolean)data.get("fail");
            String failmessage = (String)data.get("failmessage");
            if (fail && StringUtils.isNotBlank((CharSequence)failmessage)) {
                view.showErrMessage(failmessage, "");
            }
        }
    }

    private void showFailMessage(IFormView view, String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            message = ResManager.loadKDString((String)"\u540e\u53f0\u4efb\u52a1\u5df2\u7ec8\u6b62\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"PortalSchemeTaskClick_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        }
        if (message.length() > 50 && (message.contains("Exception") || message.contains("exception"))) {
            view.showErrMessage(message, "");
            return;
        }
        view.showErrorNotification(message);
    }
}

