/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Icon;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.IconAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.portal.constant.MenuTypeEnum;
import kd.bos.portal.dto.QuickLaunchCardInfo;
import kd.bos.portal.service.PortalMenuService;
import kd.bos.portal.service.TreeService;
import kd.bos.portal.service.bo.PortalMenuInfo;
import kd.bos.portal.service.impl.TreeServiceImpl;
import kd.bos.portal.util.LeftTreeSearchUtil;
import kd.bos.portal.util.PortalUsableFuncUtil;
import kd.bos.util.JSONUtils;
import org.apache.commons.lang.StringUtils;

public class QuickLaunchConfigPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
ListboxClickListener,
SearchEnterListener,
TabSelectListener {
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String PARENT_ID = "parentId";
    public static final String MENU_ID = "menuId";
    public static final String FORM_ID = "formId";
    public static final String PX = "600px";
    public static final String CENTER = "center";
    private static final String APP_OR_CLOUD_JSON_INFO = "app_or_cloud_cache";
    private static final String HAS_FILTER_MENUS_CACHE = "has_Filter_Menus_cache";
    private static Log log = LogFactory.getLog(QuickLaunchConfigPlugin.class);
    public static final String SUFFIX_MENU = "|menu";
    public static final String MENU_PREFIX = "menu#";
    public static final String APP_PREFIX = "app#";
    public static final String CLOUD_PREFIX = "cloud#";
    public static final String ICON_PREFIX = "iconap";
    public static final String PANEL_PREFIX = "panelap";
    public static final String LABEL_PREFIX = "labelap";
    public static final String CARD_PREFIX = "cardap";
    public static final String VECTOR_PREFIX = "vectorap";
    public static final String PANEL_CONTAINER = "flexpanel_menucards";
    public static final String COUNT_LABEL = "label_count";
    public static final String DEFAULT_ICONURL = "/icons/pc/entrance/default_48_48.png";
    public static final String UNSELECT_FONT = "kdfont kdfont-fuxuankuangweixuanzhong_yuan";
    public static final String SELECTED_FONT = "kdfont kdfont-fuxuankuangxuanzhong_yuan";
    public static final String CLOUD_APP_TREE = "tree_cloudappmenu";
    public static final String SELECTED_NODE = "cache_selectedNode";
    private static final String MENU_SEARCH_AP = "menusearchap";
    private PortalMenuService menuService;
    private TreeService treeService = new TreeServiceImpl();

    public void initialize() {
        super.initialize();
        Listbox listbox = (Listbox)this.getControl("listboxap");
        ArrayList<ListboxItem> listboxItems = new ArrayList<ListboxItem>();
        ListboxItem listboxItem = new ListboxItem("appfunc", ResManager.loadKDString((String)"\u5e94\u7528\u529f\u80fd", (String)"QuickLaunchConfigPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        listboxItems.add(listboxItem);
        listboxItem = new ListboxItem("link", ResManager.loadKDString((String)"\u5916\u90e8\u94fe\u63a5", (String)"QuickLaunchConfigPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        listboxItems.add(listboxItem);
        listbox.addItems(listboxItems);
        this.menuService = new PortalMenuService(this.getPageCache());
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap8"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel", "icon_menu", "icon_link"});
        TreeView treeCloudAppMenu = (TreeView)this.getView().getControl(CLOUD_APP_TREE);
        treeCloudAppMenu.addTreeNodeClickListener((TreeNodeClickListener)this);
        Listbox listbox = (Listbox)this.getControl("listboxap");
        listbox.addListboxClickListener((ListboxClickListener)this);
        Search searchTreeNode = (Search)this.getControl("treenodesearch");
        searchTreeNode.addEnterListener((SearchEnterListener)this);
        Search menuSearch = (Search)this.getControl(MENU_SEARCH_AP);
        menuSearch.addEnterListener((SearchEnterListener)this);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String menuStr = (String)this.getView().getFormShowParameter().getCustomParam("menuMap");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)menuStr)) {
            Map cacheMenuMap = (Map)SerializationUtils.fromJsonString((String)menuStr, Map.class);
            this.getPageCache().put(SELECTED_NODE, menuStr);
            Label count = (Label)this.getControl(COUNT_LABEL);
            count.setText(String.valueOf(cacheMenuMap.size()));
            this.getView().updateView(COUNT_LABEL);
        }
        this.initCloudAppTree();
    }

    private void initCloudAppTree() {
        PortalUsableFuncUtil portalUtil = new PortalUsableFuncUtil(log, this.getView());
        JSONArray resultApps = portalUtil.getUserHasPerAppWithCache();
        if (resultApps == null || resultApps.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5e94\u7528\u3002", (String)"QuickLaunchConfigPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        TreeView tree = (TreeView)this.getView().getControl(CLOUD_APP_TREE);
        TreeNode rootNode = new TreeNode();
        TreeNode currentUseMenu = new TreeNode("", "currentusemenu", ResManager.loadKDString((String)"\u6700\u8fd1\u4f7f\u7528", (String)"PortalSetCommonFuncPlugin_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        rootNode.addChild(currentUseMenu);
        TreeNode myCollectMenu = new TreeNode("", "mycollectmenu", ResManager.loadKDString((String)"\u6211\u7684\u6536\u85cf", (String)"PortalSetCommonFuncPlugin_11", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        rootNode.addChild(myCollectMenu);
        TreeNode cloudNode = this.treeService.buildTree(resultApps);
        rootNode.addChildren(cloudNode.getChildren());
        tree.addNodes(rootNode.getChildren());
        String json = SerializationUtils.toJsonString((Object)rootNode);
        this.getPageCache().putBigObject(APP_OR_CLOUD_JSON_INFO, resultApps.toJSONString());
        this.getPageCache().putBigObject("nodes", json);
        this.treeService.clickCurrentAppNode(this.getView(), CLOUD_APP_TREE, rootNode, this);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Map map = (Map)e.getReturnData();
        if (map == null) {
            return;
        }
        String iconKey = (String)map.get("value");
        if ("callback_menu".equals(actionId)) {
            Icon iconMenu = (Icon)this.getControl("icon_menu");
            iconMenu.setIconKey(iconKey);
            this.getPageCache().put("cache_menuicon", iconKey);
        } else if ("callback_link".equals(actionId)) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)iconKey)) {
                return;
            }
            Icon iconLink = (Icon)this.getControl("icon_link");
            iconLink.setIconKey(iconKey);
            this.getPageCache().put("cache_linkIcon", iconKey);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = null;
        Object source = evt.getSource();
        if (source instanceof Control) {
            key = ((Control)source).getKey();
        }
        if (key == null) {
            return;
        }
        if (key.startsWith(VECTOR_PREFIX)) {
            this.menuPanelClick(key);
            return;
        }
        switch (key) {
            case "btnok": {
                this.btnOkClick();
                break;
            }
            case "icon_menu": {
                this.showImageSelForm("callback_menu");
                break;
            }
            case "icon_link": {
                this.showImageSelForm("callback_link");
                break;
            }
        }
    }

    private void btnOkClick() {
        Tab tab = (Tab)this.getControl("tabap");
        String curTabId = tab.getCurrentTab();
        ArrayList returnData = new ArrayList();
        if ("tabpage_appfunc".equals(curTabId)) {
            String selStr = this.getPageCache().get(SELECTED_NODE);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)selStr)) {
                return;
            }
            Map selMap = (Map)SerializationUtils.fromJsonString((String)selStr, Map.class);
            for (Map.Entry entry : selMap.entrySet()) {
                HashMap<String, String> returnMap = new HashMap<String, String>();
                String menuId = this.getPageCache().get((String)entry.getKey());
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)menuId)) {
                    menuId = (String)entry.getKey();
                }
                String appId = (String)entry.getValue();
                returnMap.put("cache_sel_appId", appId);
                returnMap.put("cache_sel_menuId", menuId);
                returnMap.put("launchType", "launchType_menu");
                returnData.add(returnMap);
            }
        } else if ("tabpage_link".equals(curTabId)) {
            Object value;
            String url = (String)this.getModel().getValue("url");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)url)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7f51\u5740\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QuickLaunchConfigPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (!url.contains(".")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7f51\u5740\u201d\u4e0d\u5408\u6cd5\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"QuickLaunchConfigPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (!url.toLowerCase().contains("http://") && !url.toLowerCase().contains("https://")) {
                this.getView().showTipNotification("\u201c\u7f51\u5740\u201d\u5fc5\u987b\u4ee5http://\u6216  https:// \u5f00\u5934\u3002");
                return;
            }
            Object textValue = value = this.getModel().getValue("title");
            if (value instanceof OrmLocaleValue) {
                OrmLocaleValue ormLocaleValue = (OrmLocaleValue)value;
                textValue = ormLocaleValue.getLocaleValue();
            }
            if (textValue == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6807\u9898\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QuickLaunchConfigPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String s = null;
            try {
                s = JSONUtils.toString((Object)value);
            }
            catch (IOException e) {
                log.info("JSONUtils toString error", (Object)e);
            }
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("launchType", "launchType_link");
            returnMap.put("cache_linkUrl", url);
            returnMap.put("cache_linkTitle", s);
            returnMap.put("cache_linkIcon", this.getPageCache().get("cache_linkIcon"));
            returnData.add(returnMap);
        }
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void menuPanelClick(String key) {
        Vector vectorIcon = (Vector)this.getView().getControl(key);
        String vectorUrl = this.getPageCache().get(key);
        String selStr = this.getPageCache().get(SELECTED_NODE);
        Map<String, String> selMap = new HashMap();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)selStr)) {
            try {
                selMap = (Map)SerializationUtils.fromJsonString((String)selStr, Map.class);
            }
            catch (Exception e) {
                log.info("selStr Serialize error", (Object)e);
            }
        }
        Label countLabel = (Label)this.getControl(COUNT_LABEL);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)vectorUrl) || UNSELECT_FONT.equals(vectorUrl)) {
            vectorIcon.setFontClass(SELECTED_FONT);
            this.getPageCache().put(key, SELECTED_FONT);
            String lowerMenuId = key.substring(VECTOR_PREFIX.length());
            String appId = this.getPageCache().get(this.getMenuPanelIdKey(lowerMenuId));
            if (appId == null) {
                return;
            }
            selMap.put(lowerMenuId, appId);
            countLabel.setText(String.valueOf(selMap.size()));
            this.getView().updateView(COUNT_LABEL);
        } else {
            vectorIcon.setFontClass(UNSELECT_FONT);
            this.getPageCache().put(key, UNSELECT_FONT);
            selMap.remove(key.substring(VECTOR_PREFIX.length()));
            countLabel.setText(String.valueOf(selMap.size()));
            this.getView().updateView(COUNT_LABEL);
        }
        this.getPageCache().put(SELECTED_NODE, SerializationUtils.toJsonString(selMap));
    }

    private Map<String, Map<String, String>> getMenuInfoMap(String appID, Map<String, List<String>> menuRelationMap) {
        List<AppMenuInfo> menus = this.menuService.getHasPermMenuByAppId((Long)RequestContext.get().getCurrUserId(), appID, true);
        Map<String, Map<String, String>> menuInfos = this.getMenusToMap(menus, menuRelationMap);
        HashSet<String> needDel = new HashSet<String>();
        for (Map.Entry<String, Map<String, String>> entry : menuInfos.entrySet()) {
            String key = entry.getKey();
            Map<String, String> menuInfo = entry.getValue();
            String formId = menuInfo.get(FORM_ID);
            String linkUrl = menuInfo.get("linkUrl");
            List<String> children = menuRelationMap.get(entry.getKey());
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)formId) || !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)linkUrl) || children != null && !children.isEmpty()) continue;
            needDel.add(key);
        }
        if (needDel.isEmpty()) {
            return menuInfos;
        }
        for (String id : needDel) {
            menuInfos.remove(id);
        }
        return menuInfos;
    }

    private Map<String, Map<String, String>> getMenusToMap(List<AppMenuInfo> menus, Map<String, List<String>> menuRelationMap) {
        if (menus == null) {
            return new HashMap<String, Map<String, String>>(0);
        }
        HashMap<String, Map<String, String>> menuInfos = new HashMap<String, Map<String, String>>(menus.size());
        if (menuRelationMap == null) {
            menuRelationMap = new HashMap<String, List<String>>(0);
        }
        HashMap<String, String> map = new HashMap<String, String>(menus.size());
        for (AppMenuInfo menu : menus) {
            String menuId = menu.getId();
            map.put(menuId.toLowerCase(), menuId);
            if (menuId.endsWith("#hpce")) continue;
            HashMap<String, String> menuInfo = new HashMap<String, String>(6);
            String parentId = menu.getParentId();
            menuInfo.put(MENU_ID, menuId);
            menuInfo.put(PARENT_ID, parentId);
            menuInfo.put("text", menu.getName().getLocaleValue());
            menuInfo.put(FORM_ID, menu.getFormId());
            menuInfo.put("linkUrl", menu.getLinkUrl());
            menuInfo.put("seq", menu.getSeq() == null ? "0" : menu.getSeq().toString());
            menuInfo.put("icon", menu.getShortcutIcon());
            menuInfo.put("menuType", menu.getMenuType());
            menuInfos.put(menuId, menuInfo);
            menuRelationMap.computeIfAbsent(parentId, k -> new ArrayList()).add(menuId);
        }
        if (map.size() > 0) {
            this.getPageCache().put(map);
        }
        return menuInfos;
    }

    private List<AppMenuInfo> mapCastToAppInfo(List<Map<String, Object>> menuInfoMaps) {
        if (null != menuInfoMaps) {
            ArrayList<AppMenuInfo> appMenuInfos = new ArrayList<AppMenuInfo>(menuInfoMaps.size());
            for (Map<String, Object> menuInfoMap : menuInfoMaps) {
                AppMenuInfo appMenuInfo = new AppMenuInfo();
                appMenuInfo.setAppId((String)menuInfoMap.get("appId"));
                appMenuInfo.setId((String)menuInfoMap.get("id"));
                Integer seq = (Integer)menuInfoMap.get("seq");
                if (null != seq) {
                    appMenuInfo.setSeq(Short.valueOf(seq.shortValue()));
                }
                appMenuInfo.setFormId((String)menuInfoMap.get(FORM_ID));
                appMenuInfo.setEntityNumber((String)menuInfoMap.get("entityNumber"));
                appMenuInfo.setParamType((String)menuInfoMap.get("paramType"));
                appMenuInfo.setParentId((String)menuInfoMap.get(PARENT_ID));
                appMenuInfo.setShortcutIcon((String)menuInfoMap.get("shortcutIcon"));
                LocaleString name = this.stringCastToLocalString((Map)menuInfoMap.get("name"));
                appMenuInfo.setName(name);
                LocaleString formName = this.stringCastToLocalString((Map)menuInfoMap.get("formName"));
                appMenuInfo.setFormName(formName);
                LocaleString description = this.stringCastToLocalString((Map)menuInfoMap.get("description"));
                appMenuInfo.setDescription(description);
                appMenuInfo.setNaviVector((String)menuInfoMap.get("naviVector"));
                appMenuInfo.setData((String)menuInfoMap.get("data"));
                appMenuInfo.setMenuType((String)menuInfoMap.get("menuType"));
                appMenuInfos.add(appMenuInfo);
            }
            return appMenuInfos;
        }
        return null;
    }

    private LocaleString stringCastToLocalString(Map<String, String> name) {
        if (null != name) {
            LocaleString iLocaleString = new LocaleString();
            for (Map.Entry<String, String> entry : name.entrySet()) {
                iLocaleString.setItem(entry.getKey(), (Object)entry.getValue());
            }
            return iLocaleString;
        }
        return null;
    }

    @Deprecated
    public List<AppMenuInfo> getQingMenuArray(String appID) {
        return this.menuService.getQingMenuArray(appID);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        TreeView srcTreeView = (TreeView)e.getSource();
        Map focusNodeMap = srcTreeView.getTreeState().getFocusNode();
        String treeKey = srcTreeView.getKey();
        String nodeId = (String)focusNodeMap.get("id");
        if (CLOUD_APP_TREE.equals(treeKey)) {
            String parentId = (String)focusNodeMap.get("parentid");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)parentId)) {
                if (this.isCurrentMenuOrMyCollect(nodeId)) {
                    this.refreshMenuCardPanel(nodeId);
                    return;
                }
                srcTreeView.expand(nodeId);
            } else if (nodeId.startsWith(MENU_PREFIX)) {
                this.refreshMenuCardPanel(nodeId);
            } else {
                this.refreshMenuCardPanel(nodeId);
            }
        }
    }

    private boolean isCurrentMenuOrMyCollect(String key) {
        return "currentusemenu".equals(key) || "mycollectmenu".equals(key);
    }

    private void refreshMenuCardPanel(String nodeId) {
        ArrayList<String> controlKey = new ArrayList<String>();
        Container c = (Container)this.getControl(PANEL_CONTAINER);
        this.deleteControl(c);
        String selStr = this.getPageCache().get(SELECTED_NODE);
        Map selMap = new HashMap();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)selStr)) {
            selMap = (Map)SerializationUtils.fromJsonString((String)selStr, Map.class);
        }
        if (this.isCurrentMenuOrMyCollect(nodeId)) {
            String flexKey = PANEL_PREFIX + nodeId;
            List<QuickLaunchCardInfo> cardInfos = this.getNodeDatas(nodeId);
            Map<String, Object> quickPanel = this.createQuickPanel(cardInfos, selMap.keySet(), flexKey);
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            list.add(quickPanel);
            c.addControls(list);
            controlKey.add(flexKey);
        } else {
            HashMap<String, List<String>> menuRelationMap = new HashMap<String, List<String>>();
            Map<String, Map<String, String>> menuInfoMap = this.getMenuInfoMap(nodeId, menuRelationMap);
            ArrayList<Map<String, String>> firstMenu = new ArrayList<Map<String, String>>();
            for (Map.Entry<String, Map<String, String>> entry : menuInfoMap.entrySet()) {
                Map<String, String> map = entry.getValue();
                String parentId = map.get(PARENT_ID);
                if (!nodeId.equals(parentId)) continue;
                firstMenu.add(map);
            }
            if (firstMenu.isEmpty()) {
                return;
            }
            firstMenu.sort((map1, map2) -> {
                short seq1 = Short.parseShort((String)map1.get("seq"));
                short seq2 = Short.parseShort((String)map2.get("seq"));
                return seq1 - seq2;
            });
            Map<String, Map<String, String>> menuFromSearch = this.getMenuFromSearch(nodeId, menuInfoMap, menuRelationMap);
            if (menuFromSearch != null && menuFromSearch.size() > 0) {
                menuInfoMap = menuFromSearch;
            }
            for (Map map : firstMenu) {
                String id = (String)map.get(MENU_ID);
                String text = (String)map.get("text");
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                LabelAp labelTitle = this.getLabelAp(controlKey, id, text);
                String panelKey = PANEL_PREFIX + id.toLowerCase();
                List<Map<String, String>> curAndSubMenus = this.getCurAndSubMenus(id, menuInfoMap, menuRelationMap);
                if (curAndSubMenus == null || curAndSubMenus.isEmpty()) continue;
                List<QuickLaunchCardInfo> cardInfos = curAndSubMenus.stream().map(menuMap -> new QuickLaunchCardInfo((String)menuMap.get(MENU_ID), (String)menuMap.get("text"), "", (String)menuMap.get("icon"), nodeId)).collect(Collectors.toList());
                Map<String, Object> quickPanel = this.createQuickPanel(cardInfos, selMap.keySet(), panelKey);
                controlKey.add(panelKey);
                list.add(labelTitle.createControl());
                list.add(quickPanel);
                c.addControls(list);
            }
        }
        this.getPageCache().put("controlKey", SerializationUtils.toJsonString(controlKey));
    }

    private Map<String, Map<String, String>> getMenuFromSearch(String appID, Map<String, Map<String, String>> menuInfoMap, Map<String, List<String>> menuRelationMap) {
        String s = this.getPageCache().get(HAS_FILTER_MENUS_CACHE);
        List<AppMenuInfo> menus = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s)) {
            Map menusMap = (Map)SerializationUtils.fromJsonString((String)s, Map.class);
            List menuInfoMaps = (List)menusMap.get(appID);
            if (menuInfoMaps == null) {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appID);
                menuInfoMaps = (List)menusMap.get(appInfo.getNumber());
            }
            menus = this.mapCastToAppInfo(menuInfoMaps);
        }
        if (menus == null) {
            return null;
        }
        Map<String, Map<String, String>> menusToMap = this.getMenusToMap(menus, null);
        TreeSet parentIds = new TreeSet();
        for (String key : menusToMap.keySet()) {
            this.getParentMenuId(key, parentIds, menuRelationMap);
        }
        for (String parentId : parentIds) {
            if (parentId.equals(appID)) continue;
            menusToMap.put(parentId, menuInfoMap.get(parentId));
        }
        return menusToMap;
    }

    private void getParentMenuId(String key, Set parentIds, Map<String, List<String>> menuRelationMap) {
        boolean hasParent = false;
        for (Map.Entry<String, List<String>> entry : menuRelationMap.entrySet()) {
            List<String> value = entry.getValue();
            if (!value.stream().filter(v -> key.equals(v)).findFirst().isPresent()) continue;
            parentIds.add(entry.getKey());
            hasParent = true;
            this.getParentMenuId(entry.getKey(), parentIds, menuRelationMap);
        }
        if (!hasParent) {
            return;
        }
    }

    private List<QuickLaunchCardInfo> getNodeDatas(String nodeId) {
        long userId = RequestContext.get().getCurrUserId();
        PortalUsableFuncUtil portalUsableFuncUtil = new PortalUsableFuncUtil(this.getView());
        Set<String> userHasPerAppIds = portalUsableFuncUtil.getUserHasPerAppIds();
        if ("currentusemenu".equals(nodeId)) {
            List<PortalMenuInfo> currentUseMenuDatas = this.menuService.getCurrentUseMenus(userId, new ArrayList<String>(userHasPerAppIds));
            return currentUseMenuDatas.stream().map(menu -> new QuickLaunchCardInfo(menu.getMenuId(), menu.getName(), "", menu.getIcon(), menu.getAppId())).collect(Collectors.toList());
        }
        if ("mycollectmenu".equals(nodeId)) {
            List<PortalMenuInfo> currentUseMenuDatas = this.menuService.getFavoriteMenus(userId, new ArrayList<String>(userHasPerAppIds));
            return currentUseMenuDatas.stream().map(menu -> new QuickLaunchCardInfo(menu.getMenuId(), menu.getName(), "", menu.getIcon(), menu.getAppId())).collect(Collectors.toList());
        }
        return new ArrayList<QuickLaunchCardInfo>();
    }

    private Map<String, Object> createQuickPanel(List<QuickLaunchCardInfo> cardInfos, Set<String> selMenus, String flexKey) {
        FlexPanelAp outerPanel = new FlexPanelAp();
        outerPanel.setKey(flexKey);
        outerPanel.setDirection("row");
        outerPanel.setGrow(0);
        outerPanel.setShrink(0);
        outerPanel.setWidth(new LocaleString(PX));
        outerPanel.setOverflow("auto");
        Style style = outerPanel.getStyle();
        if (style == null) {
            style = new Style();
        }
        Padding padding = new Padding();
        padding.setTop("15px");
        style.setPadding(padding);
        outerPanel.setStyle(style);
        for (QuickLaunchCardInfo cardInfo : cardInfos) {
            String menuId = cardInfo.getId();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)menuId)) continue;
            String lowerMenuId = menuId.toLowerCase();
            FlexPanelAp itemPanel = new FlexPanelAp();
            itemPanel.setKey("panelap_item_" + lowerMenuId);
            itemPanel.setDirection("row");
            itemPanel.setAlignItems(CENTER);
            itemPanel.setGrow(0);
            itemPanel.setJustifyContent(CENTER);
            itemPanel.setAlignItems(CENTER);
            itemPanel.setShrink(0);
            itemPanel.setOverflow("hidden");
            itemPanel.setWidth(new LocaleString("100px"));
            style = itemPanel.getStyle();
            if (style == null) {
                style = new Style();
            }
            padding = new Padding();
            padding.setLeft("5px");
            padding.setTop("5px");
            padding.setBottom("5px");
            style.setPadding(padding);
            itemPanel.setStyle(style);
            String name = cardInfo.getName();
            String iconUrl = cardInfo.getIconUrl();
            IconAp icon = new IconAp();
            icon.setKey(ICON_PREFIX + lowerMenuId);
            icon.setName(new LocaleString(name));
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)iconUrl)) {
                icon.setImageKey(DEFAULT_ICONURL);
            } else {
                icon.setImageKey(iconUrl);
            }
            icon.setHeight(new LocaleString("48px"));
            icon.setWidth(new LocaleString("48px"));
            icon.setRadius("6px");
            style = new Style();
            Margin margin = new Margin();
            margin.setBottom("3px");
            style.setMargin(margin);
            icon.setStyle(style);
            VectorAp selector = new VectorAp();
            selector.setKey(VECTOR_PREFIX + lowerMenuId);
            selector.setName(new LocaleString());
            if (selMenus.contains(lowerMenuId)) {
                selector.setfontClass(SELECTED_FONT);
                this.getPageCache().put(selector.getKey(), SELECTED_FONT);
            } else {
                selector.setfontClass(UNSELECT_FONT);
            }
            selector.setFontSize(13);
            selector.setForeColor("#007fff");
            style = selector.getStyle();
            if (style == null) {
                style = new Style();
            }
            Margin selectorMargin = new Margin();
            selectorMargin.setTop("-45px");
            selectorMargin.setLeft("2px");
            style.setMargin(selectorMargin);
            selector.setStyle(style);
            selector.setAlignSelf(CENTER);
            LabelAp labelMenu = new LabelAp();
            labelMenu.setKey(LABEL_PREFIX + lowerMenuId);
            labelMenu.setName(new LocaleString(name));
            labelMenu.setWidth(new LocaleString("90px"));
            labelMenu.setTextAlign(CENTER);
            labelMenu.setAutoTextWrap(true);
            labelMenu.setShrink(0);
            labelMenu.setLineHeight("15px");
            style = labelMenu.getStyle();
            if (style == null) {
                style = new Style();
            }
            Margin labelMargin = new Margin();
            labelMargin.setLeft("-15px");
            labelMargin.setTop("5px");
            style.setMargin(labelMargin);
            labelMenu.setStyle(style);
            itemPanel.getItems().add(icon);
            itemPanel.getItems().add(selector);
            itemPanel.getItems().add(labelMenu);
            outerPanel.getItems().add(itemPanel);
            this.getPageCache().put(this.getMenuPanelIdKey(lowerMenuId), cardInfo.getAppId());
            this.getPageCache().put(lowerMenuId, cardInfo.getId());
        }
        return outerPanel.createControl();
    }

    private String getMenuPanelIdKey(String menuId) {
        return "menupanel_" + menuId;
    }

    private List<Map<String, String>> getCurAndSubMenus(String id, Map<String, Map<String, String>> menuInfoMap, Map<String, List<String>> menuRelationMap) {
        List<String> subMenus;
        ArrayList<Map<String, String>> menuItems = new ArrayList<Map<String, String>>();
        Map<String, String> menuInfo = menuInfoMap.get(id);
        if (menuInfo == null || menuInfo.isEmpty()) {
            return menuItems;
        }
        if (this.menuConfigValid(menuInfo)) {
            menuItems.add(menuInfo);
        }
        if ((subMenus = menuRelationMap.get(id)) == null || subMenus.isEmpty()) {
            return menuItems;
        }
        for (String subMenuId : subMenus) {
            List<Map<String, String>> subMenuInfos = this.getCurAndSubMenus(subMenuId, menuInfoMap, menuRelationMap);
            menuItems.addAll(subMenuInfos);
        }
        return menuItems;
    }

    private boolean menuConfigValid(Map<String, String> menuInfo) {
        String menuType = menuInfo.get("menuType");
        return MenuTypeEnum.PAGE.getCode().equals(menuType) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)menuInfo.get(FORM_ID)) || MenuTypeEnum.LINK.getCode().equals(menuType) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)menuInfo.get("linkUrl"));
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith(VECTOR_PREFIX)) {
            Vector vector = new Vector();
            vector.setKey(key);
            vector.setView(this.getView());
            vector.addClickListener((ClickListener)this);
            e.setControl((Control)vector);
        } else if (key.startsWith(ICON_PREFIX)) {
            Vector vector = new Vector();
            vector.setKey(VECTOR_PREFIX + key.substring(ICON_PREFIX.length()));
            vector.setView(this.getView());
            vector.addClickListener((ClickListener)this);
            e.setControl((Control)vector);
        }
    }

    private void showImageSelForm(String callBackId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_pictureselector");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackId));
        this.getView().showForm(parameter);
    }

    public void listboxClick(ListboxEvent e) {
        String itemId;
        switch (itemId = e.getItemId()) {
            case "appfunc": {
                this.showTab("tabpage_appfunc");
                break;
            }
            case "link": {
                this.showTab("tabpage_link");
                break;
            }
        }
    }

    private void showTab(String key) {
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab(key);
    }

    public void search(SearchEnterEvent e) {
        String searchText;
        Search search = (Search)e.getSource();
        if (StringUtils.equals((String)"treenodesearch", (String)search.getKey())) {
            searchText = e.getText();
            String json = this.getPageCache().getBigObject("nodes");
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
            LeftTreeSearchUtil.searchNodeByTextInTree(CLOUD_APP_TREE, rootNode, searchText, this.getView());
        }
        if (MENU_SEARCH_AP.equals(search.getKey())) {
            searchText = e.getText();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)searchText)) {
                try {
                    PortalUsableFuncUtil portalUsableFuncUtil = new PortalUsableFuncUtil(log, this.getView());
                    Set<String> userHasPerAppIds = portalUsableFuncUtil.getUserHasPerAppIds();
                    Map<String, List<AppMenuInfo>> allHasPermAppMenus = this.menuService.getHasPermMenuByAppId((Long)RequestContext.get().getCurrUserId(), userHasPerAppIds, true);
                    Map<String, List<AppMenuInfo>> hasFilterMenus = this.filterSearchMenus(searchText, allHasPermAppMenus);
                    this.initFilterAppTree(hasFilterMenus, searchText);
                    return;
                }
                catch (Exception ex) {
                    log.error((Throwable)ex);
                }
            }
            this.refreshTree();
        }
    }

    private void refreshTree() {
        Container c = (Container)this.getControl(PANEL_CONTAINER);
        this.deleteControl(c);
        this.getPageCache().remove(HAS_FILTER_MENUS_CACHE);
        TreeView tree = (TreeView)this.getView().getControl(CLOUD_APP_TREE);
        String json = this.getPageCache().getBigObject("nodes");
        TreeNode rootNode1 = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        List childrenIdList = rootNode1.getChildren().stream().map(v -> v.getId()).collect(Collectors.toList());
        tree.deleteNodes(childrenIdList);
        this.initCloudAppTree();
    }

    private void initFilterAppTree(Map<String, List<AppMenuInfo>> hasFilterMenus, String searchText) {
        String appOrCloudCache = this.getPageCache().getBigObject(APP_OR_CLOUD_JSON_INFO);
        JSONArray jsonCloud = (JSONArray)JSONObject.parseObject((String)appOrCloudCache, JSONArray.class);
        JSONArray filterData = new JSONArray();
        JSONArray filterDataMenu = new JSONArray();
        for (Object o : jsonCloud) {
            if (ObjectUtils.isEmpty(o)) continue;
            this.filterByText(o, filterData, searchText);
            this.filterByMenu(o, filterDataMenu, hasFilterMenus);
        }
        JSONArray totalArr = this.collectData(filterData, filterDataMenu);
        if (totalArr == null || totalArr.size() < 1) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap8"});
            this.refreshTree();
            return;
        }
        TreeView tree = (TreeView)this.getView().getControl(CLOUD_APP_TREE);
        String json = this.getPageCache().getBigObject("nodes");
        TreeNode rootNode1 = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        List childrenIdList = rootNode1.getChildren().stream().map(v -> v.getId()).collect(Collectors.toList());
        tree.deleteNodes(childrenIdList);
        TreeNode cloudNode = this.treeService.buildTree(totalArr);
        TreeNode rootNode = new TreeNode();
        rootNode.addChildren(cloudNode.getChildren());
        tree.addNodes(rootNode.getChildren());
        this.getPageCache().putBigObject("nodes", SerializationUtils.toJsonString((Object)rootNode));
        this.clickSearchList(rootNode.getChildren(), hasFilterMenus, tree);
    }

    private JSONArray collectData(JSONArray filterData, JSONArray filterDataMenu) {
        ArrayList<JSONObject> all = new ArrayList<JSONObject>(8);
        JSONArray jsonArray = new JSONArray();
        this.addData(filterData, all);
        this.addData(filterDataMenu, all);
        List distinctData = all.stream().collect(Collectors.toMap(o -> o.get((Object)"id"), Function.identity(), (p1, p2) -> p1)).values().stream().collect(Collectors.toList());
        Map<Object, List<JSONObject>> collectMap = distinctData.stream().collect(Collectors.groupingBy(o -> {
            if (this.booleanValue((JSONObject)o, "iscloud")) {
                return o.get((Object)"id");
            }
            return o.get((Object)"cloudid");
        }));
        for (Map.Entry<Object, List<JSONObject>> entry : collectMap.entrySet()) {
            List<JSONObject> value = entry.getValue();
            ArrayList<Object> sortedValue = new ArrayList<Object>(value.size());
            List iscloud = value.stream().filter(v -> null != v.get((Object)"iscloud")).collect(Collectors.toList());
            List isApp = value.stream().filter(v -> null == v.get((Object)"iscloud") || !this.booleanValue((JSONObject)v, "iscloud")).collect(Collectors.toList());
            if (null == iscloud) continue;
            JSONObject cloud = (JSONObject)iscloud.get(0);
            sortedValue.add(cloud);
            sortedValue.addAll(isApp);
            String s = JSONArray.toJSONString(sortedValue);
            JSONArray objects = JSONArray.parseArray((String)s);
            jsonArray.add((Object)objects);
        }
        return jsonArray;
    }

    private void addData(JSONArray filterData, List<JSONObject> all) {
        for (Object filterDatum : filterData) {
            JSONArray cloud = (JSONArray)filterDatum;
            for (Object o : cloud) {
                JSONObject app = (JSONObject)o;
                all.add(app);
            }
        }
    }

    private void clickSearchList(List<TreeNode> children, Map<String, List<AppMenuInfo>> hasFilterMenus, TreeView tree) {
        if (children != null && children.size() > 0) {
            this.getPageCache().put(HAS_FILTER_MENUS_CACHE, SerializationUtils.toJsonString(hasFilterMenus));
            TreeNode cloudNode = children.get(0);
            List appNodeList = cloudNode.getChildren();
            TreeNode node = (TreeNode)appNodeList.get(0);
            tree.focusNode(node);
            tree.treeNodeClick(cloudNode.getId(), node.getId());
        }
    }

    private void filterByMenu(Object o, JSONArray filterData, Map<String, List<AppMenuInfo>> hasFilterMenus) {
        JSONArray cloudAndApp = (JSONArray)o;
        JSONArray data = new JSONArray();
        boolean addFlag = false;
        Set<String> appIds = hasFilterMenus.keySet();
        for (Object filterDatum : cloudAndApp) {
            if (ObjectUtils.isEmpty(filterDatum)) continue;
            JSONObject jsonObject = (JSONObject)filterDatum;
            boolean isCloud = this.booleanValue(jsonObject, "iscloud");
            String id = (String)jsonObject.get((Object)"id");
            if (id != null && appIds.contains(id)) {
                data.add((Object)jsonObject);
                addFlag = true;
            }
            if (!isCloud || addFlag) continue;
            data.add((Object)jsonObject);
        }
        if (data.size() > 0 && addFlag) {
            filterData.add((Object)data);
        }
    }

    private void filterByText(Object o, JSONArray filterData, String searchText) {
        JSONArray cloudAndApp = (JSONArray)o;
        boolean hasApp = false;
        boolean addFlag = false;
        JSONArray data = new JSONArray();
        for (Object filterDatum : cloudAndApp) {
            if (ObjectUtils.isEmpty(filterDatum)) continue;
            JSONObject jsonObject = (JSONObject)filterDatum;
            Object name = jsonObject.get((Object)"name");
            boolean isCloud = this.booleanValue(jsonObject, "iscloud");
            if (null == name) continue;
            JSONObject langName = (JSONObject)name;
            Object o1 = langName.get((Object)RequestContext.get().getLang().name());
            if (null != o1 && ((String)o1).contains(searchText)) {
                if (!isCloud) {
                    hasApp = true;
                }
                addFlag = true;
                data.add((Object)jsonObject);
            }
            if (!isCloud || addFlag) continue;
            data.add((Object)jsonObject);
        }
        if (data.size() > 0 && addFlag) {
            if (hasApp) {
                filterData.add((Object)data);
                return;
            }
            filterData.add((Object)cloudAndApp);
        }
    }

    private boolean booleanValue(JSONObject jsonObject, String name) {
        Object o = jsonObject.get((Object)name);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        return false;
    }

    private Map<String, List<AppMenuInfo>> filterSearchMenus(String searchText, Map<String, List<AppMenuInfo>> allHasPermAppMenus) {
        HashMap<String, List<AppMenuInfo>> hasFilterMenus = new HashMap<String, List<AppMenuInfo>>(32);
        for (Map.Entry<String, List<AppMenuInfo>> entry : allHasPermAppMenus.entrySet()) {
            List<AppMenuInfo> data;
            List appMenuInfos;
            List<AppMenuInfo> value = entry.getValue();
            List<AppMenuInfo> collect = value.stream().filter(Objects::nonNull).filter(v -> !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)v.getFormId())).filter(v -> {
                String localeValue;
                LocaleString name = v.getName();
                return !ObjectUtils.isEmpty((Object)name) && (localeValue = name.getLocaleValue()) != null && localeValue.contains(searchText);
            }).collect(Collectors.toList());
            if (collect.size() < 1 || (appMenuInfos = (data = this.getAppMenuInfosFromParent(value, collect, entry.getKey())).stream().filter(v -> !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)v.getFormId())).collect(Collectors.toList())) == null || appMenuInfos.size() <= 0) continue;
            hasFilterMenus.put(entry.getKey(), appMenuInfos);
        }
        return hasFilterMenus;
    }

    private List<AppMenuInfo> getAppMenuInfosFromParent(List<AppMenuInfo> value, List<AppMenuInfo> collect, String key) {
        ArrayList<AppMenuInfo> data = new ArrayList<AppMenuInfo>(collect.size());
        try {
            for (AppMenuInfo appMenuInfo : collect) {
                if (key.equals(appMenuInfo.getParentId())) {
                    data.add(appMenuInfo);
                    continue;
                }
                this.removeDataNoParent(appMenuInfo, value, data);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return data;
    }

    private void removeDataNoParent(AppMenuInfo appMenuInfo, List<AppMenuInfo> allData, List<AppMenuInfo> data) {
        String parentId = appMenuInfo.getParentId();
        if (parentId == null) {
            return;
        }
        Optional<AppMenuInfo> menuInfo = allData.stream().filter(Objects::nonNull).filter(v -> parentId.equals(v.getId())).findFirst();
        if (menuInfo.isPresent()) {
            AppMenuInfo appMenuInfo1 = menuInfo.get();
            data.add(appMenuInfo);
            data.add(appMenuInfo1);
            this.removeDataNoParent(appMenuInfo1, allData, data);
        }
    }

    private void deleteControl(Container c) {
        String controlKeyJsonStr = this.getPageCache().get("controlKey");
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)controlKeyJsonStr)) {
            List controlKey = SerializationUtils.fromJsonStringToList((String)controlKeyJsonStr, String.class);
            for (String key : controlKey) {
                c.deleteControls(new String[]{key});
            }
            this.getView().updateView(PANEL_CONTAINER);
            controlKey.clear();
        }
    }

    private LabelAp getLabelAp(List<String> controlKey, String id, String text) {
        LabelAp labelTitle = new LabelAp();
        labelTitle.setKey(id.toLowerCase());
        controlKey.add(id.toLowerCase());
        labelTitle.setName(new LocaleString(text));
        labelTitle.setFontSize(18);
        labelTitle.setHeight(new LocaleString("30px"));
        labelTitle.setWidth(new LocaleString(PX));
        labelTitle.setShrink(0);
        Style style = labelTitle.getStyle();
        if (style == null) {
            style = new Style();
        }
        Margin margin = new Margin();
        margin.setTop("20px");
        margin.setLeft("20px");
        style.setMargin(margin);
        labelTitle.setStyle(style);
        return labelTitle;
    }

    public void tabSelected(TabSelectEvent e) {
        String tabKey = e.getTabKey();
        if ("tabpage_link".equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MENU_SEARCH_AP});
        }
        if ("tabpage_appfunc".equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MENU_SEARCH_AP});
        }
    }
}

