/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.form.container.GridContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.IconAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.constant.SchemeType;
import kd.bos.portal.dto.QuickLaunchCardInfo;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.portal.service.PortalMenuService;
import kd.bos.portal.util.MyCurrentAppUtil;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.portal.util.PortalAppMetaDataUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;

public class QuickLaunchPlugin
extends GridCardPlugin {
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String CONFIG = "config";
    public static final String NETADRESS = "netadress";
    public static final String MAX_COUNT = "maxCount";
    public static final String CENTER = "center";
    public static final String NODE_DATA = "nodeData";
    private static final String PX_14 = "14px";
    private static final String D_FLEX_PANEL = "dflexpanel";
    private static final String REGEX = "_";
    private static Log logger = LogFactory.getLog(QuickLaunchPlugin.class);
    public static final String HAS_SEL_MENUINFO = "hasSelMenuInfo";
    public static final String CACHE_ADDEDMENU = "pageCache_addedMenu";
    public static final String CACHE_LASTADDMENU = "pageCache_lastAddMenu";
    public static final String CONFIRMCALLBACK_DEFAULT_OR_CUSTOM = "confirmcallback_default_or_custom";
    private static final String HIDEMENUS = "hideMenus";
    private PortalMenuService menuService;

    @Override
    public void initialize() {
        super.initialize();
        this.lstrDefaultTitle = ResManager.getLocaleString((String)"\u5feb\u901f\u53d1\u8d77", (String)"QuickLaunchPlugin_5", (String)BOS_PORTAL_PLUGIN);
        this.TITLE_DEFAULT = this.lstrDefaultTitle.getLocaleValue();
        this.TITLE_MAPENTRYSTR_DEFAULT = CardUtils.getMapEntryStrFromLocaleString(this.lstrDefaultTitle);
        this.menuService = new PortalMenuService(this.getPageCache());
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (this.isDesignMode() ? key.startsWith("iconap") : key.startsWith("icon_del")) {
            return;
        }
        if (key.startsWith("iconap") || key.startsWith("icon_del") || key.startsWith("addbtn") || key.equals("vectorap")) {
            Button button = new Button();
            button.setKey(key);
            button.setView(this.getView());
            if (!key.equals("vectorap")) {
                button.addClickListener((ClickListener)this);
            }
            e.setControl((Control)button);
        }
    }

    @Override
    public void click(EventObject e) {
        super.click(e);
        String key = "";
        Object source = e.getSource();
        if (source instanceof Control) {
            key = ((Control)source).getKey();
        }
        if ("addbtn".equals(key)) {
            if (this.checkCanEdit()) {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("bos_quicklaunchconfig");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setShowTitle(true);
                Map<String, String> allConfigMap = this.getAllConfigMap();
                fsp.setCustomParam(HAS_SEL_MENUINFO, allConfigMap);
                String obj = this.getPageCache().get(NODE_DATA);
                if (obj != null) {
                    Map nodeData = (Map)SerializationUtils.fromJsonString((String)obj.toString(), Map.class);
                    Map<String, String> menuMap = nodeData.values().stream().filter(map -> "launchType_menu".equalsIgnoreCase((String)map.get("launchType"))).collect(Collectors.toMap(obj1 -> ((String)obj1.get("cache_sel_menuId")).toLowerCase(), obj2 -> (String)obj2.get("cache_sel_appId"), (k1, k2) -> k1));
                    fsp.setCustomParam("menuMap", (Object)SerializationUtils.toJsonString(menuMap));
                }
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "quickLaunchConfigCallBack"));
                this.getView().showForm(fsp);
            }
        } else if (key.startsWith("iconap")) {
            String index;
            Map<String, Map<String, String>> nodeData = this.getNodeDatas();
            Map<String, String> nodeInfo = nodeData.get(index = key.substring("iconap".length()));
            String launchType = nodeInfo.get("launchType");
            if (launchType.equals("launchType_link")) {
                String url = nodeInfo.get("cache_linkUrl");
                this.getView().openUrl(url);
            } else if (launchType.equals("launchType_menu")) {
                String appId = nodeInfo.get("cache_sel_appId");
                String menuId = nodeInfo.get("cache_sel_menuId");
                List<AppMenuInfo> qingMenus = this.menuService.getQingMenuArray(appId);
                if (qingMenus != null) {
                    for (AppMenuInfo qingMenu : qingMenus) {
                        if (!menuId.equals(qingMenu.getId())) continue;
                        HashMap<String, Object> map2 = new HashMap<String, Object>(16);
                        map2.put("view", this.getView());
                        map2.put("formnumber", qingMenu.getFormId());
                        map2.put("parameter", qingMenu.getParams());
                        map2.put("menuname", qingMenu.getName().getLocaleValue());
                        map2.put("parametertype", null);
                        map2.put("openType", null);
                        map2.put("permItem", null);
                        AppInfo app = AppMetadataCache.getAppInfo((String)appId);
                        map2.put("appname", app.getName());
                        map2.put("appmainnumber", app.getHomeNum());
                        OpenPageUtils.openApp(qingMenu.getAppId(), menuId, map2, this.getView());
                        MyCurrentAppUtil.putMyCurrentAppCache(appId);
                        return;
                    }
                }
                OpenPageUtils.openMenu(this.getView(), menuId, appId);
                MyCurrentAppUtil.putMyCurrentAppCache(appId);
            }
        } else if (key.startsWith("icon_del")) {
            this.removeQuickLaunchFromView(key, null);
        }
    }

    private boolean checkCanEdit() {
        String curSchemeId = this.getParentPageCache().get("pgCache_currentScheme");
        return CardUtils.checkCanEditAndShowTip(this.getView(), curSchemeId, true);
    }

    private IFormView getCardParentView() {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        return this.getView().getViewNoPlugin(parentPageId);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        block13: {
            IFormView parentView;
            String callBackId;
            block12: {
                super.confirmCallBack(e);
                callBackId = e.getCallBackId();
                MessageBoxResult result = e.getResult();
                parentView = this.getCardParentView();
                CardUtils cardUtils = new CardUtils(parentView, this.getParentPageCache(), parentView.getModel(), logger);
                String layout = CardUtils.getNewLayoutInMainpageCache(parentView);
                String curSchemeType = this.getParentPageCache().get("pgCache_currentSchemeType");
                String curSchemeId = this.getParentPageCache().get("pgCache_currentScheme");
                if (!CONFIRMCALLBACK_DEFAULT_OR_CUSTOM.equals(callBackId)) break block12;
                switch (result) {
                    case Yes: {
                        if (SchemeType.SysDefScheme.getValue().equals(curSchemeType)) {
                            cardUtils.saveMainPageInfo(SchemeType.SysDefScheme, layout, this.getAllCardConfigMap(), Long.parseLong(curSchemeId), null);
                        }
                        if (SchemeType.GroupScheme.getValue().equals(curSchemeType)) {
                            cardUtils.saveMainPageInfo(SchemeType.GroupScheme, layout, this.getAllCardConfigMap(), Long.parseLong(curSchemeId), null);
                            break;
                        }
                        break block13;
                    }
                    case No: {
                        if (CardUtils.checkCurSchemeCustomable(curSchemeId, this.getView())) {
                            cardUtils.saveMainPageInfo(SchemeType.UserScheme, layout, this.getAllCardConfigMap(), null, null);
                            parentView.addClientCallBack("refreshSchemeList");
                            this.getView().sendFormAction(parentView);
                            break;
                        }
                        break block13;
                    }
                    case Cancel: {
                        Map<String, String> cardConfigMap = this.getAllConfigMap();
                        Map<String, Object> cardsConfig = CardUtils.getDetailConfigMap(cardConfigMap);
                        if (cardsConfig != null) {
                            List lastAddedMenus;
                            String menuStr = this.getPageCache().get(CACHE_LASTADDMENU);
                            if (StringUtils.isNotBlank((CharSequence)menuStr) && (lastAddedMenus = (List)SerializationUtils.fromJsonString((String)menuStr, List.class)) != null) {
                                for (String menuId : lastAddedMenus) {
                                    cardsConfig.remove(menuId);
                                }
                            }
                            this.getPageCache().remove(CACHE_LASTADDMENU);
                            cardConfigMap.put(CONFIG, SerializationUtils.toJsonString(cardsConfig));
                            this.updateAllConfigMap(cardConfigMap);
                        }
                        GridContainer container = (GridContainer)parentView.getControl("gridcontainerap");
                        container.triggerContainer();
                        this.getView().sendFormAction(parentView);
                        break;
                    }
                }
                break block13;
            }
            if ("confirmcallbackid_modify_custom".equals(callBackId) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.saveScheme(SchemeType.UserScheme, null);
                parentView.addClientCallBack("refreshSchemeList");
                this.getView().sendFormAction(parentView);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("quickLaunchConfigCallBack".equals(actionId)) {
            List<Map<String, String>> newMenuList;
            List<Map<String, String>> retDatas = (List<Map<String, String>>)e.getReturnData();
            if (retDatas == null) {
                return;
            }
            Map<String, Map<String, String>> nodeData = this.getNodeDatas();
            ArrayList<Map<String, String>> delMenuList = new ArrayList<Map<String, String>>(0);
            if (!retDatas.isEmpty() && "launchType_link".equalsIgnoreCase((String)((Map)retDatas.get(0)).get("launchType"))) {
                newMenuList = retDatas;
            } else {
                List existMenus = nodeData.values().stream().map(map -> ((String)map.get("cache_sel_menuId")).toUpperCase()).collect(Collectors.toList());
                newMenuList = retDatas.stream().filter(map -> !existMenus.contains(((String)map.get("cache_sel_menuId")).toUpperCase())).collect(Collectors.toList());
                List appMenus = retDatas.stream().filter(map -> "launchType_menu".equalsIgnoreCase((String)map.get("launchType"))).map(map -> ((String)map.get("cache_sel_menuId")).toUpperCase()).collect(Collectors.toList());
                nodeData.forEach((key, value) -> {
                    if (!appMenus.contains(((String)value.get("cache_sel_menuId")).toUpperCase()) && !"launchType_link".equalsIgnoreCase(((String)value.get("launchType")).toUpperCase())) {
                        delMenuList.add((Map<String, String>)value);
                    }
                });
            }
            if (!retDatas.isEmpty()) {
                this.addLaunchToCard(newMenuList, true);
            }
            this.delLaunch(delMenuList);
            if (!this.isDesignMode()) {
                this.confirmSave();
            }
        }
    }

    private void addLaunchToCard(List<Map<String, String>> cardInfos, boolean isAdd) {
        if (CollectionUtils.isEmpty(cardInfos)) {
            return;
        }
        Set<String> appIds = cardInfos.stream().filter(map -> "launchType_menu".equalsIgnoreCase((String)map.get("launchType"))).map(map -> (String)map.get("cache_sel_appId")).collect(Collectors.toSet());
        Map<String, List<AppMenuInfo>> allMenuByAppIds = PortalAppMetaDataUtils.getAppIdAndAllMenuByAppIds(appIds);
        Set menuIds = cardInfos.stream().map(item -> (String)item.get("cache_sel_menuId")).collect(Collectors.toSet());
        if (!isAdd) {
            Set menuIdUppers = cardInfos.stream().map(item -> ((String)item.get("cache_sel_menuId")).toUpperCase()).collect(Collectors.toSet());
            menuIds.addAll(menuIdUppers);
        }
        Map<String, AppMenuInfo> menuIdAndInfoMap = allMenuByAppIds.values().stream().flatMap(Collection::stream).filter(appMenuInfo -> menuIds.contains(appMenuInfo.getId())).collect(Collectors.toMap(AppMenuInfo::getId, i -> i, (k1, k2) -> k1));
        int maxCount = this.getMaxCount();
        Map<String, Map<String, String>> nodeData = this.getNodeDatas();
        List<String> quickMenuIdList = this.getQuickMenuIdList();
        boolean isDesignMode = this.isDesignMode();
        LinkedHashMap<String, String> newConfig = new LinkedHashMap<String, String>(cardInfos.size());
        for (Map<String, String> itemMap : cardInfos) {
            try {
                String menuId;
                QuickLaunchCardInfo quickLaunchCardInfo;
                if ((quickLaunchCardInfo = this.transToLaunchInfo(++maxCount, itemMap, menuIdAndInfoMap)) == null || quickMenuIdList.contains(menuId = quickLaunchCardInfo.getId())) continue;
                quickMenuIdList.add(menuId);
                this.creatLaunchNode(quickLaunchCardInfo, maxCount, isDesignMode);
                newConfig.put(menuId, SerializationUtils.toJsonString(itemMap));
            }
            catch (Exception e) {
                logger.info("addLaunchToCard#error", (Object)e);
                continue;
            }
            nodeData.put(Integer.toString(maxCount), itemMap);
        }
        if (isAdd) {
            this.addCardInfoConfig(newConfig);
        }
        this.getPageCache().put(NODE_DATA, SerializationUtils.toJsonString(nodeData));
        this.getPageCache().put(MAX_COUNT, Integer.toString(maxCount));
        if (!CollectionUtils.isEmpty(quickMenuIdList)) {
            this.getPageCache().put(CACHE_ADDEDMENU, SerializationUtils.toJsonString(quickMenuIdList));
        }
    }

    private QuickLaunchCardInfo transToLaunchInfo(int index, Map<String, String> launchInfo, Map<String, AppMenuInfo> appMenuInfoMap) {
        QuickLaunchCardInfo cardInfo = null;
        String launchType = launchInfo.get("launchType");
        if ("launchType_menu".equalsIgnoreCase(launchType)) {
            if (CollectionUtils.isEmpty(appMenuInfoMap)) {
                return null;
            }
            String menuId = launchInfo.get("cache_sel_menuId");
            AppMenuInfo appMenuInfo = appMenuInfoMap.get(menuId);
            if (appMenuInfo == null) {
                String upperMenuId = menuId.toUpperCase();
                appMenuInfo = appMenuInfoMap.get(menuId.toUpperCase());
                if (appMenuInfo != null) {
                    launchInfo.put("cache_sel_menuId", upperMenuId);
                }
            }
            if (appMenuInfo == null) {
                throw new KDException(new ErrorCode("GET_APPMENUINFO_ERROR", "GET_APPMENUINFO_ERROR"), new Object[0]);
            }
            String menuName = appMenuInfo.getName().getLocaleValue();
            String iconUrl = appMenuInfo.getShortcutIcon();
            String desc = appMenuInfo.getDescription() == null ? "" : appMenuInfo.getDescription().getLocaleValue();
            cardInfo = new QuickLaunchCardInfo(menuId, menuName, desc, iconUrl);
            cardInfo.setIndex(launchInfo.get("index"));
        } else if ("launchType_link".equalsIgnoreCase(launchType)) {
            String title = this.changeLaunch(launchInfo.get("cache_linkTitle"));
            String iconUrl = launchInfo.get("cache_linkIcon");
            String menuId = launchInfo.get("cache_sel_menuId");
            if (StringUtils.isBlank((CharSequence)menuId)) {
                menuId = NETADRESS + index;
            }
            launchInfo.put("cache_sel_menuId", menuId);
            cardInfo = new QuickLaunchCardInfo(menuId, title, "", iconUrl);
            cardInfo.setIndex(launchInfo.get("index"));
        }
        return cardInfo;
    }

    private void addCardInfoConfig(Map<String, String> newConfig) {
        if (CollectionUtils.isEmpty(newConfig)) {
            return;
        }
        this.getPageCache().put(CACHE_LASTADDMENU, SerializationUtils.toJsonString(newConfig.keySet()));
        Map<String, String> cardInfo = this.getAllConfigMap();
        Map<String, Object> configMap = CardUtils.getDetailConfigMap(cardInfo);
        if (configMap == null) {
            configMap = new LinkedHashMap<String, Object>(0);
        }
        configMap.putAll(newConfig);
        String config = SerializationUtils.toJsonString(configMap);
        cardInfo.put(CONFIG, config);
        this.updateAllConfigMap(cardInfo);
    }

    private void confirmSave() {
        String curSchemeType = this.getParentPageCache().get("pgCache_currentSchemeType");
        if (SchemeType.SysDefScheme.getValue().equals(curSchemeType) || SchemeType.GroupScheme.getValue().equals(curSchemeType)) {
            String curSchemeId = this.getParentPageCache().get("pgCache_currentScheme");
            Long schemeId = null;
            if (curSchemeId != null) {
                schemeId = Long.parseLong(curSchemeId);
            }
            Long userId = RequestContext.get().getCurrUserId();
            boolean hasModifyPerm = CardUtils.checkHasModifySchemeRight(userId);
            boolean isOwner = CardUtils.checkCurSchemeOwner(userId, schemeId);
            boolean isEdit = CardUtils.checkCurSchemeIsEdit(schemeId);
            if (isOwner || hasModifyPerm && isEdit || SchemeType.GroupScheme.getValue().equals(curSchemeType) && CardUtils.isOutAdmin()) {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848", (String)"QuickLaunchPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u65b9\u6848", (String)"QuickLaunchPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"QuickLaunchPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.YesNoCancel;
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5f53\u524d\u65b9\u6848\u8fd8\u662f\u53e6\u5b58\u4e3a\u4e2a\u6027\u5316\u65b9\u6848\uff1f", (String)"QuickLaunchPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, new ConfirmCallBackListener(CONFIRMCALLBACK_DEFAULT_OR_CUSTOM, (IFormPlugin)this), btnNameMaps);
            } else if (!hasModifyPerm && isEdit) {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"GridContainerPlugin_12", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"GridContainerPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848\u5c06\u66ff\u6362\u5df2\u6709\u7684\u4e2a\u6027\u65b9\u6848\uff0c\u662f\u5426\u786e\u8ba4\u4fdd\u5b58\uff1f", (String)"GridContainerPlugin_13", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, new ConfirmCallBackListener("confirmcallbackid_modify_custom", (IFormPlugin)this), btnNameMaps);
            } else if (hasModifyPerm) {
                this.saveScheme(SchemeType.getSchemeType(curSchemeType), schemeId);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u9996\u9875\u65b9\u6848\u6743\u9650\uff0c\u65e0\u6cd5\u8c03\u6574\u5e03\u5c40\u3002", (String)"GridContainerPlugin_28", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
        } else {
            this.saveScheme(SchemeType.UserScheme, null);
        }
    }

    private void saveScheme(SchemeType schemeType, Long curSchemeId) {
        IFormView parentView = this.getCardParentView();
        CardUtils cardUtils = new CardUtils(parentView, this.getParentPageCache(), parentView.getModel(), logger);
        String layout = CardUtils.getNewLayoutInMainpageCache(parentView);
        cardUtils.saveMainPageInfo(schemeType, layout, this.getAllCardConfigMap(), curSchemeId, null);
    }

    private void creatLaunchNode(QuickLaunchCardInfo cardInfo, int maxCount, boolean isDesignMode) {
        String nodeName = cardInfo.getName();
        String iconUrl = cardInfo.getIconUrl();
        String desc = cardInfo.getDescription();
        String appId = this.getView().getFormShowParameter().getAppId();
        FlexPanelAp flexAp = new FlexPanelAp();
        String flexKey = "dflexpanel_" + this.getCardId() + REGEX + maxCount;
        flexAp.setKey(flexKey);
        flexAp.setDirection("column");
        flexAp.setAlignItems(CENTER);
        flexAp.setGrow(0);
        flexAp.setJustifyContent(CENTER);
        flexAp.setAlignItems(CENTER);
        flexAp.setShrink(0);
        flexAp.setWidth(new LocaleString("100px"));
        flexAp.setOverflow("hidden");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("12px");
        margin.setLeft("12px");
        margin.setBottom("12px");
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            margin.setTop(PX_14);
        }
        style.setMargin(margin);
        flexAp.setStyle(style);
        IconAp icon = new IconAp();
        icon.setKey("iconap" + maxCount);
        icon.setName(new LocaleString(desc));
        if (StringUtils.isBlank((CharSequence)iconUrl)) {
            icon.setImageKey("/icons/pc/entrance/default_48_48.png");
            cardInfo.setIconUrl("/icons/pc/entrance/default_48_48.png");
        } else {
            icon.setImageKey(iconUrl);
        }
        icon.setHeight(new LocaleString("48px"));
        icon.setWidth(new LocaleString("48px"));
        icon.setRadius("6px");
        icon.setImageZoom(true);
        style = new Style();
        margin = new Margin();
        margin.setBottom("3px");
        style.setMargin(margin);
        icon.setStyle(style);
        if (isDesignMode) {
            IconAp icondel = new IconAp();
            icondel.setKey("icon_del" + maxCount);
            icondel.setName(new LocaleString(ResManager.loadKDString((String)"\u5220\u9664", (String)"QuickLaunchPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])));
            icondel.setImageKey("/icons/pc/other/deleteicon_normal.png");
            icondel.setHeight(new LocaleString("19px"));
            icondel.setWidth(new LocaleString("19px"));
            icondel.setZIndex(1);
            style = new Style();
            margin = new Margin();
            margin.setBottom("-10px");
            margin.setLeft("42px");
            style.setMargin(margin);
            icondel.setStyle(style);
            flexAp.getItems().add(icondel);
        }
        LabelAp label = new LabelAp();
        label.setKey("dlabel" + maxCount);
        label.setName(new LocaleString(nodeName));
        label.setWidth(new LocaleString("100px"));
        label.setTextAlign(CENTER);
        label.setAutoTextWrap(true);
        label.setLineHeight("15px");
        style = new Style();
        margin = new Margin();
        margin.setBottom("3px");
        style.setMargin(margin);
        label.setStyle(style);
        flexAp.getItems().add(icon);
        flexAp.getItems().add(label);
        Container c = (Container)this.getView().getControl("cardpanel");
        ArrayList<Map> list = new ArrayList<Map>(10);
        list.add(flexAp.createControl());
        c.insertControls(-1, list);
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("fs", "var(--kd-cq-font-size)");
        this.getView().updateControlMetadata("dlabel" + maxCount, map);
    }

    private String changeLaunch(Object o) {
        if (o instanceof String) {
            String s = (String)o;
            try {
                Map cast = (Map)JSONUtils.cast((String)s, Map.class);
                s = cast.get(Lang.get().toString()).toString();
            }
            catch (IOException e) {
                logger.info(e.getMessage());
            }
            return s;
        }
        if (o instanceof OrmLocaleValue) {
            return ((OrmLocaleValue)o).getLocaleValue();
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            Object def = map.get(Lang.get().toString());
            if (null == def) {
                def = map.get("GLang");
            }
            return def == null ? null : def.toString();
        }
        return null;
    }

    private void delLaunch(List<Map<String, String>> launchInfos) {
        if (CollectionUtils.isEmpty(launchInfos)) {
            return;
        }
        Set<String> delMenuIdSet = launchInfos.stream().map(map -> ((String)map.get("cache_sel_menuId")).toUpperCase()).collect(Collectors.toSet());
        try {
            List qingMenus = JSONObject.parseArray((String)this.getPageCache().get("qingmenus_" + this.getView().getPageId()), AppMenuInfo.class);
            ArrayList<AppMenuInfo> qingMenusFilter = new ArrayList<AppMenuInfo>(10);
            if (this.getPageCache() != null && qingMenus != null) {
                for (AppMenuInfo appMenuInfo : qingMenus) {
                    if (delMenuIdSet.contains(appMenuInfo.getId())) continue;
                    qingMenusFilter.add(appMenuInfo);
                }
                JSONArray qingPublishMenus = JSONArray.parseArray((String)JSONUtils.toString(qingMenusFilter));
                this.getPageCache().put("qingmenus_" + this.getView().getPageId(), qingPublishMenus.toJSONString());
            }
        }
        catch (Exception e) {
            logger.info("delQingMenusCache error", (Object)e);
        }
        delMenuIdSet.forEach(id -> this.removeQuickLaunchFromView(null, (String)id));
    }

    @Override
    protected void refreshCard(Map<String, String> cardInfo) {
        super.refreshCard(cardInfo);
        boolean isDesignMode = this.isDesignMode();
        this.setAddbtnStyle(isDesignMode);
        if (cardInfo == null || cardInfo.size() == 0) {
            return;
        }
        Map<String, Object> configMap = CardUtils.getDetailConfigMap(cardInfo);
        if (CollectionUtils.isEmpty(configMap)) {
            return;
        }
        configMap = this.resetMenuIdConfig(configMap);
        this.getView().sendFormAction(this.getView());
        Set<String> appIds = configMap.values().stream().map(cardInfoObj -> {
            Map cardInfoMap = (Map)cardInfoObj;
            String cardAppId = (String)cardInfoMap.get("cache_sel_appId");
            if (cardAppId == null) {
                return "";
            }
            return cardAppId;
        }).collect(Collectors.toSet());
        appIds.remove("");
        Set<String> filterAppIds = this.filterApp(appIds);
        Map<String, Set<String>> hideMenuIdsByBizAppIds = this.menuService.getHideMenuIdsByBizAppIds(RequestContext.get().getCurrUserId(), filterAppIds);
        List<String> hideMenus = this.getHideMenu();
        ArrayList<Map<String, String>> itemMapList = new ArrayList<Map<String, String>>(configMap.size());
        for (Object cardInfoObj2 : configMap.values()) {
            Map cardInfoMap = (Map)cardInfoObj2;
            String cardAppId = (String)cardInfoMap.get("cache_sel_appId");
            if (cardAppId != null && !filterAppIds.contains(cardAppId)) continue;
            String curMenuId = (String)cardInfoMap.get("cache_sel_menuId");
            String curMenuIdUpper = ((String)cardInfoMap.get("cache_sel_menuId")).toUpperCase();
            boolean isHide = hideMenus != null && (hideMenus.contains(curMenuId) || hideMenus.contains(curMenuIdUpper));
            if (isHide) continue;
            if (hideMenuIdsByBizAppIds != null) {
                Set<String> extHideMenuIds = hideMenuIdsByBizAppIds.get(cardAppId);
                boolean bl = isHide = extHideMenuIds != null && (extHideMenuIds.contains(curMenuId) || extHideMenuIds.contains(curMenuIdUpper));
                if (isHide) continue;
            }
            itemMapList.add(cardInfoMap);
        }
        this.addLaunchToCard(itemMapList, false);
    }

    private List<String> getHideMenu() {
        String hideMenuStr = this.getParentPageCache().get(HIDEMENUS);
        try {
            List hideMenus;
            if (hideMenuStr != null) {
                hideMenus = (List)SerializationUtils.fromJsonString((String)hideMenuStr, List.class);
            } else {
                hideMenus = CardUtils.getHideMenus();
                this.getParentPageCache().put(HIDEMENUS, SerializationUtils.toJsonString((Object)hideMenus));
            }
            return hideMenus;
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u9690\u85cf\u83dc\u5355\u5f02\u5e38", (Object)e);
            return new ArrayList<String>(0);
        }
    }

    private Set<String> filterApp(Set<String> appIds) {
        long userId = RequestContext.get().getCurrUserId();
        if (CollectionUtils.isEmpty(appIds)) {
            return appIds;
        }
        String userTypeInContext = RequestContext.get().getUserType();
        ArrayList<String> userTypeList = new ArrayList<String>(10);
        if (StringUtils.isBlank((CharSequence)userTypeInContext)) {
            logger.debug(ResManager.loadKDString((String)"\u67e5\u8be2\u7528\u6237\u7c7b\u578b\u5931\u8d25", (String)"PortalUsableFuncUtil_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        } else {
            String[] userType = userTypeInContext.split(",");
            userTypeList.addAll(Stream.of(userType).filter(StringUtils::isNotBlank).collect(Collectors.toList()));
        }
        if (PermissionServiceHelper.isAdminUser((long)userId) || Long.valueOf(userId).equals(10L)) {
            userTypeList.add("1");
        }
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        Map<String, AppInfo> allIdAppInfo = PortalAppMetaDataUtils.getAppIdInfo(appIds);
        return appIds.stream().filter(appId -> !disabledAppIds.contains(appId)).filter(appId -> this.checkApp((AppInfo)allIdAppInfo.get(appId), userTypeList)).collect(Collectors.toSet());
    }

    private boolean checkApp(AppInfo appInfo, List<String> userTypeList) {
        try {
            if (appInfo == null) {
                return false;
            }
            boolean visible = appInfo.isVisible();
            String status = appInfo.getDeployStatus();
            if (!visible || !"2".equals(status)) {
                return false;
            }
            String appUserTypeStr = appInfo.getUserType();
            List<Object> appUserTypeList = new ArrayList(10);
            if (appUserTypeStr != null) {
                String[] appUserType = appUserTypeStr.split(",");
                appUserTypeList = Stream.of(appUserType).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            }
            if (Collections.disjoint(appUserTypeList, userTypeList)) {
                return false;
            }
        }
        catch (Exception e) {
            logger.info("checkApp error", (Object)e);
        }
        return true;
    }

    private void setAddbtnStyle(boolean isDesignMode) {
        String appId = this.getView().getFormShowParameter().getAppId();
        String marginTop = null;
        if (isDesignMode) {
            marginTop = StringUtils.isNotBlank((CharSequence)appId) ? "23px" : "9px";
        } else if (StringUtils.isNotBlank((CharSequence)appId)) {
            marginTop = PX_14;
        }
        if (marginTop != null) {
            HashMap styleMap = new HashMap(0);
            HashMap marginMap = new HashMap(0);
            HashMap<String, String> objMap = new HashMap<String, String>(0);
            objMap.put("t", marginTop);
            marginMap.put("m", objMap);
            styleMap.put("s", marginMap);
            this.getView().updateControlMetadata("flexpanelap10", styleMap);
        }
    }

    private void removeQuickLaunchFromView(String idx, String menuId) {
        Map<String, String> nodeInfo;
        Map<String, String> cardInfo;
        Map<String, Object> configMap;
        String index = "";
        if (StringUtils.isNotBlank((CharSequence)idx)) {
            index = idx.substring("icon_del".length());
        }
        if ((configMap = CardUtils.getDetailConfigMap(cardInfo = this.getAllConfigMap())) == null) {
            return;
        }
        Map<String, Map<String, String>> nodeData = this.getNodeDatas();
        if (StringUtils.isNotBlank((CharSequence)menuId)) {
            for (Map.Entry<String, Map<String, String>> entry : nodeData.entrySet()) {
                String cacheSelMenuId = entry.getValue().get("cache_sel_menuId");
                if (cacheSelMenuId == null || !cacheSelMenuId.equalsIgnoreCase(menuId)) continue;
                index = entry.getKey();
                break;
            }
        }
        if ((nodeInfo = nodeData.remove(index)) == null) {
            return;
        }
        String key = nodeInfo.get("cache_sel_menuId");
        configMap.remove(key);
        String config = SerializationUtils.toJsonString(configMap);
        cardInfo.put(CONFIG, config);
        this.updateAllConfigMap(cardInfo);
        Container c = (Container)this.getView().getControl("cardpanel");
        String cardId = this.getCardId();
        String deleteKey = "dflexpanel_" + cardId + REGEX + index;
        c.deleteControls(new String[]{deleteKey});
        this.getPageCache().put(NODE_DATA, SerializationUtils.toJsonString(nodeData));
        String jsonStr = this.getPageCache().get(CACHE_ADDEDMENU);
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return;
        }
        List menuIdList = (List)SerializationUtils.fromJsonString((String)jsonStr, List.class);
        menuIdList.remove(key);
        this.getPageCache().put(CACHE_ADDEDMENU, SerializationUtils.toJsonString((Object)menuIdList));
    }

    private Map<String, Object> resetMenuIdConfig(Map<String, Object> configMap) {
        List linkTypeLaunchs = configMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(NETADRESS)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(linkTypeLaunchs)) {
            boolean hasLinkTypeLaunch = false;
            LinkedHashMap<String, Object> newConfigMap = new LinkedHashMap<String, Object>(configMap.size());
            HashMap<String, Map> nodeData = new HashMap<String, Map>(configMap.size());
            int maxCount = 1;
            for (Map.Entry<String, Object> entry2 : configMap.entrySet()) {
                String menuId = entry2.getKey();
                Map obj = (Map)entry2.getValue();
                if (menuId.startsWith(NETADRESS)) {
                    hasLinkTypeLaunch = true;
                    menuId = NETADRESS + maxCount;
                    obj.put("cache_sel_menuId", menuId);
                }
                newConfigMap.put(menuId, obj);
                nodeData.put(Integer.toString(maxCount), obj);
                ++maxCount;
            }
            this.getPageCache().put(NODE_DATA, SerializationUtils.toJsonString(nodeData));
            if (hasLinkTypeLaunch) {
                Map<String, String> cardInfo = this.getAllConfigMap();
                String config = SerializationUtils.toJsonString(newConfigMap);
                cardInfo.put(CONFIG, config);
                this.updateAllConfigMap(cardInfo);
                return newConfigMap;
            }
        }
        return configMap;
    }

    private int getMaxCount() {
        int maxCount = 0;
        String obj = this.getPageCache().get(MAX_COUNT);
        if (obj != null) {
            maxCount = Integer.parseInt(obj);
        }
        return maxCount;
    }

    private Map<String, Map<String, String>> getNodeDatas() {
        String obj = this.getPageCache().get(NODE_DATA);
        if (obj != null) {
            return (Map)SerializationUtils.fromJsonString((String)obj, Map.class);
        }
        return new HashMap<String, Map<String, String>>(0);
    }

    private List<String> getQuickMenuIdList() {
        String jsonStr = this.getPageCache().get(CACHE_ADDEDMENU);
        List menuIdList = StringUtils.isBlank((CharSequence)jsonStr) ? new ArrayList(8) : (List)SerializationUtils.fromJsonString((String)jsonStr, List.class);
        return menuIdList;
    }
}

