/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.constant.scheme.RoleSchemeRel;
import kd.bos.portal.constant.scheme.UserSchemeRel;
import kd.bos.portal.constant.scheme.UserTypeSchemeRel;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class SchemeDelOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        List entityDatas = Stream.of("portal_scheme_user_rel", "bos_mainpagecardconfig", "protal_scheme_group_rel", UserSchemeRel.MAIN_ENTITY_TYPE, "bos_orgmainpage_rel", RoleSchemeRel.MAIN_ENTITY_TYPE, UserTypeSchemeRel.MAIN_ENTITY_TYPE).collect(Collectors.toList());
        String pages = String.join((CharSequence)",", entityDatas);
        this.getOption().setVariableValue("ignorerefentityids", pages);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] arrDObj = e.getDataEntities();
        try (TXHandle h = TX.required();){
            try {
                ArrayList<Long> idList = new ArrayList<Long>(10);
                for (DynamicObject dObj : arrDObj) {
                    Long schemeId = dObj.getLong("id");
                    idList.add(schemeId);
                }
                DeleteServiceHelper.delete((String)"bos_mainpagecardconfig", (QFilter[])new QFilter[]{new QFilter("mainpagelayout", "in", idList)});
                DeleteServiceHelper.delete((String)"portal_scheme_user_rel", (QFilter[])new QFilter[]{new QFilter("scheme", "in", idList)});
                DeleteServiceHelper.delete((String)"protal_scheme_group_rel", (QFilter[])new QFilter[]{new QFilter("scheme", "in", idList)});
                DeleteServiceHelper.delete((String)UserSchemeRel.MAIN_ENTITY_TYPE, (QFilter[])new QFilter[]{new QFilter("scheme", "in", idList)});
                DeleteServiceHelper.delete((String)"bos_orgmainpage_rel", (QFilter[])new QFilter[]{new QFilter("scheme", "in", idList)});
                DeleteServiceHelper.delete((String)RoleSchemeRel.MAIN_ENTITY_TYPE, (QFilter[])new QFilter[]{new QFilter("scheme", "in", idList)});
                DeleteServiceHelper.delete((String)UserTypeSchemeRel.MAIN_ENTITY_TYPE, (QFilter[])new QFilter[]{new QFilter("scheme", "in", idList)});
            }
            catch (Exception ex) {
                h.markRollback();
            }
        }
    }
}

