/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.share.ShareUrlService;

public class ShareFormPlugin
extends AbstractFormPlugin {
    private static final String REFRESHURL = "refreshurl";
    private static Log logger = LogFactory.getLog(ShareFormPlugin.class);
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String BTN_COPY = "btncancel";
    private static final String BTN_SHARE = "btnok";
    private static final String TITLE = "title";
    private static final String URL = "url";
    private static final String TIPS = "tips";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_COPY, BTN_SHARE, REFRESHURL});
    }

    public void afterCreateNewData(EventObject evt) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map shareInfo = fsp.getCustomParams();
        if (StringUtils.isBlank((Object)shareInfo)) {
            return;
        }
        int validTime = 86400;
        Object validTimeObj = this.getModel().getValue("validtime");
        if (validTimeObj != null) {
            validTime = (int)(Double.parseDouble(validTimeObj.toString()) * 60.0 * 60.0);
        }
        try {
            Map shareInfoMap = (Map)JSONObject.parseObject((String)shareInfo.toString(), Map.class);
            String formId = shareInfoMap.get("shareFormId").toString();
            String pkId = shareInfoMap.get("sharePkId").toString();
            String billName = shareInfoMap.get("shareBillName").toString();
            RequestContext ctx = RequestContext.get();
            String url = ShareUrlService.createShareUrl((String)formId, (String)pkId, (int)validTime, (String)ctx.getUserId(), (String)ctx.getLang().name(), (String)ctx.getAccountId());
            String title = String.format(ResManager.loadKDString((String)"%s\u7684\u5206\u4eab\u94fe\u63a5\uff1a", (String)"BizAppHomePlugin_15", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), billName);
            this.getModel().setValue(TITLE, (Object)title);
            this.getModel().setValue(URL, (Object)url);
            String tips = ResManager.loadKDString((String)"\u94fe\u63a5\u6709\u6548\u671f\u4e3a24\u5c0f\u65f6\uff0c\u8fc7\u671f\u540e\u94fe\u63a5\u5c06\u5931\u6548", (String)"BizAppHomePlugin_16", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            this.getModel().setValue(TIPS, (Object)tips);
            this.getPageCache().put("shareInfo", SerializationUtils.toJsonString((Object)shareInfoMap));
            this.getPageCache().put(URL, url);
        }
        catch (Exception e) {
            logger.info("ShareFormPlugin--getShareInfo--error" + e);
        }
    }

    private void refreshUrl() {
        String shareInfo;
        int validTime = 86400000;
        Object validTimeObj = this.getModel().getValue("validtime");
        if (validTimeObj != null) {
            validTime = (int)Double.parseDouble(validTimeObj.toString()) * 60 * 60 * 1000;
        }
        if (StringUtils.isNotBlank((CharSequence)(shareInfo = this.getPageCache().get("shareInfo")))) {
            Map shareInfoMap = (Map)SerializationUtils.fromJsonString((String)shareInfo, Map.class);
            String formId = shareInfoMap.get("shareFormId").toString();
            String pkId = shareInfoMap.get("sharePkId").toString();
            String billName = shareInfoMap.get("shareBillName").toString();
            RequestContext ctx = RequestContext.get();
            String url = ShareUrlService.createShareUrl((String)formId, (String)pkId, (int)validTime, (String)ctx.getUserId(), (String)ctx.getLang().name(), (String)ctx.getAccountId());
            String title = String.format(ResManager.loadKDString((String)"%s\u7684\u5206\u4eab\u94fe\u63a5\uff1a", (String)"BizAppHomePlugin_15", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), billName);
            this.getModel().setValue(TITLE, (Object)title);
            this.getModel().setValue(URL, (Object)url);
            String tips = ResManager.loadKDString((String)"\u94fe\u63a5\u6709\u6548\u671f\u4e3a24\u5c0f\u65f6\uff0c\u8fc7\u671f\u540e\u94fe\u63a5\u5c06\u5931\u6548", (String)"BizAppHomePlugin_16", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            this.getModel().setValue(TIPS, (Object)tips);
        }
    }

    public void click(EventObject evt) {
        String actionName;
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        String url = this.getPageCache().get(URL);
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u94fe\u63a5\u4e0d\u5b58\u5728", (String)"ShareFormPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("content", url);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("pageId", this.getView().getPageId());
        params.put("data", data);
        if (BTN_COPY.equals(key)) {
            actionName = "copyLocal";
        } else if (BTN_SHARE.equals(key)) {
            actionName = "shareFormToYZJ";
        } else {
            if (REFRESHURL.equals(key)) {
                this.refreshUrl();
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u64cd\u4f5c", (String)"ShareFormPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        proxy.addAction(actionName, params);
    }
}

