/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.sql.ResultSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Optional;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.jetbrains.annotations.NotNull;

public class UIThemeSettingPlugin
extends AbstractFormPlugin {
    private static final String ENABLE_MOB_DESIGN_THEME_SYS = "enable_mob_design_theme_s";
    private static final String ENABLE_MOB_DESIGN_THEME_FORM = "enable_mob_design_theme";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("PORTAL_PARAMS", new DistributeCacheHAPolicy(true, true));

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initEnableMobileTheme();
        this.initEnableMobDesignThemeColor();
    }

    private void initEnableMobDesignThemeColor() {
        Optional<Boolean> enableOp = this.isEnableMobDesignThemeColor();
        if (!enableOp.isPresent()) {
            this.insertMobDesignThemeSwitch();
            this.getModel().setValue(ENABLE_MOB_DESIGN_THEME_FORM, (Object)true);
            return;
        }
        if (enableOp.get().booleanValue()) {
            this.getModel().setValue(ENABLE_MOB_DESIGN_THEME_FORM, (Object)true);
        } else {
            this.getModel().setValue(ENABLE_MOB_DESIGN_THEME_FORM, (Object)false);
        }
    }

    private void insertMobDesignThemeSwitch() {
        HashMap<String, Boolean> switchMap = new HashMap<String, Boolean>();
        switchMap.put(ENABLE_MOB_DESIGN_THEME_SYS, true);
        SystemParamServiceHelper.savePublicParameter(switchMap);
    }

    public Optional<Boolean> isEnableMobDesignThemeColor() {
        Boolean enable = (Boolean)SystemParamServiceHelper.loadPublicParameterFromCache((String)ENABLE_MOB_DESIGN_THEME_SYS);
        return Optional.ofNullable(enable);
    }

    private void initEnableMobileTheme() {
        String themeSettingSql = this.getMobileThemeSettingSql();
        boolean isHaveData = (Boolean)DB.query((DBRoute)DBRoute.base, (String)themeSettingSql, ResultSet::next);
        if (!isHaveData) {
            this.insertData(Boolean.FALSE);
            this.getModel().setValue("checkboxfield", (Object)Boolean.FALSE);
            return;
        }
        String enableMobileTheme = (String)DB.query((DBRoute)DBRoute.base, (String)themeSettingSql, rs -> rs.next() ? rs.getString("fparam_value") : "false");
        this.getModel().setValue("checkboxfield", (Object)enableMobileTheme);
    }

    @NotNull
    private String getMobileThemeSettingSql() {
        return "select fparam_value from T_BAS_DEFAULT_PARAMS where fparam_key = 'enableMobileTheme'";
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.updateMobThemeSwitch();
        this.updateMobDesignThemeSwitch();
        this.getView().close();
    }

    private void updateMobThemeSwitch() {
        Boolean choose = (Boolean)this.getModel().getValue("checkboxfield");
        String themeSettingSql = this.getMobileThemeSettingSql();
        boolean isHaveData = (Boolean)DB.query((DBRoute)DBRoute.base, (String)themeSettingSql, ResultSet::next);
        if (isHaveData) {
            this.updateData(choose);
        }
    }

    private void updateMobDesignThemeSwitch() {
        Boolean designTheme = (Boolean)this.getModel().getValue(ENABLE_MOB_DESIGN_THEME_FORM);
        HashMap<String, Boolean> switchMap = new HashMap<String, Boolean>();
        switchMap.put(ENABLE_MOB_DESIGN_THEME_SYS, designTheme);
        SystemParamServiceHelper.savePublicParameter(switchMap);
    }

    private void insertData(Boolean choose) {
        String insertSql = "insert into T_BAS_DEFAULT_PARAMS (fparam_key, fparam_value, fparam_type) values('enableMobileTheme', ?, '1');";
        Object[] params = new Object[]{Boolean.toString(choose)};
        DB.execute((DBRoute)DBRoute.base, (String)insertSql, (Object[])params);
        this.removeCache();
    }

    private void updateData(Boolean choose) {
        String updateSql = "update T_BAS_DEFAULT_PARAMS set fparam_value=? where fparam_key='enableMobileTheme';";
        Object[] params = new Object[]{Boolean.toString(choose)};
        DB.execute((DBRoute)DBRoute.base, (String)updateSql, (Object[])params);
        this.removeCache();
    }

    private void removeCache() {
        String key = "enableMobileTheme_" + RequestContext.get().getAccountId();
        cache.remove(key);
    }
}

