/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.util.UserCenterCardUtil;
import kd.bos.url.UrlService;
import kd.bos.util.RevProxyUtil;

public class UserCenterConfigPlugin
extends AbstractFormPlugin {
    public static final String ENTRYENTITY = "entryentity";
    public static final String PUBID = "pubid";
    public static final String PUBNAME = "pubname";
    public static final String PUCARDTYPE = "pucardtype";
    public static final String CARD_TYPE = "card_type";
    private static Log logger = LogFactory.getLog(UserCenterConfigPlugin.class);
    private static String BASEURL = "http://api.cloudsz.kingdee.com";
    public static final String BTN_OK = "btn_ok";
    public static final String BTN_PRE = "btn_pre";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_PRE});
    }

    public void click(EventObject e) {
        String ctrlKey;
        super.click(e);
        Control ctrl = (Control)e.getSource();
        switch (ctrlKey = ctrl.getKey()) {
            case "btn_ok": {
                EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
                int[] selRows = eg.getSelectRows();
                if (selRows == null || selRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u9605\u53f7\u3002", (String)"UserCenterConfigPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList returnList = new ArrayList(1);
                for (int idx : selRows) {
                    String pubId = (String)this.getModel().getValue(PUBID, idx);
                    String pubName = (String)this.getModel().getValue(PUBNAME, idx);
                    String puCardType = (String)this.getModel().getValue(PUCARDTYPE, idx);
                    HashMap<String, String> returnMap = new HashMap<String, String>();
                    returnMap.put("cardType", "bos_card_usercenter");
                    returnMap.put(PUBID, pubId);
                    returnMap.put(PUBNAME, pubName);
                    returnMap.put(PUCARDTYPE, puCardType);
                    String cardTitleMapEntryStr = "[zh_CN=" + pubName + "]";
                    returnMap.put("cardtitle", cardTitleMapEntryStr);
                    returnList.add(returnMap);
                }
                this.getView().returnDataToParent(returnList);
                this.getView().close();
                break;
            }
            case "btn_pre": {
                HashMap<String, String> returnMap = new HashMap<String, String>();
                returnMap.put("event_rtn_addcard", "8");
                this.getView().returnDataToParent(returnMap);
                this.getView().close();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map<String, Object> jsonArr = null;
        try {
            jsonArr = UserCenterCardUtil.getUserCenterCardInfo();
        }
        catch (Exception ee) {
            logger.info("\u83b7\u53d6\u7528\u6237\u4e2d\u5fc3\u5361\u7247\u51fa\u9519\uff01", (Object)ee);
            return;
        }
        if (jsonArr == null || jsonArr.size() == 0) {
            return;
        }
        List<Map<String, Object>> data = (List<Map<String, Object>>)jsonArr.get("data");
        if (null == (data = this.getNeededCard(data)) || data.size() == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, data.size());
        IClientViewProxy cvProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        String photourl = "";
        for (int i = 0; i < data.size(); ++i) {
            photourl = "";
            Map<String, Object> cardInfoMap = data.get(i);
            if ("index_activity".equals(cardInfoMap.get(CARD_TYPE))) {
                photourl = RevProxyUtil.addSlash((String)UrlService.getDomainContextUrl()) + "private/rmhd_100_100.png";
            } else if ("index_courses".equals(cardInfoMap.get(CARD_TYPE))) {
                photourl = RevProxyUtil.addSlash((String)UrlService.getDomainContextUrl()) + "private/wdkc_100_100.png";
            } else if ("index_knowledge".equals(cardInfoMap.get(CARD_TYPE))) {
                photourl = RevProxyUtil.addSlash((String)UrlService.getDomainContextUrl()) + "private/sqzs_100_100.png";
            }
            String pubname = (String)cardInfoMap.get("name");
            Integer pubid = (Integer)cardInfoMap.get("id");
            String pubCardType = (String)cardInfoMap.get(CARD_TYPE);
            this.getModel().setValue(PUBID, (Object)(pubid + ""), i);
            this.getModel().setValue(PUBNAME, (Object)pubname, i);
            this.getModel().setValue(PUCARDTYPE, (Object)pubCardType, i);
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>();
            propertiesMap.put("src", photourl);
            pmap.put("photourl", propertiesMap);
            cvProxy.invokeControlMethod(ENTRYENTITY, "setCustomProperties", new Object[]{i, pmap});
        }
    }

    private List<Map<String, Object>> getNeededCard(List<Map<String, Object>> data) {
        if (null == data || data.size() == 0) {
            return null;
        }
        Iterator<Map<String, Object>> iterable = data.iterator();
        while (iterable.hasNext()) {
            Map<String, Object> cardInfoMap = iterable.next();
            if ("index_activity".equals(cardInfoMap.get(CARD_TYPE)) || "index_courses".equals(cardInfoMap.get(CARD_TYPE)) || "index_knowledge".equals(cardInfoMap.get(CARD_TYPE))) continue;
            iterable.remove();
        }
        return data;
    }
}

