/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.service.IPageHelpCustomMenuService;
import kd.bos.portal.service.VersionService;
import kd.bos.portal.service.bo.PageHelpCustomMenu;
import kd.bos.portal.service.enums.PageHelpMenuEnum;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.sysint.servicehelper.KnowledgeServiceHelper;
import kd.bos.sysint.servicehelper.constant.LocationConst;
import kd.bos.sysint.servicehelper.dto.KnowledgeSearchParams;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.util.RevProxyUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class BizAppHomeAbstract
extends AbstractFormPlugin {
    protected static Log logger = LogFactory.getLog(BizAppHomeAbstract.class);
    protected static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"helpinfo");
    private static final String TYPE_NAME = "typeName";
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String TITLE = "title";
    private static final String CCS_ATLAS_URL = "https://club.kdcloud.com/knowledge/atlas?productLineId=2";
    private static final String COSMIC_ATLAS_URL = "https://developer.kingdee.com/knowledge/atlas?productLineId=29";

    protected abstract void showHotQuestion(Object var1, String var2);

    protected abstract String getBillFormId();

    protected abstract IFormView getCurrentView();

    protected void knowledgeSearch() {
        String billFormId = this.getBillFormId();
        Object result = null;
        String entityUrl = null;
        String module = "";
        String domain = "";
        String type = "";
        IFormView view = this.getCurrentView();
        if (view != null) {
            module = view.getFormShowParameter().getAppId();
            domain = AppMetadataCache.getAppInfo((String)module).getCloudNum();
        }
        String bizentity = billFormId == null ? "" : billFormId;
        String label = "";
        String restrictIn = "domain,module,bizentity";
        String authcode = "";
        String searchScope = "knowledge";
        int page = 1;
        int pageSize = 50;
        Lang lang = RequestContext.get().getLang();
        boolean langFlag = lang == Lang.zh_CN || lang == Lang.zh_TW;
        Map<Object, Object> customHelp = new HashMap();
        if (langFlag) {
            customHelp = this.getCustomHelp(module, bizentity);
        }
        KnowledgeSearchParams searchParams = new KnowledgeSearchParams(type, domain, module, bizentity, label, restrictIn, "", authcode, page, pageSize, true, searchScope);
        searchParams.setLocation(LocationConst.PAGE_HELP.code());
        Future future = threadPool.submit(() -> this.getKnowledgeSpecial(searchParams));
        Future searchFuture = threadPool.submit(() -> KnowledgeServiceHelper.knowledgeSearch(searchParams));
        String knowledgeSource = null;
        try {
            knowledgeSource = (String)searchFuture.get(3000L, TimeUnit.MILLISECONDS);
            JSONObject jason = (JSONObject)JSON.parse((String)knowledgeSource);
            int totalPages = Integer.parseInt(jason.get((Object)"totalPages").toString());
            String moreUrl = jason.get((Object)"moreUrl").toString();
            ArrayList<String> sources = new ArrayList<String>(totalPages);
            sources.add(knowledgeSource);
            Map<String, Object> parseResult = this.parse(sources, customHelp);
            if (!"".equals(moreUrl)) {
                int produceId = KnowledgeServiceHelper.getProductId();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("productId", produceId);
                params.put("domain", searchParams.getDomain());
                params.put("module", searchParams.getModule());
                String destUrl = this.getUrlParamsByMap(params);
                parseResult.put("moreUrl", moreUrl + RevProxyUtil.getHttpParamCollectFlag((String)moreUrl) + destUrl);
            }
            result = parseResult;
        }
        catch (Exception e) {
            logger.info("getHelpInfo error", (Object)e);
            result = customHelp.get("list") != null ? customHelp : JSON.parseObject((String)knowledgeSource, Map.class);
        }
        if (this.isHomepage()) {
            entityUrl = this.getEntityUrl();
        } else {
            try {
                entityUrl = (String)future.get();
            }
            catch (Exception e) {
                logger.info("getKnowledgeSpecial error", (Object)e);
            }
        }
        this.showHotQuestion(result, entityUrl);
    }

    private Map<String, Object> getCustomHelp(String module, String bizentity) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)module) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bizentity)) {
            return Collections.emptyMap();
        }
        QFilter qFilter = this.buildQFilter(module, bizentity);
        return this.queryHelpData(qFilter);
    }

    private QFilter buildQFilter(String module, String bizentity) {
        QFilter qFilter = new QFilter("onstatus", "=", (Object)"A");
        if (kd.bos.util.StringUtils.isNotEmpty((String)module)) {
            String appNum = this.getAppNumber(module);
            qFilter.and(new QFilter("application", "=", (Object)appNum).and(new QFilter("busobject", "is null", null).or("busobject", "=", (Object)" ")));
        }
        QFilter qFilter1 = new QFilter("onstatus", "=", (Object)"A");
        if (kd.bos.util.StringUtils.isNotEmpty((String)bizentity)) {
            qFilter1.and("busobject", "=", (Object)bizentity);
        } else {
            String homeNum = AppMetadataCache.getAppInfo((String)module).getHomeNum();
            qFilter1.and("busobject", "=", (Object)homeNum);
        }
        return qFilter.or(qFilter1);
    }

    private String getAppNumber(String module) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_devp_bizapplist", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)module)});
        return ObjectUtils.isEmpty((Object)dynamicObject) ? null : dynamicObject.getString("id");
    }

    private Map<String, Object> queryHelpData(QFilter qFilter) {
        DynamicObjectCollection helpPageList = QueryServiceHelper.query((String)"custom_help_page_list", (String)"id,number,mulititle,helptype,linktype,urllink,label,weight,pageview", (QFilter[])new QFilter[]{qFilter}, (String)"weight desc,pageview desc", (int)50);
        Map<String, Object> data = this.parseCustomData(helpPageList);
        return data;
    }

    private Map<String, Object> parseCustomData(DynamicObjectCollection helpPageList) {
        HashMap<String, Object> response = new HashMap<String, Object>(16);
        ArrayList<HashMap<String, Object>> contentList = new ArrayList<HashMap<String, Object>>();
        try {
            for (DynamicObject dynamicObject : helpPageList) {
                HashMap<String, Object> content = new HashMap<String, Object>(8);
                String url = this.getUrlFromData(dynamicObject);
                content.put("type", this.getHelpType(dynamicObject.getString("helptype")));
                this.getTypeName(this.getHelpType(dynamicObject.getString("helptype")), content);
                content.put(TITLE, dynamicObject.getString("mulititle"));
                content.put("url", url);
                content.put("isCustom", true);
                content.put("number", dynamicObject.getString("number"));
                if (null != dynamicObject.getString("label")) {
                    content.put("customLable", this.getCustomLable(dynamicObject.getString("label")));
                }
                contentList.add(content);
            }
        }
        catch (Exception e) {
            logger.info("parseCustomData", (Object)e);
        }
        response.put("list", contentList);
        if (contentList.size() > 0) {
            response.put("errcode", "0");
        } else {
            response.put("errcode", "1");
        }
        response.put("description", "");
        return response;
    }

    private String getHelpType(String helpType) {
        String value = null;
        switch (helpType) {
            case "0": {
                value = "Question";
                break;
            }
            case "1": {
                value = "Article";
                break;
            }
            case "2": {
                value = "Course";
                break;
            }
        }
        return value;
    }

    private String getCustomLable(String label) {
        String customLable = null;
        switch (label) {
            case "0": {
                customLable = "MUST";
                break;
            }
            case "1": {
                customLable = "NEW";
                break;
            }
            case "2": {
                customLable = "HOT";
                break;
            }
        }
        return customLable;
    }

    private String getUrlFromData(DynamicObject dynamicObject) {
        String contextUrl = UrlService.getDomainContextUrl();
        String url = RevProxyUtil.addSlash((String)contextUrl) + "index.html?formId=custom_help_page&key=" + dynamicObject.getLong("id");
        return url;
    }

    protected void doCustomHelpClick(String number) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)number)) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"custom_help_page_list", (String)"id,number,pageview,linktype,onstatus,urllink", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        this.openPageUrl(dynamicObject);
        this.addPageView(dynamicObject);
    }

    private void openPageUrl(DynamicObject dynamicObject) {
        String urlFromData = this.getUrlFromData(dynamicObject);
        if (!"A".equals(dynamicObject.getString("onstatus"))) {
            this.getView().openUrl(urlFromData);
        } else if ("1".equals(dynamicObject.getString("linktype"))) {
            this.getView().openUrl(dynamicObject.getString("urllink"));
        } else {
            this.getView().openUrl(urlFromData);
        }
    }

    private void addPageView(DynamicObject dynamicObject) {
        long pageview = dynamicObject.getLong("pageview");
        dynamicObject.set("pageview", (Object)(++pageview));
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private String getEntityUrl() {
        String entityUrl = null;
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        if (modelType == 3) {
            int count = VersionService.getVersionCount();
            entityUrl = count < 2 ? COSMIC_ATLAS_URL : CCS_ATLAS_URL;
        } else if (modelType == 2 || modelType == 4) {
            entityUrl = "https://vip.kingdee.com/knowledge/atlas?productId=93&productLineId=1";
        }
        return entityUrl;
    }

    private boolean isHomepage() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("home_page".equals(formId)) {
            Tab appTab = (Tab)this.getView().getControl("tabap");
            if (appTab != null) {
                String currentTab = appTab.getCurrentTab();
                return "tabpageap".equals(currentTab) || "yzjportal".equals(currentTab) || "gpt_home_page".equals(currentTab);
            }
            return false;
        }
        return false;
    }

    private Map<String, Object> parse(List<String> sources, Map<String, Object> customHelp) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> contentList = new ArrayList<HashMap<String, Object>>();
        if (customHelp != null && customHelp.get("list") != null) {
            contentList.addAll((Collection)customHelp.get("list"));
        }
        for (String source : sources) {
            try {
                JSONObject jason = (JSONObject)JSON.parse((String)source);
                JSONArray contentJason = (JSONArray)jason.get((Object)"content");
                for (Object eachContent : contentJason.toArray()) {
                    JSONObject eachContentJason = (JSONObject)eachContent;
                    String title = (String)eachContentJason.get((Object)TITLE);
                    String url = (String)eachContentJason.get((Object)"entityUrl");
                    String entityType = eachContentJason.get((Object)"entity-type").toString();
                    HashMap<String, Object> content = new HashMap<String, Object>();
                    content.put("type", entityType);
                    this.getTypeName(entityType, content);
                    content.put(TITLE, title);
                    content.put("url", url);
                    contentList.add(content);
                }
            }
            catch (Exception e) {
                logger.info("parse", (Object)e);
            }
        }
        response.put("list", contentList);
        if (contentList.size() > 0) {
            response.put("errcode", "0");
        } else {
            response.put("errcode", "1");
        }
        response.put("description", "");
        return response;
    }

    private void getTypeName(String entityType, Map<String, Object> content) {
        switch (entityType) {
            case "Question": {
                content.put(TYPE_NAME, ResManager.loadKDString((String)"\u95ee\u7b54", (String)"BizAppHomePlugin_11", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                break;
            }
            case "Article": {
                content.put(TYPE_NAME, ResManager.loadKDString((String)"\u77e5\u8bc6", (String)"BizAppHomePlugin_12", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                break;
            }
            case "Course": 
            case "LearningCourse": {
                content.put("type", "Course");
                content.put(TYPE_NAME, ResManager.loadKDString((String)"\u8bfe\u7a0b", (String)"BizAppHomePlugin_13", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                break;
            }
        }
    }

    private String getUrlParamsByMap(Map<String, Object> map) {
        if (map == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue());
            sb.append("&");
        }
        String s = sb.toString();
        if (s.endsWith("&")) {
            s = StringUtils.substringBeforeLast((String)s, (String)"&");
        }
        return s;
    }

    protected String getKnowledgeSpecial(KnowledgeSearchParams searchParams) {
        String response = KnowledgeServiceHelper.getKnowledgeSpecial(searchParams);
        String entityUrl = null;
        try {
            JSONObject data;
            JSONArray content;
            JSONObject jason = (JSONObject)JSON.parse((String)response);
            int errorCode = Integer.parseInt(jason.get((Object)"errorCode").toString());
            if (errorCode == 0 && (content = (JSONArray)(data = (JSONObject)jason.get((Object)"data")).get((Object)"content")).size() > 0) {
                JSONObject result = (JSONObject)content.get(0);
                entityUrl = result.get((Object)"entityUrl").toString();
            }
        }
        catch (Exception e) {
            logger.info("BizAppHomePlugin--getKnowledgeSpecial error", (Object)e);
        }
        return entityUrl;
    }

    protected void getPageHelpCustomMenu(String key) {
        List<IPageHelpCustomMenuService> pageHelpCustomMenuServices = this.getPageHelpCustomMenuService();
        if (pageHelpCustomMenuServices == null || pageHelpCustomMenuServices.isEmpty()) {
            return;
        }
        ArrayList pageHelpCustomMenus = new ArrayList();
        pageHelpCustomMenuServices.forEach(service -> {
            List<PageHelpCustomMenu> datas = null;
            try {
                datas = service.getPageHelpCustomMenus();
            }
            catch (Exception e) {
                logger.info("getPageHelpCustomMenus error", (Object)e);
            }
            if (datas != null && pageHelpCustomMenus.size() <= 5) {
                pageHelpCustomMenus.addAll(datas);
            }
        });
        if (pageHelpCustomMenus.isEmpty()) {
            return;
        }
        ArrayList customMenusResult = new ArrayList(pageHelpCustomMenus.subList(0, Math.min(pageHelpCustomMenus.size(), 5)));
        List customMenuKeys = customMenusResult.stream().map(PageHelpCustomMenu::getKey).collect(Collectors.toList());
        this.getPageCache().put("customMenuKeys", SerializationUtils.toJsonString(customMenuKeys));
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", customMenusResult);
        map.put("key", key);
        HashSet hiddenItem = new HashSet();
        pageHelpCustomMenuServices.forEach(plugin -> {
            Set<PageHelpMenuEnum> datas = plugin.getHiddenItem();
            if (datas != null) {
                datas.forEach(data -> hiddenItem.add(data.getNumber()));
            }
        });
        map.put("hiddenitem", hiddenItem);
        proxy.addAction("pageHelpCustomMenus", map);
    }

    private List<IPageHelpCustomMenuService> getPageHelpCustomMenuService() {
        List plugins = null;
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IPageHelpCustomMenuService.class, (String)"BOS_SVC_PORTAL_PAGEHELP_CUSTOMMENU", null);
            plugins = pluginProxy.getPlugins();
        }
        catch (Exception e) {
            logger.info("getPageHelpCustomMenuService error", (Object)e);
        }
        return plugins;
    }

    protected void pageHelpCustomMenuClick(String key) {
        String customMenuKeyStr = this.getPageCache().get("customMenuKeys");
        if (customMenuKeyStr == null) {
            return;
        }
        List customMenuKeys = (List)SerializationUtils.fromJsonString(customMenuKeyStr, List.class);
        if (!customMenuKeys.contains(key)) {
            return;
        }
        List<IPageHelpCustomMenuService> pageHelpCustomMenuServices = this.getPageHelpCustomMenuService();
        if (pageHelpCustomMenuServices == null || pageHelpCustomMenuServices.isEmpty()) {
            return;
        }
        pageHelpCustomMenuServices.forEach(service -> {
            try {
                service.click(key, this.getView());
            }
            catch (Exception e) {
                logger.info("click error", (Object)e);
            }
        });
    }
}

