/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.form.container.GridContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.FloatMenu;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.constant.SchemeType;
import kd.bos.portal.model.CardInfo;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.service.PortalMenuService;
import kd.bos.portal.service.PortalSchemeService;
import kd.bos.portal.service.dto.CardResult;
import kd.bos.portal.service.factory.PortalSchemeServiceFactory;
import kd.bos.portal.util.PortalLogUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class GridContainerAbstract
extends AbstractFormPlugin
implements TabSelectListener,
ClickListener,
ItemClickListener {
    public static final String LAYOUT = "layout";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String APPMIANTAB = "appmiantab";
    private static final String TABPAGEAP = "tabpageap";
    private static final String GLAXY_MODE = "2";
    private static Log logger = LogFactory.getLog(GridContainerAbstract.class);
    public static final String CALLBACK_SHOWNEWCARDTYPEFORM = "CallBack_showAddCardForm";
    public static final String CALLBACK_GETSCHEME = "CallBack_getScheme";
    public static final String CACHE_CARDCONFIG = "cache_cardConfig";
    public static final String CACHE_ALLCARDCONFIG = "cache_allCardConfig";
    public static final String CACHE_CARDID_PAGEID_MAP = "cache_CardId_PageId_Map";
    public static final String CACHE_TEMPDEL = "cache_TempDel";
    public static final String CACHE_GRID_LAYOUT = "cache_grid_layout";
    public static final String FORM_NEWCARDTYPE = "bos_card_addnew";
    public static final String BTN_ADDCARD = "addCard";
    public static final String BTN_EDITEND = "editEnd";
    public static final String BTN_EDITCANCEL = "editCancel";
    public static final String BTN_DELETECARD = "deleteCard";
    public static final String CTRL_GRIDCONTAINER = "gridcontainerap";
    public static final String FLOATMENU_DESIGNMODE = "adjustlayout";
    public static final String FLOATMENU_RESET = "reset";
    public static final String FLOATMENU_SAVE_AS = "saveas";
    public static final String FLOATMENU_SWITCH = "switch";
    public static final String FLOATMENU_PANEL = "floatmenu";
    public static final String FLOATMENU_REFRESH = "refresh";
    public static final String FLOATMENU_SETDEFAULT = "setdefault";
    public static final String CONFIRMCALLBACKID_RESET = "confirm_reset";
    public static final String CONFIRMCALLBACKID_SET_DEFAULT = "confirm_setDefault";
    public static final String CONFIRMCALLBACKID_MODIFY_OR_NEWCUSTOM = "confirm_modifyOrNewCustom";
    public static final String CONFIRMCALLBACKID_MODIFY_CUSTOM = "confirmcallbackid_modify_custom";
    public static final String CONFIRMCALLBACKID_MODIFY_SYS = "confirmcallbackid_modify_sys";
    public static final String CONFIRMCALLBACKID_DELETE_USER = "confirmcallbackid_delete_user";
    public static final String CONFIRMCALLBACKID_DISABLE_ALLSYS = "confirmcallbackid_disable_allsys";
    public static final String CONFIRMCALLBACKID_DISABLE_ALLCUSTOM = "confirmcallbackid_disable_allcustom";
    private static final String DELETE_USER_SCHEME_ID = "delete_userSchemeId";
    public static final String PGCACHE_ISMAINPAGE = "IS_MainPage_Type";
    public static final String PGCACHE_ISCUSTOM_MAINPAGE = "pgCache_IsCustomMainPage";
    private static List<String> schemeTypes = Arrays.asList(SchemeType.SysDefScheme.getValue(), SchemeType.UserScheme.getValue(), SchemeType.GroupScheme.getValue());
    private PortalSchemeService portalSchemeService = PortalSchemeServiceFactory.createPortalSchemeService();
    private PortalMenuService menuService;

    public void initialize() {
        this.menuService = new PortalMenuService(this.getPageCache());
    }

    private boolean isNewPortal() {
        IFormView mainView = this.getView().getMainView();
        if (mainView == null) {
            String rootPageId = this.getView().getFormShowParameter().getRootPageId();
            IFormView rootView = SessionManager.getCurrent().getView(rootPageId);
            mainView = rootView.getParentView();
            if (mainView == null) {
                mainView = rootView;
            }
        }
        String formId = mainView.getFormShowParameter().getFormId();
        return "home_page".equals(formId);
    }

    public void tabSelected(TabSelectEvent event) {
        String tabKey = event.getTabKey();
        if (APPMIANTAB.equals(tabKey) || TABPAGEAP.equals(tabKey)) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            HashMap dataMap = new HashMap(0);
            proxy.invokeControlMethod(CTRL_GRIDCONTAINER, FLOATMENU_REFRESH, new Object[]{dataMap});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        String layout = this.getPageCache().get("pgCache_grid_layout");
        String curSchemeType = this.getPageCache().get("pgCache_currentSchemeType");
        String curSchemeId = this.getPageCache().get("pgCache_currentScheme");
        if (curSchemeType == null || curSchemeId == null) {
            logger.info("confirmCallBack curSchemeType or curSchemeId is null");
            return;
        }
        MessageBoxResult result = e.getResult();
        if (result.equals((Object)MessageBoxResult.No) && CONFIRMCALLBACKID_MODIFY_OR_NEWCUSTOM.equals(callBackId)) {
            if (CardUtils.checkCurSchemeCustomable(curSchemeId, this.getView())) {
                this.editEnd(SchemeType.UserScheme, layout, null);
            }
            return;
        }
        if (result.equals((Object)MessageBoxResult.Yes)) {
            switch (callBackId) {
                case "confirm_modifyOrNewCustom": {
                    this.editEnd(SchemeType.getSchemeType(curSchemeType), layout, Long.valueOf(curSchemeId));
                    break;
                }
                case "confirm_reset": {
                    this.reset();
                    break;
                }
                case "confirm_setDefault": {
                    this.editEnd(SchemeType.SysDefScheme, layout, null);
                    break;
                }
                case "confirmcallbackid_modify_custom": {
                    this.editEnd(SchemeType.UserScheme, layout, null);
                    break;
                }
                case "confirmcallbackid_modify_sys": {
                    this.editEnd(SchemeType.SysDefScheme, layout, null);
                    break;
                }
                case "confirmcallbackid_delete_user": {
                    this.deleteScheme();
                    break;
                }
                case "confirmcallbackid_disable_allsys": {
                    this.saveAsSchemeWithDisable(SchemeType.SysDefScheme, layout);
                    break;
                }
                case "confirmcallbackid_disable_allcustom": {
                    this.saveAsSchemeWithDisable(SchemeType.UserScheme, layout);
                    break;
                }
            }
        }
    }

    private void saveAsSchemeWithDisable(SchemeType schemeType, String layout) {
        List<DynamicObject> schemeDatas = this.getCurrentUserScheme(schemeType);
        if (schemeDatas.size() > 1) {
            this.disableScheme(schemeDatas);
        }
        this.editEnd(schemeType, layout, null);
    }

    public boolean checkCanEdit() {
        String curSchemeId = this.getPageCache().get("pgCache_currentScheme");
        return CardUtils.checkCurSchemeCustomable(curSchemeId, this.getView());
    }

    private boolean checkCanEditAndShowTip(boolean showTip) {
        String curSchemeId = this.getPageCache().get("pgCache_currentScheme");
        return CardUtils.checkCanEditAndShowTip(this.getView(), curSchemeId, showTip);
    }

    private void showSchemeSwitchList() {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"portal_scheme", (boolean)false);
        List<QFilter> rangeFilterList = this.getCurrentUserSchemeFilters();
        lsp.setListFilterParameter(new ListFilterParameter(rangeFilterList, null));
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_GETSCHEME));
        lsp.setCustomParam("schemeSwitchF7", (Object)"true");
        String curSchemeId = this.getPageCache().get("pgCache_currentScheme");
        if (StringUtils.isNotEmpty((String)curSchemeId)) {
            lsp.setSelectedRow((Object)Long.valueOf(curSchemeId));
        }
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void showItemControl(Boolean isShowChangeDesignItem) {
        this.getView().setVisible(isShowChangeDesignItem, new String[]{FLOATMENU_DESIGNMODE});
        String schemeType = this.getPageCache().get("pgCache_currentSchemeType");
        if (SchemeType.UserScheme.getValue().equals(schemeType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLOATMENU_RESET});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLOATMENU_RESET});
        }
        Long userId = RequestContext.get().getCurrUserId();
        boolean hasRight = false;
        if (!isShowChangeDesignItem.booleanValue()) {
            hasRight = CardUtils.checkHasModifySchemeRight(userId);
            if (CardUtils.isOutAdmin()) {
                hasRight = true;
            }
        }
        this.getView().setVisible(Boolean.valueOf(hasRight), new String[]{FLOATMENU_SAVE_AS});
        this.getView().setVisible(Boolean.TRUE, new String[]{FLOATMENU_SWITCH});
        this.getView().setVisible(Boolean.TRUE, new String[]{FLOATMENU_REFRESH});
        this.getView().setVisible(Boolean.TRUE, new String[]{FLOATMENU_SETDEFAULT});
    }

    public void showItemOnlyModify() {
        this.getView().setVisible(Boolean.TRUE, new String[]{FLOATMENU_DESIGNMODE});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLOATMENU_RESET});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLOATMENU_SAVE_AS});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLOATMENU_SWITCH});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLOATMENU_REFRESH});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLOATMENU_SETDEFAULT});
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        Map paramMap = evt.getParamsMap();
        switch (key) {
            case "adjustlayout": {
                this.changeToDesignMode();
                break;
            }
            case "addCard": {
                if (paramMap.get(LAYOUT) != null) {
                    this.getPageCache().put(LAYOUT, paramMap.get(LAYOUT).toString());
                }
                this.showNewCardTypeForm(null);
                break;
            }
            case "editEnd": {
                String layout = (String)paramMap.get(LAYOUT);
                boolean isSetDefault = (Boolean)paramMap.get("isSetDefault");
                this.doFinish(layout, isSetDefault);
                break;
            }
            case "editCancel": {
                this.editCancel();
                break;
            }
            case "deleteCard": {
                String cardId = (String)paramMap.get("cardId");
                this.deleteCard(cardId);
                break;
            }
            case "reset": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u5e03\u5c40\u5c06\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u5e03\u5c40\uff0c\u786e\u5b9a\u91cd\u7f6e\uff1f", (String)"GridContainerPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACKID_RESET, (IFormPlugin)this));
                break;
            }
            case "saveas": {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("pc_main_scheme_saveas");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(fsp);
                break;
            }
            case "switch": {
                this.showSchemeSwitchList();
                break;
            }
            case "refresh": {
                this.clickFreshGridContainer();
                break;
            }
            case "setdefault": {
                this.setDefaultMainpage();
                break;
            }
            case "trigger": {
                this.trigger();
                break;
            }
            case "edit": {
                this.toDesignMode();
                break;
            }
            case "switchScheme": {
                this.switchScheme((String)paramMap.get("schemeId"));
                break;
            }
            case "setDefaultScheme": {
                this.setDefaultScheme((String)paramMap.get("schemeId"));
                break;
            }
            case "saveAsSchemeType": {
                String schemeLayout = (String)paramMap.get(LAYOUT);
                String type = (String)paramMap.get("type");
                this.saveAsSchemeType(type, schemeLayout);
                break;
            }
            case "deleteScheme": {
                this.deleteSchemeBefore((String)paramMap.get("schemeId"));
                break;
            }
            case "save": {
                this.saveCurrentScheme((String)paramMap.get(LAYOUT));
                break;
            }
        }
    }

    private void setDefaultMainpage() {
        String schemeId = this.getPageCache().get("pgCache_currentScheme");
        this.setDefaultScheme(schemeId);
    }

    private void reset() {
        boolean result;
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject schemeObj = CardUtils.loadScheme(SchemeType.UserScheme, userId, "id", CardUtils.isMainPage(this.getView()), this.getView());
        if (schemeObj != null && (result = this.doDeleteScheme(schemeObj.getLong("id")))) {
            this.updateTempDelIds(new ArrayList<String>());
            this.getPageCache().remove("pgCache_currentScheme");
            this.getPageCache().remove("pgCache_currentSchemeType");
            this.refreshGridContainer();
        }
    }

    private boolean doDeleteScheme(Long schemeId) {
        Throwable throwable = null;
        try (TXHandle txHandle = TX.required();){
            DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"portal_scheme");
            if (schemeObj != null) {
                DeleteServiceHelper.delete((String)"bos_mainpagecardconfig", (QFilter[])new QFilter[]{new QFilter("mainpagelayout", "=", schemeObj.get("id"))});
                DeleteServiceHelper.delete((String)"portal_scheme", (QFilter[])new QFilter[]{new QFilter("id", "=", schemeObj.get("id"))});
                String schemeName = schemeObj.getString("name");
                PortalLogUtils.addLog("portal_scheme", "2deb950100005dac", "delete", new MultiLangEnumBridge("\u5220\u9664", "PortalSchemeGroupTreeListPlugin_11", BOS_PORTAL_PLUGIN), new MultiLangEnumBridge("%s\u5220\u9664\u6210\u529f\u3002", "GridContainerAbstract_0", BOS_PORTAL_PLUGIN), schemeName);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            txHandle.markRollback();
            logger.info("deleteScheme fail", (Object)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7528\u6237\u7684\u5e03\u5c40\u4fe1\u606f\u5220\u9664\u5931\u8d25\uff1a%s", (String)"GridContainerPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage()));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return false;
    }

    public void registerListener(EventObject e) {
        GridContainer gc;
        FloatMenu floatMenu;
        Tab tab;
        super.registerListener(e);
        Tab apptabs = (Tab)this.getView().getControl("_submaintab_");
        if (apptabs != null) {
            apptabs.addTabSelectListener((TabSelectListener)this);
        }
        if ((tab = (Tab)this.getView().getControl("tabap")) != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        if ((floatMenu = (FloatMenu)this.getControl(FLOATMENU_PANEL)) != null) {
            floatMenu.addItemClickListener((ItemClickListener)this);
        }
        if ((gc = (GridContainer)this.getControl(CTRL_GRIDCONTAINER)) != null) {
            gc.addItemClickListener((ItemClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshGridContainer();
        this.initNewPortalScheme();
    }

    public void showNewCardTypeForm(String cardTypeIndex) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(FORM_NEWCARDTYPE);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_SHOWNEWCARDTYPEFORM));
        if (StringUtils.isNotEmpty((String)cardTypeIndex)) {
            fsp.setCustomParam("event_rtn_addcard", (Object)cardTypeIndex);
        }
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object retDataObj = e.getReturnData();
        if (retDataObj == null) {
            return;
        }
        String actionId = e.getActionId();
        if (actionId.equals(CALLBACK_SHOWNEWCARDTYPEFORM)) {
            List<Map<String, Object>> list = new ArrayList<Map<String, Object>>(20);
            if (retDataObj instanceof Map) {
                Object rtnCardIndex = ((Map)retDataObj).get("event_rtn_addcard");
                if (rtnCardIndex != null) {
                    String cardTypeIndex = (String)rtnCardIndex;
                    this.showNewCardTypeForm(cardTypeIndex);
                    return;
                }
                list.add((Map)retDataObj);
            } else if (retDataObj instanceof List) {
                list = (List)retDataObj;
            }
            this.showNewAddCardForm(list);
        } else if (actionId.equals(CALLBACK_GETSCHEME) && retDataObj instanceof ListSelectedRowCollection) {
            Long schemeId = Long.parseLong(((ListSelectedRowCollection)retDataObj).getPrimaryKeyValues()[0].toString());
            DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"portal_scheme");
            this.refreshGridContainer(schemeObj);
        }
    }

    private void setFormId(FormShowParameter fsp, Map<String, Object> pReturnMap) {
        String cardType = (String)pReturnMap.get("cardType");
        if (cardType.equals("bos_card_custom")) {
            String formNum = (String)pReturnMap.get("cardformnum");
            fsp.setFormId(formNum);
        } else {
            fsp.setFormId(cardType);
        }
    }

    private void showNewAddCardForm(List<FormShowParameter> fspList, Map<String, Object> pReturnMap, List<Map<String, Object>> cardInfoMaps, Map<String, String> newCardIdPageIdMap) {
        String cardType = (String)pReturnMap.get("cardType");
        if (StringUtils.isEmpty((String)cardType)) {
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        this.setFormId(fsp, pReturnMap);
        String cardId = this.setShowType(fsp, cardType, null, true);
        this.setCustomParam(fsp, cardType);
        if (StringUtils.isNotEmpty((String)cardId)) {
            Map<String, String> allCardConfigMap = this.getAllCardConfigMap();
            allCardConfigMap.put(cardId, SerializationUtils.toJsonString(pReturnMap));
            this.setAllCardConfigCache(allCardConfigMap);
            HashMap<Object, Object> config = new HashMap(16);
            if (this.getPageCache().get(LAYOUT) != null) {
                String layout = this.getPageCache().get(LAYOUT);
                int cols = this.getGridCols();
                config = CardUtils.getLayoutForNewCard(layout, 4, 1, cols);
                JSONArray jsonArr = JSONArray.parseArray((String)layout);
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("w", config.get("w"));
                jsonObj.put("h", config.get("h"));
                jsonObj.put("x", config.get("x"));
                jsonObj.put("y", config.get("y"));
                jsonObj.put("i", (Object)cardId);
                jsonObj.put("moved", (Object)Boolean.FALSE);
                jsonObj.put("static", (Object)Boolean.FALSE);
                jsonArr.add((Object)jsonObj);
                String newLayout = jsonArr.toJSONString();
                this.getPageCache().put(LAYOUT, newLayout);
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("formId", "");
            dataMap.put("cardId", cardId);
            dataMap.put("config", config);
            cardInfoMaps.add(dataMap);
            newCardIdPageIdMap.put(cardId, fsp.getPageId());
        }
        fspList.add(fsp);
    }

    private int getGridCols() {
        String defaultGridCols = "12";
        String formId = this.getView().getFormShowParameter().getFormId();
        String cols = this.getPageCache().get(formId + "_gridcontainerap_cols");
        if (StringUtils.isEmpty((String)cols)) {
            try {
                MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
                String meta = metadataService.loadClientFormMeta(formId);
                Map<String, Object> data = this.getGridRuntimeMeta(CTRL_GRIDCONTAINER, (Map)SerializationUtils.fromJsonString((String)meta, Map.class));
                cols = data != null ? data.get("cols").toString() : defaultGridCols;
            }
            catch (Exception e) {
                logger.info("getGridCols error", (Object)e);
                cols = defaultGridCols;
            }
            this.getPageCache().put(formId + "_gridcontainerap_cols", cols);
        }
        return Integer.parseInt(cols);
    }

    private Map<String, Object> getGridRuntimeMeta(String gridId, Map<String, Object> meta) {
        List items;
        if (meta != null && meta.containsKey("items") && meta.get("items") instanceof List && (items = (List)meta.get("items")) != null && !items.isEmpty()) {
            for (Map item : items) {
                if (item.containsKey("id") && item.containsKey("cols") && Objects.equals(gridId, item.get("id"))) {
                    return item;
                }
                Map<String, Object> metadata = this.getGridRuntimeMeta(gridId, item);
                if (metadata == null) continue;
                return metadata;
            }
        }
        return null;
    }

    private void showNewAddCardForm(List<Map<String, Object>> pListReturnMap) {
        ArrayList<FormShowParameter> fspList = new ArrayList<FormShowParameter>();
        ArrayList<Map<String, Object>> cardInfoMaps = new ArrayList<Map<String, Object>>();
        HashMap<String, String> newCardIdPageIdMap = new HashMap<String, String>(16);
        for (Map<String, Object> map : pListReturnMap) {
            this.showNewAddCardForm(fspList, map, cardInfoMaps, newCardIdPageIdMap);
        }
        this.updateCardPageMap(newCardIdPageIdMap);
        GridContainer gc = (GridContainer)this.getView().getControl(CTRL_GRIDCONTAINER);
        gc.addCards(cardInfoMaps);
        for (FormShowParameter fsp : fspList) {
            this.getView().showForm(fsp);
        }
    }

    private String setShowType(FormShowParameter fsp, String cardType, String pNewCardIndex, boolean ifDesignMode) {
        HashMap custParam = fsp.getOpenStyle().getCustParam();
        if (custParam == null) {
            custParam = new HashMap(16);
            fsp.getOpenStyle().setCustParam(custParam);
        }
        String strNewCardIndex = pNewCardIndex;
        switch (cardType) {
            case "bos_card_billstatsconfig": 
            case "bos_card_workflowconfig": 
            case "bos_card_qingconfig": 
            case "bos_card_custom_config": 
            case "bos_card_yzjconifg": 
            case "bos_card_usercenterconfig": {
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), CALLBACK_SHOWNEWCARDTYPEFORM));
                break;
            }
            case "bos_card_custom": 
            case "bos_card_quicklaunch": 
            case "bos_card_billstats": 
            case "bos_card_billstats_list": 
            case "bos_card_workflow": 
            case "bos_card_msgcenter": 
            case "bos_card_qing": 
            case "bos_card_yzj_subscribe": 
            case "bos_card_usercenter": {
                fsp.getOpenStyle().setShowType(ShowType.InContainer);
                if (strNewCardIndex == null) {
                    strNewCardIndex = this.getNewCardIndex();
                }
                fsp.getOpenStyle().setTargetKey(CTRL_GRIDCONTAINER);
                fsp.getOpenStyle().getCustParam().put("cardId", strNewCardIndex);
                String strIfDesignMode = ifDesignMode ? "1" : "0";
                fsp.getOpenStyle().getCustParam().put("ifDesignMode", strIfDesignMode);
                break;
            }
        }
        return strNewCardIndex;
    }

    private void setCustomParam(FormShowParameter fsp, String cardType) {
        Object isFreshClick = this.getView().getFormShowParameter().getCustomParam("isFreshClick");
        boolean isFreshClickFlag = false;
        if (isFreshClick != null && Boolean.parseBoolean(isFreshClick.toString())) {
            isFreshClickFlag = true;
        }
        switch (cardType) {
            case "bos_card_quicklaunch": {
                fsp.getOpenStyle().getCustParam().put("cardRefresh", "false");
                break;
            }
            case "bos_card_billstats": 
            case "bos_card_billstats_list": {
                fsp.setCustomParam("isFreshClick", (Object)isFreshClickFlag);
                break;
            }
        }
    }

    public void showAllCardForm(Map<String, String> allCardConfigMap, boolean ifDesignMode) {
        HashMap<String, String> newCardPageMap = new HashMap<String, String>(16);
        String hideCardIdStr = this.getPageCache().get("pgCache_hideCardIds");
        Set hideCardIds = null;
        if (StringUtils.isNotEmpty((String)hideCardIdStr)) {
            hideCardIds = (Set)SerializationUtils.fromJsonString((String)hideCardIdStr, Set.class);
        }
        Map<String, Set<String>> noPermMenuMap = this.getUserNoPermMenuByAppIds(allCardConfigMap);
        for (Map.Entry<String, String> entry : allCardConfigMap.entrySet()) {
            String strConfigMap;
            Map configMap;
            String cardType;
            String cardId = entry.getKey();
            if (CollectionUtils.isNotEmpty((Collection)hideCardIds) && hideCardIds.contains(cardId) || StringUtils.isEmpty((String)(cardType = (String)(configMap = (Map)SerializationUtils.fromJsonString((String)(strConfigMap = entry.getValue()), Map.class)).get("cardType")))) continue;
            FormShowParameter fsp = new FormShowParameter();
            fsp.setSendToClient(true);
            this.setFormId(fsp, configMap);
            this.setShowType(fsp, cardType, cardId, ifDesignMode);
            this.setCustomParam(fsp, cardType);
            if ("bos_card_billstats".equals(cardType) || "bos_card_billstats_list".equals(cardType)) {
                fsp.setCustomParam("noPermMenuMap", noPermMenuMap);
            }
            try {
                this.getView().showForm(fsp);
            }
            catch (Exception e) {
                logger.info("\u663e\u793a\u8868\u5355\u51fa\u73b0\u5f02\u5e38\uff01", (Object)e);
            }
            newCardPageMap.put(cardId, fsp.getPageId());
        }
        this.updateCardPageMap(newCardPageMap);
    }

    private Map<String, Set<String>> getUserNoPermMenuByAppIds(Map<String, String> allCardConfigMap) {
        HashSet appNums = new HashSet(10);
        allCardConfigMap.values().forEach(cardInfo -> {
            Map cardConfigMap = (Map)SerializationUtils.fromJsonString((String)cardInfo, Map.class);
            if ("bos_card_billstats".equals(cardConfigMap.get("cardType"))) {
                String appNum = (String)cardConfigMap.get("appnum");
                appNums.add(appNum);
            } else if ("bos_card_billstats_list".equals(cardConfigMap.get("cardType"))) {
                Map<String, Object> configMap = CardUtils.getDetailConfigMap(cardConfigMap);
                if (configMap == null) {
                    return;
                }
                Set cardAppNums = configMap.values().stream().map(cardInfoObj -> {
                    Map cardInfoMap = (Map)cardInfoObj;
                    return (String)cardInfoMap.get("appnum");
                }).collect(Collectors.toSet());
                appNums.addAll(cardAppNums);
            }
        });
        long userId = RequestContext.get().getCurrUserId();
        if (appNums.isEmpty()) {
            return null;
        }
        Set<String> appIds = appNums.stream().map(BizAppServiceHelp::getAppIdByAppNumber).collect(Collectors.toSet());
        return this.menuService.getNoPermMenuByAppIds(userId, appIds);
    }

    public void resetGridContainerLayout(String layout) {
        GridContainer gc = (GridContainer)this.getView().getControl(CTRL_GRIDCONTAINER);
        if (gc != null) {
            gc.reset(layout);
        }
    }

    private DynamicObject getCurUserSuitableScheme(Long userId) {
        DynamicObject curScheme;
        String selFields = "id,layout,schemetype,ismultiorg";
        boolean isMainPage = CardUtils.isMainPage(this.getView());
        this.getPageCache().put(PGCACHE_ISMAINPAGE, Boolean.toString(isMainPage));
        String strSchemeId = this.getPageCache().get("pgCache_currentScheme");
        if (StringUtils.isNotEmpty((String)strSchemeId) && (curScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(strSchemeId), (String)"portal_scheme", (String)selFields)) != null) {
            return curScheme;
        }
        String bizAppId = CardUtils.getAppIdFromView(this.getView());
        String entityId = this.getView().getEntityId();
        String pageType = CardUtils.getPageType(this.getView());
        Long defaultSchemeId = CardUtils.getDefaultSchemeId(pageType, bizAppId, entityId, this.getView());
        if (defaultSchemeId != null) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)defaultSchemeId, (String)"portal_scheme", (String)selFields);
        }
        String modeType = CardUtils.convertModeType();
        List<QFilter> modeTypeFilter = Collections.singletonList(new QFilter("ismultiorg", "=", (Object)modeType));
        DynamicObject schemeObj = CardUtils.loadScheme(SchemeType.UserScheme, userId, selFields, modeTypeFilter, isMainPage, this.getView());
        if (schemeObj != null) {
            return schemeObj;
        }
        Long schemeId = CardUtils.getGroupSchemeId(userId, this.getView());
        if (schemeId != null) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"portal_scheme", (String)selFields);
        }
        schemeObj = CardUtils.loadScheme(SchemeType.SysDefScheme, userId, selFields, modeTypeFilter, isMainPage, this.getView());
        if (schemeObj == null && GLAXY_MODE.equals(modeType)) {
            List<QFilter> ccsFilter = Collections.singletonList(new QFilter("ismultiorg", "=", (Object)"1"));
            schemeObj = CardUtils.loadScheme(SchemeType.SysDefScheme, userId, selFields, ccsFilter, isMainPage, this.getView());
        }
        return schemeObj;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void clickFreshGridContainer() {
        this.getView().getFormShowParameter().setCustomParam("isFreshClick", (Object)Boolean.TRUE);
        String curSchemeId = this.getPageCache().get("pgCache_currentScheme");
        if (StringUtils.isNotEmpty((String)curSchemeId)) {
            DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((String)"portal_scheme", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(curSchemeId))});
            if (schemeObj != null) {
                boolean enable = schemeObj.getBoolean("enable");
                if (enable) {
                    this.refreshGridContainer(schemeObj);
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bfb\u53d6\u7684\u9996\u9875\u65b9\u6848\u5df2\u88ab\u7981\u7528\uff0c\u5c06\u81ea\u52a8\u8df3\u8f6c\u5176\u4ed6\u65b9\u6848\u3002", (String)"GridContainerPlugin_25", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bfb\u53d6\u7684\u9996\u9875\u65b9\u6848\u5df2\u88ab\u5220\u9664\uff0c\u5c06\u81ea\u52a8\u8df3\u8f6c\u5176\u4ed6\u65b9\u6848\u3002", (String)"GridContainerPlugin_24", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
        }
        this.refreshGridContainer();
        this.initNewPortalScheme();
    }

    public void refreshGridContainer(DynamicObject schemeObj) {
        String layout = null;
        Long schemeId = 0L;
        String schemeType = "";
        if (schemeObj != null) {
            layout = schemeObj.getString(LAYOUT);
            schemeId = schemeObj.getLong("id");
            schemeType = schemeObj.getString("schemetype");
        }
        this.getPageCache().put("pgCache_currentScheme", String.valueOf(schemeId));
        this.getPageCache().put("pgCache_currentSchemeType", schemeType);
        this.showItemControl(Boolean.TRUE);
        if (StringUtils.isEmpty((String)layout)) {
            this.resetGridContainerLayout("");
            return;
        }
        DynamicObject[] arrDObj = CardUtils.loadAllMainPageCardConfig(schemeId);
        layout = CardUtils.replaceBackSlach(layout);
        Map<String, CardResult> cardResults = null;
        try {
            cardResults = this.portalSchemeService.getPermFilterCardInfo(arrDObj);
        }
        catch (Exception e) {
            logger.info("getPermFilterCardInfo", (Object)e);
        }
        this.getPageCache().remove("pgCache_hideCardIds");
        this.getPageCache().remove("pgCache_permFilterCardInfo");
        if (cardResults != null && cardResults.size() > 0) {
            Set<String> hideCardIds = this.portalSchemeService.getHideCardIds(cardResults);
            if (CollectionUtils.isNotEmpty(hideCardIds)) {
                layout = this.portalSchemeService.hideCards(layout, hideCardIds);
                this.getPageCache().put("pgCache_hideCardIds", SerializationUtils.toJsonString(hideCardIds));
            }
            this.getPageCache().put("pgCache_permFilterCardInfo", SerializationUtils.serializeToBase64(cardResults));
        }
        this.resetGridContainerLayout(layout);
        this.getPageCache().put("pgCache_grid_layout", layout);
        HashMap<String, String> allCardConfig = new HashMap<String, String>(16);
        for (DynamicObject cardObj : arrDObj) {
            Map configMap;
            String cardId = cardObj.getString("cardid");
            String configStr = cardObj.getString("config");
            try {
                configMap = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
            }
            catch (Exception e) {
                logger.info("configStr serialize fail:" + configStr, (Object)e);
                try {
                    configStr = CardUtils.convertToPureJson(configStr);
                    configMap = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
                }
                catch (Exception ex) {
                    logger.info("\u5361\u7247\u914d\u7f6e\u5b58\u5728\u95ee\u9898\uff0c\u5bfc\u81f4\u52a0\u8f7d\u4e3a\u7a7a\uff1a", (Object)ex);
                    continue;
                }
            }
            String mapEntryStr = "";
            String cardTitleInCfgStr = (String)configMap.get("cardtitle");
            if (StringUtils.isNotEmpty((String)cardTitleInCfgStr) && !"[]".equals(cardTitleInCfgStr)) {
                mapEntryStr = "[zh_CN=" + cardTitleInCfgStr + "]";
            } else {
                OrmLocaleValue ormLocaleValue = (OrmLocaleValue)cardObj.get("cardtitle");
                mapEntryStr = CardUtils.getMapEntryStrFromOrmLocaleValue(ormLocaleValue);
            }
            configMap.put("cardtitle", mapEntryStr);
            configStr = SerializationUtils.toJsonString((Object)configMap);
            allCardConfig.put(cardId, configStr);
        }
        this.setAllCardConfigCache(allCardConfig);
        this.getView().addClientCallBack("showAllCardForm");
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if ("showAllCardForm".equals(e.getName())) {
            Map<String, String> allCardConfig = this.getAllCardConfigMap();
            this.showAllCardForm(allCardConfig, false);
        } else if ("refreshSchemeList".equals(e.getName())) {
            this.initNewPortalScheme();
        }
    }

    public void refreshGridContainer() {
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject schemeObj = this.getCurUserSuitableScheme(userId);
        try {
            if (schemeObj == null) {
                this.resetGridContainerLayout(null);
                this.showItemOnlyModify();
                return;
            }
        }
        catch (Exception exception) {
            logger.info("\u6ca1\u6709\u9996\u9875\u65b9\u6848\uff0c\u91cd\u7f6e\u4e3a\u7a7a\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Object)exception.getMessage());
        }
        this.refreshGridContainer(schemeObj);
    }

    private void setAllCardConfigCache(Map<String, String> allCardConfigMap) {
        String jsonStr = SerializationUtils.toJsonString(allCardConfigMap);
        this.getPageCache().put(CACHE_ALLCARDCONFIG, jsonStr);
    }

    private String getNewCardIndex() {
        long lNewCardId = ORM.create().genLongId("bos_mainpagecardconfig");
        return String.valueOf(lNewCardId);
    }

    public Map<String, String> getAllCardConfigMap() {
        HashMap<String, String> allCardConfigMap;
        String cacheStr = this.getPageCache().get(CACHE_ALLCARDCONFIG);
        if (StringUtils.isNotEmpty((String)cacheStr)) {
            allCardConfigMap = (HashMap<String, String>)SerializationUtils.fromJsonString((String)cacheStr, Map.class);
        } else {
            allCardConfigMap = new HashMap<String, String>(16);
            this.setAllCardConfigCache(allCardConfigMap);
        }
        return allCardConfigMap;
    }

    public void deleteCard(String cardId) {
        List<String> tempDelIds = this.getTempDelIds();
        tempDelIds.add(cardId);
        this.updateTempDelIds(tempDelIds);
    }

    public List<String> getTempDelIds() {
        ArrayList<String> result;
        String tempDelStr = this.getPageCache().get(CACHE_TEMPDEL);
        if (StringUtils.isEmpty((String)tempDelStr)) {
            result = new ArrayList(0);
            this.getPageCache().put(CACHE_TEMPDEL, SerializationUtils.toJsonString(result));
        } else {
            result = (List)SerializationUtils.fromJsonString((String)tempDelStr, List.class);
        }
        return result;
    }

    public void updateTempDelIds(List<String> tempDelIds) {
        this.getPageCache().put(CACHE_TEMPDEL, SerializationUtils.toJsonString(tempDelIds));
    }

    public Map<String, String> getCardPageMap() {
        HashMap<String, String> result;
        String cardPageMapStr = this.getPageCache().get(CACHE_CARDID_PAGEID_MAP);
        if (StringUtils.isEmpty((String)cardPageMapStr)) {
            result = new HashMap(16);
            this.getPageCache().put(CACHE_CARDID_PAGEID_MAP, SerializationUtils.toJsonString(result));
        } else {
            result = (Map)SerializationUtils.fromJsonString((String)cardPageMapStr, Map.class);
        }
        return result;
    }

    public void setCardPageMap(Map<String, String> pCardPageMap) {
        this.getPageCache().put(CACHE_CARDID_PAGEID_MAP, SerializationUtils.toJsonString(pCardPageMap));
    }

    public static void updateCardIdPageIdMap(IFormView pMainFormView, String cardId, String pageId) {
        Map<String, String> cardPageMap;
        IPageCache pageCache = (IPageCache)pMainFormView.getService(IPageCache.class);
        String cardPageMapStr = pageCache.get(CACHE_CARDID_PAGEID_MAP);
        if (StringUtils.isEmpty((String)cardPageMapStr)) {
            cardPageMap = new HashMap(16);
            pageCache.put(CACHE_CARDID_PAGEID_MAP, SerializationUtils.toJsonString(cardPageMap));
        } else {
            cardPageMap = (Map)SerializationUtils.fromJsonString((String)cardPageMapStr, Map.class);
        }
        cardPageMap.put(cardId, pageId);
        pageCache.put(CACHE_CARDID_PAGEID_MAP, SerializationUtils.toJsonString(cardPageMap));
    }

    public void updateCardPageMap(String cardId, String pageId) {
        Map<String, String> cardPageMap = this.getCardPageMap();
        cardPageMap.put(cardId, pageId);
        this.setCardPageMap(cardPageMap);
    }

    public void updateCardPageMap(Map<String, String> newCardIdPageIdMap) {
        Map<String, String> cardPageMap = this.getCardPageMap();
        cardPageMap.putAll(newCardIdPageIdMap);
        this.setCardPageMap(cardPageMap);
    }

    public void changeToDesignMode() {
        boolean success = this.toDesignMode();
        if (!success) {
            return;
        }
        this.showGuide();
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = CardUtils.checkHasModifySchemeRight(userId);
        GridContainer gridContainer = (GridContainer)this.getView().getControl(CTRL_GRIDCONTAINER);
        gridContainer.setIsDefaultVisible(false);
        if (hasPerm) {
            String curSchemeType = this.getPageCache().get("pgCache_currentSchemeType");
            if (!SchemeType.SysDefScheme.getValue().equals(curSchemeType)) {
                gridContainer.setIsDefaultVisible(true);
            }
        }
    }

    private void showGuide() {
        String fieldName;
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject dObj = BusinessDataServiceHelper.loadSingle((String)"bos_user_isfirstlogin", (String)"id,mainpage,appmainpage", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
        boolean isMainPage = CardUtils.isMainPage(this.getView());
        String string = fieldName = isMainPage ? "mainpage" : "appmainpage";
        if (dObj == null) {
            dObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_user_isfirstlogin");
            dObj.set("user", (Object)userId);
            dObj.set("isfirstlogin", (Object)true);
        }
        if (dObj.get(fieldName) == null || !dObj.getBoolean(fieldName)) {
            dObj.set(fieldName, (Object)Boolean.TRUE);
            SaveServiceHelper.save((IDataEntityType)dObj.getDataEntityType(), (Object[])new Object[]{dObj});
            String[] urls = new String[]{"/private/card_guide_GIF.png"};
            Lang lang = RequestContext.get().getLang();
            if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                urls[0] = "/images/pc/other/card_guide_English-GIF.png-600\u00d7500.gif";
            }
            HashMap<String, Object> jo = new HashMap<String, Object>(16);
            jo.put("showToolbar", Boolean.FALSE);
            jo.put("canOperate", Boolean.FALSE);
            jo.put("urls", urls);
            jo.put("activeIndex", 0);
            jo.put("isStaticImage", Boolean.TRUE);
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.addAction("showPictureView", jo);
        }
    }

    public void trigger() {
        this.refreshGridContainer();
        this.initNewPortalScheme();
    }

    public void editEnd(SchemeType schemeType, String layout, Long modifyCurSchemeId) {
        Map<String, String> allCardConfigMap = this.getAllCardConfigMap();
        HashMap<String, String> deletedCardConfigMap = new HashMap<String, String>(16);
        List<String> tempDelIds = this.getTempDelIds();
        Map<String, String> cardPageMap = this.getCardPageMap();
        for (String tempDelId : tempDelIds) {
            String cardConfig = allCardConfigMap.remove(tempDelId);
            deletedCardConfigMap.put(tempDelId, cardConfig);
            cardPageMap.remove(tempDelId);
        }
        this.setAllCardConfigCache(allCardConfigMap);
        this.setCardPageMap(cardPageMap);
        this.updateTempDelIds(new ArrayList<String>());
        CardUtils cardUtils = new CardUtils(this.getView(), this.getPageCache(), this.getModel(), logger);
        boolean result = cardUtils.saveMainPageInfo(schemeType, layout, allCardConfigMap, modifyCurSchemeId, null);
        if (result) {
            this.showAllCardForm(allCardConfigMap, false);
            GridContainer gridContainer = (GridContainer)this.getView().getControl(CTRL_GRIDCONTAINER);
            gridContainer.setDesignMode(false);
            this.showItemControl(Boolean.TRUE);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"GridContainerPlugin_11", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
        this.doOtherThing(deletedCardConfigMap);
        this.initNewPortalScheme();
    }

    private void doFinish(String layout, boolean isSetDefault) {
        this.getPageCache().put("pgCache_grid_layout", layout);
        if (isSetDefault) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5c06\u5f53\u524d\u65b9\u6848\u8bbe\u4e3a\u5168\u5c40\u65b9\u6848\u5417\uff1f", (String)"GridContainerPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRMCALLBACKID_SET_DEFAULT, (IFormPlugin)this));
            return;
        }
        String curSchemeType = this.getPageCache().get("pgCache_currentSchemeType");
        String curSchemeId = this.getPageCache().get("pgCache_currentScheme");
        Long schemeId = null;
        if (curSchemeId != null) {
            schemeId = Long.parseLong(curSchemeId);
        }
        if (this.isSysOrGroupShemeType(curSchemeType)) {
            Long userId = RequestContext.get().getCurrUserId();
            boolean hasModifyPerm = CardUtils.checkHasModifySchemeRight(userId);
            boolean isOwner = CardUtils.checkCurSchemeOwner(userId, schemeId);
            boolean isEdit = CardUtils.checkCurSchemeIsEdit(schemeId);
            if (isOwner || hasModifyPerm && isEdit || SchemeType.GroupScheme.getValue().equals(curSchemeType) && CardUtils.isOutAdmin()) {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848", (String)"GridContainerPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4e2a\u6027\u65b9\u6848", (String)"GridContainerPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"GridContainerPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.YesNoCancel;
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5f53\u524d\u65b9\u6848\u8fd8\u662f\u53e6\u5b58\u4e3a\u4e2a\u6027\u5316\u65b9\u6848\uff1f", (String)"GridContainerPlugin_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, new ConfirmCallBackListener(CONFIRMCALLBACKID_MODIFY_OR_NEWCUSTOM, (IFormPlugin)this), btnNameMaps);
            } else if (!hasModifyPerm && isEdit) {
                List<DynamicObject> schemeDatas = this.getCurrentUserScheme(SchemeType.UserScheme);
                if (CollectionUtils.isEmpty(schemeDatas)) {
                    this.editEnd(SchemeType.UserScheme, layout, null);
                } else {
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"GridContainerPlugin_12", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"GridContainerPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    MessageBoxOptions options = MessageBoxOptions.OKCancel;
                    String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848\u5c06\u66ff\u6362\u5df2\u6709\u7684\u4e2a\u6027\u65b9\u6848\uff0c\u662f\u5426\u786e\u8ba4\u4fdd\u5b58\uff1f", (String)"GridContainerPlugin_13", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                    this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, new ConfirmCallBackListener(CONFIRMCALLBACKID_MODIFY_CUSTOM, (IFormPlugin)this), btnNameMaps);
                }
            } else if (hasModifyPerm) {
                this.editEnd(SchemeType.getSchemeType(curSchemeType), layout, schemeId);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u9996\u9875\u65b9\u6848\u6743\u9650\uff0c\u65e0\u6cd5\u8c03\u6574\u5e03\u5c40\u3002", (String)"GridContainerPlugin_28", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
        } else {
            this.editEnd(SchemeType.UserScheme, layout, schemeId);
        }
    }

    private boolean isSysOrGroupShemeType(String curSchemeType) {
        return SchemeType.SysDefScheme.getValue().equals(curSchemeType) || SchemeType.GroupScheme.getValue().equals(curSchemeType);
    }

    private void doOtherThing(Map<String, String> deletedCardConfigMap) {
        this.doQingThing(deletedCardConfigMap);
    }

    private void doQingThing(Map<String, String> deletedCardConfigMap) {
        HashMap<String, String> deletedQingCardConfig = new HashMap<String, String>(16);
        for (Map.Entry<String, String> entry : deletedCardConfigMap.entrySet()) {
            Map oneCardConfigMap;
            String cardType;
            String cardConfigJson = entry.getValue();
            if (cardConfigJson == null || !"bos_card_qing".equals(cardType = (String)(oneCardConfigMap = (Map)SerializationUtils.fromJsonString((String)cardConfigJson, Map.class)).get("cardType"))) continue;
            deletedQingCardConfig.put(entry.getKey(), cardConfigJson);
        }
        if (deletedQingCardConfig.size() > 0) {
            DispatchServiceHelper.invokeBOSService((String)"qing", (String)"QingService", (String)"removeCardFromHomepage", (Object[])new Object[]{deletedQingCardConfig});
        }
    }

    public void editCancel() {
        this.updateTempDelIds(new ArrayList<String>());
        this.showItemControl(Boolean.TRUE);
        this.refreshGridContainer();
    }

    @Deprecated
    public void dynamicAddCards(String cardType, List<CardInfo> cardInfoList, IFormView view) {
        boolean isNull;
        boolean bl = isNull = StringUtils.isEmpty((String)cardType) || cardInfoList == null || cardInfoList.isEmpty() || view == null;
        if (isNull) {
            return;
        }
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("bos_card_quicklaunch");
        typeList.add("bos_card_billstats");
        typeList.add("bos_card_billstats_list");
        typeList.add("bos_card_yzj_subscribe");
        typeList.add("bos_card_workflow");
        typeList.add("bos_card_qing");
        typeList.add("bos_card_custom");
        typeList.add("bos_card_usercenter");
        if (!typeList.contains(cardType)) {
            return;
        }
        IFormView mainView = view.getMainView();
        if (mainView == null) {
            view.showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u4e0b\u65e0\u6cd5\u83b7\u53d6\u5230\u9996\u9875\u7684FormView\uff0c\u8bbe\u8ba1\u5668\u4e2d\u9884\u89c8\u8868\u5355\u4f1a\u51fa\u73b0\u6b64\u60c5\u51b5\uff0c\u8bf7\u524d\u5f80\u83dc\u5355\u8bbf\u95ee\u5f53\u524d\u8868\u5355\u3002", (String)"GridContainerPlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        IPageCache mainPageCache = (IPageCache)mainView.getService(IPageCache.class);
        CardUtils cardUtils = new CardUtils(mainView, mainPageCache, mainView.getModel(), logger);
        String layoutStr = CardUtils.getNewLayoutInMainpageCache(mainView);
        cardUtils.saveMainPageInfo(SchemeType.UserScheme, layoutStr, (Map)SerializationUtils.fromJsonString((String)mainPageCache.get(CACHE_ALLCARDCONFIG), Map.class), null, null);
        Long userId = RequestContext.get().getCurrUserId();
        String curSchemeId = mainPageCache.get("pgCache_currentScheme");
        DynamicObject layoutObj = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(curSchemeId), (String)"portal_scheme");
        if (layoutObj == null) {
            layoutObj = BusinessDataServiceHelper.loadSingle((String)"portal_scheme", (String)"layout,user,pagetype,schemetype,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("creator", "=", (Object)userId), new QFilter("schemetype", "=", (Object)SchemeType.UserScheme)});
        }
        StringBuilder layout = new StringBuilder(layoutObj.getString(LAYOUT));
        List<Long> cardIdList = this.addCardsToLayout(layout, cardInfoList);
        layoutObj.set(LAYOUT, (Object)layout.toString());
        layoutObj.set("user", (Object)userId);
        layoutObj.set("pagetype", (Object)"main");
        layoutObj.set("isedit", (Object)Boolean.TRUE);
        layoutObj.set("modifier", (Object)userId);
        layoutObj.set("modifytime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((IDataEntityType)layoutObj.getDataEntityType(), (Object[])new Object[]{layoutObj});
        DynamicObject[] cardsConfig = new DynamicObject[cardInfoList.size()];
        for (CardInfo cardInfo : cardInfoList) {
            String configStr = SerializationUtils.toJsonString(cardInfo.getConfig());
            DynamicObject newDObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_mainpagecardconfig");
            newDObj.set("cardid", (Object)cardIdList.get(cardInfoList.indexOf(cardInfo)));
            newDObj.set("user", (Object)userId);
            newDObj.set("cardtype", (Object)cardType);
            newDObj.set("config", (Object)configStr);
            newDObj.set("mainpagelayout", (Object)layoutObj.getLong("id"));
            cardsConfig[cardInfoList.indexOf((Object)cardInfo)] = newDObj;
        }
        SaveServiceHelper.save((DynamicObject[])cardsConfig);
        GridContainer grid = (GridContainer)mainView.getControl(CTRL_GRIDCONTAINER);
        grid.triggerContainer();
        view.sendFormAction(mainView);
    }

    private List<Long> addCardsToLayout(StringBuilder layout, List<CardInfo> cardInfoList) {
        String layoutStr = layout.toString();
        ArrayList<Long> cardIdList = new ArrayList<Long>(cardInfoList.size());
        long[] newCardIds = ORM.create().genLongIds("bos_mainpagecardconfig", cardInfoList.size());
        int i = 0;
        for (CardInfo cardInfo : cardInfoList) {
            List cardList = (List)SerializationUtils.fromJsonString((String)layoutStr, List.class);
            int w = cardInfo.getW();
            int h = cardInfo.getH();
            HashMap<String, Object> cardConfig = CardUtils.getLayoutForNewCard(layoutStr, w, h);
            HashMap<String, Object> newCard = new HashMap<String, Object>(16);
            newCard.put("x", cardConfig.get("x"));
            newCard.put("y", cardConfig.get("y"));
            newCard.put("w", cardConfig.get("w"));
            newCard.put("h", cardConfig.get("h"));
            long newCardId = newCardIds[i];
            newCard.put("i", String.valueOf(newCardId));
            newCard.put("moved", Boolean.FALSE);
            newCard.put("static", Boolean.FALSE);
            cardList.add(newCard);
            cardIdList.add(newCardId);
            layoutStr = SerializationUtils.toJsonString((Object)cardList);
            ++i;
        }
        layout = layout.replace(0, layout.length(), layoutStr);
        return cardIdList;
    }

    private void initNewPortalScheme() {
        try {
            if (this.isNewPortal()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FLOATMENU_PANEL, "floatmenupanelap"});
                HashMap<String, String> r = new HashMap<String, String>(16);
                r.put("r", "0px");
                HashMap<String, HashMap<String, String>> p = new HashMap<String, HashMap<String, String>>(16);
                p.put("p", r);
                HashMap<String, HashMap<String, HashMap<String, String>>> s = new HashMap<String, HashMap<String, HashMap<String, String>>>(16);
                s.put("s", p);
                this.getView().updateControlMetadata(CTRL_GRIDCONTAINER, s);
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.setFieldProperty(CTRL_GRIDCONTAINER, "portalScheme", this.getPortalSchemeInfo(false));
                proxy.setFieldProperty(CTRL_GRIDCONTAINER, "hideSchemeEdit", (Object)(!this.checkCanEditAndShowTip(false) ? 1 : 0));
                proxy.setFieldProperty(CTRL_GRIDCONTAINER, "hideSchemeSwitch", (Object)this.hideSchemeSwitch());
            }
        }
        catch (Exception e) {
            logger.info("initNewPortalScheme error", (Object)e);
        }
    }

    private Map<String, Object> getPortalSchemeInfo(boolean showTip) {
        HashMap<String, Object> schemeMap = new HashMap<String, Object>(16);
        String currentSchemeId = this.getPageCache().get("pgCache_currentScheme");
        schemeMap.put("schemeGroup", this.getUserAvailSchemesGroup());
        schemeMap.put("defaultSchemeId", this.getDefaultScheme() + "");
        schemeMap.put("selectedSchemeId", currentSchemeId);
        schemeMap.put("canSave", this.canSave());
        boolean editable = this.checkCanEditAndShowTip(showTip);
        schemeMap.put("editable", editable);
        List<Map<String, String>> saveList = null;
        if (editable) {
            saveList = this.getSaveList();
        }
        schemeMap.put("saveSTList", saveList);
        return schemeMap;
    }

    private boolean canSave() {
        String curSchemeId;
        Long useId = RequestContext.get().getCurrUserId();
        boolean hasPerm = CardUtils.checkHasModifySchemeRight(useId);
        if (!hasPerm && (curSchemeId = this.getPageCache().get("pgCache_currentScheme")) != null) {
            return CardUtils.checkCurSchemeOwner(useId, Long.valueOf(curSchemeId));
        }
        return true;
    }

    private List<Map<String, Object>> getUserAvailSchemesGroup() {
        List<QFilter> filters = this.getCurrentUserSchemeFilters();
        DynamicObjectCollection schemeList = QueryServiceHelper.query((String)"portal_scheme", (String)"id, number, name, schemetype, ispreset, creator", (QFilter[])filters.toArray(new QFilter[0]));
        if (schemeList == null) {
            return null;
        }
        this.getPageCache().put("schemeSize", schemeList.size() + "");
        Map<Integer, List<DynamicObject>> schemeDataGroup = schemeList.stream().collect(Collectors.groupingBy(data -> data.getInt("schemetype")));
        ArrayList<Map<String, Object>> schemeGroupList = new ArrayList<Map<String, Object>>();
        for (String schemeType : schemeTypes) {
            Integer type = Integer.valueOf(schemeType);
            List<DynamicObject> schemes = schemeDataGroup.get(type);
            if (CollectionUtils.isEmpty(schemes)) continue;
            HashMap<String, Object> schemeGroup = new HashMap<String, Object>(16);
            schemeGroup.put("type", type);
            schemeGroup.put("name", SchemeType.getSchemeType(type + "").getName());
            ArrayList schemeDataList = new ArrayList(schemes.size());
            for (DynamicObject dy : schemes) {
                HashMap<String, Object> schemeDataMap = new HashMap<String, Object>(16);
                schemeDataMap.put("name", dy.getString("name"));
                schemeDataMap.put("id", dy.getString("id"));
                schemeDataMap.put("canDelete", SchemeType.getSchemeType(type + "") == SchemeType.UserScheme);
                schemeDataMap.put("canSetAsDefault", true);
                schemeDataList.add(schemeDataMap);
            }
            schemeGroup.put("items", schemeDataList);
            schemeGroupList.add(schemeGroup);
        }
        return schemeGroupList;
    }

    private Long getDefaultScheme() {
        String bizAppId = CardUtils.getAppIdFromView(this.getView());
        String entityId = this.getView().getEntityId();
        String pageType = CardUtils.getPageType(this.getView());
        return CardUtils.getDefaultSchemeId(pageType, bizAppId, entityId, this.getView());
    }

    private List<Map<String, String>> getSaveList() {
        ArrayList<Map<String, String>> saveList = new ArrayList<Map<String, String>>();
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = CardUtils.checkHasModifySchemeRight(userId);
        String currentSchemeType = this.getPageCache().get("pgCache_currentSchemeType");
        if (CardUtils.isOutAdmin()) {
            saveList.add(this.buildSaveMap(SchemeType.GroupScheme.getValue(), SchemeType.GroupScheme.getName()));
        } else {
            boolean editable = false;
            boolean isOwner = false;
            String currentSchemeId = this.getPageCache().get("pgCache_currentScheme");
            if (currentSchemeId != null) {
                Long schemeId = Long.valueOf(currentSchemeId);
                editable = CardUtils.checkCurSchemeIsEdit(schemeId);
                isOwner = CardUtils.checkCurSchemeOwner(userId, schemeId);
            }
            if (hasPerm) {
                if (SchemeType.SysDefScheme.getValue().equals(currentSchemeType)) {
                    saveList.add(this.buildSaveMap(SchemeType.GroupScheme.getValue(), SchemeType.GroupScheme.getName()));
                } else if (SchemeType.UserScheme.getValue().equals(currentSchemeType) || SchemeType.GroupScheme.getValue().equals(currentSchemeType)) {
                    saveList.add(this.buildSaveMap(SchemeType.SysDefScheme.getValue(), SchemeType.SysDefScheme.getName()));
                    saveList.add(this.buildSaveMap(SchemeType.GroupScheme.getValue(), SchemeType.GroupScheme.getName()));
                }
                if (!SchemeType.UserScheme.getValue().equals(currentSchemeType) && (editable || isOwner)) {
                    saveList.add(this.buildSaveMap(SchemeType.UserScheme.getValue(), SchemeType.UserScheme.getName()));
                }
            } else if (!SchemeType.UserScheme.getValue().equals(currentSchemeType) && (editable || isOwner)) {
                saveList.add(this.buildSaveMap(SchemeType.UserScheme.getValue(), SchemeType.UserScheme.getName()));
            }
        }
        return saveList;
    }

    private Map<String, String> buildSaveMap(String type, String name) {
        HashMap<String, String> saveMap = new HashMap<String, String>(16);
        saveMap.put("type", type);
        saveMap.put("name", name);
        return saveMap;
    }

    private boolean toDesignMode() {
        if (!this.checkCanEditAndShowTip(true)) {
            return false;
        }
        GridContainer gridContainer = (GridContainer)this.getView().getControl(CTRL_GRIDCONTAINER);
        gridContainer.setDesignMode(true);
        this.showItemControl(Boolean.FALSE);
        this.showAllCardForm(this.getAllCardConfigMap(), true);
        return true;
    }

    private void switchScheme(String schemeId) {
        String curSchemeId = this.getPageCache().get("pgCache_currentScheme");
        if (curSchemeId.equals(schemeId)) {
            return;
        }
        DynamicObject schemeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(schemeId), (String)"portal_scheme");
        if (schemeObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9996\u9875\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5207\u6362\u3002", (String)"GridContainerPlugin_23", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        boolean enable = schemeObj.getBoolean("enable");
        if (enable) {
            this.refreshGridContainer(schemeObj);
            this.initNewPortalScheme();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9996\u9875\u65b9\u6848\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u5207\u6362\u3002", (String)"GridContainerPlugin_22", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void setDefaultScheme(String schemeId) {
        if (StringUtils.isEmpty((String)schemeId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9996\u9875\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8bbe\u4e3a\u9ed8\u8ba4\u3002", (String)"GridContainerPlugin_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String bizAppId = CardUtils.getAppIdFromView(this.getView());
        String entityId = this.getView().getEntityId();
        String pageType = CardUtils.getPageType(this.getView());
        CardUtils.setDefaultMainPageLayout(Long.parseLong(schemeId), pageType, bizAppId, entityId);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9ed8\u8ba4\u65b9\u6848\u6210\u529f\u3002", (String)"GridContainerPlugin_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        this.initNewPortalScheme();
    }

    private void deleteSchemeBefore(String schemeId) {
        boolean canDelete;
        String schemeType;
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(schemeId), (String)"portal_scheme");
        boolean ispreset = scheme.getBoolean("ispreset");
        DynamicObject creatorDy = scheme.getDynamicObject("creator");
        String creator = "";
        if (creatorDy != null) {
            creator = creatorDy.getString("id");
        }
        boolean isUserScheme = SchemeType.getSchemeType(schemeType = scheme.getString("schemetype")) == SchemeType.UserScheme;
        boolean bl = canDelete = isUserScheme && !ispreset && creator.equals(userId + "");
        if (canDelete) {
            String curSchemeId = this.getPageCache().get("pgCache_currentScheme");
            if (schemeId.equals(curSchemeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e2a\u6027\u65b9\u6848\u6b63\u5728\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"GridContainerPlugin_21", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(DELETE_USER_SCHEME_ID, schemeId);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"GridContainerPlugin_12", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"GridContainerPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4e2a\u6027\u65b9\u6848\u5220\u9664\u540e\u4e0d\u53ef\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"GridContainerPlugin_15", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), "", options, ConfirmTypes.Save, new ConfirmCallBackListener(CONFIRMCALLBACKID_DELETE_USER, (IFormPlugin)this), btnNameMaps);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u53ea\u80fd\u5220\u9664\u4e2a\u6027\u65b9\u6848\u3002", (String)"GridContainerPlugin_20", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void deleteScheme() {
        String schemeId = this.getPageCache().get(DELETE_USER_SCHEME_ID);
        boolean result = this.doDeleteScheme(Long.valueOf(schemeId));
        if (result) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"GridContainerPlugin_16", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            this.initNewPortalScheme();
        }
    }

    private void saveCurrentScheme(String layout) {
        boolean hasPerm = this.canSave();
        if (!hasPerm) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u65b9\u6848\u4fee\u6539\u6743\u9650\u3002", (String)"GridContainerPlugin_17", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String schemeId = this.getPageCache().get("pgCache_currentScheme");
        String schemeType = this.getPageCache().get("pgCache_currentSchemeType");
        if (schemeId != null && schemeType != null) {
            this.editEnd(SchemeType.getSchemeType(schemeType), layout, Long.valueOf(schemeId));
        } else {
            this.saveAsScheme(layout, SchemeType.UserScheme);
        }
    }

    private void saveAsSchemeType(String schemeType, String layout) {
        String sysScheme = SchemeType.SysDefScheme.getValue();
        String groupScheme = SchemeType.GroupScheme.getValue();
        String userScheme = SchemeType.UserScheme.getValue();
        if (sysScheme.equals(schemeType) || userScheme.equals(schemeType)) {
            this.saveAsScheme(layout, SchemeType.getSchemeType(schemeType));
        } else if (groupScheme.equals(schemeType)) {
            this.showGroupSchemeSaveAs();
        }
    }

    private void showGroupSchemeSaveAs() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("pc_main_scheme_saveas");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(fsp);
    }

    private void saveAsScheme(String layout, SchemeType schemeType) {
        this.getPageCache().put("pgCache_grid_layout", layout);
        List<DynamicObject> schemeDatas = this.getCurrentUserScheme(schemeType);
        if (CollectionUtils.isEmpty(schemeDatas)) {
            this.editEnd(schemeType, layout, null);
        } else if (schemeDatas.size() == 1) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"GridContainerPlugin_12", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"GridContainerPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u60a8\u5df2\u6709%s\uff0c\u786e\u5b9a\u8981\u8986\u76d6\u5b83\u5417\uff1f", (String)"GridContainerPlugin_19", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), schemeType.getName()), "", options, ConfirmTypes.Save, new ConfirmCallBackListener(this.getSingleCallBackId(schemeType), (IFormPlugin)this), btnNameMaps);
        } else {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"GridContainerPlugin_12", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"GridContainerPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = String.format(ResManager.loadKDString((String)"\u60a8\u5df2\u6709\u591a\u4e2a%1$s\u65b9\u6848\uff0c\u53e6\u5b58\u540e\u5c06\u7981\u7528\u5176\u4ed6%2$s\u65b9\u6848\uff0c\u786e\u5b9a\u8981\u64cd\u4f5c\u5417\uff1f", (String)"GridContainerPlugin_18", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), schemeType.getName(), schemeType.getName());
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, new ConfirmCallBackListener(this.getMulitCallBackId(schemeType), (IFormPlugin)this), btnNameMaps);
        }
    }

    private void disableScheme(List<DynamicObject> schemeDatas) {
        if (CollectionUtils.isEmpty(schemeDatas)) {
            return;
        }
        schemeDatas.forEach(scheme -> scheme.set("enable", (Object)0));
        SaveServiceHelper.update((DynamicObject[])schemeDatas.toArray(new DynamicObject[0]));
    }

    private String getSingleCallBackId(SchemeType schemeType) {
        String callBackId = "";
        if (SchemeType.SysDefScheme == schemeType) {
            callBackId = CONFIRMCALLBACKID_MODIFY_SYS;
        } else if (SchemeType.UserScheme == schemeType) {
            callBackId = CONFIRMCALLBACKID_MODIFY_CUSTOM;
        }
        return callBackId;
    }

    private String getMulitCallBackId(SchemeType schemeType) {
        String callBackId = "";
        if (SchemeType.SysDefScheme == schemeType) {
            callBackId = CONFIRMCALLBACKID_DISABLE_ALLSYS;
        } else if (SchemeType.UserScheme == schemeType) {
            callBackId = CONFIRMCALLBACKID_DISABLE_ALLCUSTOM;
        }
        return callBackId;
    }

    private List<DynamicObject> getCurrentUserScheme(SchemeType schemeType) {
        List<QFilter> filters = this.getCurrentUserSchemeFilters();
        QFilter customFilter = new QFilter("schemetype", "=", (Object)schemeType);
        filters.add(customFilter);
        Map schemeDatas = BusinessDataServiceHelper.loadFromCache((String)"portal_scheme", (String)"id,enable", (QFilter[])filters.toArray(new QFilter[0]));
        return new ArrayList<DynamicObject>(schemeDatas.values());
    }

    private List<QFilter> getCurrentUserSchemeFilters() {
        String pageType = CardUtils.getPageType(this.getView());
        long userId = RequestContext.get().getCurrUserId();
        ArrayList<QFilter> rangeFilterList = new ArrayList<QFilter>();
        QFilter curSituationfilter = new QFilter("pagetype", "=", (Object)pageType).and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        if ("app".equals(pageType)) {
            String bizappId = CardUtils.getAppIdFromView(this.getView());
            curSituationfilter = curSituationfilter.and(new QFilter("bizapp", "=", (Object)bizappId));
        } else if ("custom".equals(pageType)) {
            String formNum = this.getView().getEntityId();
            curSituationfilter = curSituationfilter.and(new QFilter("formnum", "=", (Object)formNum));
        }
        QFilter curSituationfilter2 = curSituationfilter.copy();
        QFilter curUserScheme = new QFilter("creator", "=", (Object)userId).and(new QFilter("schemetype", "=", (Object)SchemeType.UserScheme.getValue()));
        QFilter sysDefScheme = new QFilter("schemetype", "=", (Object)SchemeType.SysDefScheme.getValue());
        QFilter filter = curSituationfilter2.and(curUserScheme.or(sysDefScheme));
        List<Long> groupSchemeIds = CardUtils.getShareSchemeIds(userId, this.getView());
        if (!CollectionUtils.isEmpty(groupSchemeIds)) {
            QFilter groupSchemeFilter = new QFilter("id", "in", groupSchemeIds);
            filter = filter.or(groupSchemeFilter);
        }
        QFilter curCreatorOrModifier = curSituationfilter.and(new QFilter("creator", "=", (Object)userId));
        filter = filter.or(curCreatorOrModifier);
        String modeType = CardUtils.convertModeType();
        filter.and("ismultiorg", "=", (Object)modeType);
        rangeFilterList.add(filter);
        return rangeFilterList;
    }

    private boolean hideSchemeSwitch() {
        String schemeSize = this.getPageCache().get("schemeSize");
        return schemeSize == null || Integer.parseInt(schemeSize) <= 1;
    }
}

