/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew.common;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Image;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.widget.events.WidgetContainerDesignerListener;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.service.MainPortalMenuInfoExtService;
import kd.bos.portal.util.DevportalUtil;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.portal.util.SystemParamConfigUtils;
import kd.bos.servicehelper.DispatchServiceHelper;

public abstract class MainConsoleDesignerAbstract
extends AbstractFormPlugin
implements WidgetContainerDesignerListener {
    protected static Log logger = LogFactory.getLog(MainConsoleDesignerAbstract.class);

    public abstract boolean isNewPortal();

    public abstract void invalidHomePage();

    public abstract String getCustomHomePageId();

    public void afterCreateNewData(EventObject e) {
        String schemeId;
        Lang lang = RequestContext.get().getLang();
        if (Lang.zh_CN != lang && Lang.zh_TW != lang) {
            Image image = (Image)this.getControl("cosmicimage");
            image.setUrl("/images/pc/other/gpt_cosmic_en_273_72.png");
            this.getView().setVisible(Boolean.FALSE, new String[]{"aiflex_cn"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"ailabelap_en"});
        }
        if ((schemeId = (String)this.getView().getFormShowParameter().getCustomParam("schemeId")) != null) {
            this.getPageCache().put("switchschemeid", schemeId);
        }
        this.getPageCache().put("operationstatus", "runtime");
        try {
            this.invalidHomePage();
            String isOpenPage = (String)this.getView().getFormShowParameter().getCustomParam("isOpenPage");
            String appNumber = (String)this.getView().getFormShowParameter().getCustomParam("appNumber");
            if (StringUtils.isNotEmpty((CharSequence)isOpenPage) && Boolean.parseBoolean(isOpenPage) || StringUtils.isNotEmpty((CharSequence)appNumber)) {
                return;
            }
            if (SystemParamConfigUtils.getGPTHomeSwitch().booleanValue()) {
                this.sendXiaoKAvailableInfoToClient();
            }
            if (this.activeCustomHomePage()) {
                return;
            }
        }
        catch (Exception e2) {
            logger.info(e2.getMessage(), (Object)e2);
        }
    }

    private boolean activeCustomHomePage() {
        String tabKey = this.getCustomHomePageId();
        Tab tab = (Tab)this.getView().getControl("tabap");
        if (StringUtils.isNotBlank((CharSequence)tabKey) && tab != null && !CollectionUtils.isEmpty((Collection)tab.getItems()) && tab.getItems().stream().anyMatch(a -> a.getKey().equals(tabKey))) {
            tab.activeTab(tabKey);
            return true;
        }
        return false;
    }

    private void sendXiaoKAvailableInfoToClient() {
        Object isShowMessageTab = false;
        try {
            isShowMessageTab = DispatchServiceHelper.invokeBizService((String)"ai", (String)"cbp", (String)"CbpService", (String)"isLittleKInit", (Object[])new Object[]{RequestContext.get().getAccountId(), RequestContext.get().getTenantId()});
            logger.info("MainConsoleDesignerAbstract afterCreateNewData isShowMessageTab = {}", isShowMessageTab);
        }
        catch (Throwable e) {
            logger.info("MainConsoleDesignerAbstract sendXiaoKAvailableInfoToClient e", (Object)e);
        }
        CustomControl ctr = (CustomControl)this.getControl("customcontrolap");
        HashMap<String, Object> showMessageMap = new HashMap<String, Object>();
        showMessageMap.put("isShowMessageTab", isShowMessageTab);
        ctr.setData(showMessageMap);
    }

    public void afterBindData(EventObject e) {
        String appNumber = (String)this.getView().getFormShowParameter().getCustomParam("appNumber");
        String isOpenPage = (String)this.getView().getFormShowParameter().getCustomParam("isOpenPage");
        String pageId = (String)this.getView().getFormShowParameter().getCustomParam("pageId");
        Map<String, Object> appParameter = this.getAppInfo(appNumber);
        if (StringUtils.isNotEmpty((CharSequence)isOpenPage) && Boolean.parseBoolean(isOpenPage) && StringUtils.isNotEmpty((CharSequence)appNumber) && StringUtils.isNotEmpty((CharSequence)pageId) && appParameter != null) {
            IFormView formView = SessionManager.getCurrent().getView(pageId);
            if (formView == null) {
                return;
            }
            OpenPageUtils.openAppAndPage(appNumber, pageId, appParameter, this.getView());
            return;
        }
        if (appParameter != null) {
            OpenPageUtils.openApp(appNumber, null, appParameter, this.getView());
            return;
        }
        Map<String, String> appInfo = this.getMenuInfoExt();
        if (!appInfo.isEmpty() && StringUtils.isNotEmpty((CharSequence)appInfo.get("appNumber"))) {
            Map<String, Object> app = this.getAppInfo(appInfo.get("appNumber"));
            if (!appInfo.isEmpty() && StringUtils.isNotEmpty((CharSequence)appInfo.get("menuId"))) {
                this.openMenu(appInfo, app);
                return;
            }
            OpenPageUtils.openApp(appInfo.get("appNumber"), null, app, this.getView());
        }
    }

    private Map<String, Object> getAppInfo(String appNumber) {
        if (StringUtils.isBlank((CharSequence)appNumber)) {
            return null;
        }
        AppInfo app = AppMetadataCache.getAppInfo((String)appNumber);
        if (app == null) {
            return null;
        }
        String homeId = app.getHomeId();
        if (StringUtils.isBlank((CharSequence)homeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5e94\u7528\u9996\u9875\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"MainConsoleDesignerPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return null;
        }
        HashMap<String, Object> appParameter = new HashMap<String, Object>();
        appParameter.put("view", this.getView());
        appParameter.put("appname", app.getName().getLocaleValue());
        appParameter.put("appmainnumber", app.getHomeNum());
        return appParameter;
    }

    private void openMenu(Map<String, String> appInfo, Map<String, Object> appParameter) {
        String menuId = appInfo.get("menuId");
        String appNumber = appInfo.get("appNumber");
        AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)appNumber, (String)menuId);
        if (menu == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("view", this.getView());
        map.put("formnumber", menu.getFormId());
        map.put("parametertype", menu.getParamType());
        map.put("parameter", JSONArray.parseObject((String)menu.getParams()));
        map.put("menuname", menu.getName());
        map.put("openType", menu.getOpenType());
        map.put("permItem", menu.getPermission());
        map.putAll(appParameter);
        OpenPageUtils.openApp(appNumber, menuId, map, this.getView());
    }

    private Map<String, String> getMenuInfoExt() {
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, MainPortalMenuInfoExtService.class, (String)"BOS_SVC_MAIN_PORTAL_MENU", null);
            List plugins = pluginProxy.getPlugins();
            if (plugins != null && plugins.size() > 0) {
                MainPortalMenuInfoExtService menuInfoExtService = (MainPortalMenuInfoExtService)plugins.get(0);
                return menuInfoExtService.mainPortalMenuInfo();
            }
        }
        catch (Exception e) {
            logger.info("MainConsoleDesignerAbstract===>", (Object)e);
        }
        return Collections.emptyMap();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String appNumber = (String)((FormShowParameter)e.getSource()).getCustomParam("appNumber");
        if (appNumber == null) {
            return;
        }
        boolean checkAppPermission = DevportalUtil.checkAppPermission(appNumber);
        if (!checkAppPermission) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5bf9\u8be5\u5e94\u7528\u6388\u6743\u3002", (String)"MainConsoleDesignerPlugin_1", (String)"bos-portal-plugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }
}

