/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.devportal.AppElement;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BizCustomList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.portal.model.AppOperationType;
import kd.bos.portal.model.AppSchemeType;
import kd.bos.portal.model.BrandUpEnum;
import kd.bos.portal.model.GoAppEnum;
import kd.bos.portal.model.PersonalSchemaInfo;
import kd.bos.portal.pluginnew.noCode.NoCodeAppUtils;
import kd.bos.portal.service.PortalMenuService;
import kd.bos.portal.util.CloudLadderSkipUtils;
import kd.bos.portal.util.FeedbackUtil;
import kd.bos.portal.util.MyCurrentAppUtil;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.portal.util.PersonalSchemaTemplateUtil;
import kd.bos.portal.util.PortalLogUtils;
import kd.bos.portal.util.PortalUsableFuncUtil;
import kd.bos.portal.util.YZJSpecialEditionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.util.DisCardUtil;
import kd.svc.control.AppNavigationMenu;
import kd.svc.control.events.AppNavigationMenuEvent;
import kd.svc.control.events.AppNavigationMenuListener;

public abstract class MyAppAbstract
extends AbstractFormPlugin
implements AppNavigationMenuListener {
    public static final String GROUP = "group";
    public static final String DELETE_COMFIRM = "delete_comfirm";
    public static final String SAVEAPPS = "saveapps";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String APPNAME = "appname";
    public static final String DESCRIPTION = "description";
    public static final String CANCEL = "Cancel";
    public static final String SAVEDEFAULTSCHEMACALLBACK = "savedefaultschemacallback";
    public static final String SAVEPERSONALSCHEMACALLBACK = "savepersonalschemacallback";
    private Log logger = LogFactory.getLog(MyAppAbstract.class);
    private final String USERCONFIGKEY = "appPersonalList";
    private final String TENANTCONFIGKEY = "tenantPersonalList";
    private static final String CLOUD_ID_ICC = "0B+E5YAC2OJF";
    private static final String PAGECACHE_MYAPP = "finalFilterApp";
    public static final String PAGECACHE_MYHASPERAPP = "pagecache_myhasperapp";
    private static final String CLOUD_LADDER = "ladder";
    private static final String CLOUD_ID_DATA = "18Y35CVM2EDB";
    private static final String APP_ID_DMO = "198I/T67QJ+P";
    private static final String APP_INFO_ID_DMO = "dmo";
    private static final String PARAM_KEY_DMO = "dmoserver";
    private static final String BIZ_APP_ID_CTS = "18XR3MJ0W0ET";
    private static final String MENU_ITEM_ID_PARAMETER_CONSOLE = "0866+=N09CUU";
    private PortalMenuService menuService;
    private PortalUsableFuncUtil portalUtil;

    public abstract boolean isNewPortal();

    public void initialize() {
        this.menuService = new PortalMenuService(this.getPageCache());
        this.portalUtil = new PortalUsableFuncUtil(null, this.getView());
    }

    public void registerListener(EventObject e) {
        if (this.isNewPortal()) {
            AppNavigationMenu appnavigationmenuap = (AppNavigationMenu)this.getControl("appnavigationmenuap");
            appnavigationmenuap.addAppNavigationMenuListener((AppNavigationMenuListener)this);
        } else {
            BizCustomList appStoreList = (BizCustomList)this.getView().getControl("bizcustomlistap");
            appStoreList.addCustomListListener((ItemClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.isNewPortal()) {
            AppNavigationMenu appnavigationmenuap = (AppNavigationMenu)this.getControl("appnavigationmenuap");
            this.refreshMyAppPanel(appnavigationmenuap);
        }
    }

    private String getLocalValue(Object name) {
        if (name == null) {
            return null;
        }
        if (name instanceof LocaleString) {
            LocaleString localeString = (LocaleString)name;
            return localeString.getLocaleValue();
        }
        String localName = name.toString();
        try {
            LocaleString localeString = (LocaleString)SerializationUtils.fromJsonString((String)localName, LocaleString.class);
            localName = localeString.getLocaleValue();
        }
        catch (Exception e) {
            return localName;
        }
        return localName;
    }

    public void customEvent(CustomEventArgs e) {
        if (this.isNewPortal()) {
            AppNavigationMenu appnavigationmenuap = (AppNavigationMenu)this.getControl("appnavigationmenuap");
            if ("afterShowSlideBill".equals(e.getKey())) {
                this.refreshMyAppPanel(appnavigationmenuap);
            }
        }
    }

    public void appItemClick(AppNavigationMenuEvent evt) {
        Map arg = evt.getArgs();
        if (arg != null && arg.size() > 0) {
            String appId;
            Object appIdObj = arg.get("appId");
            Object appNameObj = arg.get("appName");
            String appName = appNameObj == null ? null : appNameObj.toString();
            String string = appId = appIdObj == null ? null : appIdObj.toString();
            if (StringUtils.isEmpty((CharSequence)appId)) {
                return;
            }
            this.gotoApp(GoAppEnum.NewPortalOpen, appId, appName);
            this.closeSlide();
            MyCurrentAppUtil.putMyCurrentAppCache(appId);
        }
    }

    public void menuClick(AppNavigationMenuEvent evt) {
        String type;
        Map arg = evt.getArgs();
        if (arg == null || arg.size() == 0) {
            return;
        }
        switch (type = arg.get("type") == null ? "" : arg.get("type").toString()) {
            case "openApp": {
                String appId = arg.get("appId") == null ? null : arg.get("appId").toString();
                this.gotoApp(GoAppEnum.NewPortalNewWindowOpen, appId, null);
                break;
            }
            case "addApp": {
                this.addApp(JSONObject.parseObject((String)JSON.toJSONString((Object)arg)));
                break;
            }
            case "cancelFavorite": {
                String menuId = arg.get("menuId") == null ? null : arg.get("menuId").toString();
                Long userId = RequestContext.get().getCurrUserId();
                this.menuService.deleteMarkMenu(userId, menuId);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getOperationKey();
        JSONObject arg = evt.getItemKey() == null ? null : (JSONObject)JSON.parse((String)evt.getItemKey());
        switch (key) {
            case "app_store_list": {
                this.appStoreList(AppSchemeType.USERSCHEME);
                break;
            }
            case "app_factory_list": {
                this.appStoreList(AppSchemeType.DEFAULTSCHEME);
                break;
            }
            case "isadminuser": {
                this.isAdminUser();
                break;
            }
            case "appright": {
                this.getAppRightPart();
                break;
            }
            case "feedback": {
                this.feedback();
                break;
            }
            case "addapp": {
                if (arg == null) break;
                this.addApp(arg);
                break;
            }
            case "resetapp": {
                this.resetApps();
                break;
            }
            case "saveapps": {
                if (arg == null) break;
                this.saveApps(arg);
                break;
            }
            case "restorefactory": {
                this.appStoreList(AppSchemeType.FACTORYSCHEME);
                this.addOperationLog(AppOperationType.RESETFACTORYSCHEME);
                break;
            }
            case "restoredefault": {
                this.appStoreList(AppSchemeType.DEFAULTSCHEME);
                this.addOperationLog(AppOperationType.RESETDEFAULTSCHEME);
                break;
            }
            case "gotoapp": 
            case "gotocommendapp": {
                if (arg == null) break;
                String appNum = this.getAppNumFromArg(arg);
                String appName = arg.getString(APPNAME);
                this.gotoApp(GoAppEnum.OldPortalOpen, appNum, appName);
                break;
            }
            case "gotoappshop": {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5e94\u7528\u5546\u57ce\u8fd8\u5728\u5efa\u8bbe\u4e2d\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"MyAppPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), "", MessageTypes.ComingSoon);
                break;
            }
            case "editappinfo": {
                this.editAppInfo(arg);
                break;
            }
            case "editcloudinfo": {
                this.editCloudInfo(arg);
                break;
            }
        }
    }

    private String getAppNumFromArg(JSONObject arg) {
        String appNum = null;
        try {
            appNum = arg.getString("appnumber");
            if (StringUtils.isBlank((CharSequence)appNum)) {
                String bizAppId = arg.getString("appid");
                appNum = AppMetadataCache.getAppNumberById((String)bizAppId);
            }
        }
        catch (Exception e) {
            this.logger.info("getAppNumFromArg error", (Object)e);
        }
        return appNum;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map map;
        String key = evt.getActionId();
        if ("addappcallback".equals(key) && evt.getReturnData() != null) {
            ListSelectedRowCollection rt = (ListSelectedRowCollection)evt.getReturnData();
            Object[] primaryKeyValues = rt.getPrimaryKeyValues();
            List<String> bizAppIds = Arrays.stream(primaryKeyValues).map(Object::toString).collect(Collectors.toList());
            this.addAppCloseCallBack(bizAppIds);
        } else if ("appinfoeditclosecallback".equals(key) && evt.getReturnData() != null) {
            Map map2 = (Map)evt.getReturnData();
            if (map2 != null && map2.size() > 0) {
                String bizAppid = (String)map2.get("bizappid");
                OrmLocaleValue appName = (OrmLocaleValue)map2.get(APPNAME);
                OrmLocaleValue description = (OrmLocaleValue)map2.get(DESCRIPTION);
                JSONObject dataInfo = new JSONObject();
                dataInfo.put("bizappid", (Object)bizAppid);
                dataInfo.put(APPNAME, (Object)appName);
                dataInfo.put(DESCRIPTION, (Object)description);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("AFTEREDITAPPOPERATION", (Object)dataInfo);
            }
        } else if ("cloudinfoeditclosecallback".equals(key) && evt.getReturnData() != null && (map = (Map)evt.getReturnData()) != null && map.size() > 0) {
            String bizCloudId = (String)map.get("bizcloudid");
            OrmLocaleValue bizCloudName = (OrmLocaleValue)map.get("bizcloudname");
            JSONObject dataInfo = new JSONObject();
            dataInfo.put("bizcloudid", (Object)bizCloudId);
            dataInfo.put("bizcloudname", (Object)bizCloudName);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("AFTEREDITCLOUDOPERATION", (Object)dataInfo);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key = evt.getCallBackId();
        String resultKey = evt.getResultValue();
        if (MessageBoxResult.Yes.equals((Object)evt.getResult()) && "btn_config_add".equals(evt.getCallBackId())) {
            OpenPageUtils.openMenu(this.getView(), "1646402983019152384", BIZ_APP_ID_CTS);
            return;
        }
        if (MessageBoxResult.Yes.equals((Object)evt.getResult()) && "btn_goto_cts".equals(evt.getCallBackId())) {
            OpenPageUtils.openMenu(this.getView(), MENU_ITEM_ID_PARAMETER_CONSOLE, BIZ_APP_ID_CTS);
            return;
        }
        if (key != null && key.equals("doreset")) {
            if ("Yes".equals(resultKey)) {
                Long userId = Long.parseLong(RequestContext.get().getUserId());
                UserConfigServiceHelper.clearSetting((long)userId, (String)"appPersonalList");
                this.appStoreList(AppSchemeType.USERSCHEME);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6062\u590d\u6210\u529f\uff01", (String)"MyAppPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
            } else if (CANCEL.equals(resultKey)) {
                this.appStoreList(AppSchemeType.USERSCHEME);
            }
        } else if (key != null && key.contains("gotoapp")) {
            String[] appInfo = key.split("&");
            if ("Yes".equals(resultKey)) {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("pc_devportal_main");
                fsp.getOpenStyle().setShowType(ShowType.NewWindow);
                this.getView().showForm(fsp);
            } else if (CANCEL.equals(resultKey)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("view", this.getView());
                map.put(APPNAME, appInfo[1]);
                map.put("appmainnumber", appInfo[2]);
                OpenPageUtils.openAppTab(appInfo[0], null, map, this.getView());
            }
        } else if (key != null && (key.equals(SAVEDEFAULTSCHEMACALLBACK) || key.equals(SAVEPERSONALSCHEMACALLBACK))) {
            if ("Yes".equals(resultKey)) {
                String apps = this.getPageCache().get(SAVEAPPS);
                PersonalSchemaTemplateUtil personalSchemaTemplateUtil = new PersonalSchemaTemplateUtil();
                PersonalSchemaInfo savePersonalSchemaInfo = personalSchemaTemplateUtil.getPersonalSchemaInfo(apps);
                JSONArray runtimeApps = this.portalUtil.getUserHasPerAppIncludNoCode();
                PersonalSchemaInfo runtimePersonalSchemaInfo = personalSchemaTemplateUtil.getPersonalSchemaInfo(runtimeApps.toString());
                String difXML = "";
                difXML = new PersonalSchemaTemplateUtil().buildDiffXml(savePersonalSchemaInfo, runtimePersonalSchemaInfo, true);
                Long userId = Long.parseLong(RequestContext.get().getUserId());
                if (key.equals(SAVEDEFAULTSCHEMACALLBACK)) {
                    UserConfigServiceHelper.clearSetting((long)userId, (String)"appPersonalList");
                    UserConfigServiceHelper.setSetting((long)0L, (String)"tenantPersonalList", (String)difXML);
                } else if (key.equals(SAVEPERSONALSCHEMACALLBACK)) {
                    UserConfigServiceHelper.setSetting((long)userId, (String)"appPersonalList", (String)difXML);
                }
                this.appStoreList(AppSchemeType.USERSCHEME);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MyAppPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
            } else if (CANCEL.equals(resultKey)) {
                this.appStoreList(AppSchemeType.USERSCHEME);
            }
            this.getPageCache().remove(SAVEAPPS);
        } else if (key != null && key.equals(DELETE_COMFIRM)) {
            String menuValue = evt.getCustomVaule();
            if (evt.getResult().equals((Object)MessageBoxResult.Yes)) {
                Long userId = RequestContext.get().getCurrUserId();
                QFilter userFilter = new QFilter("user", "=", (Object)userId);
                QFilter menuFilter = new QFilter("menu", "=", (Object)menuValue);
                DeleteServiceHelper.delete((String)"portal_usermarkedmenu", (QFilter[])new QFilter[]{userFilter, menuFilter});
            }
        }
    }

    private void appStoreList(AppSchemeType appSchemeType) {
        Map<String, String> mapHasPerApps = this.portalUtil.getHasPerAppIdsWithCloud();
        if (mapHasPerApps == null || mapHasPerApps.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"emptytipflex"});
        } else {
            JSONArray apps = this.getResultApps(true, appSchemeType);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("APPSTORELIST", (Object)apps);
        }
    }

    private void getAppRightPart() {
        JSONObject dataInfo = new JSONObject();
        dataInfo.put("appShopImage", (Object)"DEV/DEVPORTAL/appStore_0_iBnOZlllPnQurTi4hD.png");
        dataInfo.put("appShopClickImage", (Object)"DEV/DEVPORTAL/app_appShopClick_0_M8pEARbesYf8R5fbil.png");
        dataInfo.put("shareImage", (Object)"DEV/DEVPORTAL/shareService_0_KuLtcNsNlJ3soso0SE.png");
        dataInfo.put("shareImageForAppId", (Object)"83bfebc8000020ac");
        dataInfo.put("shareText", (Object)ResManager.loadKDString((String)"\u6253\u9020\u793e\u4ea4\u5316\u5171\u4eab\u5e73\u53f0\u6a21\u5f0f", (String)"MyAppPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        dataInfo.put("robatAppImage", (Object)"DEV/DEVPORTAL/finRobot_0_P3nxR3lSim3JcCg6z6.png");
        dataInfo.put("finImageFormAppId", (Object)"3815fd11000209ac");
        dataInfo.put("finText", (Object)ResManager.loadKDString((String)"\u8bed\u8a00    \u667a\u80fd    \u8d22\u52a1\u4e91", (String)"MyAppPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("RIGHTPARTINFO", (Object)dataInfo);
    }

    private JSONArray getResultApps(boolean runtime, AppSchemeType appSchemeType) {
        if (appSchemeType == AppSchemeType.USERSCHEME) {
            return this.portalUtil.getFilterBySchemeAppsWithCache();
        }
        JSONArray allApps = this.portalUtil.getAllAppsInSystem(true);
        try {
            allApps = this.portalUtil.getAppsFilters(runtime, appSchemeType, allApps);
        }
        catch (Exception e) {
            this.logger.info("getResultApps error", (Object)e);
        }
        return allApps;
    }

    private void feedback() {
        FeedbackUtil.openFeedback(this.getView());
    }

    private void addApp(JSONObject arg) {
        String apps = null;
        String cloudId = (String)arg.get((Object)"cloudId");
        apps = this.isNewPortal() ? this.getView().getMainView().getPageCache().get(PAGECACHE_MYAPP) : arg.getString("apps");
        if (apps == null || apps.trim().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u5e94\u7528\u4f20\u9012\u53c2\u6570\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"MyAppPlugin_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        if (!this.isNewPortal()) {
            this.getPageCache().put("apps", apps);
        }
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_devportal_app_layout", (boolean)false);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u7ba1\u7406\u5e94\u7528", (String)"MyAppPlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        listShowParameter.setFormId("bos_devp_apptreelistf7");
        listShowParameter.setCustomParam("onlyvisible", (Object)Boolean.TRUE);
        if (kd.bos.util.StringUtils.isNotEmpty((String)cloudId)) {
            listShowParameter.setCustomParam("focusCloudId", (Object)cloudId);
        }
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        List<String> selectAppIds = this.getSelectAppIds(apps);
        Set<String> myApp = this.portalUtil.getUserHasPerAppIds();
        if (myApp != null && myApp.size() > 0) {
            selectAppIds.retainAll(myApp);
            filters.add(new QFilter("id", "in", myApp));
        }
        listShowParameter.setSelectedRows(selectAppIds.toArray());
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addappcallback"));
        listShowParameter.setMultiSelect(true);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private List<String> getSelectAppIds(String apps) {
        JSONArray appArray = JSONObject.parseArray((String)apps);
        ArrayList<String> appIds = new ArrayList<String>(10);
        appArray.forEach(appObj -> {
            JSONArray appObj1 = (JSONArray)appObj;
            appObj1.forEach(app -> {
                JSONObject app0 = (JSONObject)app;
                Boolean isCloud = app0.getBoolean("iscloud");
                if (isCloud == null || !isCloud.booleanValue()) {
                    appIds.add(app0.getString("id"));
                }
            });
        });
        return appIds;
    }

    private void addAppCloseCallBack(List<String> appIds) {
        String appsContent = null;
        if (this.isNewPortal()) {
            appsContent = this.getView().getMainView().getPageCache().get(PAGECACHE_MYAPP);
        } else {
            IPageCache pageCache = this.getPageCache();
            appsContent = pageCache.get("apps");
            pageCache.remove("apps");
        }
        List<String> selectAppIds = this.getSelectAppIds(appsContent);
        JSONArray allApps = JSONArray.parseArray((String)appsContent);
        ArrayList<String> deleteAppIds = new ArrayList<String>(selectAppIds.size());
        ArrayList<String> addAppIds = new ArrayList<String>(appIds.size());
        deleteAppIds.addAll(selectAppIds);
        deleteAppIds.removeAll(appIds);
        addAppIds.addAll(appIds);
        addAppIds.removeAll(selectAppIds);
        for (String appId : addAppIds) {
            AppMetadata appMetadata = BizAppServiceHelp.getAppMetaByID((String)appId);
            AppElement appElement = appMetadata.getAppElement();
            if (appElement == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u65b0\u52a0\u5e94\u7528\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", (String)"MyAppPlugin_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            this.addNewAppToContent(appMetadata, allApps);
        }
        this.deleteAppFromContent(deleteAppIds, allApps);
        if (this.isNewPortal()) {
            this.saveAppsNewPortal(allApps);
        } else {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("APPSTORELIST", (Object)allApps);
        }
    }

    private JSONArray addNewAppToContent(AppMetadata appMetadata, JSONArray allApps) {
        AppElement appElement = appMetadata.getAppElement();
        boolean newCloudIsNeed = true;
        String cloudId = appMetadata.getBizCloudID();
        JSONObject app = new JSONObject();
        String appImage = appElement.getImage();
        if (appImage == null || "".equals(appImage.trim())) {
            appImage = "icons/pc/application/gongyingxietong_48_48.png";
        }
        app.put("cloudid", (Object)cloudId);
        app.put("id", (Object)appElement.getId());
        app.put("image", (Object)appImage);
        app.put("seq", (Object)appElement.getSeq());
        app.put("name", (Object)appElement.getName());
        app.put(DESCRIPTION, (Object)appElement.getDescription());
        app.put("alluserapp", (Object)appElement.getAllUserApp());
        app.put("usertype", (Object)appElement.getUserType());
        for (int i = 0; i < allApps.size(); ++i) {
            JSONArray cloud_app = allApps.getJSONArray(i);
            if (!cloud_app.getJSONObject(0).get((Object)"id").equals(cloudId)) continue;
            newCloudIsNeed = false;
            cloud_app.add((Object)app);
            break;
        }
        if (newCloudIsNeed) {
            String fields = "id, bumber, name, image, backimage";
            DynamicObject cloudObject = BusinessDataServiceHelper.loadSingle((Object)cloudId, (String)"bos_devportal_bizcloud", (String)fields);
            JSONArray cloud_app = new JSONArray();
            JSONObject cloud = new JSONObject();
            String image = cloudObject.getString("image");
            String bgImage = cloudObject.getString("backimage");
            if (image == null || "".equals(image.trim())) {
                image = "images/pc/cardbackground/cloud_ pingtai.png";
            }
            cloud.put("id", (Object)cloudId);
            cloud.put("iscloud", (Object)Boolean.TRUE);
            cloud.put("name", (Object)cloudObject.getLocaleString("name"));
            cloud.put("pgimage", (Object)image);
            cloud.put("bgimage", (Object)bgImage);
            cloud_app.add((Object)cloud);
            cloud_app.add((Object)app);
            allApps.add((Object)cloud_app);
        }
        return allApps;
    }

    private void deleteAppFromContent(List<String> removeAppIds, JSONArray allApps) {
        if (CollectionUtils.isEmpty(removeAppIds)) {
            return;
        }
        int num = 0;
        Iterator cloudAppIt = allApps.iterator();
        while (cloudAppIt.hasNext()) {
            JSONArray cloud_app = (JSONArray)cloudAppIt.next();
            Iterator appIt = cloud_app.iterator();
            while (appIt.hasNext()) {
                JSONObject app = (JSONObject)appIt.next();
                String appId = app.getString("id");
                if (!removeAppIds.contains(appId)) continue;
                appIt.remove();
                ++num;
            }
            if (cloud_app.size() == 1) {
                cloudAppIt.remove();
            }
            if (num != removeAppIds.size()) continue;
            break;
        }
    }

    public void cloudOrderChange(AppNavigationMenuEvent evt) {
        Map arg = evt.getArgs();
        List dataList = (List)arg.get("data");
        HashMap cloudMap = new HashMap();
        if (dataList != null && dataList.size() > 0) {
            for (int i = 0; i < dataList.size(); ++i) {
                cloudMap.put(((Map)dataList.get(i)).get("id"), i);
            }
            JSONArray myApps = this.getMyApps();
            this.saveSortClouds(myApps, cloudMap);
        }
    }

    public void appOrderChange(AppNavigationMenuEvent evt) {
        Map arg = evt.getArgs();
        List dataList = (List)arg.get("data");
        HashMap appMap = new HashMap();
        String cloudId = null;
        if (dataList != null && dataList.size() > 0) {
            for (int i = 0; i < dataList.size(); ++i) {
                appMap.put(((Map)dataList.get(i)).get("appId"), i + 1);
                cloudId = String.valueOf(((Map)dataList.get(i)).get("cloudId"));
            }
            JSONArray myApps = this.getMyApps();
            this.saveSortApps(myApps, appMap, cloudId);
        }
    }

    private void saveSortClouds(JSONArray myApps, Map cloudSeqMap) {
        if (myApps == null || myApps.size() == 0) {
            return;
        }
        if (cloudSeqMap == null || cloudSeqMap.size() == 0) {
            return;
        }
        JSONArray cloudAndAppArray = myApps;
        JSONArray sortCloudArray = (JSONArray)cloudAndAppArray.clone();
        for (int i = 0; i < cloudAndAppArray.size(); ++i) {
            Object seq;
            String id;
            JSONArray appArray = (JSONArray)cloudAndAppArray.get(i);
            JSONObject cloudObject = (JSONObject)appArray.get(0);
            if (cloudSeqMap != null && cloudSeqMap.size() > 0) {
                cloudObject.put("seq", cloudSeqMap.get(cloudObject.get((Object)"id")));
            }
            if (kd.bos.util.StringUtils.isEmpty((String)(id = cloudObject.getString("id"))) || kd.bos.orm.util.StringUtils.isEmpty(seq = cloudSeqMap.get(id))) continue;
            sortCloudArray.set(Integer.parseInt(seq.toString()), (Object)appArray);
        }
        String saveApp = sortCloudArray.toJSONString();
        this.setSaveApps(saveApp, false, true);
    }

    private void saveSortApps(JSONArray myApps, Map appSeqMap, String appSortCloudId) {
        if (kd.bos.util.StringUtils.isEmpty((String)appSortCloudId)) {
            return;
        }
        if (appSeqMap == null || appSeqMap.size() == 0) {
            return;
        }
        JSONArray cloudAndAppArray = myApps;
        JSONArray sortAppArray = null;
        int index = 0;
        for (int i = 0; i < cloudAndAppArray.size(); ++i) {
            JSONArray appArray = (JSONArray)cloudAndAppArray.get(i);
            JSONObject cloudObject = (JSONObject)appArray.get(0);
            String id = cloudObject.getString("id");
            if (kd.bos.util.StringUtils.isEmpty((String)id) || !id.equals(appSortCloudId)) continue;
            index = i;
            sortAppArray = (JSONArray)appArray.clone();
            if (appSeqMap == null || appSeqMap.size() <= 0) continue;
            for (int j = 1; j < appArray.size(); ++j) {
                JSONObject appObject = (JSONObject)appArray.get(j);
                appObject.put("seq", appSeqMap.get(appObject.get((Object)"id")));
                String number = appObject.getString("id");
                if (kd.bos.util.StringUtils.isEmpty((String)number) || !StringUtils.isNotBlank(appSeqMap.get(number))) continue;
                sortAppArray.set(Integer.parseInt(appSeqMap.get(number).toString()), (Object)appObject);
            }
        }
        cloudAndAppArray.set(index, sortAppArray);
        String saveApp = cloudAndAppArray.toJSONString();
        this.setSaveApps(saveApp, false, false);
    }

    private void resetApps() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u7f6e\u5c06\u6e05\u7a7a\u4e2a\u6027\u5316\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u91cd\u7f6e\uff1f", (String)"MyAppPlugin_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("doreset"));
    }

    private void saveApps(JSONObject arg) {
        boolean flag;
        if (arg == null) {
            return;
        }
        JSONArray cloudAndAppArray = (JSONArray)arg.get((Object)"apps");
        this.sortCloudAndAppArray(cloudAndAppArray);
        String apps = arg.getString("apps");
        this.getPageCache().put(SAVEAPPS, apps);
        boolean isAdminSave = flag = ((Boolean)arg.get((Object)"ischeckdefault")).booleanValue();
        try {
            isAdminSave = (Boolean)arg.get((Object)"isadminsave");
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        this.setSaveApps(apps, isAdminSave, false);
    }

    private void saveAppsNewPortal(JSONArray jsonArray) {
        if (jsonArray == null) {
            return;
        }
        this.sortCloudAndAppArray(jsonArray);
        this.setSaveApps(jsonArray.toJSONString(), false, true);
    }

    private void sortCloudAndAppArray(JSONArray cloudAndAppArray) {
        for (int i = 0; i < cloudAndAppArray.size(); ++i) {
            JSONArray appArray = (JSONArray)cloudAndAppArray.get(i);
            JSONObject cloudObject = (JSONObject)appArray.get(0);
            cloudObject.put("seq", (Object)i);
            for (int j = 1; j < appArray.size(); ++j) {
                JSONObject appObject = (JSONObject)appArray.get(j);
                appObject.put("seq", (Object)j);
            }
        }
    }

    private void setSaveApps(String apps, boolean isAdminSave, boolean isReFresh) {
        PersonalSchemaTemplateUtil personalSchemaTemplateUtil = new PersonalSchemaTemplateUtil();
        PersonalSchemaInfo savePersonalSchemaInfo = personalSchemaTemplateUtil.getPersonalSchemaInfo(apps);
        JSONArray runtimeApps = this.portalUtil.getUserHasPerAppIncludNoCode();
        PersonalSchemaInfo runtimePersonalSchemaInfo = personalSchemaTemplateUtil.getPersonalSchemaInfo(runtimeApps.toString());
        String difXML = "";
        difXML = new PersonalSchemaTemplateUtil().buildDiffXml(savePersonalSchemaInfo, runtimePersonalSchemaInfo, true);
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        if (isAdminSave) {
            UserConfigServiceHelper.setSetting((long)0L, (String)"tenantPersonalList", (String)difXML);
            this.addOperationLog(AppOperationType.MODIFYDEFAULTSCHEME);
        } else {
            UserConfigServiceHelper.setSetting((long)userId, (String)"appPersonalList", (String)difXML);
            this.addOperationLog(AppOperationType.MODIFYUSERSCHEME);
        }
        this.portalUtil.removePageCache();
        if (this.isNewPortal()) {
            if (isReFresh) {
                AppNavigationMenu appnavigationmenuap = (AppNavigationMenu)this.getControl("appnavigationmenuap");
                this.refreshMyAppPanel(appnavigationmenuap);
            }
        } else {
            this.appStoreList(AppSchemeType.USERSCHEME);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MyAppPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private void addOperationLog(AppOperationType appOperationType) {
        if (appOperationType == null) {
            return;
        }
        MultiLangEnumBridge multiOpName = new MultiLangEnumBridge();
        switch (appOperationType.getValue()) {
            case 1: {
                multiOpName = new MultiLangEnumBridge("\u4fee\u6539\u5e94\u7528\u4e2a\u6027\u65b9\u6848", "MyAppPlugin_25", BOS_PORTAL_PLUGIN);
                break;
            }
            case 2: {
                multiOpName = new MultiLangEnumBridge("\u4fee\u6539\u5e94\u7528\u9ed8\u8ba4\u65b9\u6848", "MyAppPlugin_26", BOS_PORTAL_PLUGIN);
                break;
            }
            case 3: {
                multiOpName = new MultiLangEnumBridge("\u6062\u590d\u9ed8\u8ba4", "MyAppPlugin_28", BOS_PORTAL_PLUGIN);
                break;
            }
            case 4: {
                multiOpName = new MultiLangEnumBridge("\u6062\u590d\u663e\u793a\u6240\u6709\u5e94\u7528", "MyAppPlugin_27", BOS_PORTAL_PLUGIN);
                break;
            }
        }
        PortalLogUtils.addLog("tenant_myapp", "2deb950100005dac", "modifyScheme", multiOpName, multiOpName, new String[0]);
    }

    private void gotoApp(GoAppEnum goAppEnum, String appId, String appName) {
        List<String> appNumbers;
        String missMsg;
        if (StringUtils.isEmpty((CharSequence)appId)) {
            return;
        }
        AppInfo app = null;
        try {
            app = AppMetadataCache.getAppInfo((String)appId);
        }
        catch (KDException e) {
            this.logger.info("getAppInfo error", (Object)e);
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        if (app == null) {
            String message = String.format(ResManager.loadKDString((String)"\u5e94\u7528\u3010%s\u3011\u8fd0\u884c\u671f\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5230\u3010\u5f00\u53d1\u5e73\u53f0\u3011\u4e2d\u786e\u8ba4\u8be5\u5e94\u7528\u662f\u5426\u53ef\u89c1\u5e76\u5df2\u542f\u7528\u3002", (String)"MyAppPlugin_11", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), appId);
            this.getView().showErrorNotification(message);
            return;
        }
        if (CLOUD_ID_ICC.equals(app.getCloudId()) && StringUtils.isNotBlank((CharSequence)(missMsg = YZJSpecialEditionUtils.isMissYzjParams()))) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_config_add", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"MyAppPlugin_13", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u53bb\u6dfb\u52a0\u53c2\u6570", (String)"MyAppPlugin_14", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().showConfirm(missMsg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            return;
        }
        if (CLOUD_ID_DATA.equals(app.getCloudId()) && APP_INFO_ID_DMO.equals(app.getAppId())) {
            AppParam apm = new AppParam();
            apm.setAppId(APP_ID_DMO);
            apm.setViewType("15");
            apm.setOrgId(Long.valueOf(ParameterOrgUtils.getParamRootOrgId()));
            apm.setActBookId(Long.valueOf(0L));
            String dmoUrl = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm, (String)PARAM_KEY_DMO);
            if (StringUtils.isEmpty((CharSequence)dmoUrl)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_goto_cts", (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"MyAppPlugin_13", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u53bb\u6dfb\u52a0\u53c2\u6570", (String)"MyAppPlugin_14", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                String missMsg2 = ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u670d\u52a1\u5668\u5730\u5740\uff0c\u914d\u7f6e\u8def\u5f84\u4e3a\u201c\u57fa\u7840\u670d\u52a1\u4e91>\u516c\u5171\u8bbe\u7f6e>\u7cfb\u7edf\u53c2\u6570>\u6570\u636e\u670d\u52a1\u4e91>\u6570\u636e\u5f00\u53d1\u5e73\u53f0\u201d\u3002", (String)"MyAppPlugin_24", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                this.getView().showConfirm(missMsg2, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
                return;
            }
        }
        if (CLOUD_LADDER.equals(app.getAppId())) {
            this.cloudLadderSkip();
            return;
        }
        String mainPageNumber = app.getHomeNum();
        String homeURL = app.getHomeURL();
        String appNum = app.getNumber();
        String string = appName = appName == null ? app.getName().getLocaleValue() : appName;
        if (this.isNewPortal() && GoAppEnum.NewPortalNewWindowOpen.name().equals(goAppEnum.name()) && !"1".equals(app.getOpenType())) {
            this.getView().openUrl("?formId=home_page&appNumber=" + appNum);
            return;
        }
        if (!this.isNewPortal() && (appNumbers = BrandUpEnum.getAppNumbers(appId)) != null) {
            if (this.isHasPermApps(appNumbers, appName)) {
                this.getView().openUrl("?appNumber=" + appId);
            }
            return;
        }
        if ("1".equals(app.getMainFormType())) {
            if (StringUtils.isNotBlank((CharSequence)homeURL)) {
                this.getView().openUrl(homeURL);
            }
        } else {
            if (StringUtils.isBlank((CharSequence)mainPageNumber)) {
                if (NoCodeAppUtils.isFromNoCode(appId, RequestContext.get().getCurrUserId())) {
                    String noCodePageUrl = NoCodeAppUtils.getNoCodePageUrl(appId, "");
                    this.getView().openUrl(noCodePageUrl);
                    return;
                }
                IFormView mainView = this.getView().getMainView();
                mainView = mainView == null ? this.getView() : mainView;
                mainView.showErrorNotification(ResManager.loadKDString((String)"\u5e94\u7528\u9996\u9875\u672a\u914d\u7f6e\uff0c\u8bf7\u524d\u5f80\u201c\u5f00\u53d1\u5e73\u53f0\u201d\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"MyAppPlugin_15", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                this.getView().sendFormAction(mainView);
                return;
            }
            try {
                OpenPageUtils.openApp(appNum, null, null, this.getView(), appName);
            }
            catch (KDException ex) {
                if (BosErrorCode.metaNotFound.equals((Object)ex.getErrorCode())) {
                    String message = String.format(ResManager.loadKDString((String)"\u5e94\u7528\u914d\u7f6e\u7684\u9996\u9875\u8868\u5355\u3010%s\u3011\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8bf7\u5230\u3010\u5f00\u53d1\u5e73\u53f0\u3011\u8fdb\u884c\u68c0\u67e5\u3002", (String)"MyAppPlugin_16", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), mainPageNumber);
                    this.getView().showErrorNotification(message);
                }
                throw ex;
            }
        }
    }

    public boolean isHasPermApps(List<String> appNums, String appName) {
        Set<String> resultApps = this.portalUtil.getUserHasPerAppNumbers();
        if (resultApps == null || resultApps.isEmpty()) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u65e0%1$s\u7684\u5e94\u7528\u6743\u9650\u3002", (String)"OpenPageUtils_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), appName));
            return false;
        }
        Iterator<String> iterator = appNums.iterator();
        while (iterator.hasNext()) {
            String item = iterator.next();
            boolean isExist = resultApps.stream().anyMatch(a -> a.equals(item));
            if (isExist) continue;
            iterator.remove();
        }
        if (CollectionUtils.isEmpty(appNums)) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u65e0%1$s\u7684\u5e94\u7528\u6743\u9650\u3002", (String)"OpenPageUtils_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), appName));
            return false;
        }
        return true;
    }

    private void isAdminUser() {
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)userId);
        String personApps = UserConfigServiceHelper.getSetting((long)userId, (String)"appPersonalList");
        String defaultSchemaApps = UserConfigServiceHelper.getSetting((long)0L, (String)"appPersonalList");
        boolean resetflag = false;
        if (StringUtils.isNotBlank((CharSequence)personApps)) {
            resetflag = true;
        }
        if (isAdminUser && StringUtils.isNotBlank((CharSequence)defaultSchemaApps)) {
            resetflag = true;
        }
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("ISMANAGER", (Object)isAdminUser);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("APPINDIVIDUALIZATIONSTORELIST", (Object)resetflag);
    }

    private void editAppInfo(JSONObject arg) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_runtimeinfoedit");
        parameter.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91", (String)"MyAppPlugin_20", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.setCustomParam("appinfo", (Object)arg);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "appinfoeditclosecallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void editCloudInfo(JSONObject arg) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_cloudinfoedit");
        parameter.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91", (String)"MyAppPlugin_20", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.setCustomParam("cloudinfo", (Object)arg);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "cloudinfoeditclosecallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void cloudLadderSkip() {
        Map<String, Object> cloudLadderResp = CloudLadderSkipUtils.cloudLadderAuth();
        if (Objects.isNull(cloudLadderResp)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8fd0\u7ef4\u670d\u52a1\u8fd4\u56de\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"MyAppPlugin_21", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u8fd0\u7ef4\u670d\u52a1\u8fd4\u56de\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"MyAppPlugin_21", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), MessageTypes.Default);
            return;
        }
        if (!"SUCCESS".equals(cloudLadderResp.get("msg"))) {
            Integer error = (Integer)cloudLadderResp.get("error");
            String message = String.format(ResManager.loadKDString((String)"\u8fd0\u7ef4\u670d\u52a1\u9519\u8bef\u539f\u56e0\uff1a\u9519\u8bef\u7801\u201c%1$s\u201d\uff0c%2$s\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MyAppPlugin_22", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), error, cloudLadderResp.get("msg"));
            this.getView().showMessage(message);
            return;
        }
        String phone = CloudLadderSkipUtils.getOPSPhone();
        StringBuilder sb = new StringBuilder(CloudLadderSkipUtils.getOPSUrl());
        sb.append("boss/open/redirect?token=");
        sb.append(cloudLadderResp.get("token"));
        sb.append("&uniqueId=");
        sb.append(phone);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> mpURL = new HashMap<String, String>(2);
        mpURL.put("url", sb.toString());
        mpURL.put("openStyle", "1");
        proxy.addAction("openUrl", mpURL);
    }

    private void refreshMyAppPanel(AppNavigationMenu appnavigationmenuap) {
        JSONArray allApps = this.getMyApps();
        LinkedList cloudListMap = new LinkedList();
        if (allApps != null && allApps.size() > 0) {
            for (JSONArray cloudAndApp : allApps) {
                LinkedList appListMap = new LinkedList();
                for (JSONObject cloudOrApp : cloudAndApp) {
                    if (cloudOrApp.get((Object)"iscloud") == null) {
                        boolean showWorkbench = !"1".equals(cloudOrApp.getString("opentype"));
                        LinkedHashMap<String, Object> appMap = new LinkedHashMap<String, Object>();
                        appMap.put("appId", cloudOrApp.getString("id"));
                        appMap.put("cloudId", cloudOrApp.getString("cloudid"));
                        appMap.put("image", cloudOrApp.getString("image"));
                        appMap.put("name", this.getLocalValue(cloudOrApp.get((Object)"name")));
                        appMap.put(DESCRIPTION, this.getLocalValue(cloudOrApp.get((Object)DESCRIPTION)));
                        appMap.put("showWorkbench", showWorkbench);
                        appMap.put("grayValid", cloudOrApp.get((Object)"grayValid"));
                        appListMap.add(appMap);
                        continue;
                    }
                    LinkedHashMap<String, Object> cloudMap = new LinkedHashMap<String, Object>();
                    cloudMap.put("cloudId", cloudOrApp.getString("id"));
                    cloudMap.put("name", this.getLocalValue(cloudOrApp.get((Object)"name")));
                    cloudMap.put("items", appListMap);
                    cloudMap.put("grayValid", cloudOrApp.get((Object)"grayValid"));
                    cloudListMap.add(cloudMap);
                }
            }
        }
        appnavigationmenuap.setMyAppData(cloudListMap);
    }

    private JSONArray getMyApps() {
        return this.portalUtil.getFilterBySchemeAppsWithCache();
    }

    private void closeSlide() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("formId", "bos_portal_myapp_new");
        map.put("show", Boolean.FALSE);
        proxy.addAction("showSlideBill", map);
    }

    public void getMenuData(AppNavigationMenuEvent evt) {
        String appId;
        Map arg = evt.getArgs();
        if (CollectionUtils.isEmpty((Map)arg)) {
            return;
        }
        Object appIdObj = arg.get("appId");
        String string = appId = appIdObj == null ? null : appIdObj.toString();
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            AppNavigationMenu appNavigationMenu = (AppNavigationMenu)this.getControl("appnavigationmenuap");
            Long userId = RequestContext.get().getCurrUserId();
            List<Map<String, Object>> resultData = this.menuService.getFilterMenuData(userId, appId, (String)arg.get("cloudId"));
            appNavigationMenu.setMenuData(resultData);
        }
    }

    public void menuItemClick(AppNavigationMenuEvent evt) {
        Map arg = evt.getArgs();
        if (arg != null && arg.size() > 0) {
            String appId;
            Object appIdObj = arg.get("appId");
            Object menuIdObj = arg.get("menuId");
            String menuId = menuIdObj == null ? null : menuIdObj.toString();
            String string = appId = appIdObj == null ? null : appIdObj.toString();
            if (StringUtils.isEmpty((CharSequence)appId)) {
                return;
            }
            try {
                this.openMenu(appId, menuId);
            }
            catch (Exception e) {
                this.logger.info("MyAppAbstract#menuItemClick error", (Object)e);
                this.getView().showMessage(ResManager.loadKDString((String)"\u83dc\u5355\u5173\u8054\u7684\u8868\u5355\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BizAppHomePlugin_17", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            this.closeSlide();
        }
    }

    private void openMenu(String appId, String menuId) {
        List<AppMenuInfo> qingMenus = this.menuService.getQingMenuArray(appId);
        List<String> qingMenuIds = this.getQingMenuIds(qingMenus);
        if (qingMenus != null && qingMenuIds.contains(menuId)) {
            for (AppMenuInfo qingObj : qingMenus) {
                String qingMenuId = qingObj.getId();
                if (!menuId.equals(qingMenuId)) continue;
                String formNumber = qingObj.getFormId();
                LocaleString localeString = qingObj.getName();
                String qingMenuName = "";
                if (localeString != null) {
                    qingMenuName = localeString.getLocaleValue();
                }
                String formParams = qingObj.getParams();
                FormConfig formConfig = FormMetadataCache.getFormConfig((String)formNumber);
                if (formConfig == null) {
                    String message = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u8f7b\u5206\u6790\u52a8\u6001\u7f16\u7801\u4e3a %s \u7684\u52a8\u6001\u8868\u5355\uff0c\u8bf7\u524d\u5f80\u8f7b\u5206\u6790\u52a8\u6001\u8868\u5355\u7ba1\u7406\u4e2d\u7ef4\u62a4\u3002", (String)"BizAppHomePlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), formNumber);
                    this.getView().showTipNotification(message);
                    return;
                }
                if (StringUtils.isBlank((CharSequence)formNumber)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f7b\u5206\u6790\u83dc\u5355\u672a\u7ed1\u5b9a\u9875\u9762\uff0c\u8bf7\u524d\u5f80\u201c\u8f7b\u5206\u6790\u201d\u914d\u7f6e\u3002", (String)"BizAppHomePlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                AppInfo app = AppMetadataCache.getAppInfo((String)appId);
                if (app == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u5e94\u7528\u3002", (String)"OpenPageUtils_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                String appHomeNum = app.getHomeNum();
                String appName = app.getName().getLocaleValue();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("view", this.getView());
                map.put("formnumber", formNumber);
                map.put("parameter", formParams);
                map.put("menuname", qingMenuName);
                map.put("parametertype", null);
                map.put("openType", null);
                map.put("permItem", null);
                map.put(APPNAME, appName);
                map.put("appmainnumber", appHomeNum);
                OpenPageUtils.openApp(app.getNumber(), menuId, map, this.getView());
            }
        } else {
            AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuId);
            if (menu == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u83dc\u5355\u4fe1\u606f\u5931\u8d25", (String)"BizAppHomePlugin_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String formId = menu.getFormId();
            if (NoCodeAppUtils.isFromNoCode(appId, RequestContext.get().getCurrUserId())) {
                String noCodePageUrl = NoCodeAppUtils.getNoCodePageUrl(appId, formId);
                this.getView().openUrl(noCodePageUrl);
                return;
            }
            if ("page".equals(menu.getMenuType()) && StringUtils.isBlank((CharSequence)formId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u83dc\u5355\u672a\u7ed1\u5b9a\u5bf9\u5e94\u7684\u9875\u9762\uff0c\u8bf7\u524d\u5f80\u201c\u5f00\u53d1\u5e73\u53f0\u201d\u914d\u7f6e\u5e94\u7528\u83dc\u5355\u3002", (String)"BizAppHomePlugin_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            OpenPageUtils.openMenu(this.getView(), menuId, appId);
        }
    }

    private List<String> getQingMenuIds(List<AppMenuInfo> qingMenus) {
        LinkedList<String> qingMenuIds = new LinkedList<String>();
        if (CollectionUtils.isEmpty(qingMenus)) {
            return qingMenuIds;
        }
        for (AppMenuInfo qingObj : qingMenus) {
            String qingMenuId = qingObj.getId();
            if (!StringUtils.isNotEmpty((CharSequence)qingMenuId)) continue;
            qingMenuIds.add(qingMenuId);
        }
        return qingMenuIds;
    }

    public void getSearchResult(AppNavigationMenuEvent evt) {
        String content;
        Map args = evt.getArgs();
        if (CollectionUtils.isEmpty((Map)args)) {
            return;
        }
        Object contentObj = args.get("content");
        String string = content = contentObj == null ? null : contentObj.toString();
        if (content == null) {
            return;
        }
        JSONArray myHasPermApps = this.portalUtil.getUserHasPerAppWithCache();
        Map<String, String> appNumAndIdMap = this.getAppNumAndIdByJson(myHasPermApps);
        Map<String, Object> menuMap = this.menuService.getSearchResult(content, appNumAndIdMap);
        AppNavigationMenu appNavigationMenu = (AppNavigationMenu)this.getControl("appnavigationmenuap");
        appNavigationMenu.setSearchResult(menuMap);
    }

    private Map<String, String> getAppNumAndIdByJson(JSONArray allApps) {
        if (allApps == null || allApps.size() == 0) {
            return null;
        }
        HashMap<String, String> appsMap = new HashMap<String, String>();
        for (Object allApp : allApps) {
            JSONArray cloudAndApp = (JSONArray)allApp;
            for (Object cloudAndAppObj : cloudAndApp) {
                JSONObject cloudOrApp = (JSONObject)cloudAndAppObj;
                if (cloudOrApp.get((Object)"iscloud") != null) continue;
                String number = cloudOrApp.getString("number");
                String id = cloudOrApp.getString("id");
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                appsMap.put(number, id);
            }
        }
        return appsMap;
    }
}

