/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.ext.form.control.CommonFunctionControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.CommonFunctionItemClickEvent;
import kd.bos.form.control.events.CommonFunctionItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.service.PortalMenuService;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.svc.control.AppNavigationMenu;
import kd.svc.control.events.AppNavigationMenuListener;

public abstract class MyMarksAbstract
extends AbstractFormPlugin
implements CommonFunctionItemClickListener,
AppNavigationMenuListener {
    public static final String VECTOR_ICON_XIALA = "kdfont kdfont-xiala";
    public static final String LABEL_SETPOPULAR = "label_setpopular";
    public static final String BUTTON_ADD = "button_add";
    public static final String PANEL_ADDBUTTON = "panel_addbutton";
    public static final String PANEL_MENULIST = "panel_menulist";
    public static final String KEY_COMMONFUNC = "commonfuncap";
    public static final String PGCACHE_MARKEDAPPMENU = "pagecache_markeAppMenu";
    public static final String PGCACHE_MARKEDAPPMENU_FINAL = "pagecache_markeAppMenu_final";
    public static final String CLOSECALLBACK_SETCOMMON = "closecallback_setcommon";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String GROUP = "group";
    public static final String DELETE_COMFIRM = "delete_comfirm";
    public static final Log logger = LogFactory.getLog(MyMarksAbstract.class);
    protected PortalMenuService menuService;

    public abstract boolean isNewPortal();

    public abstract String getSetMarksFormId();

    public abstract JSONArray getHasPerApps();

    public void initialize() {
        this.menuService = new PortalMenuService(this.getPageCache());
    }

    public void afterCreateNewDataDo() {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.isNewPortal()) {
            AppNavigationMenu appnavigationmenuap = (AppNavigationMenu)this.getControl("appnavigationmenuap");
            appnavigationmenuap.addAppNavigationMenuListener((AppNavigationMenuListener)this);
        } else {
            this.addClickListeners(new String[]{LABEL_SETPOPULAR, BUTTON_ADD});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.afterCreateNewDataDo();
    }

    private void refreshMenuPanel() {
        JSONArray allApps = this.getHasPerApps();
        HashMap<String, String> cloudSeqMap = new HashMap<String, String>(16);
        HashMap<String, String> appMaps = new HashMap<String, String>(16);
        this.doAppAndCloud(cloudSeqMap, appMaps, allApps);
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        Map appAndMenuBlackList = service.getBlackMenuAndApp(appMaps);
        List blackAppList = null;
        List blackMenuList = null;
        if (appAndMenuBlackList != null && appAndMenuBlackList.size() > 0) {
            blackAppList = (List)appAndMenuBlackList.get("blackAppIds");
            blackMenuList = (List)appAndMenuBlackList.get("blackMenus");
        }
        Long userId = RequestContext.get().getCurrUserId();
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        DynamicObject[] userMarkedMenus = BusinessDataServiceHelper.load((String)"portal_usermarkedmenu", (String)"bizapp, menu", (QFilter[])new QFilter[]{userFilter}, (String)"createtime asc");
        Set userBizApps = appMaps.keySet();
        if (userMarkedMenus != null && userMarkedMenus.length > 0) {
            LinkedHashMap<String, List> appMenuMap = new LinkedHashMap<String, List>();
            HashSet<String> appIds = new HashSet<String>();
            for (DynamicObject userMarkedMenuInfo : userMarkedMenus) {
                String appNum = userMarkedMenuInfo.getString("bizapp");
                if (StringUtils.isEmpty((String)appNum) || blackAppList != null && blackAppList.contains(appNum)) continue;
                AppInfo appInfo = null;
                try {
                    appInfo = AppMetadataCache.getAppInfo((String)appNum);
                }
                catch (Exception e) {
                    logger.info("\u7f16\u7801\u4e3a " + appNum + " \u7684\u5e94\u7528\u67e5\u8be2\u5931\u8d25", (Object)e);
                }
                String menuId2 = userMarkedMenuInfo.getString("menu");
                if (StringUtils.isEmpty((String)menuId2) || blackMenuList != null && blackMenuList.contains(menuId2)) continue;
                appMenuMap.computeIfAbsent(appNum, k -> new ArrayList()).add(menuId2);
                appIds.add(appInfo.getId());
            }
            Map<String, Set<String>> userNoPermMenus = this.menuService.getHideMenuByAppIdsWithoutPerm(userId, appIds);
            ArrayList<Map> data = new ArrayList<Map>(appMenuMap.size());
            HashMap<String, Cloneable> groupMap = null;
            HashMap<String, String> appMap = null;
            ArrayList menuList = null;
            HashMap<String, String> menuMap = null;
            Iterator it = appMenuMap.entrySet().iterator();
            ArrayList errorMenuIdList = new ArrayList(0);
            while (it.hasNext()) {
                List errorMenuIdList0;
                Map.Entry entry = it.next();
                String appNum = (String)entry.getKey();
                AppInfo appInfo = null;
                try {
                    appInfo = AppMetadataCache.getAppInfo((String)appNum);
                }
                catch (Exception e) {
                    logger.info("\u7f16\u7801\u4e3a " + appNum + " \u7684\u5e94\u7528\u67e5\u8be2\u5931\u8d25", (Object)e);
                }
                if (appInfo == null || !userBizApps.contains(appInfo.getId())) continue;
                if (!appInfo.isRealRuntime()) {
                    List menuIdList = (List)appMenuMap.get(entry.getKey());
                    errorMenuIdList.addAll(menuIdList);
                    it.remove();
                    continue;
                }
                String appName = appInfo.getName() == null ? null : appInfo.getName().toString();
                if (StringUtils.isEmpty((String)appName)) continue;
                Short seq = appInfo.getSeq();
                if (seq == null) {
                    seq = 0;
                }
                String appSeq = seq.intValue() + "";
                String cloudSeq = (String)cloudSeqMap.get(appInfo.getCloudId());
                if (StringUtils.isEmpty((String)cloudSeq)) {
                    cloudSeq = "0";
                }
                appMap = new HashMap<String, String>();
                appMap.put("id", appNum);
                appMap.put("caption", appName);
                appMap.put("appSeq", appSeq);
                appMap.put("cloudSeq", cloudSeq);
                List menusInfos = AppMetadataCache.getAppMenusInfoByAppId((String)appNum);
                if (menusInfos == null || menusInfos.isEmpty()) continue;
                List appMenuIdlist = menusInfos.stream().map(AppMenuInfo::getId).collect(Collectors.toList());
                List menuIdList = (List)appMenuMap.get(entry.getKey());
                Collection noPermMenus = userNoPermMenus.get(appInfo.getId());
                if (!CollectionUtils.isEmpty((Collection)noPermMenus)) {
                    menuIdList.removeAll(noPermMenus);
                }
                if (!CollectionUtils.isEmpty(errorMenuIdList0 = menuIdList.stream().filter(menuId -> !appMenuIdlist.contains(menuId)).collect(Collectors.toList()))) {
                    errorMenuIdList.addAll(errorMenuIdList0);
                }
                Map<String, List<AppMenuInfo>> parentIdMap = menusInfos.stream().collect(Collectors.groupingBy(AppMenuInfo::getParentId));
                List<AppMenuInfo> rootMenuList = menusInfos.stream().filter(menuInfo -> parentIdMap.keySet().stream().filter(parentMenuId -> !appMenuIdlist.contains(parentMenuId)).collect(Collectors.toList()).contains(menuInfo.getParentId())).collect(Collectors.toList());
                ArrayList<AppMenuInfo> sortMenusInfos = new ArrayList<AppMenuInfo>(menusInfos.size());
                this.appMenuSort(rootMenuList, parentIdMap, sortMenusInfos);
                menuList = new ArrayList(menuIdList.size());
                for (AppMenuInfo menuInfo2 : sortMenusInfos) {
                    String menuName;
                    if (!menuIdList.contains(menuInfo2.getId())) continue;
                    String string = menuName = menuInfo2.getName() == null ? null : menuInfo2.getName().toString();
                    if (StringUtils.isEmpty((String)menuName)) continue;
                    menuMap = new HashMap<String, String>();
                    menuMap.put("id", menuInfo2.getId());
                    if (!this.isNewPortal()) {
                        menuMap.put("caption", menuName);
                    }
                    menuMap.put("appId", appInfo.getId());
                    menuMap.put("cloudId", appInfo.getCloudId());
                    menuMap.put("name", menuName);
                    menuList.add(menuMap);
                }
                if (menuList.isEmpty()) continue;
                groupMap = new HashMap<String, Cloneable>();
                groupMap.put(GROUP, appMap);
                groupMap.put("items", menuList);
                data.add(groupMap);
            }
            data.sort(Comparator.comparing(map -> Integer.valueOf((String)((Map)map.get(GROUP)).get("cloudSeq"))).thenComparing(map -> Integer.valueOf((String)((Map)map.get(GROUP)).get("appSeq"))));
            if (this.isNewPortal()) {
                if (!appMenuMap.isEmpty()) {
                    this.getPageCache().put(PGCACHE_MARKEDAPPMENU_FINAL, SerializationUtils.toJsonString(appMenuMap));
                } else {
                    this.getPageCache().remove(PGCACHE_MARKEDAPPMENU_FINAL);
                }
                Iterator iterator = data.iterator();
                ArrayList result = new ArrayList();
                while (iterator.hasNext()) {
                    Map map2 = (Map)iterator.next();
                    List items = (List)map2.get("items");
                    result.addAll(items);
                }
                AppNavigationMenu appnavigationmenuap = (AppNavigationMenu)this.getControl("appnavigationmenuap");
                appnavigationmenuap.setFavoriteData(result);
            } else {
                if (!appMenuMap.isEmpty()) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_ADDBUTTON});
                    this.getView().setVisible(Boolean.TRUE, new String[]{LABEL_SETPOPULAR, KEY_COMMONFUNC});
                    this.getPageCache().put(PGCACHE_MARKEDAPPMENU, SerializationUtils.toJsonString(appMenuMap));
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_ADDBUTTON});
                    this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_SETPOPULAR, KEY_COMMONFUNC});
                    this.getPageCache().remove(PGCACHE_MARKEDAPPMENU);
                }
                ClientViewProxy proxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.invokeControlMethod(KEY_COMMONFUNC, "loadCommonFunctionData", new Object[]{data});
            }
            if (!errorMenuIdList.isEmpty()) {
                logger.info(String.format("entityName:%s,\u5220\u9664\u7528\u6237ID:%s,\u83dc\u5355ID:%s\u7684\u6570\u636e", "portal_usermarkedmenu", userId, String.join((CharSequence)",", errorMenuIdList)));
                DeleteServiceHelper.delete((String)"portal_usermarkedmenu", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("menu", "in", errorMenuIdList)});
            }
        } else if (this.isNewPortal()) {
            this.sendNoAppAction();
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_ADDBUTTON});
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_SETPOPULAR, KEY_COMMONFUNC});
            this.getPageCache().remove(PGCACHE_MARKEDAPPMENU);
        }
    }

    private void doAppAndCloud(Map<String, String> cloudSeqMap, Map<String, String> appMaps, JSONArray allApps) {
        if (allApps == null) {
            return;
        }
        Iterator iterAllApp = allApps.iterator();
        while (iterAllApp.hasNext()) {
            JSONArray cloudAndApp = (JSONArray)iterAllApp.next();
            for (JSONObject cloudOrApp : cloudAndApp) {
                if (cloudOrApp.get((Object)"iscloud") == null) {
                    String appId = cloudOrApp.getString("id");
                    String cloudid = cloudOrApp.getString("cloudid");
                    appMaps.put(appId, cloudid);
                    continue;
                }
                cloudSeqMap.put(cloudOrApp.getString("id"), cloudOrApp.getString("seq"));
            }
            if (cloudAndApp.size() != 1) continue;
            iterAllApp.remove();
        }
    }

    public void sendNoAppAction() {
        this.getPageCache().remove(PGCACHE_MARKEDAPPMENU_FINAL);
        AppNavigationMenu appnavigationmenuap = (AppNavigationMenu)this.getControl("appnavigationmenuap");
        appnavigationmenuap.setFavoriteData(new ArrayList());
    }

    private void appMenuSort(List<AppMenuInfo> menus, Map<String, List<AppMenuInfo>> parentIdMap, List<AppMenuInfo> sortMenuInfos) {
        menus.forEach(menu -> {
            sortMenuInfos.add((AppMenuInfo)menu);
            List childMenus = (List)parentIdMap.get(menu.getId());
            if (CollectionUtils.isEmpty((Collection)childMenus)) {
                return;
            }
            childMenus.sort(Comparator.comparing(AppMenuInfo::getSeq));
            this.appMenuSort(childMenus, parentIdMap, sortMenuInfos);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BUTTON_ADD.equals(key) || LABEL_SETPOPULAR.equals(key)) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId(this.getSetMarksFormId());
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.Modal);
            param.setOpenStyle(openStyle);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_SETCOMMON));
            String jsonStr = this.getPageCache().get(PGCACHE_MARKEDAPPMENU);
            if (StringUtils.isNotEmpty((String)jsonStr)) {
                Map appMenuMap = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
                param.setCustomParams(appMenuMap);
            }
            this.getView().showForm(param);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (CLOSECALLBACK_SETCOMMON.equals(actionId)) {
            this.refreshMenuPanel();
        }
    }

    public void customEvent(CustomEventArgs e) {
        if ("afterShowSlideBill".equals(e.getKey())) {
            if (this.isNewPortal()) {
                this.afterCreateNewDataDo();
            } else {
                this.refreshMenuPanel();
            }
        }
        if (!this.isNewPortal() && "sideslippingFlex".equals(e.getKey())) {
            Vector vector = (Vector)this.getView().getMainView().getControl("menulisticon");
            vector.setFontClass(VECTOR_ICON_XIALA);
            this.getView().sendFormAction(this.getView().getMainView());
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.equals(KEY_COMMONFUNC)) {
            CommonFunctionControl ctrl = new CommonFunctionControl();
            ctrl.setKey(key);
            ctrl.setView(this.getView());
            ctrl.addItemClickListener((CommonFunctionItemClickListener)this);
            e.setControl((Control)ctrl);
        }
    }

    public void itemClick(CommonFunctionItemClickEvent evt) {
        String menuId;
        Map params = evt.getParams();
        String appNum = params.get("groupId") == null ? null : params.get("groupId").toString();
        String string = menuId = params.get("itemId") == null ? null : params.get("itemId").toString();
        if (StringUtils.isNotEmpty((String)appNum) && StringUtils.isNotEmpty((String)menuId)) {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNum);
            if (appInfo == null) {
                return;
            }
            String appId = appInfo.getId();
            if (StringUtils.isEmpty((String)appId)) {
                return;
            }
            this.gotoMenu(menuId, appId);
            if (!this.isNewPortal()) {
                this.closeSlide("portal_usermarkedmenulist");
            }
        }
    }

    public void gotoMenu(String menuId, String appId) {
        String bizAppId = AppMetadataCache.getAppNumberById((String)appId);
        AppInfo app = AppMetadataCache.getAppInfo((String)bizAppId);
        if (app == null) {
            this.getView().getMainView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u5e94\u7528", (String)"PortalMenuListPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)bizAppId, (String)menuId);
        if (menu == null) {
            this.getView().getMainView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u83dc\u5355", (String)"PortalMenuListPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String appHomeNum = app.getHomeNum();
        String menuFormId = menu.getFormId();
        if (StringUtils.isBlank((String)appHomeNum) || StringUtils.isEmpty((String)menuFormId)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8868\u5355\u5df2\u5931\u6548\uff0c\u786e\u8ba4\u5220\u9664\uff1f", (String)"PortalMenuListPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), null, MessageBoxOptions.YesNo, null, new ConfirmCallBackListener(DELETE_COMFIRM, (IFormPlugin)this), null, menuId);
            return;
        }
        FormConfig formConfig = null;
        try {
            formConfig = FormMetadataCache.getFormConfig((String)menuFormId);
        }
        catch (Exception e) {
            logger.info("getFormConfig", (Object)e);
        }
        if (formConfig == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8868\u5355\u5df2\u5931\u6548\uff0c\u786e\u8ba4\u5220\u9664\uff1f", (String)"PortalMenuListPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), null, MessageBoxOptions.YesNo, null, new ConfirmCallBackListener(DELETE_COMFIRM, (IFormPlugin)this), null, menuId);
            return;
        }
        OpenPageUtils.openMenu(this.getView().getMainView(), menuId, appId);
        this.getView().sendFormAction(this.getView().getMainView());
    }

    public void closeSlide() {
        this.closeSlide("bos_portal_myapp_new");
    }

    private void closeSlide(String formId) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("formId", formId);
        map.put("show", Boolean.FALSE);
        proxy.addAction("showSlideBill", map);
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        String menuValue = mbce.getCustomVaule();
        if (callBackId.equals(DELETE_COMFIRM) && mbce.getResult() == MessageBoxResult.Yes) {
            Long userId = RequestContext.get().getCurrUserId();
            QFilter userFilter = new QFilter("user", "=", (Object)userId);
            QFilter menuFilter = new QFilter("menu", "=", (Object)menuValue);
            DeleteServiceHelper.delete((String)"portal_usermarkedmenu", (QFilter[])new QFilter[]{userFilter, menuFilter});
            this.refreshMenuPanel();
        }
    }

    public void deleteMark(Map<String, Object> arg) {
        String appId;
        String menuId = arg.get("id") == null ? "" : arg.get("id").toString();
        String string = appId = arg.get("appId") == null ? "" : arg.get("appId").toString();
        if (StringUtils.isEmpty((String)menuId) || StringUtils.isEmpty((String)appId)) {
            this.getView().getMainView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"MyMarksAbstract_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Long userId = RequestContext.get().getCurrUserId();
        String jsonStr = this.getPageCache().get(PGCACHE_MARKEDAPPMENU_FINAL);
        Map appMenuMap = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
        if (appMenuMap == null) {
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                this.menuService.deleteMarkMenu(userId, menuId);
                this.refreshMenuPanel();
            }
            catch (Exception e) {
                logger.info("\u8bbe\u7f6e\u5e38\u7528\u529f\u80fd\u83dc\u5355\u5f02\u5e38", (Object)e);
                h.markRollback();
            }
        }
    }

    private void deletePagechMenuId(String menuId, String appId, Map<String, List<String>> appMenuMap) {
        List<String> menuList = appMenuMap.get(appId);
        if (CollectionUtils.isEmpty(menuList)) {
            return;
        }
        menuList.remove(menuId);
        if (CollectionUtils.isEmpty(menuList)) {
            appMenuMap.remove(appId);
        } else {
            appMenuMap.put(appId, menuList);
        }
        this.getPageCache().put(PGCACHE_MARKEDAPPMENU_FINAL, SerializationUtils.toJsonString(appMenuMap));
    }
}

