/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew.common;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.EnabledLang;
import kd.bos.license.api.ILicenseService;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.model.Language;
import kd.bos.login.user.LanguageService;
import kd.bos.login.utils.ModeTypeUtils;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.UserBizRoleCache;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.portal.service.PersonalSettingService;
import kd.bos.portal.service.VersionService;
import kd.bos.portal.util.ImageUtil;
import kd.bos.portal.util.NewPortalUtils;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.portal.util.PortalUserUtils;
import kd.bos.portal.util.TaskAndMsgUtil;
import kd.bos.portal.util.YZJSpecialEditionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.portal.InitailVersionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.session.SessionManager;
import org.apache.commons.lang3.StringUtils;

public abstract class PersonalSettingAbstract
extends AbstractFormPlugin
implements RowClickEventListener {
    public static final String BIZROLE = "bizrole";
    public static final String PERM_BUSIROLE = "perm_busirole";
    public static final String PERSONAL_SETTING_PLUGIN_6 = "PersonalSettingPlugin_6";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String SWITCHTHEMEPANEL_SHOW = "switchthemepanelShow";
    public static final String ENABLE = "enable";
    public static final String DESCRIPTION = "description";
    public static final String GROUP_NUMBER = "group.number";
    public static final String NUMBER = "number";
    public static final String NUMBER_AND_KEYMAP = "numberAndKeymap";
    public static final String COLOR = "color";
    public static final String HEADPANEL = "headpanel";
    public static final String ISDEFAULT = "isdefault";
    public static final String CONTENT = "content";
    private static Log logger = LogFactory.getLog(PersonalSettingAbstract.class);
    protected PersonalSettingService personalSettingService = new PersonalSettingService();
    private static final String BILL_PERSONAL_INFO_ID = "bos_portal_personalinfo";
    private static final String CLIENT_COMMAND_BILL_CLOSE = "closeSlideBill";
    private static final String BTN_SETTING = "btn_setting";
    private static final String BTN_ABOUT = "btn_about";
    private static final String BTN_LOGINOUT = "btn_loginout";
    private static final String BTN_NEWPORTAL = "btn_newportal";
    private static final String SVG_SWITCH_TENANT = "svg_switchtenant";
    private static final String SVG_SWITCH_ORG = "svg_switchorg";
    private static final String SVG_SWITCH_BUSPARTNER = "svg_switchbuspartner";
    private static final String SVG_SWITCH_BIZROLE = "svg_switchbizrole";
    public static final String SVG_SWITCH_THEME = "svg_switchtheme";
    private static final String NOTIFY_ENTITY = "notifyentity";
    private static final String LABEL_NOTIFYMORE = "notifymore";
    private static final String LABEL_NOTIFY_TITLE = "notifytitlelabel1";
    private static final String NOTIFY_PANEL = "notifypanel";
    private static final String BLANK_PANEL = "blankpanel";
    private static final String WF_TASKCENTERHOME = "wf_msg_center";
    private static final String ENTITY_ID_PROVERBS = "bos_proverbs";
    private static final String MSG_ENTITY = "msgentity";
    private static final String LABEL_MSGMORE = "msgmore";
    private static final String LABEL_MSG_TITLE = "msgtitlelabel1";
    private static final String NOMSG_PANEL = "nomsgpanel";
    private static final int DEFAULT_COUNT = 5;
    private static final String HTML_NEWLINE_LABEL = "<br/>";
    private static final String HTML_MORE_LABEL = "...";
    private static final String ICON_USER_CENTER = "icon_usercenter";
    private static final String SERVICE_PANEL = "servicepanel";
    public static final String KEY_THEME_FRONT = "theme_";
    public static final String KEY_THEME_PANEL = "theme_panel";
    private static final String LOADING_IMAGE_URL = "/images/pc/other/jcfwb_loading_100_100.gif";
    private static final String KEY_MARK_LOADING_PANEL = "markloadingpanel";
    private static final String KEY_MSG_LOADING_PANEL = "msgloadingpanel";
    private static final String KEY_MARK_IMAGE = "markloading";
    private static final String KEY_MSG_IMAGE = "msgloading";
    private static final String BTN_LANG = "btn_lang";
    private static final String BTN_OLDPORTAL = "btn_oldportal";
    public static final String BTN_USERCENTER = "btn_usercenter";

    public abstract boolean isNewPortal();

    public abstract void initTheme(DynamicObject[] var1);

    public abstract void switchTheme(String var1);

    public abstract void userCenterDisplay();

    public String[] getSwitchPortalBtn() {
        return new String[0];
    }

    public void setSwitchPortalBtnVisible() {
        boolean isNewTenant = InitailVersionServiceHelper.isInitailVersion((int)6);
        if (!isNewTenant) {
            this.getView().setVisible(Boolean.valueOf(true), this.getSwitchPortalBtn());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setSwitchPortalBtnVisible();
        this.userCenterDisplay();
        if (this.isNewPortal()) {
            this.setToolTips();
        } else {
            this.getPageCache().put(SWITCHTHEMEPANEL_SHOW, "0");
            this.bizRoleDisplay();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getMainView() == null) {
            this.initUserInfo();
            if (this.isNewPortal()) {
                this.getView().updateView("flexpanelap");
            } else {
                this.initBizRole();
                this.showAllMsg();
                this.getView().updateView("flexpanelap1");
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (!this.isNewPortal()) {
            if (e == null || StringUtils.isBlank((CharSequence)e.getName())) {
                return;
            }
            if ("showNotification".equals(e.getName())) {
                this.showNotification();
            }
            if ("showMessage".equals(e.getName())) {
                this.showMessage();
            }
        }
    }

    public void registerListener(EventObject e) {
        this.addVectorClickListener(SVG_SWITCH_ORG);
        this.addVectorClickListener(SVG_SWITCH_BUSPARTNER);
        this.addButtonClickListener(BTN_ABOUT);
        if (this.isNewPortal()) {
            this.addVectorClickListener(BTN_LANG);
            this.addButtonClickListener(BTN_USERCENTER);
            this.addButtonClickListener(BTN_OLDPORTAL);
            this.addVectorClickListener(BTN_SETTING);
            this.addVectorClickListener(BTN_LOGINOUT);
        } else {
            EntryGrid msgentity;
            Label msgtitle;
            Label msgmore;
            EntryGrid entryentity;
            Label notifytitle;
            this.addButtonClickListener(BTN_SETTING);
            this.addButtonClickListener(BTN_LOGINOUT);
            this.addButtonClickListener(BTN_NEWPORTAL);
            this.addVectorClickListener(SVG_SWITCH_TENANT);
            this.addVectorClickListener(SVG_SWITCH_BIZROLE);
            this.addVectorClickListener(SVG_SWITCH_THEME);
            Container servicePanel = (Container)this.getControl(SERVICE_PANEL);
            if (servicePanel != null) {
                servicePanel.addClickListener((ClickListener)this);
            }
            this.addContainerClickListener();
            Label notifymore = (Label)this.getControl(LABEL_NOTIFYMORE);
            if (notifymore != null) {
                notifymore.addClickListener((ClickListener)this);
            }
            if ((notifytitle = (Label)this.getControl(LABEL_NOTIFY_TITLE)) != null) {
                notifytitle.addClickListener((ClickListener)this);
            }
            if ((entryentity = (EntryGrid)this.getControl(NOTIFY_ENTITY)) != null) {
                entryentity.addRowClickListener((RowClickEventListener)this);
            }
            if ((msgmore = (Label)this.getControl(LABEL_MSGMORE)) != null) {
                msgmore.addClickListener((ClickListener)this);
            }
            if ((msgtitle = (Label)this.getControl(LABEL_MSG_TITLE)) != null) {
                msgtitle.addClickListener((ClickListener)this);
            }
            if ((msgentity = (EntryGrid)this.getControl(MSG_ENTITY)) != null) {
                msgentity.addRowClickListener((RowClickEventListener)this);
            }
        }
    }

    private void addContainerClickListener() {
        Container blankPanel;
        Container notifyPanel = (Container)this.getControl(NOTIFY_PANEL);
        if (notifyPanel != null) {
            notifyPanel.addClickListener((ClickListener)this);
        }
        if (null != (blankPanel = (Container)this.getControl(BLANK_PANEL))) {
            blankPanel.addClickListener((ClickListener)this);
        }
    }

    private void addButtonClickListener(String key) {
        Button button = (Button)this.getControl(key);
        if (button != null) {
            button.addClickListener((ClickListener)this);
        }
    }

    private void addVectorClickListener(String key) {
        Vector vector = (Vector)this.getControl(key);
        if (vector != null) {
            vector.addClickListener((ClickListener)this);
        }
    }

    public void customEvent(CustomEventArgs e) {
        if ("afterShowSlideBill".equals(e.getKey())) {
            this.initUserInfo();
            if (!this.isNewPortal()) {
                this.getView().showLoading(null, 3000);
                this.initBizRole();
                Image imageUserCenter = (Image)this.getControl(ICON_USER_CENTER);
                if (imageUserCenter != null) {
                    imageUserCenter.setUrl("/icons/pc/other/grzx_yhzx_24_24.png");
                }
                this.showAllMsg();
                this.getView().hideLoading();
            }
        } else if ("langcustomcontrol".equals(e.getKey())) {
            this.switchLang(e.getEventArgs());
        } else if ("themecustomcontrol".equals(e.getKey())) {
            this.switchTheme(e.getEventArgs());
        } else if ("modecustomcontrol".equals(e.getKey())) {
            this.switchAppearanceMode(e.getEventArgs());
        }
    }

    private void switchLang(String args) {
        if (StringUtils.isBlank((CharSequence)args)) {
            return;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        if (map.get("key") == null) {
            return;
        }
        String lang = map.get("key").toString();
        if (StringUtils.isNotBlank((CharSequence)lang)) {
            if (lang.equalsIgnoreCase(RequestContext.get().getLang().name())) {
                return;
            }
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(lang, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u8bed\u8a00\u9700\u8981\u5237\u65b0\u540e\u751f\u6548\uff0c\u662f\u5426\u5237\u65b0\uff1f", (String)"PersonalSettingNewPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, callBackListener);
        }
    }

    private void switchAppearanceMode(String args) {
        if (StringUtils.isBlank((CharSequence)args)) {
            return;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        if (map.get("key") == null) {
            return;
        }
        String mode = map.get("key").toString();
        this.personalSettingService.modifyAppearanceMode(RequestContext.get().getCurrUserId(), mode);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("setAppearanceMode", (Object)mode);
        CustomControl customControl = (CustomControl)this.getControl("modecustomcontrol");
        customControl.setData((Object)mode);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.No == evt.getResult()) {
            return;
        }
        this.switchLanguage(evt.getCallBackId());
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> mpURL = new HashMap<String, String>(2);
        RequestContext context = RequestContext.get();
        mpURL.put("url", context.getClientFullContextPath());
        mpURL.put("openStyle", "0");
        proxy.addAction("openUrl", mpURL);
    }

    private void switchLanguage(String sysLang) {
        RequestContext rc = RequestContext.get();
        if (rc == null) {
            return;
        }
        if (!sysLang.equals(rc.getLang().name())) {
            boolean needChange = false;
            String sessionId = rc.getTenantCode();
            Account currentCenter = AccountUtils.getCorrectAccount((String)rc.getAccountId(), (String)sessionId);
            List languageList = LanguageService.getAllLanguage((Account)currentCenter);
            for (Language langObj : languageList) {
                if (!sysLang.equalsIgnoreCase(langObj.getNumber())) continue;
                needChange = true;
                break;
            }
            if (needChange) {
                sessionId = rc.getGlobalSessionId();
                SessionManager.editSessionValue((String)sessionId, (String)"language", (String)sysLang);
            }
        }
    }

    private void initBizRole() {
        String userIdStr = RequestContext.get().getUserId();
        Long userId = Long.valueOf(userIdStr);
        String selBizRole = UserBizRoleCache.getSelBizRole((Long)userId);
        if (selBizRole.equals("")) {
            this.getModel().setValue(BIZROLE, (Object)ResManager.loadKDString((String)"\u65e0", (String)"PersonalSettingPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Long bizRoleId = Long.valueOf(selBizRole);
        DynamicObject bizRole = BusinessDataServiceHelper.loadSingle((Object)bizRoleId, (String)PERM_BUSIROLE);
        String bizRoleName = bizRole.get("name").toString();
        this.getModel().setValue(BIZROLE, (Object)bizRoleName);
    }

    private void initUserInfo() {
        QFilter enableFilter;
        String selectFields = "id, name, picturefield, ispartjob, dpt, position,entryentity";
        String userIdStr = RequestContext.get().getUserId();
        long userId = Long.parseLong(userIdStr);
        QFilter idFilter = new QFilter("id", "=", (Object)userId);
        QFilter[] filters = new QFilter[]{idFilter, enableFilter = new QFilter(ENABLE, "=", (Object)Boolean.TRUE)};
        DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)selectFields, (QFilter[])filters);
        if (userObj == null) {
            this.getModel().setValue("user", (Object)RequestContext.get().getUserName());
            return;
        }
        Image icon = (Image)this.getControl("icon");
        String imageUrl = ImageUtil.getCurrentUserAvatarPath(true);
        icon.setUrl(imageUrl);
        this.getModel().setValue("user", (Object)userObj.getString("name"));
        DynamicObjectCollection entryCol = userObj.getDynamicObjectCollection("entryentity");
        if (entryCol != null && !entryCol.isEmpty()) {
            for (DynamicObject entry : entryCol) {
                if (entry.getBoolean("ispartjob")) continue;
                DynamicObject dpt = entry.getDynamicObject("dpt");
                if (dpt == null) break;
                this.setOrgPageCache(dpt);
                this.getModel().setValue("mainorg", dpt.get("name"));
                break;
            }
        }
        this.getModel().setValue("proverbs", (Object)this.genProverbs());
        this.getModel().setValue("account", (Object)this.getAccountName());
        DynamicObject[] theme = this.getEnableThemeListSort();
        Boolean visible = YZJSpecialEditionUtils.isOpenYunzhiJiaSetting() == false;
        this.getView().setVisible(visible, new String[]{"flexpanelap112"});
        this.initTheme(theme);
        if (this.isNewPortal()) {
            this.initLang();
            this.initAppearanceMode();
        }
        Integer type = this.getType(userId);
        this.initOrg(userId);
        this.initBusPartner(type);
    }

    private void setOrgPageCache(DynamicObject dpt) {
        this.getPageCache().put("mainOrg", dpt.getString("id"));
        if (dpt.get("name") instanceof LocaleString) {
            this.getPageCache().put("mainOrgName", dpt.getLocaleString("name").getLocaleValue());
            return;
        }
        this.getPageCache().put("mainOrgName", dpt.getString("name"));
    }

    private void initAppearanceMode() {
        long userId = RequestContext.get().getCurrUserId();
        String mode = this.personalSettingService.getAppearanceMode(userId);
        if (StringUtils.isNotBlank((CharSequence)mode)) {
            CustomControl customControl = (CustomControl)this.getControl("modecustomcontrol");
            customControl.setData((Object)mode);
        }
    }

    protected DynamicObject[] getEnableThemeListSort() {
        QFilter[] themeFilters = new QFilter[]{new QFilter(ENABLE, "=", (Object)"1")};
        DynamicObject[] theme = BusinessDataServiceHelper.load((String)"bas_uitheme", (String)"id,number, name, version,thumbnail,color,background,content,isdefault", (QFilter[])themeFilters, (String)"createtime");
        return theme;
    }

    private Integer getType(Long userId) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        Map types = UserServiceHelper.getUserBaseTypeByIds(userIds);
        if (types != null && types.size() > 0) {
            Integer type = (Integer)types.get(userId);
            return type;
        }
        return null;
    }

    private void bizRoleDisplay() {
        Map paramMap = BaseAppParameterServiceHelper.getParameterFromCache();
        Object isEnableSingleBizRole = paramMap.get("isenablesinglebizrole");
        if (isEnableSingleBizRole == null || !Boolean.parseBoolean(isEnableSingleBizRole.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap113"});
        }
    }

    private String genProverbs() {
        QFilter[] filters;
        QFilter f1;
        QFilter f;
        Object tabKey = null;
        try {
            tabKey = SystemParamServiceHelper.getPublicParameter((String)"hide_proverbs");
        }
        catch (Exception e) {
            logger.info("SystemParamServiceHelper.getPublicParamete:", (Object)e);
        }
        if (tabKey instanceof Boolean && ((Boolean)tabKey).booleanValue()) {
            return null;
        }
        DynamicObject[] provObj = null;
        String selectProperties = DESCRIPTION;
        SecureRandom r = new SecureRandom();
        Calendar c = Calendar.getInstance();
        int hour = c.get(11);
        String[] proverbs = null;
        if (hour >= 6 && hour < 12) {
            f = new QFilter(GROUP_NUMBER, "=", (Object)"morning");
            f1 = new QFilter(ENABLE, "=", (Object)"1");
            filters = new QFilter[]{f, f1};
            provObj = BusinessDataServiceHelper.load((String)ENTITY_ID_PROVERBS, (String)selectProperties, (QFilter[])filters);
        } else if (hour == 12) {
            f = new QFilter(GROUP_NUMBER, "=", (Object)"noon");
            f1 = new QFilter(ENABLE, "=", (Object)"1");
            filters = new QFilter[]{f, f1};
            provObj = BusinessDataServiceHelper.load((String)ENTITY_ID_PROVERBS, (String)selectProperties, (QFilter[])filters);
        } else if (hour >= 13 && hour < 18) {
            f = new QFilter(GROUP_NUMBER, "=", (Object)"afternoon");
            f1 = new QFilter(ENABLE, "=", (Object)"1");
            filters = new QFilter[]{f, f1};
            provObj = BusinessDataServiceHelper.load((String)ENTITY_ID_PROVERBS, (String)selectProperties, (QFilter[])filters);
        } else {
            f = new QFilter(GROUP_NUMBER, "=", (Object)"night");
            f1 = new QFilter(ENABLE, "=", (Object)"1");
            filters = new QFilter[]{f, f1};
            provObj = BusinessDataServiceHelper.load((String)ENTITY_ID_PROVERBS, (String)selectProperties, (QFilter[])filters);
        }
        if (provObj == null || provObj.length == 0) {
            return null;
        }
        proverbs = new String[provObj.length];
        for (int i = 0; i < provObj.length; ++i) {
            proverbs[i] = provObj[i].getString(DESCRIPTION);
        }
        if (proverbs.length == 1) {
            return proverbs[0];
        }
        return proverbs[r.nextInt(proverbs.length)];
    }

    private void initOrg(long userId) {
        boolean isSingOrg;
        boolean bl = isSingOrg = OrgUnitServiceHelper.getOrgmanageMode() == 1;
        if (isSingOrg) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap111"});
            return;
        }
        Long newOrgId = UserHasPermOrgCache.processChangeLoginOrg((String)String.valueOf(userId), null);
        if (newOrgId != null && !newOrgId.equals(0L)) {
            DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((Object)newOrgId, (String)"bos_org", (String)"name");
            if (orgObj != null) {
                this.getModel().setValue("org", (Object)orgObj.getLocaleString("name"));
                this.getPageCache().put("org", orgObj.getPkValue().toString());
            }
            return;
        }
        long curLoginOrgId = RequestContext.get().getOrgId();
        newOrgId = UserHasPermOrgCache.resetHasPermLoginOrg((long)userId, (Long)curLoginOrgId);
        if (newOrgId == null && curLoginOrgId != 0L) {
            newOrgId = curLoginOrgId;
        }
        if (newOrgId != null && !newOrgId.equals(0L)) {
            DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((Object)newOrgId, (String)"bos_org", (String)"name");
            if (orgObj != null) {
                this.getModel().setValue("org", (Object)orgObj.getLocaleString("name"));
                this.getPageCache().put("org", orgObj.getPkValue().toString());
            }
        } else {
            this.getModel().setValue("org", (Object)"");
            this.getPageCache().put("org", "");
        }
    }

    private void initBusPartner(Integer type) {
        boolean enableSwitchBizPartner = false;
        try {
            SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
            Object enable_switch_bizpartner = systemParamService.loadPublicParameterFromCache("enable_switch_bizpartner");
            if (enable_switch_bizpartner != null && Boolean.parseBoolean(enable_switch_bizpartner.toString())) {
                enableSwitchBizPartner = true;
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Object)e);
        }
        if (!enableSwitchBizPartner || "100".equals(String.valueOf(type))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelbuspartner"});
            return;
        }
        String name = PortalUserUtils.getBusPartnerName(RequestContext.get().getBizPartnerId());
        if (StringUtils.isNotBlank((CharSequence)name)) {
            this.getModel().setValue("buspartner", (Object)name);
        }
    }

    private String getAccountName() {
        Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        if (account != null) {
            return account.getAccountName();
        }
        return "";
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            String key;
            Control c = (Control)evt.getSource();
            switch (key = c.getKey()) {
                case "btn_setting": {
                    this.showPersonInformationFrom();
                    if (!this.isNewPortal()) break;
                    this.closePersonalCenter();
                    break;
                }
                case "btn_about": {
                    this.showAboutForm();
                    if (!this.isNewPortal()) break;
                    this.closePersonalCenter();
                    break;
                }
                case "btn_loginout": {
                    this.loginout();
                    break;
                }
                case "btn_newportal": {
                    this.switchPortal(true);
                    break;
                }
                case "btn_oldportal": {
                    this.switchPortal(false);
                    break;
                }
                case "svg_switchtenant": {
                    this.showSwitchTenant();
                    break;
                }
                case "svg_switchorg": {
                    this.showSwitchOrg();
                    break;
                }
                case "svg_switchbuspartner": {
                    this.showSwitchBusPartner();
                    break;
                }
                case "svg_switchbizrole": {
                    this.showSwitchBizRole();
                    break;
                }
                case "notifymore": {
                    this.showTaskForm(0L, 1);
                    break;
                }
                case "notifytitlelabel1": {
                    this.showTaskForm(0L, 1);
                    break;
                }
                case "msgmore": {
                    this.showTaskForm(0L, 2);
                    break;
                }
                case "msgtitlelabel1": {
                    this.showTaskForm(0L, 2);
                    break;
                }
                case "servicepanel": 
                case "btn_usercenter": {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u65e0\u6cd5\u767b\u5f55\u7528\u6237\u4e2d\u5fc3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonalSettingPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OK);
                    break;
                }
                case "blankpanel": {
                    this.getView().executeClientCommand(CLIENT_COMMAND_BILL_CLOSE, new Object[]{BILL_PERSONAL_INFO_ID});
                    break;
                }
            }
        }
    }

    private void closePersonalCenter() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> o1 = new HashMap<String, Object>(1);
        o1.put("formId", "bos_portal_personalcenter");
        o1.put("show", Boolean.FALSE);
        proxy.addAction("showSlideBill", o1);
    }

    private void setToolTips() {
        HashMap<String, String> settingMap = new HashMap<String, String>();
        settingMap.put("title", ResManager.loadKDString((String)"\u8bbe\u7f6e", (String)"PersonalSettingNewPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        this.getView().updateControlMetadata(BTN_SETTING, settingMap);
        HashMap<String, String> logoutMap = new HashMap<String, String>();
        logoutMap.put("title", ResManager.loadKDString((String)"\u9000\u51fa", (String)"PersonalSettingNewPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        this.getView().updateControlMetadata(BTN_LOGINOUT, logoutMap);
        HashMap<String, String> langMap = new HashMap<String, String>();
        langMap.put("title", ResManager.loadKDString((String)"\u5207\u6362\u8bed\u8a00", (String)"PersonalSettingNewPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        this.getView().updateControlMetadata("langcustomcontrol", langMap);
        HashMap<String, String> orgMap = new HashMap<String, String>();
        orgMap.put("title", ResManager.loadKDString((String)"\u5207\u6362\u7ec4\u7ec7", (String)"PersonalSettingNewPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        this.getView().updateControlMetadata(SVG_SWITCH_ORG, orgMap);
        HashMap<String, String> buspartnerMap = new HashMap<String, String>();
        buspartnerMap.put("title", ResManager.loadKDString((String)"\u5207\u6362\u5546\u52a1\u4f19\u4f34", (String)"PersonalSettingNewPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        this.getView().updateControlMetadata(SVG_SWITCH_BUSPARTNER, buspartnerMap);
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry cardEntry = (CardEntry)evt.getSource();
        if (NOTIFY_ENTITY.equals(cardEntry.getEntryKey())) {
            DynamicObject taskObj = this.getModel().getEntryRowEntity(NOTIFY_ENTITY, evt.getRow());
            long taskId = 0L;
            if (taskObj != null) {
                taskId = taskObj.getLong("taskid");
            }
            this.showTaskForm(taskId, 1);
        } else {
            DynamicObject msgObj = this.getModel().getEntryRowEntity(MSG_ENTITY, evt.getRow());
            long messageId = 0L;
            if (msgObj != null) {
                messageId = msgObj.getLong("messageid");
            }
            this.showTaskForm(messageId, 2);
        }
    }

    private void showPersonInformationFrom() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_personalsettings");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("orgName", (Object)this.getPageCache().get("mainOrgName"));
        parameter.setCustomParam("org", (Object)this.getPageCache().get("org"));
        parameter.setCustomParam("mainOrg", (Object)this.getPageCache().get("mainOrg"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "personInfo");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void showAboutForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_portal_about_new");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        parameter.setShowClose(false);
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        if (modelType == 2 || modelType == 4) {
            StyleCss styleCss = new StyleCss();
            styleCss.setHeight("456px");
            parameter.getOpenStyle().setInlineStyleCss(styleCss);
        } else {
            int count = VersionService.getVersionCount();
            boolean oemEnv = DevVerifyServiceHelper.isOEMEnv();
            if (oemEnv || ModeTypeUtils.isEducation() || count < 2) {
                StyleCss styleCss = new StyleCss();
                styleCss.setHeight("346px");
                parameter.getOpenStyle().setInlineStyleCss(styleCss);
            }
        }
        this.getView().showForm(parameter);
    }

    private void loginout() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> mpURL = new HashMap<String, String>();
        String logoutUrl = "auth/logout.do";
        if (RequestContext.get() != null && RequestContext.get().getLang() != null) {
            logoutUrl = logoutUrl + "?language=" + RequestContext.get().getLang().name();
        }
        mpURL.put("url", logoutUrl);
        mpURL.put("openStyle", "0");
        proxy.addAction("openUrl", mpURL);
    }

    private void switchPortal(boolean isNewPortal) {
        NewPortalUtils.refreshPortal(this.getView(), isNewPortal);
    }

    private void showSwitchTenant() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("pc_main_switchtenant");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SVG_SWITCH_TENANT);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void showSwitchBusPartner() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bd_bizpartner", (boolean)false, (int)0, (boolean)true);
        parameter.setFormId("pc_main_switchpartner");
        parameter.setCaption(ResManager.loadKDString((String)"\u5207\u6362\u5546\u52a1\u4f19\u4f34", (String)"PersonalSettingPlugin_18", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SVG_SWITCH_BUSPARTNER);
        parameter.setCloseCallBack(closeCallBack);
        long lUserId = Long.parseLong(RequestContext.get().getUserId());
        List ids = UserServiceHelper.getBizPartnerByUserId((long)lUserId);
        this.setSwitchBusPartnerFilters(parameter, ids);
        this.setSelectedBusPartner(parameter, ids);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showSwitchOrg() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)false, (int)0, (boolean)true);
        parameter.setFormId("pc_main_switchorg");
        parameter.setCaption(ResManager.loadKDString((String)"\u5207\u6362\u7ec4\u7ec7", (String)"PersonalSettingPlugin_20", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SVG_SWITCH_ORG);
        parameter.setCloseCallBack(closeCallBack);
        this.setSwitchOrgFilters(parameter);
        this.setSelectedOrg(parameter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showSwitchBizRole() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)PERM_BUSIROLE, (boolean)false, (int)0, (boolean)true);
        parameter.setFormId("perm_switchbizrole");
        parameter.setCaption(ResManager.loadKDString((String)"\u5207\u6362\u4e1a\u52a1\u89d2\u8272", (String)PERSONAL_SETTING_PLUGIN_6, (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SVG_SWITCH_BIZROLE);
        parameter.setCloseCallBack(closeCallBack);
        this.setSwitchBizRoleFilters(parameter);
        this.setSelectedBizRole(parameter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void setSwitchOrgFilters(ListShowParameter parameter) {
        List qFilters = parameter.getListFilterParameter().getQFilters();
        long lUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)lUserId, (boolean)true);
        QFilter orgFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
        qFilters.add(orgFilter);
        ArrayList<Long> list = new ArrayList<Long>(2);
        list.add(15L);
        QFilter viewFilter = new QFilter("structure.view", "in", list);
        qFilters.add(viewFilter);
    }

    private void setSwitchBusPartnerFilters(ListShowParameter parameter, List<Long> ids) {
        List qFilters = parameter.getListFilterParameter().getQFilters();
        QFilter filter = new QFilter("id", "in", ids);
        qFilters.add(filter);
    }

    private void setSwitchBizRoleFilters(ListShowParameter parameter) {
        List qFilters = parameter.getListFilterParameter().getQFilters();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        QFilter bizRoleFilter = new QFilter("id", "in", (Object)UserBizRoleCache.getUserBizRoles((Long)userId));
        qFilters.add(bizRoleFilter);
    }

    private void setSelectedOrg(ListShowParameter parameter) {
        long orgId = RequestContext.get().getOrgId();
        if (orgId == 0L) {
            return;
        }
        QFilter orgFilter = new QFilter("id", "=", (Object)orgId);
        ArrayList<Long> list = new ArrayList<Long>(2);
        list.add(15L);
        list.add(1L);
        QFilter viewFilter = new QFilter("structure.view", "in", list);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])filters);
        if (dynamicObject == null) {
            return;
        }
        parameter.setSelectedRow(dynamicObject.getPkValue());
    }

    private void setSelectedBusPartner(ListShowParameter parameter, List<Long> ids) {
        Long busPartnerId = RequestContext.get().getBizPartnerId();
        logger.info("\u4e0a\u4e0b\u6587\u5546\u52a1\u4f19\u4f34id\uff1a" + busPartnerId);
        if (busPartnerId == null || !ids.contains(busPartnerId)) {
            return;
        }
        parameter.setSelectedRow((Object)busPartnerId);
    }

    private void setSelectedBizRole(ListShowParameter parameter) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String selBizRole = UserBizRoleCache.getSelBizRole((Long)userId);
        if (selBizRole.equals("")) {
            UserBizRoleCache.setSelBizRole((Long)userId, null);
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(selBizRole))};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)PERM_BUSIROLE, (String)BIZROLE, (QFilter[])filters);
        if (dynamicObject == null) {
            return;
        }
        parameter.setSelectedRow(dynamicObject.getPkValue());
    }

    @Deprecated
    public void showSwitchThemePanel(boolean isVisible) {
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"switchthemepanel"});
        this.getPageCache().put(SWITCHTHEMEPANEL_SHOW, isVisible ? "1" : "0");
    }

    private void showAllMsg() {
        this.sendNotificationAction();
        this.sendMessageAction();
    }

    private void sendNotificationAction() {
        Image image = (Image)this.getControl(KEY_MARK_IMAGE);
        image.setUrl(LOADING_IMAGE_URL);
        this.getView().setVisible(Boolean.FALSE, new String[]{"taskflexpanelap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"markpanel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_MARK_LOADING_PANEL});
        this.sendAction("showNotification");
    }

    private void showNotification() {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_MARK_LOADING_PANEL});
        String userId = RequestContext.get().getUserId();
        List notifyList = MessageCenterServiceHelper.getToHandleTasksMessage((Long)Long.valueOf(userId), (Integer)5);
        if (notifyList == null || notifyList.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"taskflexpanelap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"markpanel"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"taskflexpanelap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"markpanel"});
            this.clearOldNotify(NOTIFY_ENTITY);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("taskid", new Object[0]);
            vs.addField("notifytitle", new Object[0]);
            vs.addField("notification", new Object[0]);
            vs.addField("notifydate", new Object[0]);
            for (Map notifyMap : notifyList) {
                Object notifydate;
                String notification = String.valueOf(notifyMap.get(CONTENT));
                notification = this.replaceHtmlLabel(notification);
                Object handlestate = notifyMap.get("handlestate");
                if (handlestate != null) {
                    notification = notification + " " + handlestate;
                }
                if ((notifydate = notifyMap.get("time")) instanceof Date) {
                    notifydate = TaskAndMsgUtil.caculateTime((Date)notifydate);
                }
                vs.addRow(new Object[]{notifyMap.get("id"), notifyMap.get("title"), notification, notifydate});
            }
            model.batchCreateNewEntryRow(NOTIFY_ENTITY, vs);
            model.endInit();
            this.getView().updateView(NOTIFY_ENTITY);
        }
    }

    private void sendAction(String name) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("name", name);
        param.put("duration", 0);
        param.put("async", Boolean.TRUE);
        proxy.addAction("addClientCallBack", param);
    }

    private String replaceHtmlLabel(String content) {
        int labelIndex = content.indexOf(HTML_NEWLINE_LABEL);
        if (labelIndex == -1) {
            return content;
        }
        if (labelIndex == 0) {
            return this.replaceHtmlLabel(content.substring(HTML_NEWLINE_LABEL.length()));
        }
        return StringUtils.substringBefore((String)content, (String)HTML_NEWLINE_LABEL) + HTML_MORE_LABEL;
    }

    private void sendMessageAction() {
        Image icon = (Image)this.getControl(KEY_MSG_IMAGE);
        icon.setUrl(LOADING_IMAGE_URL);
        this.getView().setVisible(Boolean.FALSE, new String[]{"msgflexpanelap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{NOMSG_PANEL});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_MSG_LOADING_PANEL});
        this.sendAction("showMessage");
    }

    private void showMessage() {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_MSG_LOADING_PANEL});
        String userId = RequestContext.get().getUserId();
        List messageList = MessageCenterServiceHelper.getUnReadMessage((String)userId, (int)5);
        if (messageList == null || messageList.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"msgflexpanelap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{NOMSG_PANEL});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"msgflexpanelap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{NOMSG_PANEL});
            this.clearOldNotify(MSG_ENTITY);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("messageid", new Object[0]);
            vs.addField("msgtitle", new Object[0]);
            vs.addField("message", new Object[0]);
            vs.addField("msgdate", new Object[0]);
            for (Map messageMap : messageList) {
                Object notifydate;
                String notification = String.valueOf(messageMap.get(CONTENT));
                notification = this.replaceHtmlLabel(notification);
                Object handlestate = messageMap.get("handlestate");
                if (handlestate != null) {
                    notification = notification + " " + handlestate;
                }
                if ((notifydate = messageMap.get("createdate")) instanceof Date) {
                    notifydate = TaskAndMsgUtil.caculateTime((Date)notifydate);
                }
                vs.addRow(new Object[]{messageMap.get("id"), messageMap.get("title"), notification, notifydate});
            }
            model.batchCreateNewEntryRow(MSG_ENTITY, vs);
            model.endInit();
            this.getView().updateView(MSG_ENTITY);
        }
    }

    private void clearOldNotify(String entryentityName) {
        this.getModel().deleteEntryData(entryentityName);
    }

    private void showTaskForm(long id, int personCenterOpenType) {
        if (this.getView().getMainView() == null) {
            this.getView().openUrl("#/dform?formId=wf_msg_center");
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>();
        paramMap.put("close", Boolean.TRUE);
        proxy.addAction("showSlideBill", paramMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("view", this.getView());
        map.put("appmainnumber", WF_TASKCENTERHOME);
        map.put("appname", AppMetadataCache.getAppInfo((String)"wftask").getName());
        HashMap<String, Number> customparameters = new HashMap<String, Number>(2);
        customparameters.put("tabType", personCenterOpenType);
        customparameters.put("messageId", id);
        map.put("customparameters", customparameters);
        OpenPageUtils.openApp("wftask", null, map, this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map) {
            Map map = (Map)returnData;
            switch (key) {
                case "svg_switchtenant": {
                    this.getModel().setValue("account", map.get("name"));
                    break;
                }
                case "svg_switchorg": {
                    this.switchOrg(map);
                    break;
                }
                case "svg_switchbuspartner": {
                    this.switchBusPartner(map);
                    break;
                }
                case "svg_switchbizrole": {
                    this.switchBizRole(map);
                    break;
                }
                case "svg_switchtheme": {
                    break;
                }
                case "personInfo": {
                    this.updateUserImage(map);
                    break;
                }
            }
        }
    }

    private void updateUserImage(Map<String, Object> map) {
        Object userImage = map.get("userImage");
        String image = userImage == null ? ImageUtil.getCurrentUserAvatarPath(true) : ImageUtil.getFullImageUrl(userImage.toString());
        Image icon = (Image)this.getControl("icon");
        icon.setUrl(image);
        this.getView().updateView("icon");
        IFormView mainView = this.getView().getMainView();
        this.updateIconImage(mainView, image, "usericon");
        this.updateIconImage(mainView, image, "newusericon");
        this.updateIconImage(mainView, image, "usericonbrandup");
        this.getView().sendFormAction(mainView);
    }

    private void updateIconImage(IFormView formView, String image, String icon) {
        Image usericon = (Image)formView.getControl(icon);
        if (usericon != null) {
            usericon.setUrl(image);
            formView.updateView(icon);
        }
    }

    private void switchOrg(Map<String, Object> returnData) {
        long orgId = (Long)returnData.get("orgId");
        boolean setDefault = (Boolean)returnData.get("setDefault");
        if (setDefault) {
            UserServiceHelper.setUserDefaultOrg((long)Long.parseLong(RequestContext.get().getUserId()), (long)orgId);
        }
        UserServiceHelper.switchUserDefaultOrg((long)orgId);
        this.getModel().setValue("org", returnData.get("orgName"));
        this.getPageCache().put("org", orgId + "");
    }

    private void switchBusPartner(Map<String, Object> returnData) {
        long busPartnerId = (Long)returnData.get("busPartnerId");
        boolean setDefault = (Boolean)returnData.get("setDefault");
        if (setDefault) {
            try {
                this.setUserDefaultBusPartner(Long.parseLong(RequestContext.get().getUserId()), busPartnerId);
            }
            catch (Exception exception) {
                logger.info("\u5207\u6362\u5546\u52a1\u4f19\u4f34\u5e76\u8bbe\u4e3a\u9ed8\u8ba4\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Object)exception.getMessage());
                this.getView().showMessage(ResManager.loadKDString((String)"\u5207\u6362\u5546\u52a1\u4f19\u4f34\u5931\u8d25\u3002", (String)"PersonalSettingPlugin_19", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
        } else {
            SessionManager.editSessionValue((String)RequestContext.get().getGlobalSessionId(), (String)"bizPartnerId", (String)String.valueOf(busPartnerId));
        }
        this.getModel().setValue("buspartner", returnData.get("busPartnerName"));
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("f5Refresh", null);
    }

    private void setUserDefaultBusPartner(long userID, long defaultId) throws Exception {
        DynamicObject defaultBusPartnerObj = PortalUserUtils.loadUserDefaultBusPartner(userID);
        if (defaultBusPartnerObj == null) {
            defaultBusPartnerObj = BusinessDataServiceHelper.newDynamicObject((String)"bas_userdefaultorg");
            defaultBusPartnerObj.set("user", (Object)userID);
        }
        defaultBusPartnerObj.set("bizpartner", (Object)defaultId);
        DynamicObject[] dataEntities = new DynamicObject[]{defaultBusPartnerObj};
        try (TXHandle h = TX.beginRequired();){
            try {
                SaveServiceHelper.save((DynamicObject[])dataEntities);
                SessionManager.editSessionValue((String)RequestContext.get().getGlobalSessionId(), (String)"bizPartnerId", (String)String.valueOf(defaultId));
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void initLang() {
        List enabledLangs = InteServiceHelper.getEnabledLang();
        CustomControl customControl = (CustomControl)this.getControl("langcustomcontrol");
        ArrayList items = new ArrayList(enabledLangs.size());
        String selectNum = RequestContext.get().getLang().name();
        for (EnabledLang enabledLang : enabledLangs) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            String number = enabledLang.getNumber();
            LocaleString name = new LocaleString(enabledLang.getName());
            map.put("id", number);
            map.put("text", name);
            boolean isSelect = false;
            if (selectNum != null && selectNum.equals(number)) {
                isSelect = true;
            }
            map.put("isSelected", isSelect);
            items.add(map);
        }
        customControl.setData(items);
    }

    private void switchBizRole(Map<String, Object> returnData) {
        Long bizRoleId = (Long)returnData.get("bizRoleId");
        if (bizRoleId != null) {
            DynamicObject bizRole = BusinessDataServiceHelper.loadSingle((Object)bizRoleId, (String)PERM_BUSIROLE);
            String bizRoleName = bizRole.get("name").toString();
            this.getModel().setValue(BIZROLE, (Object)bizRoleName);
        }
    }
}

