/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew.common;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.TileItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.TilePanel;
import kd.bos.ext.metadata.form.control.TilePanelAp;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TileItemClickEvent;
import kd.bos.form.control.events.TileItemClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.service.PortalMenuService;
import kd.bos.portal.util.PortalUsableFuncUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public abstract class PortalCollectSetAbstract
extends AbstractFormPlugin
implements TreeNodeClickListener,
TileItemClickListener {
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static Log logger = LogFactory.getLog(PortalCollectSetAbstract.class);
    public static final String PGCACHE_MARKEDAPPMENU = "pagecache_markeAppMenu";
    public static final String PGCACHE_MARKEDAPPMENU_FINAL = "pagecache_markeAppMenu_final";
    private static final String TREEVIEW = "cloudapptreeview";
    private static final String ROOT = "root#";
    private static final String MARKEDMENU_NODE = "markedmenu#";
    private static final String PREFIX_CLOUD = "cloud#";
    private static final String BUTTON_SAVE = "button_save";
    private static final String CONTROLKEY = "tilepanel";
    public static final String PGCACHE_COUNT = "pagecache_count";
    private PortalMenuService menuService;

    public abstract String getLabelCountKey();

    public abstract boolean isNewPortal();

    public abstract void setLabelCount(int var1);

    public void initialize() {
        this.menuService = new PortalMenuService(this.getPageCache());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{BUTTON_SAVE});
        if (this.isNewPortal()) {
            this.addClickListeners(new String[]{this.getLabelCountKey()});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        int sum = 0;
        this.getPageCache().put(PGCACHE_MARKEDAPPMENU, SerializationUtils.toJsonString((Object)customParams));
        if (customParams != null && !customParams.isEmpty()) {
            for (Map.Entry entry : customParams.entrySet()) {
                List menus = (List)SerializationUtils.fromJsonString((String)customParams.get(entry.getKey()).toString(), List.class);
                if (menus == null || menus.isEmpty()) continue;
                sum += menus.size();
            }
            this.setLabelCount(sum);
            this.getPageCache().put(PGCACHE_COUNT, String.valueOf(sum));
        }
        this.initialCloudAppTree(sum);
    }

    private void initialCloudAppTree(int countOfMarkedMenus) {
        String langName = RequestContext.get().getLang().name();
        PortalUsableFuncUtil portalUtil = new PortalUsableFuncUtil(logger, this.getView());
        JSONArray resultApps = portalUtil.getUserHasPerAppWithCache();
        if (resultApps == null || resultApps.isEmpty()) {
            return;
        }
        TreeNode rootNode = new TreeNode("", ROOT, ResManager.loadKDString((String)"\u529f\u80fd\u6811", (String)"PortalSetCommonFuncPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        treeView.addNode(rootNode);
        TreeNode markedNode = null;
        if (!this.isNewPortal()) {
            String text = String.format(ResManager.loadKDString((String)"\u5df2\u9009\uff08%s\uff09", (String)"PortalSetCommonFuncPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), countOfMarkedMenus);
            markedNode = new TreeNode(ROOT, MARKEDMENU_NODE, text, false);
            rootNode.addChild(markedNode);
        }
        TreeNode cloudNode = new TreeNode();
        TreeNode appNode = null;
        TreeNode firstAppNode = null;
        HashMap<String, Integer> sortAppMap = new HashMap<String, Integer>();
        int k = 1;
        block0: for (int i = 0; i < resultApps.size(); ++i) {
            JSONArray cloudAppItem = (JSONArray)resultApps.get(i);
            for (int j = 0; j < cloudAppItem.size(); ++j) {
                String name;
                Object item = cloudAppItem.get(j);
                Map itemMap = null;
                if (item instanceof Map) {
                    itemMap = (Map)item;
                }
                if (itemMap == null) continue;
                Boolean isCloud = (Boolean)itemMap.get("iscloud");
                if (isCloud == null || !isCloud.booleanValue()) {
                    String parentId = itemMap.get("cloudid") == null ? null : itemMap.get("cloudid").toString().toLowerCase();
                    String appNum = itemMap.get("number") == null ? null : itemMap.get("number").toString();
                    Map nameMap = (Map)itemMap.get("name");
                    String name2 = null;
                    if (nameMap != null) {
                        String string = name2 = nameMap.get(langName) == null ? null : nameMap.get(langName).toString();
                    }
                    if (StringUtils.isEmpty((String)parentId) || StringUtils.isEmpty((String)appNum) || StringUtils.isEmpty((String)name2)) continue;
                    appNode = new TreeNode(parentId, appNum, name2);
                    cloudNode.addChild(appNode);
                    sortAppMap.put(appNum, k++);
                    if (!this.isNewPortal() || i != 0 || j != 1) continue;
                    treeView.focusNode(appNode);
                    firstAppNode = appNode;
                    continue;
                }
                String id = itemMap.get("id") == null ? null : itemMap.get("id").toString().toLowerCase();
                Map nameMap = (Map)itemMap.get("name");
                String string = name = nameMap.get(langName) == null ? null : nameMap.get(langName).toString();
                if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)name)) continue block0;
                cloudNode = new TreeNode(ROOT, PREFIX_CLOUD + id, name);
                if (this.isNewPortal() && i == 0) {
                    cloudNode.setIsOpened(true);
                }
                rootNode.addChild(cloudNode);
            }
        }
        this.getPageCache().put("sortApp", SerializationUtils.toJsonString(sortAppMap));
        treeView.expand(ROOT);
        if (this.isNewPortal()) {
            if (firstAppNode != null) {
                this.treeNodeClick(new TreeNodeEvent((Object)treeView, (Object)ROOT, (Object)firstAppNode.getId()));
            }
        } else {
            treeView.focusNode(markedNode);
            this.treeNodeClick(new TreeNodeEvent((Object)treeView, (Object)ROOT, (Object)MARKEDMENU_NODE));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BUTTON_SAVE.equals(key)) {
            this.saveCommonFunc();
            this.getView().close();
        } else if (this.getLabelCountKey().equals(key)) {
            this.init();
            TreeView treeView = (TreeView)this.getControl(TREEVIEW);
            treeView.focusNode(new TreeNode("", ROOT, ResManager.loadKDString((String)"\u529f\u80fd\u6811", (String)"PortalSetCommonFuncPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])));
        }
    }

    private void saveCommonFunc() {
        String jsonStr;
        Map appMenuMap;
        DynamicObject userMarkedMenu2;
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        ArrayList<String> menuIdList = new ArrayList<String>();
        DynamicObject[] userMarkedMenus = BusinessDataServiceHelper.load((String)"portal_usermarkedmenu", (String)"menu", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
        if (userMarkedMenus != null && userMarkedMenus.length > 0) {
            for (DynamicObject userMarkedMenu2 : userMarkedMenus) {
                String menuId = userMarkedMenu2.getString("menu");
                menuIdList.add(menuId);
            }
        }
        if ((appMenuMap = (Map)SerializationUtils.fromJsonString((String)(jsonStr = this.getPageCache().get(PGCACHE_MARKEDAPPMENU)), Map.class)) == null) {
            return;
        }
        ArrayList<DynamicObject> objectForSave = new ArrayList<DynamicObject>();
        userMarkedMenu2 = null;
        for (Map.Entry entry : appMenuMap.entrySet()) {
            List menuIds = (List)appMenuMap.get(entry.getKey());
            if (menuIds == null || menuIds.isEmpty()) continue;
            for (String menuId : menuIds) {
                if (menuIdList.contains(menuId)) {
                    menuIdList.remove(menuId);
                    continue;
                }
                userMarkedMenu2 = BusinessDataServiceHelper.newDynamicObject((String)"portal_usermarkedmenu");
                userMarkedMenu2.set("user", (Object)userId);
                userMarkedMenu2.set("bizapp", entry.getKey());
                userMarkedMenu2.set("menu", (Object)menuId);
                userMarkedMenu2.set("createtime", (Object)TimeServiceHelper.now());
                objectForSave.add(userMarkedMenu2);
            }
        }
        try (TXHandle h = TX.required();){
            try {
                if (!objectForSave.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])objectForSave.toArray(new DynamicObject[0]));
                }
                if (!menuIdList.isEmpty()) {
                    DeleteServiceHelper.delete((String)"portal_usermarkedmenu", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("menu", "in", menuIdList)});
                }
                if (this.isNewPortal()) {
                    this.getView().getParentView().getPageCache().put(PGCACHE_MARKEDAPPMENU_FINAL, jsonStr);
                }
            }
            catch (Exception e) {
                logger.info("\u8bbe\u7f6e\u5e38\u7528\u529f\u80fd\u83dc\u5355\u5f02\u5e38", (Object)e);
                h.markRollback();
            }
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.equals(CONTROLKEY)) {
            TilePanel tilePanel = new TilePanel();
            tilePanel.setKey(key);
            tilePanel.setView(this.getView());
            tilePanel.addItemClickListener((TileItemClickListener)this);
            e.setControl((Control)tilePanel);
        }
    }

    private void appMenuSort(List<AppMenuInfo> menus, Map<String, List<AppMenuInfo>> parentIdMap, List<AppMenuInfo> sortMenuInfos) {
        menus.forEach(menu -> {
            sortMenuInfos.add((AppMenuInfo)menu);
            List childMenus = (List)parentIdMap.get(menu.getId());
            if (CollectionUtils.isEmpty((Collection)childMenus)) {
                return;
            }
            childMenus.sort(Comparator.comparing(AppMenuInfo::getSeq));
            this.appMenuSort(childMenus, parentIdMap, sortMenuInfos);
        });
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Container c = (Container)this.getControl("menupanel");
        c.deleteControls(new String[]{CONTROLKEY});
        String focusNodeId = evt.getNodeId().toString();
        if (focusNodeId.startsWith(PREFIX_CLOUD)) {
            return;
        }
        TilePanelAp tilePanelAp = new TilePanelAp();
        tilePanelAp.setKey(CONTROLKEY);
        TilePanel tilePanel = (TilePanel)tilePanelAp.buildRuntimeControl();
        tilePanel.setView(this.getView());
        ArrayList<TileItem> data = new ArrayList<TileItem>(10);
        String jsonStr = this.getPageCache().get(PGCACHE_MARKEDAPPMENU);
        Map appMenuMap = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
        if (focusNodeId.equals(MARKEDMENU_NODE)) {
            if (appMenuMap == null || appMenuMap.isEmpty()) {
                return;
            }
            Map sortAppMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("sortApp"), Map.class);
            LinkedHashMap sortAppMenuMap = new LinkedHashMap();
            appMenuMap.entrySet().stream().filter(entry -> sortAppMap.get(entry.getKey()) != null).sorted(Comparator.comparing(entry -> (Integer)sortAppMap.get(entry.getKey()))).forEach(entry1 -> {
                List cfr_ignored_0 = (List)sortAppMenuMap.put(entry1.getKey(), entry1.getValue());
            });
            ArrayList<TileItem> secondMenuItems = null;
            for (Map.Entry entry2 : sortAppMenuMap.entrySet()) {
                AppInfo appInfo;
                String appNum = (String)entry2.getKey();
                List menuList = (List)entry2.getValue();
                try {
                    appInfo = AppMetadataCache.getAppInfo((String)appNum);
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u5e94\u7528\u83b7\u53d6\u4e0d\u5230\u8fd0\u884c\u671f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u662f\u5426\u542f\u7528\u6216\u53ef\u89c1\u3002", (String)"PortalSetCommonFuncPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), appNum));
                    continue;
                }
                List menusInfos = AppMetadataCache.getAppMenusInfoByAppId((String)appNum);
                if (menusInfos == null || menusInfos.isEmpty()) continue;
                Map<String, List<AppMenuInfo>> parentIdMap = menusInfos.stream().collect(Collectors.groupingBy(AppMenuInfo::getParentId));
                List appMenuIdlist = menusInfos.stream().map(AppMenuInfo::getId).collect(Collectors.toList());
                List<AppMenuInfo> rootMenuList = menusInfos.stream().filter(menuInfo -> parentIdMap.keySet().stream().filter(parentMenuId -> !appMenuIdlist.contains(parentMenuId)).collect(Collectors.toList()).contains(menuInfo.getParentId())).collect(Collectors.toList());
                ArrayList<AppMenuInfo> sortMenusInfos = new ArrayList<AppMenuInfo>(menusInfos.size());
                this.appMenuSort(rootMenuList, parentIdMap, sortMenusInfos);
                secondMenuItems = new ArrayList<TileItem>(menuList.size());
                for (AppMenuInfo menusInfo : sortMenusInfos) {
                    String menuId = menusInfo.getId();
                    if (!menuList.contains(menuId)) continue;
                    TileItem tileItem = new TileItem(menuId, menusInfo.getName().getLocaleValue(), true);
                    secondMenuItems.add(tileItem);
                }
                if (secondMenuItems.isEmpty()) continue;
                TileItem tileItem = new TileItem(appNum, appInfo.getName().getLocaleValue(), false, secondMenuItems);
                data.add(tileItem);
            }
            ArrayList<String> fontClass = new ArrayList<String>(2);
            fontClass.add("tupianyulanguanbi");
            fontClass.add("tupianyulanguanbi");
            tilePanel.setFontClass(fontClass);
            tilePanel.setTextClickable(false);
        } else {
            List markedMenus = appMenuMap.get(focusNodeId) == null ? new ArrayList() : (List)appMenuMap.get(focusNodeId);
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            AppInfo appInfo = null;
            try {
                appInfo = AppMetadataCache.getAppInfo((String)focusNodeId);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u5e94\u7528\u83b7\u53d6\u4e0d\u5230\u8fd0\u884c\u671f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u662f\u5426\u542f\u7528\u6216\u53ef\u89c1\u3002", (String)"PortalSetCommonFuncPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), focusNodeId));
                return;
            }
            String appId = appInfo.getId();
            List<AppMenuInfo> menusInfos = this.menuService.getHasPermMenuByAppId(userId, appId, true);
            if (menusInfos == null || menusInfos.isEmpty()) {
                return;
            }
            HashMap<String, List> menuMap = new HashMap<String, List>();
            for (AppMenuInfo menuInfo2 : menusInfos) {
                String parentId = menuInfo2.getParentId();
                String menuId = menuInfo2.getId();
                if (menuId.endsWith("#hpce")) continue;
                if (StringUtils.isEmpty((String)parentId) || parentId.equals(appId)) {
                    menuMap.computeIfAbsent(appId, k -> new ArrayList()).add(menuInfo2);
                    continue;
                }
                menuMap.computeIfAbsent(parentId, k -> new ArrayList()).add(menuInfo2);
            }
            ArrayList<TileItem> secondMenuItems = null;
            List firstMenuList = (List)menuMap.get(appId);
            if (firstMenuList == null || firstMenuList.isEmpty()) {
                return;
            }
            for (AppMenuInfo firstmenuInfo : firstMenuList) {
                List secondMenuList;
                if (firstmenuInfo == null) continue;
                String firstMenuId = firstmenuInfo.getId();
                String formId = firstmenuInfo.getFormId();
                String text = firstmenuInfo.getName().getLocaleValue();
                secondMenuItems = new ArrayList<TileItem>();
                if (StringUtils.isNotEmpty((String)formId)) {
                    secondMenuItems.add(new TileItem(firstMenuId, text, markedMenus.contains(firstMenuId)));
                }
                if ((secondMenuList = (List)menuMap.get(firstMenuId)) != null && !secondMenuList.isEmpty()) {
                    for (AppMenuInfo secondMenuInfo : secondMenuList) {
                        if (secondMenuInfo == null) continue;
                        String secondMenuId = secondMenuInfo.getId();
                        String secondFormId = secondMenuInfo.getFormId();
                        List thirdMenuList = (List)menuMap.get(secondMenuId);
                        if (!CollectionUtils.isEmpty((Collection)thirdMenuList)) {
                            for (AppMenuInfo thirdMenuInfo : thirdMenuList) {
                                if (thirdMenuInfo == null) continue;
                                String thirdMenuId = thirdMenuInfo.getId();
                                String thirdMenuName = thirdMenuInfo.getName().getLocaleValue();
                                String thirdFormId = thirdMenuInfo.getFormId();
                                secondMenuItems.add(new TileItem(thirdMenuId, thirdMenuName, markedMenus.contains(thirdMenuId)));
                            }
                            continue;
                        }
                        String secondMenuName = secondMenuInfo.getName().getLocaleValue();
                        secondMenuItems.add(new TileItem(secondMenuId, secondMenuName, markedMenus.contains(secondMenuId)));
                    }
                }
                TileItem tileItem = new TileItem(firstMenuId, text, false, secondMenuItems);
                data.add(tileItem);
            }
            ArrayList<String> fontClass = new ArrayList<String>(2);
            fontClass.add("xingxing_shixin");
            fontClass.add("xingxing_xianxing");
            tilePanel.setFontClass(fontClass);
            tilePanel.setTextClickable(true);
        }
        tilePanel.setData(data);
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(tilePanelAp.createControl());
        c.addControls(list);
    }

    private void init() {
        Container c = (Container)this.getControl("menupanel");
        c.deleteControls(new String[]{CONTROLKEY});
        TilePanelAp tilePanelAp = new TilePanelAp();
        tilePanelAp.setKey(CONTROLKEY);
        TilePanel tilePanel = (TilePanel)tilePanelAp.buildRuntimeControl();
        tilePanel.setView(this.getView());
        ArrayList<TileItem> data = new ArrayList<TileItem>(10);
        String jsonStr = this.getPageCache().get(PGCACHE_MARKEDAPPMENU);
        Map appMenuMap = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
        if (appMenuMap == null || appMenuMap.isEmpty()) {
            return;
        }
        Map sortAppMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("sortApp"), Map.class);
        LinkedHashMap sortAppMenuMap = new LinkedHashMap();
        appMenuMap.entrySet().stream().filter(entry -> sortAppMap.get(entry.getKey()) != null).sorted(Comparator.comparing(entry -> (Integer)sortAppMap.get(entry.getKey()))).forEach(entry1 -> {
            List cfr_ignored_0 = (List)sortAppMenuMap.put(entry1.getKey(), entry1.getValue());
        });
        ArrayList<TileItem> secondMenuItems = null;
        for (Map.Entry entry2 : sortAppMenuMap.entrySet()) {
            AppInfo appInfo;
            String appNum = (String)entry2.getKey();
            List menuList = (List)entry2.getValue();
            try {
                appInfo = AppMetadataCache.getAppInfo((String)appNum);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u5e94\u7528\u83b7\u53d6\u4e0d\u5230\u8fd0\u884c\u671f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u662f\u5426\u542f\u7528\u6216\u53ef\u89c1\u3002", (String)"PortalSetCommonFuncPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), appNum));
                continue;
            }
            List menusInfos = AppMetadataCache.getAppMenusInfoByAppId((String)appNum);
            if (menusInfos == null || menusInfos.isEmpty()) continue;
            Map<String, List<AppMenuInfo>> parentIdMap = menusInfos.stream().collect(Collectors.groupingBy(AppMenuInfo::getParentId));
            List appMenuIdlist = menusInfos.stream().map(AppMenuInfo::getId).collect(Collectors.toList());
            List<AppMenuInfo> rootMenuList = menusInfos.stream().filter(menuInfo -> parentIdMap.keySet().stream().filter(parentMenuId -> !appMenuIdlist.contains(parentMenuId)).collect(Collectors.toList()).contains(menuInfo.getParentId())).collect(Collectors.toList());
            ArrayList<AppMenuInfo> sortMenusInfos = new ArrayList<AppMenuInfo>(menusInfos.size());
            this.appMenuSort(rootMenuList, parentIdMap, sortMenusInfos);
            secondMenuItems = new ArrayList<TileItem>(menuList.size());
            for (AppMenuInfo menusInfo : sortMenusInfos) {
                String menuId = menusInfo.getId();
                if (!menuList.contains(menuId)) continue;
                TileItem tileItem = new TileItem(menuId, menusInfo.getName().getLocaleValue(), true);
                secondMenuItems.add(tileItem);
            }
            TileItem tileItem = new TileItem(appNum, appInfo.getName().getLocaleValue(), false, secondMenuItems);
            data.add(tileItem);
        }
        ArrayList<String> fontClass = new ArrayList<String>(2);
        fontClass.add("tupianyulanguanbi");
        fontClass.add("tupianyulanguanbi");
        tilePanel.setFontClass(fontClass);
        tilePanel.setTextClickable(false);
        tilePanel.setData(data);
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(tilePanelAp.createControl());
        c.addControls(list);
    }

    private boolean isFormExist(String formId) {
        if (StringUtils.isEmpty((String)formId)) {
            return false;
        }
        try {
            return FormMetadataCache.getFormConfig((String)formId) != null;
        }
        catch (Exception e) {
            logger.info("getFormConfig", (Object)e);
            return false;
        }
    }

    public void itemClick(TileItemClickEvent evt) {
        String node;
        List params = evt.getParams();
        if (params == null || params.isEmpty()) {
            return;
        }
        ClientViewProxy proxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        String menuId = (String)params.get(params.size() - 1);
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        String sumStr = this.getPageCache().get(PGCACHE_COUNT);
        if (StringUtils.isEmpty((String)sumStr)) {
            sumStr = "0";
        }
        int sum = Integer.parseInt(sumStr);
        String jsonStr = this.getPageCache().get(PGCACHE_MARKEDAPPMENU);
        Map appMenuMap = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
        String string = node = this.isNewPortal() ? ROOT : MARKEDMENU_NODE;
        if (focusNodeId.equals(node)) {
            String appNum = (String)params.get(0);
            List menuList = (List)appMenuMap.get(appNum);
            menuList.remove(menuId);
            --sum;
            if (menuList.isEmpty()) {
                appMenuMap.remove(appNum);
            }
            ArrayList data = new ArrayList(2);
            data.addAll(params);
            proxy.invokeControlMethod(CONTROLKEY, "deleteItem", new Object[]{data});
        } else {
            List menuList = (List)appMenuMap.get(focusNodeId);
            HashMap<String, Object> data = new HashMap<String, Object>(2);
            data.put("ids", params);
            if (menuList == null || !menuList.contains(menuId)) {
                appMenuMap.computeIfAbsent(focusNodeId, k -> new ArrayList()).add(menuId);
                ++sum;
                data.put("isSelected", Boolean.TRUE);
            } else {
                menuList.remove(menuId);
                if (menuList.isEmpty()) {
                    appMenuMap.remove(focusNodeId);
                }
                --sum;
                data.put("isSelected", Boolean.FALSE);
            }
            proxy.invokeControlMethod(CONTROLKEY, "setItemIsSelected", new Object[]{data});
        }
        this.getPageCache().put(PGCACHE_COUNT, String.valueOf(sum));
        this.getPageCache().put(PGCACHE_MARKEDAPPMENU, SerializationUtils.toJsonString((Object)appMenuMap));
        if (this.isNewPortal()) {
            this.setLabelCount(sum);
        } else {
            String text = String.format(ResManager.loadKDString((String)"\u5df2\u9009\uff08%s\uff09", (String)"PortalSetCommonFuncPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), sum);
            TreeNode treeNode = new TreeNode(ROOT, node, text, false);
            treeView.updateNode(treeNode);
            if (focusNodeId.equals(node)) {
                treeView.focusNode(treeNode);
            }
        }
    }
}

