/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew.lightMobile.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.pluginnew.lightMobile.pojo.PageDataInfo;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;

public class LightAppMobileService {
    public static final String LABELCLOSE = "labelclose";
    private static final Log LOG = LogFactory.getLog(LightAppMobileService.class);
    private static final String SELECT_CLOUNM = "formnum,appnum,appname,iconurl,formtype";
    private static final String FORMNUM = "formnum";
    private static final String FORM_NAME = "formName";
    private static final String APP_NAME = "appname";
    private static final String ICON_URL = "iconurl";
    private static final String FORM_TYPE = "formtype";
    private static final String MOBILE_LIGHT_APP = "mobile_light_app";
    private static final String MOBILE_LIGHT_APP_MANAGE = "mobile_light_app_manage";
    private static final String MOBILE_LIGHT_APP_SHOW = "mobile_light_app_show";
    private static final String MOBILE_LIGHT_APP_MODIFY = "mobile_light_app_modify";
    private static final String MOBILE_LIGHT_APP_ICON = "mobile_light_app_icon";
    private static final String MOBILE_LIGHT_APP_PAGE = "mobile_light_app_page";
    private static final String MOBILE_LIGHT_APP_HOME = "mobile_light_app_home";
    private static final String FLEX_CONTENT = "flexcontent";
    private static final String ROW = "row";
    private static final String COLUMN = "column";
    private static final String FLEX_START = "flex-start";
    private static final String FLEX_END = "flex-end";
    private static final String STRETCH = "stretch";
    private static final String CENTER = "center";
    private static final String PX_SOLID_D9 = "1px_solid_#d9d9d9";
    private static final String KDFONT_KDFONT_JINRU = "kdfont kdfont-jinru";
    private static final String VECTOR_AP = "vectorap_";
    private static final String LABEL_AP = "labelap_";
    private static final String IMAGE = "image";
    private static final String VECTOR = "vector";
    private static final String LABEL = "label";
    private static final String IMAGE_MANAGE = "image_manage";
    private static final String LABEL_MANAGE = "label_manage";
    private static final String LABEL_APP_NAME = "label_app_name";
    protected static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String KEY_DELETE = "delete_form";
    private static final String FLEX_AP = "flexap";
    private static final String FLEX_KEY = "flexKey";
    private static final String DELETE = "delete";
    private static final String IDE_PICTURERESEDITER = "ide_pictureresediter";
    private static final String ICON_CL = "id,furl0,fname";
    private static final String FURL0 = "furl0";
    private static final String CATEGORY = "categoryid.number";
    private static final String SHORTCUT_ENTRANCE = "shortcut_entrance";
    private static final String SHOW_ICON = "show_icon";
    private static final String VALUE_ONE = "1";
    private static final String VALUE_TWO = "2";
    private static final String PAGE_CURRENT_TAB = "page_current_tab";
    private static final String ICON_PK_VALUE = "icon_pk_values";
    private static final String PAGE_PK_VALUES = "page_pk_values";
    private static final String SELECT_PAGE = "select_page";
    private static final String MODIFY_PAGE_INFO = "modify_page_info";
    private static final String MODIFY_IMAGE_URL = "modify_image_url";
    private static final String MODIFY_FORM_ID = "modify_form_id";
    public static final String ICON = "icon";
    public static final String BUTTON_CLOSE = "button_close";
    public static final String BUTTON_SAVE = "button_save";
    public static final String LABEL_FORM = "label_form";
    public static final String FLEX_URL = "flexurl";
    public static final String FLEX_FORM = "flexform";
    public static final String FLEXCLOUD = "flexcloud";
    public static final String FLEXAPP = "flexapp";
    public static final String FLEXGROUP = "flexgroup";
    public static final String FLEXPAGE = "flexpage";
    public static final String FLEXSELECTED = "flexselected";
    public static final String FLEXCONFIRM = "flexconfirm";
    public static final String LABEL_RETURN = "labelreturn";
    public static final String PAGE_TAB_DATA_INFO = "page_tab_dataInfo";
    public static final String LABEL_CONFIRM = "labelconfirm";
    public static final String IMAGEAP = "imageap";
    public static final String VECTORAP = "vectorap";
    public static final String FLEXPANELICON = "flexpanelicon";
    public static final String TAB_APP = "labelapp";
    public static final String TAB_GROUP = "labelgroup";
    public static final String TAB_PAGE = "labelpage";
    public static final String TAB_CLOUD = "labelcloud";
    public static final String FLEXRETURN = "flexreturn";
    public static final String LABEL_MODIFY = "label_modify";
    public static final String LABEL_DELETE = "label_delete";
    public static final String LABEL_CLOSE = "label_close";
    public static final String LABEL_DEFAULT = "label_default";
    public static final String VECTOR_FORM = "vector_form";
    public static final String LABEL_ADD_APP = "label_add_app";
    public static final String IMAGE_ADD_APP = "image_add_app";
    public static final String ID = "id";
    public static final String HOME = "home";
    public static final String MANAGE = "manage";
    public static final String MODIFY = "modify";
    public static final String MA_SHOW = "maShow";
    public static final String PAGE = "page";
    public static final String PAGE_TIMES = "page_times";
    public static final String DOREFRESH = "dorefresh";
    public static final String URL = "url";
    private String imgName = ResManager.loadKDString((String)"\u56fe\u7247", (String)"LightAppMobileService_7", (String)"bos-portal-plugin", (Object[])new Object[0]);
    private DynamicObject[] dynamicObjects;
    private IFormView formView;
    private IDataModel dataModel;
    private IPageCache pageCache;

    public LightAppMobileService(IFormView formView, IDataModel dataModel, IPageCache pageCache) {
        this.formView = formView;
        this.dataModel = dataModel;
        this.pageCache = pageCache;
    }

    public void renderCustomControlHome() {
        this.renderCustomControl(HOME);
    }

    public void renderCustomControlManage() {
        this.renderCustomControl(MANAGE);
    }

    private void renderCustomControl(String name) {
        DynamicObject[] dynamicObjects = this.loadDataArrayFromDB();
        this.createControl(dynamicObjects, name);
    }

    private void createControl(DynamicObject[] dynamicObjects, String name) {
        FlexPanelAp dynamicPanel;
        Container flexContent = (Container)this.formView.getControl(FLEX_CONTENT);
        FlexPanelAp flexPanelAp = dynamicPanel = HOME.equals(name) ? this.createDynamicPanel(dynamicObjects) : this.createDynamicPanelMa(dynamicObjects);
        if (dynamicPanel == null) {
            return;
        }
        ArrayList<Map> itemMaps = new ArrayList<Map>(8);
        flexContent.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        itemMaps.add(dynamicPanel.createControl());
        flexContent.insertControls(0, itemMaps);
        this.formView.createControlIndex(flexContent.getItems());
        String s = this.pageCache.get(name + PAGE_TIMES);
        int time = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)s) ? 0 : Integer.parseInt(s);
        String key = name + FLEX_CONTENT + (time - 1);
        this.formView.setVisible(Boolean.valueOf(false), new String[]{key});
    }

    public void controlBindClick(OnGetControlArgs e, AbstractFormPlugin plugin, String type) {
        switch (type) {
            case "icon": {
                this.iconBindClick(e, plugin);
                break;
            }
            case "manage": 
            case "home": {
                this.homePageBindClick(e, plugin);
                break;
            }
            case "page": {
                this.pageTabBindClick(e, plugin);
                break;
            }
        }
    }

    private void pageTabBindClick(OnGetControlArgs e, AbstractFormPlugin plugin) {
        String s = this.pageCache.get(PAGE_CURRENT_TAB);
        Map<String, String> pkCache = this.getPkMapCache(PAGE_PK_VALUES + s);
        if (pkCache.isEmpty()) {
            return;
        }
        String value = pkCache.get(e.getKey());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)value)) {
            this.addControlListener(e, plugin, (Button)new Label());
        }
    }

    private void iconBindClick(OnGetControlArgs e, AbstractFormPlugin plugin) {
        List<String> iconPks = this.getPkCache(ICON_PK_VALUE);
        if (iconPks.isEmpty()) {
            return;
        }
        if (iconPks.contains(e.getKey())) {
            this.addControlListener(e, plugin, (Button)new Image());
        }
    }

    private void homePageBindClick(OnGetControlArgs e, AbstractFormPlugin plugin) {
        DynamicObject[] dynamicObjects = this.loadDataArray();
        if (dynamicObjects == null) {
            return;
        }
        String clickType = this.checkClickType(e.getKey(), dynamicObjects);
        if (IMAGE.equals(clickType)) {
            this.addControlListener(e, plugin, (Button)new Image());
        }
        if (VECTOR.equals(clickType)) {
            this.addControlListener(e, plugin, (Button)new Vector());
        }
        if (LABEL.equals(clickType)) {
            this.addControlListener(e, plugin, (Button)new Label());
        }
    }

    private String checkClickType(String key, DynamicObject[] dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            String name = dynamicObject.getString(ID);
            if (name.equals(key)) {
                return IMAGE;
            }
            if ((VECTOR_AP + name).equals(key)) {
                return VECTOR;
            }
            if (!(LABEL_AP + name).equals(key)) continue;
            return LABEL;
        }
        return null;
    }

    private void addControlListener(OnGetControlArgs e, AbstractFormPlugin plugin, Button control) {
        control.setKey(e.getKey());
        control.setView(this.formView);
        control.addClickListener((ClickListener)plugin);
        e.setControl((Control)control);
    }

    public void showManagerApp() {
        if (!PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
            this.formView.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4"});
        }
    }

    public void mobileMaShowName() {
        String formName = this.getFormName();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)formName)) {
            Label appName = (Label)this.formView.getControl(LABEL_APP_NAME);
            appName.setText(formName);
        }
    }

    public void doDelete(MessageBoxClosedEvent event) {
        Map customParams;
        Object pk;
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_DELETE, (CharSequence)event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes && null != (pk = (customParams = this.formView.getFormShowParameter().getCustomParams()).get("pk"))) {
            DeleteServiceHelper.delete((String)MOBILE_LIGHT_APP, (QFilter[])new QFilter[]{new QFilter(ID, "=", pk)});
            this.formView.returnDataToParent((Object)customParams);
            this.formView.close();
        }
    }

    public void confirmListClosed(ClosedCallBackEvent closedCallBackEvent, String name) {
        if (MANAGE.equals(name)) {
            this.manageClosedBack(closedCallBackEvent);
        }
        if (MODIFY.equals(name)) {
            this.modifyClosedBack(closedCallBackEvent);
        }
    }

    private void modifyClosedBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        String actionId = closedCallBackEvent.getActionId();
        if (SHOW_ICON.equals(actionId)) {
            returnData = (String)closedCallBackEvent.getReturnData();
            if (null == returnData) {
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong((String)returnData), (String)IDE_PICTURERESEDITER);
            Image image = (Image)this.formView.getControl(IMAGEAP);
            image.setUrl(dynamicObject.getString(FURL0));
            this.pageCache.put(MODIFY_IMAGE_URL, dynamicObject.getString(FURL0));
        }
        if (SELECT_PAGE.equals(actionId)) {
            returnData = (Map)closedCallBackEvent.getReturnData();
            if (null == returnData) {
                return;
            }
            Label label = (Label)this.formView.getControl(LABEL_FORM);
            label.setText((String)returnData.get("name"));
            this.formView.setVisible(Boolean.valueOf(true), new String[]{LABEL_FORM});
            this.formView.setVisible(Boolean.valueOf(false), new String[]{LABEL_DEFAULT});
            this.pageCache.put(MODIFY_PAGE_INFO, SerializationUtils.toJsonString(returnData));
        }
    }

    private void manageClosedBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (DELETE.equals(actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (null == returnData) {
                return;
            }
            this.formView.setVisible(Boolean.valueOf(false), new String[]{(String)returnData.get(FLEX_KEY)});
        }
    }

    public void click(EventObject evt, AbstractFormPlugin plugin, String type) {
        switch (type) {
            case "modify": {
                this.mobileModifyClick(evt, plugin);
                break;
            }
            case "maShow": {
                this.mobileMaShowClick(evt, plugin);
                break;
            }
            case "manage": {
                this.controlClickMa(evt, plugin);
                break;
            }
            case "home": {
                this.controlClick(evt);
                break;
            }
            case "icon": {
                this.controlClickIcon(evt);
                break;
            }
            case "page": {
                this.controlClickPage(evt);
                break;
            }
        }
    }

    public List<PageDataInfo> queryPageData(String tab) {
        String s;
        this.pageCache.put(PAGE_CURRENT_TAB, tab);
        String fields = "id, number, name";
        QFilter visible = new QFilter("visible", "=", (Object)true);
        if (TAB_CLOUD.equals(tab)) {
            return this.changeToDataInfo(this.getCloudByUser(visible, fields));
        }
        if (TAB_APP.equals(tab) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(s = this.pageCache.get("labelcloudvalue")))) {
            return this.changeToDataInfo(this.getAppByUser(visible, s));
        }
        if (TAB_GROUP.equals(tab)) {
            s = this.pageCache.get("labelappvalue");
            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)s, (boolean)false);
            List appFunctionPackets = appMetadata.getAppFunctionPackets();
            return this.changeToDataInfo(appFunctionPackets);
        }
        if (TAB_PAGE.equals(tab)) {
            String bizGroupId = this.pageCache.get("labelgroupvalue");
            String bizAppId = this.pageCache.get("labelappvalue");
            JSONArray selectedUnitPages = DevportalUtil.getSelectedUnitPages((String)bizAppId, (String)bizGroupId, (String)"all", (String)"AllFormModel", (String)"number");
            return this.changeToDataInfo(selectedUnitPages);
        }
        return Collections.emptyList();
    }

    private DynamicObjectCollection getCloudByUser(QFilter visible, String fields) {
        QFilter qFilter = new QFilter("visible", "=", (Object)true);
        DynamicObjectCollection collection = this.getAppByUser(visible, "");
        List ids = collection.stream().filter(v -> v.get("bizcloud") != null).map(v -> v.getString("bizcloud")).distinct().collect(Collectors.toList());
        qFilter.and(ID, "in", ids);
        return QueryServiceHelper.query((String)"bos_devportal_bizcloud", (String)fields, (QFilter[])new QFilter[]{qFilter});
    }

    private DynamicObjectCollection getAppByUser(QFilter visible, String cloudId) {
        visible.and(new QFilter("masterid", "is null", null).or("masterid", "=", (Object)" "));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cloudId)) {
            visible.and("bizcloud", "=", (Object)cloudId);
        }
        List list = PermissionServiceHelper.getUserBizApps((Long)RequestContext.get().getCurrUserId());
        visible.and(ID, "in", (Object)list);
        return QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id, number, name,bizcloud.id bizcloud", (QFilter[])new QFilter[]{visible});
    }

    public void createIconAp() {
        DynamicObjectCollection query = QueryServiceHelper.query((String)IDE_PICTURERESEDITER, (String)ICON_CL, (QFilter[])new QFilter[]{new QFilter(CATEGORY, "=", (Object)SHORTCUT_ENTRANCE)});
        if (query == null || query.isEmpty()) {
            return;
        }
        ArrayList<String> iconPks = new ArrayList<String>(32);
        int index = 0;
        Container container = (Container)this.formView.getControl(FLEX_CONTENT);
        for (DynamicObject dynamicObject : query) {
            FlexPanelAp panelAp = new FlexPanelAp();
            panelAp.setKey(FLEX_AP + dynamicObject.getString(ID));
            panelAp.setId(FLEX_AP + dynamicObject.getString(ID));
            panelAp.setDirection(ROW);
            panelAp.setJustifyContent(CENTER);
            panelAp.setAlignContent(CENTER);
            panelAp.setAlignItems(CENTER);
            panelAp.setWidth(new LocaleString("54px"));
            panelAp.setHeight(new LocaleString("54px"));
            panelAp.setGrow(0);
            panelAp.setShrink(0);
            Margin margin = new Margin();
            margin.setLeft("20px");
            margin.setRight("20px");
            margin.setTop("10px");
            margin.setBottom("10px");
            Style style = new Style();
            style.setMargin(margin);
            panelAp.setStyle(style);
            ImageAp imageAp = new ImageAp();
            imageAp.setId(dynamicObject.getString(ID));
            imageAp.setKey(dynamicObject.getString(ID));
            imageAp.setName(new LocaleString(dynamicObject.getString("fname")));
            imageAp.setImageKey(dynamicObject.getString(FURL0));
            imageAp.setHeight(new LocaleString("40px"));
            imageAp.setWidth(new LocaleString("40px"));
            imageAp.setClickable(true);
            panelAp.getItems().add(imageAp);
            container.getItems().addAll(((Container)panelAp.buildRuntimeControl()).getItems());
            ArrayList<Map> itemMaps = new ArrayList<Map>(8);
            itemMaps.add(panelAp.createControl());
            container.insertControls(index, itemMaps);
            this.formView.createControlIndex(container.getItems());
            iconPks.add(dynamicObject.getString(ID));
            ++index;
        }
        this.savePkCache(iconPks, ICON_PK_VALUE);
    }

    public void loadModifyData() {
        Object pk = this.formView.getFormShowParameter().getCustomParam("pk");
        if (null == pk) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)MOBILE_LIGHT_APP);
        this.dataModel.setValue(APP_NAME, dynamicObject.get(APP_NAME));
        Image image = (Image)this.formView.getControl(IMAGEAP);
        image.setUrl(dynamicObject.getString(ICON_URL));
        this.pageCache.put(MODIFY_IMAGE_URL, dynamicObject.getString(ICON_URL));
        this.dataModel.setValue(FORM_TYPE, (Object)dynamicObject.getString(FORM_TYPE));
        if (VALUE_ONE.equals(dynamicObject.getString(FORM_TYPE))) {
            this.setVisibleValue(FLEX_URL, FLEX_FORM);
            this.setFormNameByNum(dynamicObject.getString(FORMNUM));
            this.setUrlInput(false);
        } else {
            this.setUrlInput(true);
            this.setVisibleValue(FLEX_FORM, FLEX_URL);
            this.dataModel.setValue(URL, (Object)dynamicObject.getString(FORMNUM));
        }
    }

    private void setUrlInput(boolean b) {
        TextEdit textEdit = (TextEdit)this.formView.getControl(URL);
        textEdit.setMustInput(b);
    }

    public void propertyChanged(PropertyChangedArgs e, AbstractFormPlugin plugin, String type) {
        switch (type) {
            case "modify": {
                this.modifyChange(e, plugin);
                break;
            }
        }
    }

    public void renderPageData(String tab) {
        String currentFlex = this.showCurrentFlex(tab);
        if (!TAB_CLOUD.equals(tab)) {
            this.formView.setVisible(Boolean.valueOf(true), new String[]{FLEXRETURN});
        } else {
            this.formView.setVisible(Boolean.valueOf(false), new String[]{FLEXRETURN});
        }
        List<PageDataInfo> data = this.queryPageData(tab);
        if (data == null || data.isEmpty()) {
            return;
        }
        Integer times = this.getTabTimes(tab);
        HashMap<String, String> map = new HashMap<String, String>(data.size());
        FlexPanelAp headFlex = new FlexPanelAp();
        headFlex.setKey(FLEX_AP + tab + times);
        headFlex.setId(FLEX_AP + tab + times);
        headFlex.setDirection(COLUMN);
        headFlex.setJustifyContent(FLEX_START);
        headFlex.setWrap(false);
        Container flexCloud = (Container)this.formView.getControl(currentFlex);
        ArrayList<String> visibleList = new ArrayList<String>(data.size());
        for (PageDataInfo pageDataInfo : data) {
            String pk = pageDataInfo.getId();
            FlexPanelAp flexPanelAp = new FlexPanelAp();
            flexPanelAp.setKey(FLEX_AP + tab + pk);
            flexPanelAp.setId(FLEX_AP + tab + pk);
            flexPanelAp.setDirection(ROW);
            flexPanelAp.setJustifyContent(FLEX_START);
            flexPanelAp.setAlignItems(CENTER);
            flexPanelAp.setAlignContent(CENTER);
            flexPanelAp.setShrink(0);
            flexPanelAp.setGrow(0);
            flexPanelAp.setHeight(new LocaleString("44px"));
            flexPanelAp.setWidth(new LocaleString("100%"));
            Border border = new Border();
            border.setBottom(PX_SOLID_D9);
            Style style = new Style();
            style.setBorder(border);
            flexPanelAp.setStyle(style);
            LabelAp labelAp = new LabelAp();
            labelAp.setId(pk);
            labelAp.setKey(pk);
            labelAp.setName(new LocaleString(pageDataInfo.getName()));
            labelAp.setFontSize(14);
            Margin marginLabel = new Margin();
            marginLabel.setLeft("12px");
            Style styleLabel = new Style();
            styleLabel.setMargin(marginLabel);
            labelAp.setStyle(styleLabel);
            labelAp.setClickable(true);
            flexPanelAp.getItems().add(labelAp);
            if (TAB_PAGE.equals(tab)) {
                this.showSelectVector(pk, flexPanelAp, visibleList);
            }
            headFlex.getItems().add(flexPanelAp);
            map.put(pk.toLowerCase(), pk);
        }
        flexCloud.getItems().addAll(((Container)headFlex.buildRuntimeControl()).getItems());
        ArrayList<Map> itemMaps = new ArrayList<Map>(8);
        itemMaps.add(headFlex.createControl());
        flexCloud.insertControls(0, itemMaps);
        this.formView.createControlIndex(flexCloud.getItems());
        this.formView.setVisible(Boolean.valueOf(false), new String[]{FLEX_AP + tab + (times - 1)});
        this.pageCache.put(tab + "load", VALUE_ONE);
        this.pageCache.put(tab + "times", times + 1 + "");
        this.savePkCache(map, PAGE_PK_VALUES + tab);
        this.setVisibleFalse(visibleList);
    }

    private void showSelectVector(String pk, FlexPanelAp flexPanelAp, List<String> visibleList) {
        FlexPanelAp vectorFlexAp = new FlexPanelAp();
        vectorFlexAp.setKey("veFlex" + pk);
        vectorFlexAp.setId("veFlex" + pk);
        vectorFlexAp.setDirection(ROW);
        vectorFlexAp.setJustifyContent(FLEX_END);
        vectorFlexAp.setAlignItems(CENTER);
        vectorFlexAp.setAlignContent(CENTER);
        vectorFlexAp.setWrap(false);
        VectorAp vectorAp = new VectorAp();
        vectorAp.setKey("ve" + pk);
        vectorAp.setId("ve" + pk);
        vectorAp.setWidth(new LocaleString("16px"));
        vectorAp.setHeight(new LocaleString("16px"));
        vectorAp.setfontClass("kdfont kdfont-danliexuanze");
        vectorAp.setForeColor("#276FF5");
        Margin veMargin = new Margin();
        veMargin.setRight("12px");
        Style veStyle = new Style();
        veStyle.setMargin(veMargin);
        vectorAp.setStyle(veStyle);
        vectorFlexAp.getItems().add(vectorAp);
        flexPanelAp.getItems().add(vectorFlexAp);
        visibleList.add("ve" + pk);
    }

    private void controlClickPage(EventObject evt) {
        this.formView.setVisible(Boolean.valueOf(false), new String[]{FLEXCONFIRM, FLEXSELECTED});
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (LABEL_RETURN.equals(key)) {
            String step = this.previousStep();
            this.setLabelText(step);
            this.clickToNext(step);
            this.pageCache.put(PAGE_CURRENT_TAB, step);
            return;
        }
        if (LABEL_CONFIRM.equals(key)) {
            this.formView.returnDataToParent(this.getDataInfoCache(PAGE_TAB_DATA_INFO, this.pageCache.get("labelpagevalue")));
            this.formView.close();
            return;
        }
        if (LABEL_CLOSE.equals(key)) {
            this.formView.close();
            return;
        }
        if (TAB_PAGE.equals(this.pageCache.get(PAGE_CURRENT_TAB))) {
            String s = this.pageCache.get("labelpagevalue");
            this.formView.setVisible(Boolean.valueOf(false), new String[]{"ve" + s});
            this.formView.setVisible(Boolean.valueOf(true), new String[]{FLEXCONFIRM, "ve" + key});
            this.pageCache.put("labelpagevalue", key);
            return;
        }
        String next = this.setNextStep(key);
        this.clickToNext(next);
    }

    private String previousStep() {
        String tab = this.pageCache.get(PAGE_CURRENT_TAB);
        if (tab.equals(TAB_APP)) {
            return TAB_CLOUD;
        }
        if (tab.equals(TAB_GROUP)) {
            return TAB_APP;
        }
        if (tab.equals(TAB_PAGE)) {
            return TAB_GROUP;
        }
        return null;
    }

    private void clickToNext(String next) {
        this.renderPageData(next);
    }

    private String setNextStep(String key) {
        String currentTab = this.pageCache.get(PAGE_CURRENT_TAB);
        this.savePageValue(key, currentTab);
        String next = this.getNext(currentTab);
        this.pageCache.put(PAGE_CURRENT_TAB, next);
        this.setLabelText(next);
        return next;
    }

    private String getNext(String tab) {
        if (TAB_CLOUD.equals(tab)) {
            return TAB_APP;
        }
        if (TAB_APP.equals(tab)) {
            return TAB_GROUP;
        }
        if (TAB_GROUP.equals(tab)) {
            return TAB_PAGE;
        }
        return null;
    }

    private void savePageValue(String key, String tab) {
        Map<String, String> pkMapCache = this.getPkMapCache(PAGE_PK_VALUES + tab);
        this.pageCache.put(tab + "value", pkMapCache.get(key));
    }

    private void setLabelText(String tab) {
        Label label = (Label)this.formView.getControl(TAB_CLOUD);
        String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e91", (String)"LightAppMobileService_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        if (TAB_APP.equals(tab)) {
            msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528", (String)"LightAppMobileService_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        }
        if (TAB_GROUP.equals(tab)) {
            msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u7ec4", (String)"LightAppMobileService_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        }
        if (TAB_PAGE.equals(tab)) {
            msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9875\u9762", (String)"LightAppMobileService_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        }
        label.setText(msg);
    }

    private void mobileModifyClick(EventObject evt, AbstractFormPlugin plugin) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (IMAGEAP.equals(key) || VECTORAP.equals(key) || FLEXPANELICON.equals(key)) {
            this.showIconPage(plugin);
        }
        if (BUTTON_CLOSE.equals(key)) {
            this.closeParent();
            this.formView.close();
        }
        if (VECTOR_FORM.equals(key) || LABEL_DEFAULT.equals(key) || LABEL_FORM.equals(key)) {
            this.showPageInfo(plugin);
        }
        if (BUTTON_SAVE.equals(key)) {
            this.saveData();
            this.closeParent();
            this.formView.close();
        }
    }

    private void closeParent() {
        if (this.formView.getParentView() != null && this.formView.getParentView() instanceof MobileFormView) {
            MobileFormView view = (MobileFormView)this.formView.getParentView();
            if (MOBILE_LIGHT_APP_SHOW.equals(view.getFormId())) {
                view.getParentView().updateView();
                view.close();
            }
            if (MOBILE_LIGHT_APP_MANAGE.equals(view.getFormId()) || MOBILE_LIGHT_APP_HOME.equals(view.getFormId())) {
                view.updateView();
                this.formView.sendFormAction((IFormView)view);
            }
        }
    }

    private void saveData() {
        DynamicObject dynamicObject;
        Object pk = this.formView.getFormShowParameter().getCustomParam("pk");
        if (pk != null) {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)MOBILE_LIGHT_APP);
        } else {
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)MOBILE_LIGHT_APP);
            dynamicObject = new DynamicObject((DynamicObjectType)mainEntityType);
        }
        Object formType = this.dataModel.getValue(FORM_TYPE);
        dynamicObject.set(APP_NAME, this.dataModel.getValue(APP_NAME));
        dynamicObject.set(ICON_URL, (Object)this.pageCache.get(MODIFY_IMAGE_URL));
        dynamicObject.set(FORM_TYPE, formType);
        dynamicObject.set(FORMNUM, (Object)this.getSaveFormNum(formType));
        dynamicObject.set("enable", (Object)true);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        this.formView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"OpConfirmListPlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
    }

    private String getSaveFormNum(Object formType) {
        String data = this.pageCache.get(MODIFY_PAGE_INFO);
        if (VALUE_ONE.equals(formType)) {
            if (data == null) {
                return this.pageCache.get(MODIFY_FORM_ID);
            }
            Map dataMap = (Map)SerializationUtils.fromJsonString(data, Map.class);
            return (String)dataMap.get("number");
        }
        return (String)this.dataModel.getValue(URL);
    }

    private void showPageInfo(AbstractFormPlugin plugin) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(MOBILE_LIGHT_APP_PAGE);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Floating);
        parameter.setOpenStyle(openStyle);
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u9875\u9762", (String)"LightAppMobileService_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, SELECT_PAGE);
        parameter.setCloseCallBack(closeCallBack);
        this.formView.showForm((FormShowParameter)parameter);
    }

    private void showIconPage(AbstractFormPlugin plugin) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(MOBILE_LIGHT_APP_ICON);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Floating);
        parameter.setOpenStyle(openStyle);
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u56fe\u6807", (String)"LightAppMobileService_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, SHOW_ICON);
        parameter.setCloseCallBack(closeCallBack);
        this.formView.showForm((FormShowParameter)parameter);
    }

    private void controlClickIcon(EventObject evt) {
        List<String> iconPks;
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (BUTTON_CLOSE.equals(key)) {
            this.formView.close();
        }
        if (null == (iconPks = this.getPkCache(ICON_PK_VALUE))) {
            return;
        }
        if (iconPks.contains(key)) {
            this.formView.returnDataToParent((Object)key);
            this.formView.close();
        }
    }

    private String getFormName() {
        Map customParams = this.formView.getFormShowParameter().getCustomParams();
        return (String)customParams.get(FORM_NAME);
    }

    private String getManageClickKey(Control control) {
        String key = control.getKey();
        if (control instanceof Label) {
            return key.split(LABEL_AP)[1];
        }
        if (control instanceof Vector) {
            return key.split(VECTOR_AP)[1];
        }
        return key;
    }

    private void showManageModifyForm(DynamicObject dynamicObject, AbstractFormPlugin plugin) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        this.setCustomParams(dynamicObject, parameter);
        parameter.setFormId(MOBILE_LIGHT_APP_SHOW);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        parameter.setOpenStyle(openStyle);
        parameter.setShowTitle(true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, DELETE);
        parameter.setCloseCallBack(closeCallBack);
        this.formView.showForm((FormShowParameter)parameter);
    }

    private void setCustomParams(DynamicObject dynamicObject, MobileFormShowParameter parameter) {
        if (dynamicObject == null) {
            return;
        }
        ILocaleString localeString = dynamicObject.getLocaleString(APP_NAME);
        if (null != localeString) {
            parameter.setCustomParam(FORM_NAME, (Object)localeString.getLocaleValue());
        }
        parameter.setCustomParam("pk", dynamicObject.getPkValue());
        parameter.setCustomParam(FLEX_KEY, (Object)(FLEX_AP + dynamicObject.getString(ID)));
    }

    private void showManagerAppForm() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(MOBILE_LIGHT_APP_MANAGE);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Floating);
        parameter.setOpenStyle(openStyle);
        parameter.setShowTitle(true);
        this.formView.showForm((FormShowParameter)parameter);
    }

    private void showDisplayForm(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return;
        }
        String formId = dynamicObject.getString(FORMNUM);
        if (VALUE_ONE.equals(dynamicObject.getString(FORM_TYPE))) {
            MobileFormShowParameter parameter = new MobileFormShowParameter();
            parameter.setFormId(formId);
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.Floating);
            parameter.setOpenStyle(openStyle);
            this.formView.showForm((FormShowParameter)parameter);
        }
        if (VALUE_TWO.equals(dynamicObject.getString(FORM_TYPE))) {
            this.formView.openUrl(UrlService.getDomainContextUrl() + formId);
        }
    }

    private DynamicObject getCurrentDynamicObject(DynamicObject[] dynamicObjects, String key) {
        if (dynamicObjects == null) {
            return null;
        }
        for (DynamicObject object : dynamicObjects) {
            if (!key.equals(object.getString(ID))) continue;
            return object;
        }
        return null;
    }

    private FlexPanelAp createDynamicPanelMa(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length < 1) {
            return null;
        }
        return this.createPanelMa(dynamicObjects);
    }

    private FlexPanelAp createPanelMa(DynamicObject[] dynamicObjects) {
        FlexPanelAp flexPanelAp = this.initFlexPanelContent(MANAGE);
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String formNum = dynamicObject.getString(ID);
            FlexPanelAp panelAp = this.initFlexPanelMa(formNum, index);
            FlexPanelAp panelAp2 = this.addFlexPanelAp(formNum);
            this.addImageAp(panelAp2, dynamicObject.getString(ICON_URL), formNum);
            this.addLabelAp(panelAp2, dynamicObject.getLocaleString(APP_NAME), formNum);
            panelAp.getItems().add(panelAp2);
            this.addVectorAp(panelAp, formNum);
            flexPanelAp.getItems().add(panelAp);
            ++index;
        }
        return flexPanelAp;
    }

    private FlexPanelAp addFlexPanelAp(String formNum) {
        FlexPanelAp panelAp = new FlexPanelAp();
        panelAp.setKey("flexap1" + formNum);
        panelAp.setDirection(ROW);
        panelAp.setAlignItems(CENTER);
        panelAp.setGrow(1);
        panelAp.setShrink(1);
        panelAp.setJustifyContent(FLEX_START);
        return panelAp;
    }

    private void addVectorAp(FlexPanelAp panelAp, String formNum) {
        VectorAp vectorAp = new VectorAp();
        vectorAp.setKey(VECTOR_AP + formNum);
        vectorAp.setfontClass(KDFONT_KDFONT_JINRU);
        vectorAp.setForeColor("#cccccc");
        Style style1 = new Style();
        Margin margin1 = new Margin();
        margin1.setRight("12px");
        margin1.setLeft("12px");
        style1.setMargin(margin1);
        vectorAp.setStyle(style1);
        panelAp.getItems().add(vectorAp);
    }

    private void addLabelAp(FlexPanelAp panelAp2, ILocaleString appName, String formNum) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(LABEL_AP + formNum);
        labelAp.setId(LABEL_AP + formNum);
        labelAp.setName(new LocaleString(appName.getLocaleValue()));
        labelAp.setClickable(true);
        labelAp.setFontSize(16);
        panelAp2.getItems().add(labelAp);
    }

    private void addImageAp(FlexPanelAp panelAp2, String iconurl, String formNum) {
        ImageAp imageAp = new ImageAp();
        imageAp.setKey(formNum);
        imageAp.setImageKey(iconurl);
        imageAp.setWidth(new LocaleString("24px"));
        imageAp.setHeight(new LocaleString("24px"));
        imageAp.setId(formNum);
        imageAp.setName(new LocaleString(this.imgName));
        imageAp.setClickable(true);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("12px");
        margin.setLeft("12px");
        style.setMargin(margin);
        imageAp.setStyle(style);
        panelAp2.getItems().add(imageAp);
    }

    private FlexPanelAp initFlexPanelMa(String formNum, int index) {
        FlexPanelAp panelAp = new FlexPanelAp();
        panelAp.setKey(FLEX_AP + formNum);
        panelAp.setDirection(ROW);
        panelAp.setGrow(0);
        panelAp.setShrink(0);
        panelAp.setJustifyContent(FLEX_START);
        panelAp.setAlignItems(CENTER);
        panelAp.setAlignContent(CENTER);
        panelAp.setHeight(new LocaleString("48px"));
        Style style = new Style();
        Border border = new Border();
        border.setBottom(PX_SOLID_D9);
        if (index == 0) {
            border.setTop(PX_SOLID_D9);
        }
        style.setBorder(border);
        panelAp.setStyle(style);
        return panelAp;
    }

    private FlexPanelAp createDynamicPanel(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length < 1) {
            return null;
        }
        return this.createPanel(dynamicObjects);
    }

    private FlexPanelAp createPanel(DynamicObject[] dynamicObjects) {
        FlexPanelAp contentAp = this.initFlexPanelContent(HOME);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String formNum = dynamicObject.getString(ID);
            FlexPanelAp panelAp = this.initFlexPanel(formNum);
            ImageAp imageAp = new ImageAp();
            imageAp.setKey(formNum);
            imageAp.setImageKey(dynamicObject.getString(ICON_URL));
            imageAp.setWidth(new LocaleString("40px"));
            imageAp.setHeight(new LocaleString("40px"));
            imageAp.setId(formNum);
            imageAp.setName(new LocaleString(this.imgName));
            imageAp.setClickable(true);
            panelAp.getItems().add(imageAp);
            LabelAp labelAp = new LabelAp();
            labelAp.setKey(LABEL_AP + formNum);
            labelAp.setId(LABEL_AP + formNum);
            labelAp.setAutoTextWrap(true);
            ILocaleString appName = dynamicObject.getLocaleString(APP_NAME);
            labelAp.setName(new LocaleString(appName.getLocaleValue()));
            Style style = new Style();
            Margin margin = new Margin();
            margin.setTop("7px");
            style.setMargin(margin);
            labelAp.setStyle(style);
            labelAp.setFontSize(13);
            panelAp.getItems().add(labelAp);
            contentAp.getItems().add(panelAp);
        }
        return contentAp;
    }

    private FlexPanelAp initFlexPanelContent(String name) {
        String s = this.pageCache.get(name + PAGE_TIMES);
        int time = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)s) ? 0 : Integer.parseInt(s);
        String key = name + FLEX_CONTENT + (time + 1);
        FlexPanelAp panelAp = new FlexPanelAp();
        panelAp.setId(key);
        panelAp.setKey(key);
        panelAp.setShrink(1);
        panelAp.setGrow(1);
        panelAp.setDirection(ROW);
        panelAp.setWrap(true);
        panelAp.setAlignItems(FLEX_START);
        panelAp.setJustifyContent(FLEX_START);
        if (MANAGE.equals(name)) {
            panelAp.setDirection(COLUMN);
            panelAp.setWrap(false);
            panelAp.setAlignItems(STRETCH);
            panelAp.setShrink(0);
            panelAp.setGrow(0);
        }
        this.pageCache.put(name + PAGE_TIMES, String.valueOf(time + 1));
        return panelAp;
    }

    private FlexPanelAp initFlexPanel(String identifying) {
        FlexPanelAp panelAp = new FlexPanelAp();
        panelAp.setKey(FLEX_AP + identifying);
        panelAp.setShrink(0);
        panelAp.setGrow(0);
        panelAp.setDirection(COLUMN);
        panelAp.setAlignItems(CENTER);
        panelAp.setAlignContent(CENTER);
        panelAp.setJustifyContent(CENTER);
        panelAp.setWidth(new LocaleString("72px"));
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("8px");
        margin.setRight("8px");
        margin.setBottom("8px");
        margin.setTop("8px");
        style.setMargin(margin);
        panelAp.setStyle(style);
        return panelAp;
    }

    private DynamicObject[] loadDataArray() {
        if (this.dynamicObjects == null) {
            this.dynamicObjects = this.loadDataArrayFromDB();
        }
        return this.dynamicObjects;
    }

    private DynamicObject[] loadDataArrayFromDB() {
        return BusinessDataServiceHelper.load((String)MOBILE_LIGHT_APP, (String)SELECT_CLOUNM, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)VALUE_ONE)}, (String)ID);
    }

    private void mobileMaShowClick(EventObject evt, AbstractFormPlugin plugin) {
        Control source = (Control)evt.getSource();
        if (LABEL_CLOSE.equals(source.getKey())) {
            this.formView.close();
        }
        if (LABEL_DELETE.equals(source.getKey())) {
            String formName = this.getFormName();
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_DELETE, (IFormPlugin)plugin);
            String strDeleteConfirmTip = ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u300a%s\u300b\u5417\uff1f\u6b64\u64cd\u4f5c\u4e0d\u53ef\u64a4\u9500\u3002", (String)"LightAppMobileService_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            String msg = String.format(strDeleteConfirmTip, formName);
            this.formView.showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
        }
        if (LABEL_MODIFY.equals(source.getKey())) {
            this.showAppModifyForm(plugin);
        }
    }

    private void showAppModifyForm(AbstractFormPlugin plugin) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setCustomParam("pk", this.formView.getFormShowParameter().getCustomParam("pk"));
        parameter.setFormId(MOBILE_LIGHT_APP_MODIFY);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Floating);
        parameter.setOpenStyle(openStyle);
        parameter.setShowTitle(true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, "app_modify");
        parameter.setCloseCallBack(closeCallBack);
        this.formView.showForm((FormShowParameter)parameter);
    }

    private void controlClickMa(EventObject evt, AbstractFormPlugin plugin) {
        Control control = (Control)evt.getSource();
        if (FLEXRETURN.equals(control.getKey())) {
            this.closeParent();
            this.formView.close();
            return;
        }
        if (IMAGE_ADD_APP.equals(control.getKey()) || LABEL_ADD_APP.equals(control.getKey())) {
            this.showAppModifyForm(plugin);
            return;
        }
        String key = this.getManageClickKey(control);
        DynamicObject dynamicObject = this.getCurrentDynamicObject(this.loadDataArray(), key);
        this.showManageModifyForm(dynamicObject, plugin);
    }

    private void controlClick(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("flexpanelap4")) {
            this.showManagerAppForm();
            return;
        }
        DynamicObject dynamicObject = this.getCurrentDynamicObject(this.loadDataArray(), key);
        this.showDisplayForm(dynamicObject);
    }

    private void savePkCache(Object pks, String key) {
        this.pageCache.putBigObject(key, SerializationUtils.toJsonString(pks));
    }

    private List<String> getPkCache(String key) {
        String iconPkValue = this.pageCache.getBigObject(key);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)iconPkValue)) {
            return (List)SerializationUtils.fromJsonString(iconPkValue, List.class);
        }
        return Collections.emptyList();
    }

    private Map<String, String> getDataInfoCache(String key, String number) {
        String data = this.pageCache.getBigObject(key);
        Map<String, String> pkMapCache = this.getPkMapCache("page_pk_valueslabelpage");
        String value = pkMapCache.get(number);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)data)) {
            List infoList = (List)SerializationUtils.fromJsonString(data, List.class);
            for (Map map : infoList) {
                if (!value.equals(map.get("number"))) continue;
                return map;
            }
        }
        return null;
    }

    private Map<String, String> getPkMapCache(String key) {
        String iconPkValue = this.pageCache.getBigObject(key);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)iconPkValue)) {
            return (Map)SerializationUtils.fromJsonString(iconPkValue, Map.class);
        }
        return Collections.emptyMap();
    }

    private void setVisibleValue(String falseName, String trueName) {
        this.formView.setVisible(Boolean.valueOf(false), new String[]{falseName});
        this.formView.setVisible(Boolean.valueOf(true), new String[]{trueName});
    }

    private void setFormNameByNum(String formId) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        if (formConfig != null && formConfig.getCaption() != null) {
            this.setFormNameValue(formConfig.getCaption().getLocaleValue());
            this.pageCache.put(MODIFY_FORM_ID, formId);
        }
    }

    private void setFormNameValue(String localeValue) {
        this.formView.setVisible(Boolean.valueOf(true), new String[]{LABEL_FORM});
        this.formView.setVisible(Boolean.valueOf(false), new String[]{LABEL_DEFAULT});
        Label labelForm = (Label)this.formView.getControl(LABEL_FORM);
        labelForm.setText(localeValue);
    }

    private void modifyChange(PropertyChangedArgs e, AbstractFormPlugin plugin) {
        if (FORM_TYPE.equals(e.getProperty().getName())) {
            ChangeData changeData = e.getChangeSet()[0];
            if (VALUE_ONE.equals(changeData.getNewValue())) {
                this.setVisibleValue(FLEX_URL, FLEX_FORM);
                String formId = this.pageCache.get(MODIFY_FORM_ID);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)formId)) {
                    this.setFormNameByNum(formId);
                }
            }
            if (VALUE_TWO.equals(changeData.getNewValue())) {
                TextEdit textEdit = (TextEdit)this.formView.getControl(URL);
                textEdit.setMustInput(true);
                this.setVisibleValue(FLEX_FORM, FLEX_URL);
            }
        }
    }

    private void setVisibleFalse(List<String> visibleList) {
        for (String s : visibleList) {
            this.formView.setVisible(Boolean.valueOf(false), new String[]{s});
        }
    }

    private Integer getTabTimes(String tab) {
        String times = this.pageCache.get(tab + "times");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)times)) {
            return Integer.parseInt(times);
        }
        return 0;
    }

    private String showCurrentFlex(String tab) {
        if (TAB_CLOUD.equals(tab)) {
            this.formView.setVisible(Boolean.valueOf(true), new String[]{FLEXCLOUD});
            this.formView.setVisible(Boolean.valueOf(false), new String[]{FLEXAPP, FLEXGROUP, FLEXPAGE});
            return FLEXCLOUD;
        }
        if (TAB_APP.equals(tab)) {
            this.formView.setVisible(Boolean.valueOf(true), new String[]{FLEXAPP});
            this.formView.setVisible(Boolean.valueOf(false), new String[]{FLEXCLOUD, FLEXGROUP, FLEXPAGE});
            return FLEXAPP;
        }
        if (TAB_GROUP.equals(tab)) {
            this.formView.setVisible(Boolean.valueOf(true), new String[]{FLEXGROUP});
            this.formView.setVisible(Boolean.valueOf(false), new String[]{FLEXCLOUD, FLEXAPP, FLEXPAGE});
            return FLEXGROUP;
        }
        if (TAB_PAGE.equals(tab)) {
            this.formView.setVisible(Boolean.valueOf(true), new String[]{FLEXPAGE});
            this.formView.setVisible(Boolean.valueOf(false), new String[]{FLEXCLOUD, FLEXAPP, FLEXGROUP});
            return FLEXPAGE;
        }
        return null;
    }

    private List<PageDataInfo> changeToDataInfo(DynamicObjectCollection data) {
        if (data == null || data.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PageDataInfo> dataInfo = new ArrayList<PageDataInfo>(data.size());
        for (DynamicObject datum : data) {
            dataInfo.add(new PageDataInfo(datum.getString(ID), datum.getString("number"), datum.getString("name")));
        }
        return dataInfo;
    }

    private List<PageDataInfo> changeToDataInfo(List<AppFunctionPacketElement> data) {
        if (data == null || data.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PageDataInfo> dataInfo = new ArrayList<PageDataInfo>(data.size());
        for (AppFunctionPacketElement datum : data) {
            dataInfo.add(new PageDataInfo(datum.getId(), datum.getNumber(), datum.getName().getLocaleValue()));
        }
        return dataInfo;
    }

    private List<PageDataInfo> changeToDataInfo(JSONArray data) {
        if (data == null || data.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PageDataInfo> dataInfo = new ArrayList<PageDataInfo>(data.size());
        for (Object datum : data) {
            JSONObject json = (JSONObject)datum;
            dataInfo.add(new PageDataInfo(json.getString("number"), json.getString("number"), json.getString("name")));
        }
        this.pageCache.putBigObject(PAGE_TAB_DATA_INFO, SerializationUtils.toJsonString(dataInfo));
        return dataInfo;
    }
}

