/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew.newmainpage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabCloseEvent;
import kd.bos.form.control.events.TabCloseListener;
import kd.bos.form.control.events.TabOperationEvent;
import kd.bos.form.control.events.TabOperationListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.login.utils.StringUtils;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.portal.pluginnew.common.MainPageAbstract;
import kd.bos.portal.service.factory.MenuModeFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class MainPageNewPlugin
extends MainPageAbstract
implements ClickListener,
TabCloseListener,
TabOperationListener {
    @Override
    public String getUsericon() {
        return "newusericon";
    }

    @Override
    public boolean isNewPortal() {
        return true;
    }

    @Override
    public void setSlideBill(IClientViewProxy proxy) {
        HashMap<String, Object> o1 = new HashMap<String, Object>(1);
        o1.put("direction", "topRight");
        o1.put("formId", "bos_portal_personalcenter");
        o1.put("visualStyle", "newDesign");
        HashMap<String, Integer> offset = new HashMap<String, Integer>();
        offset.put("top", 48);
        o1.put("offsetInAllDC", offset);
        HashMap<String, String> borderRadius = new HashMap<String, String>();
        borderRadius.put("borderRadius", "8px");
        borderRadius.put("boxShadow", "0px 9px 24px 6px rgb(0 0 0 / 10%)");
        o1.put("style", borderRadius);
        proxy.addAction("setSlideBillFormId", o1);
        HashMap<String, Object> o2 = new HashMap<String, Object>(1);
        o2.put("dc", "right");
        o2.put("formId", "bos_portal_taskandmsg");
        HashMap<String, Integer> offset1 = new HashMap<String, Integer>();
        offset1.put("top", 48);
        o2.put("offsetInAllDC", offset1);
        HashMap<String, String> taskNewBoxShadow = new HashMap<String, String>();
        taskNewBoxShadow.put("boxShadow", "0px 30px 24px 6px rgb(0 0 0 / 10%)");
        o2.put("style", taskNewBoxShadow);
        proxy.addAction("setSlideBillFormId", o2);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("direction", "top");
        map.put("formId", "portal_usermarkedmenulist");
        map.put("offset", 48);
        proxy.addAction("setSlideBillFormId", map);
        HashMap<String, Object> makeNewMap = new HashMap<String, Object>();
        makeNewMap.put("direction", "left");
        makeNewMap.put("formId", "bos_portal_myapp_new");
        HashMap<String, String> offsetInAllDCMap = new HashMap<String, String>();
        offsetInAllDCMap.put("top", String.valueOf(48));
        makeNewMap.put("offsetInAllDC", offsetInAllDCMap);
        HashMap<String, String> makeNewBoxShadow = new HashMap<String, String>();
        makeNewBoxShadow.put("boxShadow", "-9px 24px 24px 6px rgb(0 0 0 / 10%)");
        makeNewMap.put("style", makeNewBoxShadow);
        HashMap<String, Object> maskInfoMap = new HashMap<String, Object>();
        maskInfoMap.put("isShowHeader", true);
        maskInfoMap.put("bgColor", "rgba(55,55,55,.5)");
        makeNewMap.put("maskInfo", maskInfoMap);
        proxy.addAction("setSlideBillFormId", makeNewMap);
        HashMap<String, Object> homepageTabMap = new HashMap<String, Object>();
        homepageTabMap.put("tabCanFixed", Boolean.TRUE);
        homepageTabMap.put("homeTabKey", this.getMainPageTabKey());
        this.getView().updateControlMetadata("homepagetabap", homepageTabMap);
    }

    @Override
    public void registerListener(EventObject e) {
        ComboEdit comboEdit;
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        if (tab != null) {
            tab.addTabCloseListener((TabCloseListener)this);
            tab.addTabReOpenListener((TabOperationListener)this);
        }
        if ((comboEdit = (ComboEdit)this.getControl("orgcombofield")) != null) {
            comboEdit.addClickListener((ClickListener)this);
        }
        this.addClickListeners(new String[]{"usernameiconflex", "username"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        HashMap<String, Integer> navMap = new HashMap<String, Integer>();
        navMap.put("showType", 1);
        this.getView().updateControlMetadata("appnavigationmenuap", navMap);
        if (MenuModeFactory.tileMenuModeEnable()) {
            HashMap<String, Comparable<Boolean>> tabMap = new HashMap<String, Comparable<Boolean>>();
            tabMap.put("hideNav", Boolean.FALSE);
            tabMap.put("tabStyle", Integer.valueOf(5));
            tabMap.put("canSlide", Boolean.TRUE);
            tabMap.put("sddi", Boolean.TRUE);
            this.getView().updateControlMetadata("tabap", tabMap);
            HashMap<String, String> iconMap = new HashMap<String, String>();
            iconMap.put("icon", "kdfont kdfont-gongzuotai");
            this.getView().updateControlMetadata("tabpageap", iconMap);
            this.getView().updateControlMetadata("gpt_home_page", iconMap);
            String tabKey = (String)SystemParamServiceHelper.getPublicParameter((String)"mainpage_tab_key");
            if (StringUtils.isNotEmpty((String)tabKey)) {
                this.getView().updateControlMetadata(tabKey, iconMap);
            }
            HashMap<String, String> yzjIconMap = new HashMap<String, String>();
            yzjIconMap.put("icon", "kdfont kdfont-xietongyun");
            this.getView().updateControlMetadata("yzjportal", yzjIconMap);
            HashMap<String, Object> comboMap = new HashMap<String, Object>();
            comboMap.put("defType", 1);
            comboMap.put("skipShortCutFocus", true);
            comboMap.put("fp", ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ec4\u7ec7\u540d\u79f0/\u7f16\u7801", (String)"MainPageNewPlugin_23", (String)"bos-portal-plugin", (Object[])new Object[0]));
            this.getView().updateControlMetadata("orgcombofield", comboMap);
            this.getView().setVisible(Boolean.FALSE, new String[]{"homepagetabap"});
        }
        if (MenuModeFactory.accountAndOrgVisible()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"username"});
            this.getView().addClientCallBack("loadCurrentOrgData");
            this.setUserName();
        }
        this.hideMyAppIcon();
    }

    private void hideMyAppIcon() {
        Container flex = (Container)this.getControl("flexpanelap6");
        Vector myAppIcon = (Vector)this.getControl("mymarksapp");
        if (flex.isInvisible() || myAppIcon.isInvisible()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap10"});
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "orgcombofield": {
                this.setDefaultOrg(evt);
                break;
            }
            case "newusericon": 
            case "username": 
            case "usernameiconflex": {
                this.openPersonalCenter();
                break;
            }
        }
    }

    private void openPersonalCenter() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> o = new HashMap<String, String>(1);
        o.put("formId", "bos_portal_personalcenter");
        proxy.addAction("showSlideBill", o);
    }

    private void setDefaultOrg(EventObject evt) {
        if (!(evt instanceof ClickEvent)) {
            return;
        }
        ClickEvent clickEvent = (ClickEvent)evt;
        Map paramsMap = clickEvent.getParamsMap();
        Object setDefault = paramsMap.get("setDefault");
        long userId = RequestContext.get().getCurrUserId();
        if (setDefault != null && Boolean.TRUE.toString().equals(setDefault.toString())) {
            UserServiceHelper.setUserDefaultOrg((long)userId, (long)Long.parseLong(paramsMap.get("id").toString()));
        } else {
            this.deleteDefaultOrg(userId, Long.parseLong(paramsMap.get("id").toString()));
        }
        this.setDefault(paramsMap);
    }

    private void deleteDefaultOrg(Long userId, Long orgId) {
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{userFilter, orgFilter};
        DeleteServiceHelper.delete((String)"bas_userdefaultorg", (QFilter[])filters);
    }

    private void setAccountName() {
        List allAccounts = AccountUtils.getAllAccounts((String)RequestContext.get().getTenantId());
        if (allAccounts.size() <= 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"accountlabelap", "splitlabel"});
            return;
        }
        Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        if (account != null) {
            Label label = (Label)this.getControl("accountlabelap");
            label.setText(account.getAccountName());
        }
    }

    private void setDefault(Map<String, Object> map) {
        IClientViewProxy viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        viewProxy.invokeControlMethod("orgcombofield", "updateDefaultValue", new Object[]{map});
    }

    @Override
    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if ("loadCurrentOrgData".equals(e.getName())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"accountorgflex"});
            this.setAccountName();
            this.loadCurrentOrgData();
        } else if ("initOrgComboEdit".equals(e.getName())) {
            this.initOrgComboEdit();
        }
    }

    private void loadCurrentOrgData() {
        long orgId = this.getPermissionOrg();
        DynamicObject userOrg = QueryServiceHelper.queryOne((String)"bos_org", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)});
        if (userOrg != null) {
            long id = userOrg.getLong("id");
            String name = userOrg.getString("name");
            String number = userOrg.getString("number");
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(String.format("%s %s", number, name)));
            item.setValue(id + "");
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
            list.add(item);
            ComboEdit comboEdit = (ComboEdit)this.getControl("orgcombofield");
            comboEdit.setComboItems(list);
            this.getModel().setValue("orgcombofield", (Object)orgId);
            this.getPageCache().put("orgId", orgId + "");
        }
        this.getView().addClientCallBack("initOrgComboEdit");
    }

    private void initOrgComboEdit() {
        String orgIdStr = this.getPageCache().get("orgId");
        long orgId = orgIdStr == null ? this.getPermissionOrg() : Long.parseLong(orgIdStr);
        DynamicObjectCollection datas = this.getUserHasPermOrgs();
        ArrayList list = new ArrayList(10);
        ArrayList ids = new ArrayList(10);
        datas.forEach(orgData -> {
            Long id = orgData.getLong("id");
            if (ids.contains(id)) {
                return;
            }
            String name = orgData.getString("name");
            String number = orgData.getString("number");
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(String.format("%s %s", number, name)));
            item.setValue(id + "");
            list.add(item);
            ids.add(id);
        });
        if (list.size() > 0) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("orgcombofield");
            comboEdit.setComboItems(list);
            this.getModel().setValue("orgcombofield", (Object)orgId);
            HashMap<String, Object> map = new HashMap<String, Object>();
            long defaultOrgId = UserServiceHelper.getUserDefaultOrgID((long)RequestContext.get().getCurrUserId());
            map.put("id", defaultOrgId + "");
            map.put("setDefault", true);
            this.setDefault(map);
        }
    }

    private DynamicObjectCollection getUserHasPermOrgs() {
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)userId, (boolean)true);
        QFilter orgFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
        ArrayList<Long> viewList = new ArrayList<Long>(2);
        viewList.add(15L);
        QFilter viewFilter = new QFilter("structure.view", "in", viewList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter, enableFilter};
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"bos_org", (String)"id, name, number", (QFilter[])filters, (String)"number asc");
        if (CollectionUtils.isEmpty((Collection)datas)) {
            long mainOrgId = UserServiceHelper.getUserMainOrgId((long)userId);
            datas = QueryServiceHelper.query((String)"bos_org", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)mainOrgId), enableFilter});
        }
        return datas;
    }

    private Long getPermissionOrg() {
        Long hasPermLoginOrg;
        long userId = RequestContext.get().getCurrUserId();
        Long newOrgId = UserHasPermOrgCache.processChangeLoginOrg((String)(userId + ""), null);
        if (newOrgId != null && this.checkOrgEnable(newOrgId)) {
            return newOrgId;
        }
        long orgId = RequestContext.get().getOrgId();
        boolean orgEnable = this.checkOrgEnable(orgId);
        if (!orgEnable) {
            orgId = 0L;
        }
        if ((hasPermLoginOrg = UserHasPermOrgCache.resetHasPermLoginOrg((long)userId, (Long)orgId)) != null && (orgEnable = this.checkOrgEnable(hasPermLoginOrg))) {
            return hasPermLoginOrg;
        }
        DynamicObjectCollection userHasPermOrgs = this.getUserHasPermOrgs();
        if (userHasPermOrgs != null && !userHasPermOrgs.isEmpty()) {
            for (DynamicObject data : userHasPermOrgs) {
                long dbOrgId = data.getLong("id");
                if (!Long.valueOf(orgId).equals(dbOrgId)) continue;
                return orgId;
            }
            DynamicObject data = (DynamicObject)userHasPermOrgs.get(0);
            return data.getLong("id");
        }
        return 0L;
    }

    private boolean checkOrgEnable(long orgId) {
        QFilter idFilter = new QFilter("id", "=", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.exists((String)"bos_org", (QFilter[])new QFilter[]{idFilter, enableFilter});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object orgId;
        String name = e.getProperty().getName();
        if ("orgcombofield".equals(name) && (orgId = this.getModel().getValue("orgcombofield")) != null) {
            UserServiceHelper.switchUserDefaultOrg((long)Long.parseLong(orgId.toString()));
        }
    }

    private void setUserName() {
        String userIdStr = RequestContext.get().getUserId();
        long userId = Long.parseLong(userIdStr);
        String selectFields = "id, name";
        QFilter idFilter = new QFilter("id", "=", (Object)userId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{idFilter, enableFilter};
        DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)selectFields, (QFilter[])filters);
        if (userObj != null) {
            this.getModel().setValue("username", (Object)userObj.getString("name"));
        }
    }

    public void tabClose(TabCloseEvent evt) {
        List tabKeys = evt.getTabKeys();
        ArrayList tabListClose = new ArrayList(10);
        for (String tabKey : tabKeys) {
            IFormView formView = SessionManager.getCurrent().getViewNoPlugin(tabKey);
            if (formView != null) {
                formView.close();
            }
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put("pageId", tabKey);
            tabListClose.add(arg);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("closeWindow", tabListClose);
    }

    public void tabReOpen(TabOperationEvent tabReopenEvent) {
        if (!this.isNewPortal() || !MenuModeFactory.tileMenuModeEnable()) {
            return;
        }
        if (!this.limitOpenPageNumber()) {
            return;
        }
        String pageId = tabReopenEvent.getTabKey();
        IFormView formView = this.getView().getViewNoPlugin(pageId);
        if (formView != null) {
            String mainPageId = this.getView().getPageId();
            String menuPageId = pageId.contains(mainPageId) ? pageId.substring(0, pageId.indexOf("root")) + mainPageId : pageId;
            FormShowParameter formShowParameter = formView.getFormShowParameter();
            formShowParameter.setPageId(menuPageId + StringUtils.randomNumber((int)16));
            this.getView().showForm(formShowParameter);
        }
    }

    private boolean limitOpenPageNumber() {
        Tab tab = (Tab)this.getView().getControl("tabap");
        List items = tab.getItems();
        if (items != null && items.size() > 100) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u540c\u65f6\u6253\u5f00100\u4e2a\u9875\u9762\u3002", (String)"TileMenuModeServiceImpl_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

