/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew.newmainpage;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.portal.pluginnew.common.MyMarksAbstract;
import kd.bos.portal.service.bo.PortalMenuInfo;
import kd.bos.portal.util.PortalUsableFuncUtil;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.svc.control.AppNavigationMenu;
import kd.svc.control.events.AppNavigationMenuEvent;
import org.apache.commons.lang3.StringUtils;

public class MyAppMarksPlugin
extends MyMarksAbstract {
    public static final String MY_FAVORITE_DATAS = "my_favorite_Datas";

    @Override
    public boolean isNewPortal() {
        return true;
    }

    @Override
    public String getSetMarksFormId() {
        return "portal_collect_setting";
    }

    @Override
    public void afterCreateNewDataDo() {
        this.refreshMyCurentUseMenu();
        this.refreshMarksMenu();
    }

    @Override
    public JSONArray getHasPerApps() {
        PortalUsableFuncUtil portalUsableFuncUtil = new PortalUsableFuncUtil(logger, this.getView());
        JSONArray jsonArray = portalUsableFuncUtil.getUserHasPerAppWithCache();
        if (jsonArray == null || jsonArray.isEmpty()) {
            this.sendNoAppAction();
            jsonArray = new JSONArray();
        }
        return jsonArray;
    }

    public void favoriteItemClick(AppNavigationMenuEvent evt) {
        String appId;
        Map arg = evt.getArgs();
        String id = arg.get("id") == null ? "" : arg.get("id").toString();
        String string = appId = arg.get("appId") == null ? "" : arg.get("appId").toString();
        if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)appId)) {
            this.getView().getMainView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"MyMarksAbstract_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
            return;
        }
        this.gotoMenu(id, appId);
        this.closeSlide();
    }

    public void addFavorite(AppNavigationMenuEvent evt) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(this.getSetMarksFormId());
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        param.setOpenStyle(openStyle);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closecallback_setcommon"));
        String jsonStr = this.getPageCache().get("pagecache_markeAppMenu_final");
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            Map appMenuMap = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
            param.setCustomParams(appMenuMap);
        }
        this.getView().showForm(param);
    }

    public void menuClick(AppNavigationMenuEvent evt) {
        Map arg = evt.getArgs();
        if (arg == null || arg.size() == 0) {
            return;
        }
        String type = arg.get("type") == null ? "" : arg.get("type").toString();
        String menuType = arg.get("menuType") == null ? "" : arg.get("menuType").toString();
        String menuId = arg.get("id") == null ? null : arg.get("id").toString();
        String appId = arg.get("appId") == null ? null : arg.get("appId").toString();
        String cloudId = arg.get("cloudId") == null ? null : arg.get("cloudId").toString();
        Long userId = RequestContext.get().getCurrUserId();
        switch (type) {
            case "favorite": {
                if (menuId != null && menuId.endsWith("#hpce")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e2e\u52a9\u4e2d\u5fc3\u4e0d\u652f\u6301\u6536\u85cf\u3002", (String)"BizAppHomePlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
                    return;
                }
                this.menuService.addMarkMenu(userId, menuId, appId);
                this.refreshData(menuType, userId, appId, cloudId);
                break;
            }
            case "cancelFavorite": {
                this.menuService.deleteMarkMenu(userId, menuId);
                this.refreshData(menuType, userId, appId, cloudId);
                break;
            }
        }
    }

    public void getFrequentData(AppNavigationMenuEvent evt) {
        this.refreshMyCurentUseMenu();
        this.refreshMarksMenu();
    }

    private void refreshData(String menuType, Long userId, String appId, String cloudId) {
        if ("recentUsed".equals(menuType) || "favorite".equals(menuType)) {
            this.refreshMyCurentUseMenu();
            this.refreshMarksMenu();
        } else {
            AppNavigationMenu appNavigationMenu = (AppNavigationMenu)this.getControl("appnavigationmenuap");
            List<Map<String, Object>> resultData = this.menuService.getFilterMenuData(userId, appId, cloudId);
            appNavigationMenu.setMenuData(resultData);
        }
    }

    private void refreshMyCurentUseMenu() {
        Long userId = RequestContext.get().getCurrUserId();
        JSONArray myHasPermApps = this.getHasPerApps();
        List<String> hasPermAppIds = this.getAppIdByJson(myHasPermApps);
        List<Map<String, Object>> currentUseMenuData = this.menuService.getCurrentUseMenuData(userId, hasPermAppIds);
        AppNavigationMenu appNavigationMenu = (AppNavigationMenu)this.getControl("appnavigationmenuap");
        appNavigationMenu.setRecentlyUsedMenuData(currentUseMenuData);
    }

    private void refreshMarksMenu() {
        Long userId = RequestContext.get().getCurrUserId();
        JSONArray myHasPermApps = this.getHasPerApps();
        List<String> hasPermAppIds = this.getAppIdByJson(myHasPermApps);
        List<PortalMenuInfo> favoriteMenus = this.menuService.getFavoriteMenus(userId, hasPermAppIds);
        String menuJsonStr = SerializationUtils.toJsonString(favoriteMenus);
        this.getPageCache().put(MY_FAVORITE_DATAS, menuJsonStr);
        AppNavigationMenu appNavigationMenu = (AppNavigationMenu)this.getControl("appnavigationmenuap");
        List maps = SerializationUtils.fromJsonStringToList((String)menuJsonStr, Map.class);
        appNavigationMenu.setFavoriteData(maps);
    }

    private List<String> getAppIdByJson(JSONArray allApps) {
        if (allApps == null || allApps.size() == 0) {
            return null;
        }
        ArrayList<String> hasPermAppIds = new ArrayList<String>();
        for (Object allApp : allApps) {
            if (!(allApp instanceof JSONArray)) continue;
            JSONArray cloudAndApp = (JSONArray)allApp;
            for (Object cloudAndAppObj : cloudAndApp) {
                String id;
                JSONObject cloudOrApp;
                if (!(cloudAndAppObj instanceof JSONObject) || (cloudOrApp = (JSONObject)cloudAndAppObj).get((Object)"iscloud") != null || !StringUtils.isNotBlank((CharSequence)(id = cloudOrApp.getString("id")))) continue;
                hasPermAppIds.add(id);
            }
        }
        return hasPermAppIds;
    }

    public void favoriteReOrder(AppNavigationMenuEvent evt) {
        Map args = evt.getArgs();
        try {
            Map map;
            int i;
            long currUserId = RequestContext.get().getCurrUserId();
            String favoriteDatas = this.getPageCache().get(MY_FAVORITE_DATAS);
            List markedMaps = (List)SerializationUtils.fromJsonString((String)favoriteDatas, List.class);
            int startIndex = (Integer)args.get("startIndex");
            int destinationIndex = (Integer)args.get("destinationIndex");
            if (startIndex == destinationIndex) {
                return;
            }
            if (startIndex > destinationIndex) {
                for (i = destinationIndex; i <= startIndex; ++i) {
                    map = (Map)markedMaps.get(i);
                    if (i == startIndex) {
                        map.put("index", destinationIndex + 1);
                        continue;
                    }
                    map.put("index", i + 1 + 1);
                }
            }
            if (destinationIndex > startIndex) {
                for (i = startIndex; i < destinationIndex; ++i) {
                    map = (Map)markedMaps.get(i);
                    if (i == startIndex) {
                        map.put("index", destinationIndex);
                        continue;
                    }
                    map.put("index", i);
                }
            }
            this.saveFavoriteReOrder(markedMaps, currUserId);
            this.refreshData("favorite", currUserId, "", "");
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }

    private void saveFavoriteReOrder(List<Map<String, Object>> markedMaps, long currUserId) {
        DynamicObjectCollection markedAppMenusFromDB = this.menuService.getMarkedAppMenusFromDB(currUserId);
        ArrayList<DynamicObject> hasOrder = new ArrayList<DynamicObject>(markedMaps.size());
        ArrayList<DynamicObject> noPerData = new ArrayList<DynamicObject>(markedMaps.size());
        for (DynamicObject dynamicObject : markedAppMenusFromDB) {
            Optional<Map> first = markedMaps.stream().filter(v -> null != v.get("id") && v.get("id").equals(dynamicObject.getString("menu"))).findFirst();
            if (first.isPresent()) {
                Map map = first.get();
                dynamicObject.set("markedseq", map.get("index"));
                hasOrder.add(dynamicObject);
                continue;
            }
            dynamicObject.set("markedseq", (Object)0);
            noPerData.add(dynamicObject);
        }
        if (!hasOrder.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])hasOrder.toArray(new DynamicObject[0]));
        }
        if (!noPerData.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])noPerData.toArray(new DynamicObject[0]));
        }
    }
}

