/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew.newmainpage;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IClientViewProxy;
import kd.bos.portal.pluginnew.common.PersonalSettingAbstract;
import kd.bos.portal.service.factory.MenuModeFactory;
import kd.bos.servicehelper.user.UserServiceHelper;

public class PersonalSettingNewPlugin
extends PersonalSettingAbstract {
    @Override
    public boolean isNewPortal() {
        return true;
    }

    @Override
    public void initTheme(DynamicObject[] theme) {
        if (theme == null || theme.length == 0) {
            return;
        }
        String userId = RequestContext.get().getUserId();
        Map themeMap = UserServiceHelper.getUserThemeNumAndVerNew((Long)Long.valueOf(userId));
        String selectedNum = (String)themeMap.get("number");
        CustomControl customControl = (CustomControl)this.getControl("themecustomcontrol");
        ArrayList list = new ArrayList(theme.length);
        for (DynamicObject dynamicObject : theme) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            String number = dynamicObject.getString("number");
            LocaleString name = new LocaleString(dynamicObject.get("name").toString());
            String color = dynamicObject.getString("color");
            map.put("id", number);
            map.put("description", name);
            map.put("colorValue", color);
            boolean isSelect = false;
            if (selectedNum.equals(number)) {
                isSelect = true;
            }
            map.put("isSelected", isSelect);
            list.add(map);
        }
        customControl.setData(list);
    }

    @Override
    public void userCenterDisplay() {
        Map paramMap = BaseAppParameterServiceHelper.getParameterFromCache();
        Object isEnableUserCenter = paramMap.get("isenableusercenter");
        if (StringUtils.isBlank(isEnableUserCenter) || !Boolean.parseBoolean(isEnableUserCenter.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_usercenter", "labelap3211"});
        }
    }

    @Override
    public void switchTheme(String args) {
        if (StringUtils.isEmpty((CharSequence)args)) {
            return;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        if (map.get("key") == null) {
            return;
        }
        String themeValue = map.get("key").toString();
        DynamicObject[] theme = this.getEnableThemeListSort();
        long userId = RequestContext.get().getCurrUserId();
        UserServiceHelper.setUserTheme((Long)userId, (String)themeValue);
        CustomControl customControl = (CustomControl)this.getControl("themecustomcontrol");
        ArrayList list = new ArrayList(theme.length);
        for (DynamicObject dynamicObject : theme) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            String number = dynamicObject.getString("number");
            LocaleString name = new LocaleString(dynamicObject.get("name").toString());
            String color = dynamicObject.getString("color");
            dataMap.put("id", number);
            dataMap.put("description", name);
            dataMap.put("colorValue", color);
            boolean isSelect = false;
            if (themeValue.equals(number)) {
                isSelect = true;
            }
            dataMap.put("isSelected", isSelect);
            list.add(dataMap);
        }
        customControl.setData(list);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Map defaultThemeMap = UserServiceHelper.getUserThemeNumAndVerNew((Long)userId);
        proxy.addAction("modifyTheme", (Object)defaultThemeMap);
    }

    @Override
    public String[] getSwitchPortalBtn() {
        String[] btnKeys = new String[]{"btn_oldportal", "labelap4"};
        return btnKeys;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (MenuModeFactory.accountAndOrgVisible()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"unitflexpanelap", "accountflexpanelap"});
        }
    }
}

