/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew.newmainpage;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.MyCurrentAppUtil;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.portal.util.TaskAndMsgUtil;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;

public class PortalTaskAndMsgPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String DATE_FORMAT = "MM-dd HH:mm";
    private static final String YEAR_DATE_FORMAT = "yyyy-MM-dd";
    private static final String NOTIFY_ENTITY = "notifyentity";
    private static final String MSG_ENTITY = "msgentity";
    private static final String HTML_NEWLINE_LABEL = "<br/>";
    private static final String WF_TASKCENTERHOME = "wf_msg_center";
    private static final String CONTENT = "content";
    private static final int DEFAULT_COUNT = 100;

    public void registerListener(EventObject e) {
        EntryGrid msgentity;
        super.registerListener(e);
        EntryGrid entryentity = (EntryGrid)this.getControl(NOTIFY_ENTITY);
        if (entryentity != null) {
            entryentity.addRowClickListener((RowClickEventListener)this);
        }
        if ((msgentity = (EntryGrid)this.getControl(MSG_ENTITY)) != null) {
            msgentity.addRowClickListener((RowClickEventListener)this);
        }
        Tab tab = (Tab)this.getControl("tabap");
        tab.addItemClickListener((ItemClickListener)this);
    }

    public void customEvent(CustomEventArgs e) {
        if ("afterShowSlideBill".equals(e.getKey())) {
            this.showAllMsg();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showAllMsg();
        HashMap<String, Boolean> cardParam = new HashMap<String, Boolean>();
        cardParam.put("showhov", Boolean.FALSE);
        this.getView().updateControlMetadata("cardentryrowap", cardParam);
        this.getView().updateControlMetadata("cardentryrowap11", cardParam);
    }

    private void showAllMsg() {
        this.sendAction("showNotification");
        this.sendAction("showMessage");
    }

    private void sendAction(String name) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("name", name);
        param.put("duration", 0);
        param.put("async", Boolean.TRUE);
        proxy.addAction("addClientCallBack", param);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (e == null || StringUtils.isEmpty((CharSequence)e.getName())) {
            return;
        }
        if ("showNotification".equals(e.getName())) {
            this.showNotification();
        }
        if ("showMessage".equals(e.getName())) {
            this.showMessage();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String opKey;
        switch (opKey = evt.getOperationKey()) {
            case "notifymore": {
                this.showTaskForm(0L, 1);
                break;
            }
            case "msgmore": {
                this.showTaskForm(0L, 2);
                break;
            }
        }
    }

    private void showNotification() {
        long userId = RequestContext.get().getCurrUserId();
        List notifyList = MessageCenterServiceHelper.getToHandleTasksMessage((Long)userId, (Integer)100);
        this.clearOldNotify(NOTIFY_ENTITY);
        if (!CollectionUtils.isEmpty((Collection)notifyList)) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("taskid", new Object[0]);
            vs.addField("notifytitle", new Object[0]);
            vs.addField("notification", new Object[0]);
            vs.addField("notifydate", new Object[0]);
            vs.addField("notifystatus", new Object[0]);
            for (Map notifyMap : notifyList) {
                String notification = String.valueOf(notifyMap.get(CONTENT));
                notification = this.replaceHtmlLabel(notification);
                Object handlestate = notifyMap.get("handlestate");
                Object notifydate = notifyMap.get("time");
                if (notifydate instanceof Date) {
                    notifydate = TaskAndMsgUtil.caculateTime((Date)notifydate);
                }
                vs.addRow(new Object[]{notifyMap.get("id"), notifyMap.get("title"), notification, notifydate, handlestate});
            }
            model.batchCreateNewEntryRow(NOTIFY_ENTITY, vs);
            model.endInit();
        }
        this.getView().updateView(NOTIFY_ENTITY);
    }

    private void showMessage() {
        String userId = RequestContext.get().getUserId();
        List messageList = MessageCenterServiceHelper.getUnReadMessage((String)userId, (int)100);
        this.clearOldNotify(MSG_ENTITY);
        if (!CollectionUtils.isEmpty((Collection)messageList)) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("messageid", new Object[0]);
            vs.addField("msgtitle", new Object[0]);
            vs.addField("message", new Object[0]);
            vs.addField("msgdate", new Object[0]);
            for (Map messageMap : messageList) {
                String notification = String.valueOf(messageMap.get(CONTENT));
                notification = this.replaceHtmlLabel(notification);
                Object notifydate = messageMap.get("createdate");
                if (notifydate instanceof Date) {
                    notifydate = TaskAndMsgUtil.caculateTime((Date)notifydate);
                }
                vs.addRow(new Object[]{messageMap.get("id"), messageMap.get("title"), notification, notifydate});
            }
            model.batchCreateNewEntryRow(MSG_ENTITY, vs);
            model.endInit();
        }
        this.getView().updateView(MSG_ENTITY);
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry cardEntry = (CardEntry)evt.getSource();
        if (NOTIFY_ENTITY.equals(cardEntry.getEntryKey())) {
            DynamicObject taskObj = this.getModel().getEntryRowEntity(NOTIFY_ENTITY, evt.getRow());
            long taskId = 0L;
            if (taskObj != null) {
                taskId = taskObj.getLong("taskid");
            }
            this.showTaskForm(taskId, 1);
        } else {
            DynamicObject msgObj = this.getModel().getEntryRowEntity(MSG_ENTITY, evt.getRow());
            long messageId = 0L;
            if (msgObj != null) {
                messageId = msgObj.getLong("messageid");
            }
            this.showTaskForm(messageId, 2);
        }
    }

    private void clearOldNotify(String entryentityName) {
        this.getModel().deleteEntryData(entryentityName);
    }

    private void showTaskForm(long id, int personCenterOpenType) {
        this.closeTaskAndMsg();
        if (this.getView().getMainView() == null) {
            this.getView().openUrl("#/dform?formId=wf_msg_center");
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>();
        paramMap.put("close", Boolean.TRUE);
        proxy.addAction("showSlideBill", paramMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("view", this.getView());
        map.put("appmainnumber", WF_TASKCENTERHOME);
        map.put("appname", AppMetadataCache.getAppInfo((String)"wftask").getName());
        HashMap<String, Number> customparameters = new HashMap<String, Number>(2);
        customparameters.put("tabType", personCenterOpenType);
        customparameters.put("messageId", id);
        map.put("customparameters", customparameters);
        OpenPageUtils.openApp("wftask", null, map, this.getView());
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)"wftask");
        if (appInfo != null) {
            String appId = appInfo.getId();
            MyCurrentAppUtil.putMyCurrentAppCache(appId);
        }
    }

    private void closeTaskAndMsg() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> o1 = new HashMap<String, Object>(1);
        o1.put("formId", "bos_portal_taskandmsg");
        o1.put("show", Boolean.FALSE);
        proxy.addAction("showSlideBill", o1);
    }

    private String replaceHtmlLabel(String content) {
        int labelIndex = content.indexOf(HTML_NEWLINE_LABEL);
        if (labelIndex == -1) {
            return content;
        }
        if (labelIndex == 0) {
            return this.replaceHtmlLabel(content.substring(HTML_NEWLINE_LABEL.length()));
        }
        return StringUtils.substringBefore((String)content, (String)HTML_NEWLINE_LABEL) + "...";
    }
}

