/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew.noCode;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.cache.LoginCacheService;
import kd.bos.login.utils.LoginUtils;
import kd.bos.nocode.NoCodeRuntimeService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.session.SessionKeys;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;

public class NoCodeAppUtils {
    private static final String NOCODE_USABLE_APP_IDS = "nocode_usable_appIds";
    private static Log logger = LogFactory.getLog(NoCodeAppUtils.class);
    private static LoginCacheService cacheService = new LoginCacheService("NOCODE_PORTAL");
    public static final String NOCODE_CLOUD_ID = "2HGKCE94QELW";
    public static final String NOCODE_APP_ID = "2HGKTA7HH43C";

    public static JSONArray getNoCodeApps(long userId) {
        try {
            if (NoCodeAppUtils.hasLicense(userId)) {
                JSONArray nocodeCloud = new JSONArray();
                Set<String> nocodeUsableAppIds = NoCodeAppUtils.getUsableAppIds(userId);
                if (nocodeUsableAppIds == null) {
                    return null;
                }
                DynamicObject cloudObject = BizCloudServiceHelp.getBizCloudByID((String)NOCODE_CLOUD_ID);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", (Object)cloudObject.getLocaleString("name"));
                jsonObject.put("seq", cloudObject.get("sequence"));
                jsonObject.put("iscloud", (Object)true);
                jsonObject.put("thirdapp", (Object)true);
                String image = cloudObject.getString("image");
                String bgImage = cloudObject.getString("backimage");
                if (StringUtils.isBlank((CharSequence)image)) {
                    image = "images/pc/cardbackground/cloud_ pingtai.png";
                }
                if (StringUtils.isBlank((CharSequence)bgImage)) {
                    bgImage = "images/pc/cardbackground/cloud_ pingtai.png";
                }
                jsonObject.put("bgimage", (Object)bgImage);
                jsonObject.put("pgimage", (Object)image);
                jsonObject.put("id", (Object)NOCODE_CLOUD_ID);
                jsonObject.put("cloudid", (Object)NOCODE_CLOUD_ID);
                nocodeCloud.add((Object)jsonObject);
                NoCodeAppUtils.putNoCodeIdCache(nocodeUsableAppIds, userId);
                Map<Object, DynamicObject> nocodeApps = NoCodeAppUtils.getBizAppsById(nocodeUsableAppIds);
                for (Map.Entry<Object, DynamicObject> objectEntry : nocodeApps.entrySet()) {
                    DynamicObject nocodeApp = objectEntry.getValue();
                    JSONObject app = new JSONObject();
                    app.put("image", (Object)NoCodeAppUtils.getImageUrl(nocodeApp.get("image")));
                    app.put("usertype", nocodeApp.get("usertype"));
                    app.put("description", nocodeApp.get("description"));
                    app.put("industry", nocodeApp.get("description"));
                    app.put("mainformtype", nocodeApp.get("mainformtype"));
                    app.put("isv", nocodeApp.get("isv"));
                    app.put("number", nocodeApp.get("number"));
                    app.put("cloudid", (Object)NOCODE_CLOUD_ID);
                    app.put("name", nocodeApp.get("name"));
                    app.put("alluserapp", (Object)true);
                    app.put("id", nocodeApp.get("id"));
                    app.put("seq", nocodeApp.get("sequence"));
                    app.put("thirdapp", (Object)true);
                    app.put("opentype", (Object)"1");
                    nocodeCloud.add((Object)app);
                }
                return nocodeCloud;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return null;
    }

    private static Set<String> getUsableAppIds(long userId) {
        Set nocodeUsableAppIds = NoCodePermissionServiceHelper.getUsableAppIds((long)userId);
        if (nocodeUsableAppIds == null || nocodeUsableAppIds.isEmpty()) {
            return null;
        }
        NoCodeRuntimeService service = (NoCodeRuntimeService)ServiceFactory.getService(NoCodeRuntimeService.class);
        Set templateAppIds = service.getTemplateAppIds();
        Iterator iterator = nocodeUsableAppIds.iterator();
        while (iterator.hasNext()) {
            String appId = (String)iterator.next();
            if (templateAppIds != null && templateAppIds.contains(appId)) {
                iterator.remove();
            }
            if (!NOCODE_APP_ID.equals(appId)) continue;
            iterator.remove();
        }
        return nocodeUsableAppIds;
    }

    private static String getImageUrl(Object image) {
        if (image instanceof String) {
            String img = (String)image;
            return NoCodeAppUtils.splicingUrl(img, RequestContext.get().getAccountId());
        }
        return null;
    }

    private static String splicingUrl(String url, String accountId) {
        boolean accountSession = SessionKeys.isAccountSession((String)RequestContext.get().getTenantId());
        if (accountSession) {
            if (url.contains("?")) {
                return url + "&kdcdc=" + accountId;
            }
            return url + "?kdcdc=" + accountId;
        }
        return url;
    }

    private static void putNoCodeIdCache(Set<String> nocodeUsableAppIds, long userId) {
        cacheService.put(NOCODE_USABLE_APP_IDS + userId, SerializationUtils.toJsonString(nocodeUsableAppIds));
    }

    private static String getNoCodeIdCache(long userId) {
        return cacheService.get(NOCODE_USABLE_APP_IDS + userId);
    }

    public static String getNoCodePageUrl(String appId, String formId) {
        String url = LoginUtils.getPathString((String)UrlService.getDomainContextUrl()) + "nocode/" + appId + "/home";
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            url = url + "/" + formId;
        }
        return NoCodeAppUtils.splicingUrl(url, RequestContext.get().getAccountId());
    }

    public static boolean isFromNoCode(String appId, long userId) {
        Set<String> nocodeSet = NoCodeAppUtils.getNoCodeIds(userId);
        return nocodeSet.contains(appId);
    }

    public static Set<String> getNoCodeIds(long userId) {
        String nocodeIds = NoCodeAppUtils.getNoCodeIdCache(userId);
        if (StringUtils.isBlank((CharSequence)nocodeIds)) {
            Set<String> usableAppIds = NoCodeAppUtils.getUsableAppIds(userId);
            if (usableAppIds == null) {
                return new TreeSet<String>();
            }
            NoCodeAppUtils.putNoCodeIdCache(usableAppIds, userId);
            return usableAppIds;
        }
        return (Set)SerializationUtils.fromJsonString((String)nocodeIds, Set.class);
    }

    private static Map<Object, DynamicObject> getBizAppsById(Set<String> nocodeUsableAppIds) {
        QFilter qFilter = new QFilter("id", "in", nocodeUsableAppIds).and(new QFilter("visible", "=", (Object)"1"));
        Map devportalBizapp = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id,number,name,description,sequence,image,masterid,bizcloud,visible,usertype,isv,homeurl,mainformtype,industry,alluserapp", (QFilter[])new QFilter[]{qFilter}, (String)"createdate desc");
        return devportalBizapp;
    }

    public static boolean hasLicense(long userId) {
        LicenseCheckResult licenseCheckResult = LicenseServiceHelper.checkUserInGroup((Long)userId, (Long)640L);
        return licenseCheckResult.getHasLicense();
    }

    public static Map<String, List<Map>> filterMenu(Map<String, List<Map>> menuAppIdGroup) {
        HashMap<String, List<Map>> hashMap = new HashMap<String, List<Map>>();
        if (menuAppIdGroup == null) {
            return hashMap;
        }
        String noCodeIdCache = NoCodeAppUtils.getNoCodeIdCache(RequestContext.get().getCurrUserId());
        if (StringUtils.isBlank((CharSequence)noCodeIdCache)) {
            return menuAppIdGroup;
        }
        Set nocodeIds = (Set)SerializationUtils.fromJsonString((String)noCodeIdCache, Set.class);
        for (Map.Entry<String, List<Map>> entry : menuAppIdGroup.entrySet()) {
            if (nocodeIds.contains(entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }
}

