/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.privacystatement;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.privacystatement.CountrySourceFactory;
import kd.bos.portal.service.IPrivacyStatementService;
import kd.bos.portal.service.impl.PrivacyStatementServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PrivacyStatementService {
    private static Log log = LogFactory.getLog(CountrySourceFactory.class);
    private static final String PROP_VERSION = "version";
    private static final String PROP_ENABLE = "enable";
    private IPrivacyStatementService privacyStatementService = new PrivacyStatementServiceImpl();

    public Map<String, String> getUserPrivacyStmt(String formid, String locale, Long userId, long countryId) {
        HashMap<String, String> userPrivacyStmt = new HashMap<String, String>();
        DynamicObject privacyStmt = this.getExtPrivacyStatement(userId, Lang.from((String)locale), formid);
        if (null == privacyStmt) {
            privacyStmt = this.getLatestPrivacyStatement(formid, locale, countryId);
        }
        if (null == privacyStmt || userId == -10110L) {
            return userPrivacyStmt;
        }
        Object pkid = privacyStmt.get("id");
        String version = privacyStmt.getString(PROP_VERSION);
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        QFilter privacystmtFilter = new QFilter("privacystmt", "=", pkid);
        QFilter[] filters = new QFilter[]{userFilter, privacystmtFilter};
        DynamicObject[] privacystmtSigns = BusinessDataServiceHelper.load((String)"userprivacystmt", (String)"id, privacystmt, isagree, modifytime", (QFilter[])filters);
        boolean isNeedSign = false;
        if (privacystmtSigns.length == 0) {
            privacystmtSigns = BusinessDataServiceHelper.load((String)"userprivacystmthistory", (String)"id, privacystmt, isagree, modifytime", (QFilter[])filters);
            if (!"1".equals(this.getLatestPrivacystmtSign(Arrays.asList(privacystmtSigns), version))) {
                isNeedSign = true;
            }
        } else if (!"1".equals(this.getLatestPrivacystmtSign(Arrays.asList(privacystmtSigns), version))) {
            isNeedSign = true;
        }
        if (isNeedSign) {
            String content = privacyStmt.getString("content_tag");
            userPrivacyStmt.put("pkid", pkid.toString());
            userPrivacyStmt.put("content", content);
            userPrivacyStmt.put("formid", formid);
        }
        return userPrivacyStmt;
    }

    private DynamicObject getExtPrivacyStatement(Long userId, Lang lang, String formid) {
        Long privacyStatementExt = this.privacyStatementService.getPrivacyStatementExt(userId, lang, formid);
        if (null != privacyStatementExt) {
            return BusinessDataServiceHelper.loadSingle((String)"privacystatement", (String)"id, number, name, version, locale, form, content_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)privacyStatementExt)});
        }
        return null;
    }

    private DynamicObject getLatestPrivacyStatement(String formid, String locale, long countryId) {
        DynamicObjectCollection privacyStmtCollection = this.getMatchedPrivacyStmts(formid, locale, countryId);
        if (CollectionUtils.isEmpty((Collection)privacyStmtCollection)) {
            return null;
        }
        return this.getLatestPrivacyStmt(privacyStmtCollection);
    }

    private DynamicObject getLatestPrivacyStmt(DynamicObjectCollection privacystmts) {
        DynamicObject privacyStmt = privacystmts.size() == 1 ? (DynamicObject)privacystmts.get(0) : privacystmts.stream().max(Comparator.comparing(dynamicObject -> Double.valueOf(dynamicObject.getString(PROP_VERSION).substring(1)))).get();
        return privacyStmt;
    }

    private DynamicObjectCollection getMatchedPrivacyStmts(String formid, String locale, long countryId) {
        QFilter[] filter;
        QFilter formFilter = new QFilter("form", "=", (Object)formid);
        QFilter localeFilter = new QFilter("locale.number", "=", (Object)locale);
        Optional<Boolean> matchCountrySwitchOp = this.privacyStatementService.isCountrySwitchOpen();
        if (matchCountrySwitchOp.isPresent() && matchCountrySwitchOp.get().booleanValue()) {
            QFilter countryFilter = new QFilter("country", "=", (Object)countryId);
            filter = new QFilter[]{formFilter, localeFilter, countryFilter, new QFilter("status", "=", (Object)"C"), new QFilter(PROP_ENABLE, "=", (Object)Boolean.TRUE)};
        } else {
            filter = new QFilter[]{formFilter, localeFilter, new QFilter("status", "=", (Object)"C"), new QFilter(PROP_ENABLE, "=", (Object)Boolean.TRUE)};
        }
        DynamicObjectCollection privacystmts = QueryServiceHelper.query((String)"privacystatement", (String)"id, number, name, version, locale, form, content_tag", (QFilter[])filter);
        return privacystmts;
    }

    private String getLatestPrivacystmtSign(List<DynamicObject> privacystmtSigns, String version) {
        Optional<DynamicObject> optional = privacystmtSigns.stream().filter(ps -> ps.getDynamicObject("privacystmt").getString(PROP_VERSION).equals(version)).max(Comparator.comparing(p -> p.getString("modifytime")));
        if (optional.isPresent()) {
            DynamicObject privacystmtSign = optional.get();
            return privacystmtSign.getString("isagree");
        }
        return null;
    }
}

