/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.schedule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.license.NextCloud;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.datalog.service.IDataCollectService;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.DisCardUtil;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class DataCollectSchedule
extends AbstractTask {
    private static Log logger = LogFactory.getLog(DataCollectSchedule.class);
    private static ServiceLoader<IDataCollectService> dataCollectServices = DataCollectSchedule.loadService();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        for (IDataCollectService dataCollectService : dataCollectServices) {
            List<Map<String, Object>> cusData = this.getCusData(dataCollectService);
            if (!ObjectUtils.isNotEmpty(cusData)) continue;
            list.addAll(cusData);
        }
        this.synchData(list);
    }

    private void synchData(List<Map<String, Object>> cusDataList) {
        if (ObjectUtils.isEmpty(cusDataList)) {
            return;
        }
        int i = 1;
        boolean isOk = true;
        int batchSize = 20;
        while (isOk) {
            List<Map<String, Object>> dataList = null;
            if (i * batchSize < cusDataList.size()) {
                dataList = this.subList(cusDataList, (i - 1) * batchSize, i * batchSize);
            } else {
                dataList = this.subList(cusDataList, (i - 1) * batchSize, cusDataList.size());
                isOk = false;
            }
            this.synToDataPlatform(dataList);
            ++i;
        }
    }

    private void synToDataPlatform(List<Map<String, Object>> dataList) {
        try {
            Map result;
            String body = this.wrapBody(dataList);
            Map<String, String> header = this.getHeader();
            String url = "https://bj2-api.kingdee.com/laddercs/ladderlog?project=%s&store=%s&client_id=%s&client_secret=%s";
            url = String.format(url, "cosmic", "server_beacon", NextCloud.CLIENT_ID, NextCloud.CLIENT_SECRET);
            String responseData = HttpClientUtils.postjson((String)url, header, (String)body);
            if (StringUtils.isNotBlank((CharSequence)responseData) && !"0".equals(String.valueOf((result = (Map)JSONUtils.cast((String)responseData, HashMap.class)).get("errcode")))) {
                logger.info(String.valueOf(result.get("description")));
            }
        }
        catch (Exception e) {
            logger.info("kd.bos.portal.schedule.DataCollectSchedule.synchData", (Object)e);
        }
    }

    private List<Map<String, Object>> subList(List<Map<String, Object>> cusDataList, int start, int end) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        for (int i = start; i < end; ++i) {
            list.add(cusDataList.get(i));
        }
        return list;
    }

    private Map<String, String> getHeader() {
        HashMap<String, String> header = new HashMap<String, String>(8);
        return header;
    }

    private String wrapBody(List<Map<String, Object>> dataList) {
        JSONArray array = new JSONArray();
        dataList.forEach(map -> {
            try {
                JSONObject json = new JSONObject();
                json.put("tenant_id", (Object)RequestContext.get().getTenantId());
                json.put("dc_id", (Object)RequestContext.get().getAccountId());
                json.put("event_name", (Object)"svc_statistics_template");
                json.put("synDataTime", System.currentTimeMillis());
                json.put("cusData", (Object)new JSONObject(map));
                array.put((Object)json);
            }
            catch (Exception e) {
                DisCardUtil.discard();
            }
        });
        return array.toString();
    }

    private List<Map<String, Object>> getCusData(IDataCollectService dataCollectService) {
        try {
            Map data;
            ArrayList<Map<String, Object>> list = dataCollectService.collectBatchData();
            if (ObjectUtils.isEmpty((Object)list)) {
                list = new ArrayList<Map<String, Object>>(8);
            }
            if (!ObjectUtils.isEmpty((Object)(data = dataCollectService.collectData()))) {
                list.add(data);
            }
            return list;
        }
        catch (Exception e) {
            DisCardUtil.discard();
            return null;
        }
    }

    private static ServiceLoader<IDataCollectService> loadService() {
        ServiceLoader<IDataCollectService> dataCollectServices = ServiceLoader.load(IDataCollectService.class);
        return dataCollectServices;
    }
}

