/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.schedule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.portal.model.LegalPrivacyPolicyDto;
import kd.bos.portal.service.IPrivacyPolicyService;
import kd.bos.portal.service.impl.PrivacyPolicyServiceImpl;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;

public class PrivacyPolicySchedule
extends AbstractTask {
    private static Log logger = LogFactory.getLog(PrivacyPolicySchedule.class);
    private static IPrivacyPolicyService privacyPolicyService = new PrivacyPolicyServiceImpl();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (PrivacyPolicyServiceImpl.enablePrivacy()) {
            this.synLatestPrivacyPolicy();
        }
    }

    private void synLatestPrivacyPolicy() {
        List<LegalPrivacyPolicyDto> privacyPolicy;
        List<LegalPrivacyPolicyDto> userPolicy = this.getPrivacyPolicy("1");
        if (!ObjectUtils.isEmpty(userPolicy)) {
            privacyPolicyService.savePrivacyPolicy(userPolicy, "1");
        }
        if (!ObjectUtils.isEmpty(privacyPolicy = this.getPrivacyPolicy("2"))) {
            privacyPolicyService.savePrivacyPolicy(privacyPolicy, "2");
        }
    }

    private List<LegalPrivacyPolicyDto> getPrivacyPolicy(String type) {
        List<LegalPrivacyPolicyDto> privacyPolicy = new ArrayList<LegalPrivacyPolicyDto>(8);
        try {
            Map result;
            String url = DefaultParameterService.getDefaultValueByKey((String)"privacy_policy_url") + "/kapi/v2/kdec/kdec_legal_center/legalPrivacyPolicy/getPrivacyPolicyList?productVersion=7.0.1&type=" + type;
            String data = HttpClientUtils.get((String)url);
            if (StringUtils.isNotBlank((CharSequence)data) && (result = (Map)JSONUtils.cast((String)data, HashMap.class)) != null && "true".equals(String.valueOf(result.get("status"))) && !ObjectUtils.isEmpty(result.get("data"))) {
                List list = (List)result.get("data");
                privacyPolicy = this.wrapData(list);
            }
        }
        catch (Exception e) {
            logger.info("kd.bos.portal.schedule.PrivacyPolicySchedule.getPrivacyPolicy", (Object)e);
        }
        return privacyPolicy;
    }

    private List<LegalPrivacyPolicyDto> wrapData(List<Map<String, String>> list) {
        ArrayList<LegalPrivacyPolicyDto> result = new ArrayList<LegalPrivacyPolicyDto>(8);
        for (Map<String, String> map : list) {
            LegalPrivacyPolicyDto legalPrivacyPolicyDto = new LegalPrivacyPolicyDto();
            legalPrivacyPolicyDto.setId(Long.parseLong(map.get("id")));
            legalPrivacyPolicyDto.setVersion(map.get("version"));
            legalPrivacyPolicyDto.setContent(map.get("content"));
            legalPrivacyPolicyDto.setCountry(map.get("country"));
            legalPrivacyPolicyDto.setLanguage(map.get("language"));
            if (StringUtils.isNotBlank((CharSequence)map.get("createtime"))) {
                legalPrivacyPolicyDto.setCreatetime(map.get("createtime"));
            }
            if (StringUtils.isNotBlank((CharSequence)map.get("modifytime"))) {
                legalPrivacyPolicyDto.setModifytime(map.get("modifytime"));
            }
            result.add(legalPrivacyPolicyDto);
        }
        return result;
    }
}

