/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.extplugin.PluginProxy;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.emun.LoginConfigEnum;
import kd.bos.login.service.IExtLoginConfigService;
import kd.bos.login.service.ILoginConfigService;
import kd.bos.login.service.IThirdAppExtService;
import kd.bos.login.service.dto.CustomLoginConfig;
import kd.bos.login.service.dto.CustomLoginParams;
import kd.bos.login.service.dto.CustomPolicyLink;
import kd.bos.login.service.factory.BaseFactory;
import kd.bos.login.service.factory.LoginConfigBuildFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.portal.aggregator.ApiAggregatePostProcessor;
import kd.bos.portal.aggregator.GeneralResponse;
import kd.bos.portal.privacy.IPrivacyStatementExtService;
import kd.bos.util.CollectionUtils;

public class ExtLoginConfigService
implements IExtLoginConfigService {
    private static Log logger = LogFactory.getLog(ExtLoginConfigService.class);
    private ILoginConfigService configService;

    public ExtLoginConfigService() {
        this("bizextplugin");
    }

    public ExtLoginConfigService(String type) {
        BaseFactory factory = LoginConfigBuildFactory.getFactory(type);
        this.configService = factory.getLoginConfigService();
    }

    public ExtLoginConfigService(ILoginConfigService loginConfigService) {
        this.configService = loginConfigService;
    }

    public Map<String, Object> getLoginConfigServiceData(CustomLoginParams params, String others) {
        BaseFactory factory = LoginConfigBuildFactory.getFactory(params.getType());
        this.configService = factory.getLoginConfigService();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (this.configService == null) {
            return map;
        }
        map.putAll(this.getCustomLoginConfig(params));
        map.putAll(this.getCustomPolicyLink(params.getLangList()));
        return map;
    }

    public Map<String, Object> getLoginConfigServiceData(List<String> numList) {
        CustomLoginParams loginParams = new CustomLoginParams();
        loginParams.setType("bizextplugin");
        loginParams.setLangList(numList);
        return this.getLoginConfigServiceData(loginParams, "");
    }

    public Map<String, Object> getExtData(String caseName, String type) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        PluginProxy pluginProxy = PluginProxy.create(null, ApiAggregatePostProcessor.class, (String)caseName, null);
        List plugins = pluginProxy.getPlugins();
        for (ApiAggregatePostProcessor apiAggregatePostProcessor : plugins) {
            try {
                GeneralResponse generalResponse = apiAggregatePostProcessor.getData();
                map.put(generalResponse.getKey(), generalResponse.getPlayload());
            }
            catch (Exception e) {
                logger.info("getData error", (Object)e);
            }
        }
        return map;
    }

    public Map<String, Object> afterLoginApps(Long userId, String appType, String entryRole) {
        IThirdAppExtService thirdAppLoginPlugin = this.getThirdAppLoginPlugin();
        if (thirdAppLoginPlugin != null) {
            try {
                return thirdAppLoginPlugin.afterLoginApps(userId, appType, entryRole);
            }
            catch (Exception e) {
                logger.info("afterLoginApps error", (Object)e);
            }
        }
        return null;
    }

    public boolean hasLoginThirdAppPlugin() {
        IThirdAppExtService thirdAppLoginPlugin = this.getThirdAppLoginPlugin();
        return thirdAppLoginPlugin != null;
    }

    private IThirdAppExtService getThirdAppLoginPlugin() {
        PluginProxy pluginProxy = PluginProxy.create(null, IThirdAppExtService.class, (String)"BOS_SVC_LOGIN_THIRDAPP", null);
        List plugins = pluginProxy.getPlugins();
        if (plugins != null && plugins.size() > 0) {
            return (IThirdAppExtService)plugins.get(0);
        }
        return null;
    }

    public Map<String, Object> getExtData(String caseName) {
        return this.getExtData(caseName, "bizextplugin");
    }

    public String getMainPageLogoData(String language) {
        if (this.configService == null) {
            return null;
        }
        return this.configService.getMainPageCustomLogo(language);
    }

    private Map<String, Object> getCustomLoginConfig(CustomLoginParams params) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        try {
            CustomLoginConfig customLoginConfig = null;
            customLoginConfig = "extConfigPlugin".equals(params.getType()) ? this.configService.getCustomLoginConfig(params) : this.configService.getCustomLoginConfig(params.getLangList());
            if (customLoginConfig != null) {
                LocaleString tabImg;
                LocaleString logoImg;
                LocaleString bgImg;
                LocaleString welcomeMsg;
                LocaleString tabWord;
                logger.info("getLoginConfigServiceData:" + customLoginConfig);
                LocaleString accountTypeDesc = customLoginConfig.getAccountTypeDesc();
                if (this.isNotEmptyValue(accountTypeDesc)) {
                    this.subLengthStr(accountTypeDesc);
                    map.put(LoginConfigEnum.ACCOUNT_TYPE_DESC.getKey(), accountTypeDesc);
                }
                if (this.isNotEmptyValue(tabWord = customLoginConfig.getTabWord())) {
                    this.subLengthStr(tabWord);
                    map.put(LoginConfigEnum.TAB_WORD.getKey(), tabWord);
                }
                if (this.isNotEmptyValue(welcomeMsg = customLoginConfig.getWelcomeMsg())) {
                    this.subLengthStr(welcomeMsg);
                    map.put(LoginConfigEnum.WELCOME_MSG.getKey(), welcomeMsg);
                }
                if (this.isNotEmptyValue(bgImg = customLoginConfig.getBgImg())) {
                    map.put(LoginConfigEnum.BG_IMG.getKey(), bgImg);
                }
                if (this.isNotEmptyValue(logoImg = customLoginConfig.getLogoImg())) {
                    map.put(LoginConfigEnum.LOGO_IMG.getKey(), logoImg);
                }
                if (this.isNotEmptyValue(tabImg = customLoginConfig.getTabImg())) {
                    map.put(LoginConfigEnum.TAB_IMG.getKey(), tabImg);
                }
                if (customLoginConfig.isShowpolicy()) {
                    map.put(LoginConfigEnum.SHOW_POLICY.getKey(), customLoginConfig.isShowpolicy());
                }
            }
        }
        catch (Exception e) {
            logger.info("getLoginConfigServiceData--getCustomLoginConfig error", (Object)e);
        }
        return map;
    }

    private Map<String, Object> getCustomPolicyLink(List<String> numList) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        try {
            List<List<CustomPolicyLink>> policylink = this.configService.getCustomPolicyLink(numList);
            if (CollectionUtils.isNotEmpty(policylink)) {
                String data = SerializationUtils.toJsonString(policylink);
                logger.info("getLoginConfigServiceData:" + data);
                map.put(LoginConfigEnum.POLICY_LINK.getKey(), SerializationUtils.fromJsonString((String)data, List.class));
            }
        }
        catch (Exception e) {
            logger.info("getLoginConfigServiceData--getCustomPolicyLink error", (Object)e);
        }
        return map;
    }

    private boolean isNotEmptyValue(LocaleString value) {
        if (value == null) {
            return false;
        }
        for (Map.Entry entry : value.entrySet()) {
            String v = (String)entry.getValue();
            if (!StringUtils.isNotEmpty((String)v)) continue;
            return true;
        }
        return false;
    }

    private void subLengthStr(LocaleString value) {
        int length = 50;
        for (Map.Entry entry : value.entrySet()) {
            String v = (String)entry.getValue();
            if (v == null || v.length() <= length) continue;
            value.setItem((String)entry.getKey(), (Object)v.substring(0, length));
        }
    }

    public Long getPrivacyStatement(Long userId, Lang lang, String source) {
        PluginProxy pluginProxy = PluginProxy.create(null, IPrivacyStatementExtService.class, (String)"BOS_SVC_PORTAL_PRIVACY_STATEMENT", null);
        List plugins = pluginProxy.getPlugins();
        if (plugins != null && plugins.size() > 0) {
            IPrivacyStatementExtService iPrivacyStatementExtService = (IPrivacyStatementExtService)plugins.get(0);
            return iPrivacyStatementExtService.getPrivacyStatement(userId, lang, source);
        }
        return null;
    }
}

