/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.service;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.service.InitailVersionService;
import kd.bos.session.service.DBUtils;

public class InitailVersionServiceImpl
implements InitailVersionService {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("isInitailVersion", new DistributeCacheHAPolicy(true, true));
    private static final Log logger = LogFactory.getLog(InitailVersionServiceImpl.class);
    private static Map<String, String> versionMap = new HashMap<String, String>();

    public boolean isInitailVersion(int versionNumber) {
        boolean isInitailVersion;
        String accountId = RequestContext.get().getAccountId();
        String key = this.getKey(accountId, versionNumber);
        String value = this.getCache(key);
        if (value != null) {
            logger.debug(String.format("isInitailVersion from cache:%s, accountId:%s, versionNumber:%s", value, accountId, versionNumber));
            isInitailVersion = Boolean.parseBoolean(value);
        } else {
            Account account = AccountUtils.getAccountById((String)accountId);
            isInitailVersion = this.isInitailVersionExist(versionNumber, account);
            logger.debug(String.format("isInitailVersion from db:%s, accountId:%s, versionNumber:%s", isInitailVersion, accountId, versionNumber));
            this.putCache(key, String.valueOf(isInitailVersion));
        }
        return isInitailVersion;
    }

    private String getCache(String key) {
        String value = versionMap.get(key);
        if (value != null) {
            return value;
        }
        value = (String)cache.get(key);
        if (value != null) {
            versionMap.put(key, value);
        }
        return value;
    }

    private void putCache(String key, String value) {
        versionMap.put(key, value);
        cache.put(key, (Object)value);
    }

    private String getKey(String accountId, int versionNumber) {
        return String.format("isInitailVersion_%s_%s", accountId, versionNumber);
    }

    public void removeCache(int versionNumber) {
        String accountId = RequestContext.get().getAccountId();
        String key = this.getKey(accountId, versionNumber);
        versionMap.remove(key);
        cache.remove(key);
    }

    public void removeCache() {
        this.removeCache(6);
    }

    private boolean isInitailVersionExist(int versionNumber, Account account) {
        String selectSql = "select fid from T_BAS_DEFAULT_PARAMS  where fparam_key = ?";
        String param = "cosmic_initial_version_" + versionNumber;
        return (Boolean)DBUtils.query((Account)account, (DBRoute)DBRoute.base, (String)selectSql, (Object[])new Object[]{param}, ResultSet::next);
    }
}

