/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.service;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.license.api.bean.LicenseGrayNotice;
import kd.bos.list.ListFilterParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.NewPortalService;
import kd.bos.login.utils.BeanUtils;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.req.CheckPermissionReq;
import kd.bos.permission.model.perm.req.user.CheckUserBizAppReq;
import kd.bos.portal.model.BrandUpEnum;
import kd.bos.portal.plugin.trace.MenuTraceService;
import kd.bos.portal.plugin.yzj.enums.YzjAppEnum;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.service.bo.OpenPageContext;
import kd.bos.portal.util.CollectAppAndMenuUtil;
import kd.bos.portal.util.MyCurrentAppUtil;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.portal.util.PortalMessageUtils;
import kd.bos.servicehelper.license.LicenseGrayServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public abstract class MenuModeServiceAbstract {
    private static Log logger = LogFactory.getLog(MenuModeServiceAbstract.class);
    private static final String TABAP = "tabap";
    private static final String FILTER_SCHEME_ID = "filterSchemeId";
    private static final String APPNAME = "appname";
    private static final String APPMAINNUMBER = "appmainnumber";
    private static final String APPIMAGEURL = "appImageUrl";
    private static final String FORMNUMBER = "formnumber";
    private static final String PARAMETER = "parameter";
    private static final String WFTASK = "wftask";
    private static final String PARAMETERTYPE = "parametertype";
    private static final String APPID = "appid";
    private static final String YYY_MM_DD_HH_MM_SS = "yyy-MM-dd hh:mm:ss";
    private static final String TIME = "---time:";
    private static final String MESSAGE_ID = "messageId";
    private static final String TAB_TYPE = "tabType";
    private static final String OPEN_PAGE = "openPage";
    private static final String BILL_FORM_ID = "billFormId";
    private static final String SPLIT_STR = "@";
    private static final String NEW_WINDOW = "1";
    private static final String MODAL = "2";
    private static final String CUSTOMPARAMETERS = "customparameters";
    protected static final String HOMEPAGE_TABAP_COUNT = "homepage_tabap_count";
    protected static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static ThreadPool pool = ThreadPools.newCachedThreadPool((String)"trace_user_menu_1", (int)0, (int)3);

    protected abstract String getShowFormTargetKey();

    protected abstract void showMenuPage(OpenPageContext var1, FormShowParameter var2);

    protected abstract void openAppMenuProcess(OpenPageContext var1);

    protected abstract boolean limitOpenPageNumber(OpenPageContext var1, boolean var2);

    public void openApp(String appId, String menuId, Map<String, Object> map, IFormView myappView, String selfAppName) {
        try {
            OpenPageContext openPageContext = new OpenPageContext(appId, menuId, map, myappView, selfAppName);
            boolean result = this.checkPermission(openPageContext);
            if (!result) {
                return;
            }
            result = this.checkListFilterSchemePerm(openPageContext);
            if (!result) {
                return;
            }
            this.showAppFeatureMsg(openPageContext);
            this.openAppMenuProcess(openPageContext);
            AppInfo app = openPageContext.getAppInfo();
            MyCurrentAppUtil.putMyCurrentUseAppMenu(app.getId(), menuId);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if ("LicenseGrayNotice EXPIRED".equals(message)) {
                logger.info(message);
            }
            logger.info("openApp error", (Object)e);
            myappView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u9875\u9762\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u9875\u9762\u63d2\u4ef6\u6216\u670d\u52a1\uff0c\u8be6\u7ec6\u9519\u8bef\uff1a%s", (String)"MenuModeServiceAbstract_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage()));
        }
    }

    private boolean checkPermission(OpenPageContext openPageContext) {
        Long userId = RequestContext.get().getCurrUserId();
        PermResult permResult = this.checkAppMenuPermission(openPageContext);
        Map<String, Object> map = openPageContext.getParameter();
        if (!permResult.isOk()) {
            if (map.containsKey("openUserFixedApp")) {
                DeleteServiceHelper.delete((String)"bos_portal_userfixedapp", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("bizapp", "=", (Object)openPageContext.getAppNumber())});
            } else {
                openPageContext.getCurrentView().showMessage(permResult.getMsg());
            }
            return false;
        }
        return true;
    }

    private PermResult checkAppMenuPermission(OpenPageContext openPageContext) {
        PermResult permResult;
        AppInfo app = openPageContext.getAppInfo();
        Map<String, Object> map = openPageContext.getParameter();
        String menuId = openPageContext.getMenuId();
        String appNumber = openPageContext.getAppNumber();
        Long userId = RequestContext.get().getCurrUserId();
        boolean isSuperAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        boolean isDisableApp = this.checkIsDisableApp(app.getId());
        if (isDisableApp) {
            return PermResult.fail((String)ResManager.loadKDString((String)"\u5e94\u7528\u5df2\u7981\u7528\uff0c\u65e0\u6743\u8bbf\u95ee\u3002", (String)"OpenPageUtils_12", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
        String formNumber = (String)map.get(FORMNUMBER);
        boolean isAllUserApp = app.isAllUserApp();
        if (isAllUserApp) {
            if (appNumber.equals(WFTASK)) {
                return PermResult.ok();
            }
            if (isSuperAdmin && !OpenPageUtils.isAllowAdminBizOperate()) {
                return PermResult.fail((String)ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u4e0d\u5141\u8bb8\u505a\u4e1a\u52a1\u64cd\u4f5c\u3002", (String)"ADMIN_CANNOT_DOBUSI", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            Set appBlackSet = PermissionServiceHelper.getAppBlackSet((Long)RequestContext.get().getCurrUserId());
            if (appBlackSet.contains(app.getId())) {
                return PermResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u5b58\u5728\u4e8e\u5168\u5458\u5e94\u7528\u9ed1\u540d\u5355\u4e2d\u3002", (String)"CURAPP_IS_ALLUSERAPPBLACK", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            Map checkPermAllUserAppEntMap = PermissionServiceHelper.getCheckPermAllUserAppEntMap();
            List entNums = (List)checkPermAllUserAppEntMap.get(app.getId());
            if (entNums == null || !entNums.contains(formNumber)) {
                return PermResult.ok();
            }
        }
        if (!(permResult = PermissionServiceHelper.checkUserBizApp((CheckUserBizAppReq)new CheckUserBizAppReq(userId, app.getId()))).isOk()) {
            return permResult;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)menuId)) {
            boolean isNotSpecialMenu = true;
            AppMenuInfo menu = null;
            try {
                menu = AppMetadataCache.getAppMenuInfo((String)appNumber, (String)menuId);
            }
            catch (Exception e) {
                logger.info("getAppMenuInfo error", (Object)e);
            }
            IFormView view = (IFormView)map.get("view");
            if (menu != null && view != null) {
                if ("link".equals(menu.getMenuType())) {
                    return PermResult.ok();
                }
                Short menuSeq = menu.getSeq();
                if (menuSeq == -1) {
                    isNotSpecialMenu = false;
                }
                if (isNotSpecialMenu) {
                    if (formNumber != null) {
                        String parameterType = "";
                        if (map.get(PARAMETERTYPE) != null) {
                            parameterType = (String)map.get(PARAMETERTYPE);
                        }
                        String permItem = map.get("permItem") == null ? null : map.get("permItem").toString();
                        boolean isOnlyCheckView = false;
                        String formId = view.getFormShowParameter().getFormId();
                        if ("bos_card_numstatisticcard".equals(formId) || "bos_card_sumstatisticcard".equals(formId)) {
                            isOnlyCheckView = true;
                        }
                        permResult = isOnlyCheckView ? PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(userId, null, app.getId(), formNumber, "47150e89000000ac")) : (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)permItem) ? ("ListShowParameter".equalsIgnoreCase(parameterType) || "ReportShowParameter".equalsIgnoreCase(parameterType) || "FormShowParameter".equalsIgnoreCase(parameterType) ? PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(userId, null, app.getId(), formNumber, "47150e89000000ac")) : ("BillShowParameter".equalsIgnoreCase(parameterType) || "BaseShowParameter".equalsIgnoreCase(parameterType) ? PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(userId, null, app.getId(), formNumber, "47156aff000000ac")) : PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(userId, null, app.getId(), formNumber, "47150e89000000ac")))) : PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(userId, null, app.getId(), formNumber, permItem)));
                    } else {
                        String openPageUtils_6 = ResManager.loadKDString((String)"\u5f53\u524d\u83dc\u5355\u672a\u7ed1\u5b9a\u5355\u636e\uff0c\u8bf7\u524d\u5f80\u201c\u5f00\u53d1\u5e73\u53f0\u201d\u91cd\u65b0\u914d\u7f6e\u3002", (String)"OpenPageUtils_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                        view.showTipNotification(openPageUtils_6);
                        permResult = PermResult.fail((String)openPageUtils_6);
                    }
                }
            }
        }
        logger.info("checkAppMenuPermission end..., permResult:{}", (Object)permResult);
        return permResult;
    }

    private boolean checkListFilterSchemePerm(OpenPageContext openPageContext) {
        Map<String, Object> map = openPageContext.getParameter();
        IFormView currentView = openPageContext.getCurrentView();
        Object para = map.get(PARAMETER);
        if (para != null) {
            Map parameter = (Map)SerializationUtils.fromJsonString((String)para.toString(), Map.class);
            String filterSchemeId = null;
            if (parameter != null) {
                filterSchemeId = (String)parameter.get(FILTER_SCHEME_ID);
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(filterSchemeId)) {
                if (!CardUtils.isHaveSchemeRecord(filterSchemeId)) {
                    currentView.showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"OpenPageUtils_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    return false;
                }
                if (!OpenPageUtils.isHaveSchemeAuth(filterSchemeId, RequestContext.get().getCurrUserId())) {
                    currentView.showMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u65b9\u6848\u6743\u9650\u3002", (String)"OpenPageUtils_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    return false;
                }
            }
        }
        return true;
    }

    private void showAppFeatureMsg(OpenPageContext openPageContext) {
        IFormView mainPageView = openPageContext.getMainView();
        String appNumber = openPageContext.getAppNumber();
        IFormView currentView = openPageContext.getCurrentView();
        String showMessage = (String)currentView.getFormShowParameter().getCustomParam("showMessage");
        if (!"false".equals(showMessage)) {
            String mainPageId = mainPageView.getPageId();
            PortalMessageUtils.showActivityMessageAsync(mainPageId, appNumber);
        }
    }

    protected void showAppWithOpenType(OpenPageContext openPageContext) {
        String openType;
        Map<String, Object> parameter = openPageContext.getParameter();
        Object isFixedApp = parameter.get("openUserFixedApp");
        if (!"true".equals(isFixedApp)) {
            AppInfo appInfo = openPageContext.getAppInfo();
            boolean result = this.checkLicenseGray(openPageContext.getCurrentView(), appInfo.getHomeNum(), appInfo.getNumber(), appInfo.getCloudNum());
            if (!result) {
                openPageContext.getMainView().getPageCache().put("Portal_LicenseGrayNotice_" + openPageContext.getAppNumber(), "true");
            }
        }
        AppInfo app = openPageContext.getAppInfo();
        switch (openType = app.getOpenType()) {
            case "1": {
                this.showFormWithNewWindow(openPageContext);
                break;
            }
            case "2": {
                this.showFormWithModal(openPageContext);
                break;
            }
            default: {
                this.doOpenApp(openPageContext);
            }
        }
    }

    private boolean checkLicenseGray(IFormView view, String formNum, String appNum, String cloudNum) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)formNum)) {
            return true;
        }
        IFormView mainView = view.getMainView();
        LicenseGrayNotice notice = LicenseGrayServiceHelper.getExpiringGrayFeatureNotice((Long)RequestContext.get().getCurrUserId(), (String)formNum, (String)appNum, (String)cloudNum);
        LicenseGrayNotice.NoticeType noticeType = notice.getNoticeType();
        if (noticeType == LicenseGrayNotice.NoticeType.UNEXPIRED || noticeType == LicenseGrayNotice.NoticeType.EXPIRED) {
            String message = notice.getNoticeMessage();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)message)) {
                mainView.showForm(PortalMessageUtils.createFormShowParameter(notice.getTitle(), message));
                view.sendFormAction(mainView);
            }
            if (noticeType == LicenseGrayNotice.NoticeType.EXPIRED) {
                throw new KDException(new ErrorCode("LicenseGrayNotice EXPIRED", "LicenseGrayNotice EXPIRED"), new Object[0]);
            }
            return false;
        }
        return true;
    }

    private void showFormWithNewWindow(OpenPageContext openPageContext) {
        String appNumber = openPageContext.getAppNumber();
        IFormView currentView = openPageContext.getCurrentView();
        String formNumber = openPageContext.getFormNumber();
        if ("devportal".equals(appNumber) || "devnew".equals(appNumber)) {
            currentView.openUrl("?formId=" + formNumber);
        } else {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(formNumber);
            fsp.setAppId(openPageContext.getAppNumber());
            fsp.getOpenStyle().setShowType(ShowType.NewWindow);
            currentView.showForm(fsp);
        }
    }

    private void showFormWithModal(OpenPageContext openPageContext) {
        IFormView currentView = openPageContext.getCurrentView();
        String formNumber = openPageContext.getFormNumber();
        FormShowParameter fsp = new FormShowParameter();
        fsp.setAppId(openPageContext.getAppNumber());
        fsp.setFormId(formNumber);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        currentView.showForm(fsp);
    }

    private void doOpenApp(OpenPageContext openPageContext) {
        IFormView mainPageView = openPageContext.getMainView();
        IFormView currentView = openPageContext.getCurrentView();
        String appNumber = openPageContext.getAppNumber();
        String mainPageId = mainPageView.getPageId();
        Map<String, Object> map = openPageContext.getParameter();
        Tab tab = (Tab)mainPageView.getControl(TABAP);
        for (Control ctrl : tab.getItems()) {
            if (!ctrl.getKey().equals(appNumber)) continue;
            tab.activeTab(appNumber);
            currentView.sendFormAction(mainPageView);
            return;
        }
        String appPageId = appNumber + mainPageId;
        IFormView appPageView = mainPageView.getViewNoPlugin(appPageId);
        if (appPageView != null) {
            this.activatePage(appPageId, currentView, map);
        } else {
            IFormView formView;
            if (!this.limitOpenPageNumber(openPageContext, true)) {
                return;
            }
            this.openAppPage(appNumber, map);
            Object newWindowPageId = map.get("newWindosPageId");
            if (newWindowPageId != null && (appPageView = mainPageView.getViewNoPlugin(appPageId)) != null && (formView = SessionManager.getCurrent().getView(newWindowPageId.toString())) != null) {
                FormShowParameter formShowParameter = formView.getFormShowParameter();
                formShowParameter.setRootPageId(mainPageId);
                formShowParameter.setParentPageId(appPageId);
                formShowParameter.setPageId(formShowParameter.getPageId() + kd.bos.util.StringUtils.randomNumber((int)16));
                appPageView.showForm(formShowParameter);
                currentView.sendFormAction(appPageView);
            }
            if ((appPageView = mainPageView.getViewNoPlugin(appPageId)) != null) {
                IPageCache homepagePageCache = (IPageCache)mainPageView.getService(IPageCache.class);
                String homepageTabapCount = homepagePageCache.get(HOMEPAGE_TABAP_COUNT);
                int count = homepageTabapCount == null ? 3 : Integer.parseInt(homepageTabapCount);
                homepagePageCache.put(HOMEPAGE_TABAP_COUNT, ++count + "");
            }
        }
    }

    protected void doOpenMenu(OpenPageContext openPageContext) {
        Map<String, Object> map = openPageContext.getParameter();
        String data = openPageContext.getMainView().getPageCache().get("Portal_LicenseGrayNotice_" + openPageContext.getAppNumber());
        if (!"true".equals(data)) {
            AppInfo appInfo = openPageContext.getAppInfo();
            this.checkLicenseGray(openPageContext.getCurrentView(), (String)map.get(FORMNUMBER), appInfo.getNumber(), appInfo.getCloudNum());
        }
        String menuId = openPageContext.getMenuId();
        boolean isAppHome = openPageContext.isAppHome();
        if (menuId == null || isAppHome) {
            return;
        }
        String markId = menuId;
        Object parameterStr = map.get(PARAMETER);
        if (parameterStr != null) {
            Map parameter = (Map)SerializationUtils.fromJsonString((String)parameterStr.toString(), Map.class);
            String filterSchemeId = null;
            if (parameter != null) {
                filterSchemeId = (String)parameter.get(FILTER_SCHEME_ID);
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(filterSchemeId)) {
                markId = menuId + SPLIT_STR + filterSchemeId;
            }
        }
        IFormView mainView = openPageContext.getMainView();
        String mainPageId = mainView.getPageId();
        String menuPageId = markId + mainPageId;
        if (mainView.getViewNoPlugin(menuPageId) != null) {
            this.activatePage(menuPageId, openPageContext.getCurrentView(), map);
        } else {
            if (!this.limitOpenPageNumber(openPageContext, false)) {
                return;
            }
            this.openMenuPage(openPageContext);
        }
    }

    private void activatePage(String pageID, IFormView view, Map<String, Object> map) {
        List<String> yzjAppList = YzjAppEnum.getAllBosAppNum();
        Object yzjAppIdObj = map.get("yzjAppId");
        String zyjAppId = "";
        if (!ObjectUtils.isEmpty((Object)yzjAppIdObj)) {
            zyjAppId = (String)yzjAppIdObj;
        }
        String menuId = pageID.split("root")[0];
        IFormView childView = view.getViewNoPlugin(pageID);
        if (WFTASK.equals(childView.getFormShowParameter().getAppId())) {
            childView = view.getView(pageID);
        }
        if (yzjAppList.contains(zyjAppId)) {
            childView = view.getView(pageID);
        }
        if (childView != null) {
            if (!view.getPageId().equalsIgnoreCase(childView.getPageId())) {
                HashMap customparameters = (HashMap)map.get(CUSTOMPARAMETERS);
                childView.getFormShowParameter().getCustomParams().remove(MESSAGE_ID);
                childView.getFormShowParameter().getCustomParams().remove(TAB_TYPE);
                childView.getFormShowParameter().getCustomParams().remove(OPEN_PAGE);
                childView.getFormShowParameter().getCustomParams().remove(BILL_FORM_ID);
                if (customparameters != null) {
                    if (customparameters.get(MESSAGE_ID) != null) {
                        childView.getFormShowParameter().setCustomParam(MESSAGE_ID, customparameters.get(MESSAGE_ID));
                    }
                    if (customparameters.get(TAB_TYPE) != null) {
                        childView.getFormShowParameter().setCustomParam(TAB_TYPE, customparameters.get(TAB_TYPE));
                    }
                    if (customparameters.get(OPEN_PAGE) != null) {
                        childView.getFormShowParameter().setCustomParam(OPEN_PAGE, customparameters.get(OPEN_PAGE));
                    }
                    if (customparameters.get(BILL_FORM_ID) != null) {
                        childView.getFormShowParameter().setCustomParam(BILL_FORM_ID, customparameters.get(BILL_FORM_ID));
                    }
                }
                childView.getFormShowParameter().setHasRight(true);
                childView.activate();
                this.newPortalSelectAppTab(childView);
                if (WFTASK.equals(childView.getFormShowParameter().getAppId())) {
                    childView.updateView();
                }
                if (yzjAppList.contains(zyjAppId)) {
                    childView.updateView();
                }
                view.sendFormAction(childView);
                String userId = RequestContext.get().getUserId();
                String time = new SimpleDateFormat(YYY_MM_DD_HH_MM_SS).format(new Date(System.currentTimeMillis()));
                String debugInfo = "the ending of click APP debug info is: ---userID:" + userId + TIME + time + "---menuId Or appId:" + menuId + "---PageID" + pageID;
                logger.debug(debugInfo);
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u91cd\u65b0\u767b\u5f55\u3002", (String)"OpenPageUtils_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void openAppPage(String appID, Map<String, Object> map) {
        Map params;
        if (map.get(APPNAME) == null || map.get(APPMAINNUMBER) == null || map.get("view") == null) {
            logger.info("OpenPageUtils----openAppPage----appmainnumber or view in map is null [105]");
            return;
        }
        IFormView view = (IFormView)map.get("view");
        IFormView mainPageView = this.getMainPageView(view);
        String mainPageID = mainPageView.getPageId();
        String appName = map.get(APPNAME).toString();
        String appMainNumber = map.get(APPMAINNUMBER).toString();
        HashMap<String, String> customMap = new HashMap<String, String>();
        customMap.put(APPID, appID);
        customMap.put(APPNAME, appName);
        Object imageUrl = map.get(APPIMAGEURL);
        if (imageUrl != null) {
            customMap.put(APPIMAGEURL, this.getAppImgUrl(imageUrl.toString()));
        }
        if ((params = (Map)map.get(CUSTOMPARAMETERS)) != null) {
            customMap.putAll(params);
        }
        String appPageID = appID + mainPageID;
        FormShowParameter para = new FormShowParameter();
        para.setAppId(appID);
        para.setCustomParams(customMap);
        para.getOpenStyle().setTargetKey(TABAP);
        para.getOpenStyle().setShowType(ShowType.NewTabPage);
        para.setFormId(appMainNumber);
        para.setCaption(appName);
        para.setPageId(appPageID);
        para.setHasRight(true);
        para.setInvokeTimeout(300);
        if ("true".equals(map.get("noSwitchFocus"))) {
            para.getOpenStyle().setNoSwitchFocus(true);
        }
        this.setBrandUpApp(view);
        if (mainPageView.getPageId().equals(view.getPageId())) {
            view.showForm(para);
        } else {
            mainPageView.showForm(para);
            view.sendFormAction(mainPageView);
        }
        String userId = RequestContext.get().getUserId();
        String time = new SimpleDateFormat(YYY_MM_DD_HH_MM_SS).format(new Date(System.currentTimeMillis()));
        String debugInfo = "the ending of click APP debug info is: ---userID:" + userId + TIME + time + "---appID:" + appID + "---appName:" + appName + "---appPageID:" + appPageID;
        logger.debug(debugInfo);
    }

    private void openMenuPage(OpenPageContext openPageContext) {
        Boolean isAIVoiceRequest;
        HashMap<String, String> customMap;
        String markId;
        String menuPageId;
        boolean existView;
        Map<String, Object> map = openPageContext.getParameter();
        String appNumber = openPageContext.getAppNumber();
        String menuId = openPageContext.getMenuId();
        IFormView mainPageView = openPageContext.getMainView();
        IFormView view = (IFormView)map.get("view");
        if (view == null) {
            logger.info("OpenPageUtils----openMenuPage----view in map is error [143]");
            return;
        }
        AppMenuInfo appMenuInfo = openPageContext.getAppMenuInfo();
        if (Objects.nonNull(appMenuInfo) && "link".equals(appMenuInfo.getMenuType())) {
            this.openUrlWhenTypeIsUrl(openPageContext);
            return;
        }
        HashMap<String, Object> parameter = new HashMap();
        Object parameterStr = map.get(PARAMETER);
        if (parameterStr != null) {
            parameter = (Map)SerializationUtils.fromJsonString((String)parameterStr.toString(), Map.class);
        }
        String filterSchemeId = null;
        if (parameter != null) {
            filterSchemeId = (String)parameter.get(FILTER_SCHEME_ID);
        }
        if (existView = mainPageView.existView(menuPageId = (markId = org.apache.commons.lang3.StringUtils.isNotEmpty(filterSchemeId) ? menuId + SPLIT_STR + filterSchemeId : menuId) + mainPageView.getPageId())) {
            menuPageId = menuPageId + "_" + kd.bos.login.utils.StringUtils.randomNumber((int)16);
        }
        if (map.get(FORMNUMBER) == null) {
            logger.info("OpenPageUtils----openMenuPage----form number is null [144]");
            return;
        }
        String formNumber = map.get(FORMNUMBER).toString();
        String parameterType = "";
        Object objParamType = map.get(PARAMETERTYPE);
        parameterType = objParamType == null ? "FormShowParameter" : objParamType.toString();
        FormShowParameter fsp = this.showFormParameter(formNumber, parameterType, parameter, map);
        fsp.setHasRight(true);
        fsp.setAppId(appNumber);
        Map params = (Map)map.get(CUSTOMPARAMETERS);
        if (params != null) {
            fsp.setCustomParams(params);
        }
        if ((customMap = fsp.getCustomParams()) == null) {
            customMap = new HashMap<String, String>();
        }
        if ((isAIVoiceRequest = (Boolean)customMap.get("isAIVoiceRequest")) != null && isAIVoiceRequest.booleanValue()) {
            Map<String, String> openStyleCustParam = fsp.getOpenStyle().getCustParam() != null ? fsp.getOpenStyle().getCustParam() : new HashMap();
            openStyleCustParam.put("isFullScreen", "true");
            fsp.getOpenStyle().setCustParam(openStyleCustParam);
        }
        if (appMenuInfo != null && "Modal".equals(appMenuInfo.getOpenType())) {
            fsp.getOpenStyle().setShowType(ShowType.Modal);
        }
        customMap.put(APPID, appNumber);
        fsp.setCustomParams(customMap);
        fsp.setPageId(menuPageId);
        this.showMenuPage(openPageContext, fsp);
        this.traceMenu(appNumber, menuId, formNumber);
        String userId = RequestContext.get().getUserId();
        String time = new SimpleDateFormat(YYY_MM_DD_HH_MM_SS).format(new Date(System.currentTimeMillis()));
        String debugInfo = "the ending of click MENU debug info is: ---userID:" + userId + TIME + time + "---menuID:" + menuId + "---menuPageID:" + menuPageId;
        logger.debug(debugInfo);
        JSONObject menuInfo = new JSONObject();
        menuInfo.put("type", (Object)"menu");
        menuInfo.put("id", (Object)menuId);
        menuInfo.put("name", map.get("menuname"));
        menuInfo.put(APPID, (Object)appNumber);
        menuInfo.put(APPNAME, (Object)openPageContext.getAppName());
        CollectAppAndMenuUtil menuThread = new CollectAppAndMenuUtil(RequestContext.get(), menuInfo);
        ThreadPools.executeOnceIncludeRequestContext((String)"manageMenuInfo", (Runnable)menuThread);
    }

    private boolean openUrlWhenTypeIsUrl(OpenPageContext openPageContext) {
        AppMenuInfo menu = openPageContext.getAppMenuInfo();
        IFormView currentView = openPageContext.getCurrentView();
        if (menu == null) {
            return false;
        }
        String linkUrl = menu.getLinkUrl();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)linkUrl)) {
            currentView.showMessage(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u83dc\u5355\u9875\u9762\uff0c\u8bf7\u68c0\u67e5\u83dc\u5355\u914d\u7f6e\u3002", (String)"OpenPageUtils_14", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        FormShowParameter fsp = new FormShowParameter();
        IFormView mainPageView = openPageContext.getMainView();
        String pageId = menu.getId() + mainPageView.getPageId();
        fsp.setCaption(menu.getName().getLocaleValue());
        fsp.setPageId(pageId);
        fsp.setCustomParam("linkUrl", (Object)linkUrl);
        fsp.setFormId("bos_open_url");
        fsp.getOpenStyle().setShowType(ShowType.NewTabPage);
        fsp.getOpenStyle().setTargetKey(this.getShowFormTargetKey());
        this.showMenuPage(openPageContext, fsp);
        return true;
    }

    private boolean checkIsDisableApp(String appId) {
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        return disabledAppIds != null && disabledAppIds.contains(appId);
    }

    private String getAppImgUrl(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "icons/pc/entrance/default_48_48.png";
        }
        if (url.startsWith("/") && url.length() > 1) {
            url = url.substring(1);
        }
        return url;
    }

    private void setBrandUpApp(IFormView view) {
        String appNumber;
        if (view != null && kd.bos.util.StringUtils.isNotEmpty((String)(appNumber = (String)view.getFormShowParameter().getCustomParam("appNumber"))) && BrandUpEnum.getAppNumbers(appNumber) != null) {
            view.getFormShowParameter().setCustomParam("isHideHomeTab", (Object)false);
        }
    }

    private void newPortalSelectAppTab(IFormView formView) {
        Tab tab;
        RequestContext rc = RequestContext.get();
        boolean isNewPortal = NewPortalService.isPersonalSettingNewPortal((long)rc.getCurrUserId(), (String)rc.getAccountId());
        if (!isNewPortal) {
            return;
        }
        if (!WFTASK.equals(formView.getFormShowParameter().getAppId()) && (tab = (Tab)formView.getControl("_submaintab_")) != null) {
            tab.activeTab("appmiantab");
        }
    }

    private FormShowParameter showFormParameter(String formNumber, String parameterType, Map<String, Object> parameter, Map<String, Object> map) {
        FormShowParameter sp;
        if ("ListShowParameter".equalsIgnoreCase(parameterType) && Objects.nonNull(parameter)) {
            MainEntityType dt;
            String entityId;
            parameter.put("type", "list");
            String billFormId = (String)parameter.get(BILL_FORM_ID);
            if (billFormId == null && !"empty".equalsIgnoreCase(entityId = FormMetadataCache.getFormConfig((String)formNumber).getEntityTypeId()) && (dt = EntityMetadataCache.getDataEntityType((String)entityId)) instanceof BillEntityType) {
                parameter.put(BILL_FORM_ID, formNumber);
            }
            sp = FormShowParameter.createFormShowParameter(parameter);
        } else {
            if (Objects.nonNull(parameter) && parameter.get("formId") == null) {
                parameter.put("formId", formNumber);
            }
            sp = FormShowParameter.createFormShowParameter(parameter);
        }
        this.setParameterValue(sp, parameter);
        if (Objects.isNull(parameter)) {
            return sp;
        }
        String isModal = (String)parameter.get("isModal");
        if (NEW_WINDOW.equals(isModal)) {
            sp.getOpenStyle().setShowType(ShowType.Modal);
            sp.setShowTitle(false);
        } else if ("0".equals(isModal)) {
            sp.getOpenStyle().setShowType(ShowType.NewTabPage);
            sp.getOpenStyle().setTargetKey(this.getShowFormTargetKey());
        } else {
            Object openType = null;
            if (map != null) {
                openType = map.get("openType");
            }
            String openTypeStr = null;
            if (openType != null) {
                openTypeStr = openType.toString();
            }
            if ("Modal".equals(openTypeStr)) {
                sp.getOpenStyle().setShowType(ShowType.Modal);
            } else {
                sp.getOpenStyle().setShowType(ShowType.NewTabPage);
                sp.getOpenStyle().setTargetKey(this.getShowFormTargetKey());
            }
        }
        sp.setCustomParams(parameter);
        return sp;
    }

    private void setParameterValue(FormShowParameter showParameter, Map<String, Object> params) {
        if (params != null) {
            Class<?> clazz = showParameter.getClass();
            try {
                this.exeClass(showParameter, params, clazz);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    private void exeClass(FormShowParameter showParameter, Map<String, Object> params, Class<?> clazz) throws IllegalArgumentException, IllegalAccessException, IOException {
        Field[] fields;
        if (clazz == Object.class) {
            return;
        }
        block0: for (Field field : fields = clazz.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            String paramName = field.getName();
            String type = field.getGenericType().getTypeName();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String pName = entry.getKey();
                if (pName.equalsIgnoreCase("status") && paramName.equalsIgnoreCase(pName)) {
                    int paramValue = Integer.parseInt((String)entry.getValue());
                    field.set(showParameter, OperationStatus.forValue((int)paramValue));
                    continue block0;
                }
                if (pName.equalsIgnoreCase("listFilterParameter") && paramName.equalsIgnoreCase(pName)) {
                    String paramValue = (String)params.get(pName);
                    ListFilterParameter filterParameter = new ListFilterParameter();
                    filterParameter.setQFilter(paramValue);
                    field.set(showParameter, filterParameter);
                    continue block0;
                }
                if (!paramName.equalsIgnoreCase(pName)) continue;
                String paramValue = "";
                if (params.get(pName) instanceof LinkedHashMap) {
                    String captionLocalName;
                    LinkedHashMap paramLinkedHashMap = (LinkedHashMap)params.get(pName);
                    LocaleString captionName = LocaleString.fromMap((Map)paramLinkedHashMap);
                    paramValue = captionLocalName = captionName.getLocaleValue();
                } else if (params.get(pName) instanceof String) {
                    paramValue = (String)params.get(pName);
                }
                if (type.endsWith("Object")) {
                    field.set(showParameter, paramValue);
                    continue block0;
                }
                if (type.endsWith("String")) {
                    field.set(showParameter, paramValue);
                    continue block0;
                }
                if (type.endsWith("int") || type.endsWith("Integer")) {
                    field.set(showParameter, Integer.parseInt(paramValue));
                    continue block0;
                }
                if (type.endsWith("double") || type.endsWith("Double")) {
                    field.set(showParameter, Double.parseDouble(paramValue));
                    continue block0;
                }
                if (type.endsWith("boolean") || type.endsWith("Boolean")) {
                    field.set(showParameter, Boolean.parseBoolean(paramValue));
                    continue block0;
                }
                if (type.endsWith("float") || type.endsWith("Float")) {
                    field.set(showParameter, Float.valueOf(Float.parseFloat(paramValue)));
                    continue block0;
                }
                if (type.endsWith("short") || type.endsWith("Short")) {
                    field.set(showParameter, Short.parseShort(paramValue));
                    continue block0;
                }
                if (type.endsWith("long") || type.endsWith("Long")) {
                    field.set(showParameter, Long.parseLong(paramValue));
                    continue block0;
                }
                if (type.endsWith("byte") || type.endsWith("Byte")) {
                    field.set(showParameter, Byte.parseByte(paramValue));
                    continue block0;
                }
                if (!type.endsWith("Map<java.lang.String, java.lang.Object>")) continue block0;
                field.set(showParameter, SerializationUtils.fromJsonString((String)paramValue, Map.class));
                continue block0;
            }
        }
        Class<?> clazzs = clazz.getSuperclass();
        this.exeClass(showParameter, params, clazzs);
    }

    private void traceMenu(final String appNumber, final String menuid, final String formNumber) {
        pool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AppInfo app = AppMetadataCache.getAppInfo((String)appNumber);
                    MenuTraceService menuTraceService = (MenuTraceService)BeanUtils.getBean((String)"kd.bos.ais.core.sync.AisMenuTraceServiceImpl");
                    menuTraceService.traceMenu(app.getCloudId(), appNumber, formNumber, menuid, true, null, null);
                }
                catch (Exception e) {
                    logger.info("traceMenu error", (Object)e);
                }
            }
        }, RequestContext.get());
    }

    private IFormView getMainPageView(IFormView myappView) {
        IFormView mainPageView = myappView.getMainView();
        if (mainPageView == null) {
            logger.info("OpenPageUtils----openApp----mainView is null");
            String rootPageId = myappView.getFormShowParameter().getRootPageId();
            mainPageView = myappView.getView(rootPageId);
            if (mainPageView == null) {
                throw new KDException(new ErrorCode("mainView is null", "mainView is null"), new Object[0]);
            }
        }
        return mainPageView;
    }
}

