/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.nocode.model.PermItemEnum;
import kd.bos.portal.facade.PortalMenuFacade;
import kd.bos.portal.pluginnew.noCode.NoCodeAppUtils;
import kd.bos.portal.service.IPortalAppMenuFacade;
import kd.bos.portal.service.bo.MenuFilterBuilder;
import kd.bos.portal.service.bo.PortalMenuInfo;
import kd.bos.portal.util.PortalAppMetaDataUtils;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseGrayServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.DisCardUtil;
import kd.bos.util.JSONUtils;
import org.apache.commons.lang.reflect.MethodUtils;
import org.apache.commons.lang3.StringUtils;

public class PortalMenuService {
    private static Log logger = LogFactory.getLog(PortalMenuService.class);
    private IPageCache pageCache;
    private PortalMenuFacade portalMenuFacade = new PortalMenuFacade();

    public PortalMenuService(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    public PortalMenuService() {
    }

    private List<String> getUserMarkedMenus(Long userId) {
        DynamicObjectCollection userMarkedMenus = this.getUserMarkedAppMenus(userId);
        if (userMarkedMenus.size() == 0) {
            return Collections.emptyList();
        }
        return userMarkedMenus.stream().map(userMarkedMenuInfo -> userMarkedMenuInfo.getString("menu")).collect(Collectors.toList());
    }

    private DynamicObjectCollection getUserMarkedAppMenus(Long userId) {
        DynamicObjectCollection userMarkedMenus = this.getMarkedAppMenusFromDB(userId);
        if (CollectionUtils.isEmpty((Collection)userMarkedMenus)) {
            return new DynamicObjectCollection();
        }
        DynamicObjectCollection userMarkedMenuSortList = new DynamicObjectCollection();
        Map<Boolean, List<DynamicObject>> collect = userMarkedMenus.stream().collect(Collectors.groupingBy(v -> "0".equals(v.getString("markedseq"))));
        List<DynamicObject> hasOrderData = collect.get(false);
        List<DynamicObject> noPerData = collect.get(true);
        if (hasOrderData != null && noPerData != null) {
            int start = hasOrderData.size();
            for (int i = 0; i < noPerData.size(); ++i) {
                DynamicObject dynamicObject = noPerData.get(i);
                dynamicObject.set("markedseq", (Object)(i + start + 1));
            }
            hasOrderData.addAll(noPerData);
            userMarkedMenuSortList.addAll(this.sortedData(hasOrderData));
            return userMarkedMenuSortList;
        }
        if (hasOrderData != null && noPerData == null) {
            userMarkedMenuSortList.addAll(this.sortedData(hasOrderData));
            return userMarkedMenuSortList;
        }
        if (noPerData != null) {
            for (int i = 0; i < noPerData.size(); ++i) {
                DynamicObject dynamicObject = noPerData.get(i);
                dynamicObject.set("markedseq", (Object)(i + 1));
            }
            userMarkedMenuSortList.addAll(this.sortedData(noPerData));
        }
        return userMarkedMenuSortList;
    }

    private List<DynamicObject> sortedData(List<DynamicObject> userMarkedMenus) {
        List<DynamicObject> dynamicObjects = userMarkedMenus.stream().sorted(Comparator.comparing(v -> v.getInt("markedseq"))).collect(Collectors.toList());
        return dynamicObjects;
    }

    public DynamicObjectCollection getMarkedAppMenusFromDB(Long userId) {
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"portal_usermarkedmenu", (String)"bizapp, menu, markedseq", (QFilter[])new QFilter[]{userFilter}, (String)"createtime asc,id asc");
        DynamicObjectCollection userMarkedMenus = new DynamicObjectCollection();
        if (dynamicObjects.length > 0) {
            userMarkedMenus.addAll(Arrays.asList(dynamicObjects));
        }
        return userMarkedMenus;
    }

    public List<Map<String, Object>> getFavoriteDatas(Long userId, List<String> hasPermAppIds) {
        List<PortalMenuInfo> favoriteMenus = this.getFavoriteMenus(userId, hasPermAppIds);
        String menuJsonStr = SerializationUtils.toJsonString(favoriteMenus);
        return SerializationUtils.fromJsonStringToList(menuJsonStr, Map.class);
    }

    public List<PortalMenuInfo> getFavoriteMenus(Long userId, List<String> hasPermAppIds) {
        List<PortalMenuInfo> favoriteMenus = new ArrayList<PortalMenuInfo>();
        if (CollectionUtils.isEmpty(hasPermAppIds)) {
            return favoriteMenus;
        }
        DynamicObjectCollection markedMenus = this.getUserMarkedAppMenus(userId);
        if (markedMenus.size() == 0) {
            return favoriteMenus;
        }
        Set<String> appNums = markedMenus.stream().map(userMarkedMenuInfo -> userMarkedMenuInfo.getString("bizapp")).collect(Collectors.toSet());
        List menuIds = markedMenus.stream().map(userMarkedMenuInfo -> userMarkedMenuInfo.getString("menu")).collect(Collectors.toList());
        Map<String, AppInfo> appNumInfo = PortalAppMetaDataUtils.getAppNumInfo(appNums);
        Map<String, List<AppMenuInfo>> allMenuByAppIds = PortalAppMetaDataUtils.getAppIdAndAllMenuByAppIds(appNums);
        Map<String, AppMenuInfo> menuIdAndInfoMap = allMenuByAppIds.values().stream().flatMap(Collection::stream).filter(appMenuInfo -> menuIds.contains(appMenuInfo.getId())).collect(Collectors.toMap(AppMenuInfo::getId, i -> i, (k1, k2) -> k1));
        ArrayList<String> errorMenuIdList = new ArrayList<String>(0);
        for (DynamicObject markMenu : markedMenus) {
            String appNum = markMenu.getString("bizapp");
            String menuId = markMenu.getString("menu");
            if (StringUtils.isBlank((CharSequence)appNum) || StringUtils.isBlank((CharSequence)menuId)) continue;
            try {
                AppInfo appInfo2 = appNumInfo.get(appNum);
                AppMenuInfo menuInfo = menuIdAndInfoMap.get(menuId);
                if (menuInfo == null) continue;
                PortalMenuInfo portalMenuInfo2 = new PortalMenuInfo(menuId, menuId, menuInfo.getName().getLocaleValue(), menuInfo.getShortcutIcon(), appInfo2.getId(), appInfo2.getCloudId());
                portalMenuInfo2.setIndex(markMenu.getInt("markedseq"));
                favoriteMenus.add(portalMenuInfo2);
            }
            catch (Exception e) {
                logger.info("getAppMenuInfo error", (Object)e);
                errorMenuIdList.add(menuId);
            }
        }
        if (!errorMenuIdList.isEmpty()) {
            logger.debug(String.format("entityName:%s, userId:%s, menuId:%s", "portal_usermarkedmenu", userId, String.join((CharSequence)",", errorMenuIdList)));
            this.deleteMarkMenus(userId, errorMenuIdList);
        }
        Set<String> appIds = appNumInfo.values().stream().map(appInfo -> appInfo.getAppId()).collect(Collectors.toSet());
        Map<String, Set<String>> userNoPermMenus = this.getHideMenuByAppIdsWithoutPerm(userId, appIds);
        favoriteMenus = favoriteMenus.stream().filter(portalMenuInfo -> hasPermAppIds.contains(portalMenuInfo.getAppId())).filter(portalMenuInfo -> {
            String appId = portalMenuInfo.getAppId();
            String menuId = portalMenuInfo.getMenuId();
            Set noPermMenus = (Set)userNoPermMenus.get(appId);
            return noPermMenus == null || !noPermMenus.contains(menuId);
        }).collect(Collectors.toList());
        this.addMenuGrayValid(favoriteMenus);
        return favoriteMenus;
    }

    private void addMenuGrayValid(List<PortalMenuInfo> portalMenuInfos) {
        Set<String> appIds = portalMenuInfos.stream().map(PortalMenuInfo::getAppId).collect(Collectors.toSet());
        Map<String, String> appNumAndIdMap = PortalAppMetaDataUtils.getAppNumAndIdMap(appIds);
        Map<String, String> appIdAndNumMap = appNumAndIdMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map grayMenuIdAppMap = new HashMap();
        try {
            grayMenuIdAppMap = LicenseGrayServiceHelper.getGrayMenuIdByPublishAppNumbers(new ArrayList<String>(appNumAndIdMap.keySet()));
        }
        catch (Exception e) {
            logger.info("getGrayObjectInfoByAppNumbers error", (Object)e);
        }
        if (grayMenuIdAppMap == null || grayMenuIdAppMap.isEmpty()) {
            return;
        }
        for (PortalMenuInfo portalMenuInfo : portalMenuInfos) {
            String menuId;
            Map grayMap;
            String appId = portalMenuInfo.getAppId();
            String appNum = appIdAndNumMap.get(appId);
            Map grayMenuIdMap = (Map)grayMenuIdAppMap.get(appNum);
            if (grayMenuIdMap == null || (grayMap = (Map)grayMenuIdMap.get(menuId = portalMenuInfo.getMenuId())) == null) continue;
            String valid = (String)grayMap.get("valid");
            portalMenuInfo.setGrayValid(valid);
        }
    }

    private List<String> getUserMarkedMenusByApp(Long userId, String appNum) {
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        QFilter appFilter = new QFilter("bizapp", "=", (Object)appNum);
        DynamicObject[] userMarkedMenus = BusinessDataServiceHelper.load((String)"portal_usermarkedmenu", (String)"menu", (QFilter[])new QFilter[]{userFilter, appFilter});
        if (userMarkedMenus == null || userMarkedMenus.length == 0) {
            return Collections.emptyList();
        }
        return Stream.of(userMarkedMenus).map(userMarkedMenuInfo -> userMarkedMenuInfo.getString("menu")).collect(Collectors.toList());
    }

    public void addMarkMenu(Long userId, String menuId, String appId) {
        List<String> markMenus = this.getUserMarkedMenus(userId);
        if (markMenus.contains(menuId)) {
            return;
        }
        String appNum = AppMetadataCache.getAppNumberById((String)appId);
        if (StringUtils.isBlank((CharSequence)appNum)) {
            return;
        }
        DynamicObject objForSave = BusinessDataServiceHelper.newDynamicObject((String)"portal_usermarkedmenu");
        objForSave.set("user", (Object)userId);
        objForSave.set("bizapp", (Object)appNum);
        objForSave.set("menu", (Object)menuId);
        objForSave.set("createtime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{objForSave});
    }

    public void deleteMarkMenu(Long userId, String menuId) {
        DynamicObject deleteData;
        int anInt;
        if (menuId == null) {
            return;
        }
        DynamicObjectCollection markedAppMenusFromDB = this.getMarkedAppMenusFromDB(userId);
        ArrayList<DynamicObject> updateData = new ArrayList<DynamicObject>(markedAppMenusFromDB.size() / 2);
        Optional<DynamicObject> first = markedAppMenusFromDB.stream().filter(v -> menuId.equals(v.getString("menu"))).findFirst();
        if (first.isPresent() && (anInt = (deleteData = first.get()).getInt("markedseq")) != 0) {
            for (DynamicObject dynamicObject : markedAppMenusFromDB) {
                if (dynamicObject.getInt("markedseq") <= anInt) continue;
                dynamicObject.set("markedseq", (Object)(dynamicObject.getInt("markedseq") - 1));
                updateData.add(dynamicObject);
            }
        }
        if (!updateData.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateData.toArray(new DynamicObject[0]));
        }
        DeleteServiceHelper.delete((String)"portal_usermarkedmenu", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("menu", "=", (Object)menuId)});
    }

    public void deleteMarkMenus(Long userId, List<String> menuIds) {
        DeleteServiceHelper.delete((String)"portal_usermarkedmenu", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("menu", "in", menuIds)});
    }

    public List<Map<String, Object>> getFilterMenuData(Long userId, String appId) {
        return this.getFilterMenuData(userId, appId, "");
    }

    public List<Map<String, Object>> getFilterMenuData(Long userId, String appId, String cloudId) {
        AppInfo appInfo;
        List<AppMenuInfo> menusInfos = this.getFilterAppMenuInfos(userId, appId, cloudId);
        if (menusInfos == null) {
            return null;
        }
        try {
            appInfo = AppMetadataCache.getAppInfo((String)appId);
        }
        catch (Exception e) {
            logger.info("getFilterMenuData getAppInfo error", (Object)e);
            return null;
        }
        List<String> markMenuIds = this.getUserMarkedMenusByApp(userId, appInfo.getAppId());
        ArrayList<PortalMenuInfo> menuDatas = new ArrayList<PortalMenuInfo>(10);
        for (AppMenuInfo menusInfo : menusInfos) {
            String menuId = menusInfo.getId();
            PortalMenuInfo portalMenuInfo = new PortalMenuInfo(menuId, menuId, menusInfo.getName().getLocaleValue(), menusInfo.getShortcutIcon(), appInfo.getId(), appInfo.getCloudId());
            portalMenuInfo.setFavorite(markMenuIds.contains(menuId));
            portalMenuInfo.setParentId(menusInfo.getParentId());
            menuDatas.add(portalMenuInfo);
        }
        this.addMenuGrayValid(menuDatas);
        Map<String, List<PortalMenuInfo>> menuMap = menuDatas.stream().collect(Collectors.groupingBy(PortalMenuInfo::getParentId));
        ArrayList<Map<String, Object>> resultData = new ArrayList<Map<String, Object>>(10);
        this.recursiveMenu(appInfo, appId, menuMap, resultData);
        return resultData;
    }

    private List<AppMenuInfo> getFilterAppMenuInfos(Long userId, String appId, String cloudId) {
        if (StringUtils.isNotBlank((CharSequence)cloudId) && "2HGKCE94QELW".equals(cloudId)) {
            List menusInfo = AppMetadataCache.getAppMenusInfoByAppId((String)appId);
            ArrayList<AppMenuInfo> results = new ArrayList<AppMenuInfo>(menusInfo.size());
            for (AppMenuInfo appMenuInfo : menusInfo) {
                if (!NoCodePermissionServiceHelper.getPermItems((long)RequestContext.get().getCurrUserId(), (String)appMenuInfo.getEntityNumber()).contains(PermItemEnum.VIEW.getId())) continue;
                results.add(appMenuInfo);
            }
            return results;
        }
        return this.getHasPermMenuByAppId(userId, appId, true);
    }

    public List<AppMenuInfo> getQingMenuArray(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        try {
            List qingMenus;
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
            String appPkId = appInfo.getId();
            String result = "";
            if (this.pageCache != null) {
                result = this.pageCache.get(this.getQingMenuPageCacheKey(appPkId));
            }
            if (StringUtils.isBlank((CharSequence)result)) {
                Class<?> qingAppMenuUtil = Class.forName("kd.bos.qing.plugin.appmenu.PublishedAppMenuUtil");
                qingMenus = (List)MethodUtils.invokeStaticMethod(qingAppMenuUtil, (String)"getPublishedAppQingMenuList", (Object)appPkId);
                result = JSONUtils.toString((Object)qingMenus);
                logger.debug("getQingMenuArray--getAppQingMenu\uff1a" + result);
                if (this.pageCache != null) {
                    this.pageCache.put(this.getQingMenuPageCacheKey(appPkId), result);
                }
            } else {
                qingMenus = JSONObject.parseArray((String)result, AppMenuInfo.class);
            }
            return qingMenus;
        }
        catch (Exception e) {
            logger.info("getQingMenuArray--error", (Object)e);
            return null;
        }
    }

    private String getQingMenuPageCacheKey(String appId) {
        return "qingmenus_" + appId;
    }

    private List<Map<String, Object>> recursiveMenu(AppInfo appInfo, String parentId, Map<String, List<PortalMenuInfo>> menuMap, List<Map<String, Object>> resultData) {
        List<PortalMenuInfo> menuList = menuMap.get(parentId);
        if (CollectionUtils.isEmpty(menuList)) {
            return null;
        }
        boolean isOnlyFirstLevelMenu = true;
        ArrayList<Map<String, Object>> secondMenuItems = new ArrayList<Map<String, Object>>();
        for (PortalMenuInfo menuInfo : menuList) {
            boolean isFirstLevelMenu;
            List<Map<String, Object>> childList;
            if (menuInfo == null) continue;
            String appId = menuInfo.getAppId();
            String menuId = menuInfo.getId();
            String menuName = menuInfo.getName();
            if (appId.equals(parentId)) {
                secondMenuItems = new ArrayList();
                HashMap<String, Object> menuData = new HashMap<String, Object>();
                menuData.put("appId", appId);
                menuData.put("cloudId", menuInfo.getCloudId());
                menuData.put("menuId", menuId);
                menuData.put("name", menuName);
                menuData.put("children", secondMenuItems);
                menuData.put("isFavorite", menuInfo.isFavorite());
                menuData.put("grayValid", menuInfo.getGrayValid());
                resultData.add(menuData);
            }
            if (CollectionUtils.isEmpty(childList = this.recursiveMenu(appInfo, menuId, menuMap, resultData))) {
                HashMap<String, Object> menuData = new HashMap<String, Object>();
                menuData.put("appId", appId);
                menuData.put("cloudId", menuInfo.getCloudId());
                menuData.put("menuId", menuId);
                menuData.put("name", menuName);
                menuData.put("isFavorite", menuInfo.isFavorite());
                menuData.put("grayValid", menuInfo.getGrayValid());
                secondMenuItems.add(menuData);
            } else {
                secondMenuItems.addAll(childList);
            }
            boolean bl = isFirstLevelMenu = secondMenuItems.size() == 0 || secondMenuItems.size() == 1 && ((Map)secondMenuItems.get(0)).get("menuId").equals(menuId);
            if (!isOnlyFirstLevelMenu || appId.equals(parentId) && isFirstLevelMenu) continue;
            isOnlyFirstLevelMenu = false;
        }
        if (isOnlyFirstLevelMenu) {
            this.transFirstLevelMenuData(resultData, appInfo);
        }
        return secondMenuItems;
    }

    private void transFirstLevelMenuData(List<Map<String, Object>> resultData, AppInfo appInfo) {
        ArrayList menuItems = new ArrayList();
        resultData.forEach(menuData -> menuItems.addAll((List)menuData.get("children")));
        HashMap<String, Object> menuData2 = new HashMap<String, Object>();
        menuData2.put("appId", appInfo.getId());
        menuData2.put("cloudId", appInfo.getCloudId());
        menuData2.put("name", appInfo.getName().getLocaleValue());
        menuData2.put("children", menuItems);
        resultData.clear();
        resultData.add(menuData2);
    }

    @Deprecated
    public boolean menuFilter(AppMenuInfo menuInfo, MenuFilterBuilder builder, String appId) {
        String formId = menuInfo.getFormId();
        String menuId = menuInfo.getId();
        String parentId = menuInfo.getParentId();
        List<String> blackMenuIds = builder.getBlackMenuIds(appId);
        boolean hideMenu = false;
        if (blackMenuIds != null) {
            hideMenu = blackMenuIds.contains(menuId) || blackMenuIds.contains(parentId);
        }
        List<String> hideMenuIdList = builder.getHideMenuIds();
        if (!hideMenu && hideMenuIdList != null) {
            hideMenu = hideMenuIdList.contains(menuId) || hideMenuIdList.contains(parentId);
        }
        List<String> noPermMenuIds = builder.getNoPermMenuIds(appId);
        if (!hideMenu && noPermMenuIds != null && noPermMenuIds.size() > 0) {
            hideMenu = noPermMenuIds.contains(menuId);
        }
        if (hideMenu) {
            return false;
        }
        boolean isHideHelpMenu = builder.isHideHelpMenu();
        if (isHideHelpMenu && "bas_appstarted".equals(formId)) {
            return false;
        }
        if ("gated_launch_user".equals(formId)) {
            if (!builder.isAdmin()) {
                return false;
            }
            if (!builder.isGray()) {
                return false;
            }
        }
        return true;
    }

    public Map<String, Object> getSearchResult(String content, Map<String, String> appNumAndIdMap) {
        int appSize;
        HashMap<String, Object> resultData = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)content) || appNumAndIdMap == null) {
            return resultData;
        }
        content = content.trim();
        HashMap<String, List<Map<String, Object>>> dataMap = new HashMap<String, List<Map<String, Object>>>();
        resultData.put("keyword", content);
        Map jsonObject = (Map)BizAppServiceHelp.searchAppAndMenu((String)content);
        List appList = (List)jsonObject.get("apps");
        List menuList = (List)jsonObject.get("menus");
        if (CollectionUtils.isEmpty((Collection)appList) && CollectionUtils.isEmpty((Collection)menuList)) {
            resultData.put("data", dataMap);
            return resultData;
        }
        Set<String> hasPermAppNums = appNumAndIdMap.keySet();
        List<Map> appReusltList = this.getFilterAppList(content, appList, hasPermAppNums);
        List<Map<String, Object>> menuChilds = this.getFilterMenuList(content, menuList, appNumAndIdMap);
        int menuSize = menuChilds.size();
        if (menuSize > 0) {
            dataMap.put("menuItemList", menuChilds);
        }
        if ((appSize = appReusltList.size()) > 0) {
            dataMap.put("appItemList", appReusltList);
        }
        long count = appSize + menuSize;
        resultData.put("data", dataMap);
        resultData.put("totalCount", count);
        return resultData;
    }

    private List<Map> getFilterAppList(String content, List<Map> appList, Set<String> hasPermAppNums) {
        List appReusltList = new LinkedList<Map>();
        if (CollectionUtils.isNotEmpty(appList)) {
            Set<String> noCodeIds = NoCodeAppUtils.getNoCodeIds(RequestContext.get().getCurrUserId());
            appList = appList.stream().filter(appDataMap -> {
                Object number = appDataMap.get("number");
                Object id = appDataMap.get("id");
                if (hasPermAppNums.contains(number)) {
                    return true;
                }
                return noCodeIds.contains(id);
            }).map(appDataMap -> {
                HashMap map = new HashMap();
                map.put("appId", appDataMap.get("id"));
                map.put("appName", appDataMap.get("name"));
                map.put("cloudId", appDataMap.get("cloudId"));
                map.put("cloudName", appDataMap.get("cloudName"));
                return map;
            }).collect(Collectors.toList());
            appReusltList.addAll(appList.stream().filter(appDataMap -> content.equals(appDataMap.get("appName"))).collect(Collectors.toList()));
            appReusltList.addAll(appList.stream().filter(appDataMap -> !content.equals(appDataMap.get("appName"))).collect(Collectors.toList()));
            if (appReusltList.size() > 100) {
                appReusltList = appReusltList.subList(0, 100);
            }
        }
        return appReusltList;
    }

    private List<Map<String, Object>> getFilterMenuList(String content, List<Map> menuList, Map<String, String> appNumAndIdMap) {
        ArrayList<Map<String, Object>> menuChilds = new ArrayList<Map<String, Object>>();
        if (CollectionUtils.isNotEmpty(menuList)) {
            logger.debug("getSearchResult--menu--size:" + menuList.size());
            Long userId = RequestContext.get().getCurrUserId();
            Map<String, List<Map>> exactMenuAppIdGroup = menuList.stream().filter(menuDataMap -> content.equals(menuDataMap.get("name"))).collect(Collectors.groupingBy(menu -> (String)menu.get("appId")));
            Map<String, List<Map>> menuAppIdGroup = menuList.stream().filter(menuDataMap -> {
                Object name = menuDataMap.get("name");
                return name != null && StringUtils.isNotBlank((CharSequence)name.toString()) && !content.equals(name);
            }).collect(Collectors.groupingBy(menu -> (String)menu.get("appId")));
            exactMenuAppIdGroup = NoCodeAppUtils.filterMenu(exactMenuAppIdGroup);
            menuAppIdGroup = NoCodeAppUtils.filterMenu(menuAppIdGroup);
            HashSet<String> searchAppNums = new HashSet<String>();
            searchAppNums.addAll(exactMenuAppIdGroup.keySet());
            searchAppNums.addAll(menuAppIdGroup.keySet());
            Set<String> appIds = searchAppNums.stream().map(appNumAndIdMap::get).collect(Collectors.toSet());
            Set<String> hasPermAppNums = appNumAndIdMap.keySet();
            Map<String, Set<String>> userHasPermMenus = this.getUserHasPermMenuIds(userId, appIds);
            this.filterPermAppInfo(exactMenuAppIdGroup, hasPermAppNums, menuChilds, appNumAndIdMap, userHasPermMenus);
            this.filterPermAppInfo(menuAppIdGroup, hasPermAppNums, menuChilds, appNumAndIdMap, userHasPermMenus);
        }
        return menuChilds;
    }

    public Map<String, Set<String>> getUserHasPermMenuIds(Long userId, Set<String> appIds) {
        HashMap<String, Set<String>> userHasPermMenuIds = new HashMap<String, Set<String>>(0);
        Map<String, List<AppMenuInfo>> hasPermMenuByAppId = this.getHasPermMenuByAppId(userId, appIds, false);
        if (hasPermMenuByAppId != null && hasPermMenuByAppId.size() > 0) {
            hasPermMenuByAppId.forEach((appId, appMenuInfo) -> {
                Set menuIds = appMenuInfo.stream().map(AppMenuInfo::getId).collect(Collectors.toSet());
                userHasPermMenuIds.put((String)appId, menuIds);
            });
        }
        return userHasPermMenuIds;
    }

    private void filterPermAppInfo(Map<String, List<Map>> menuAppIdGroup, Set<String> hasPermAppNums, List<Map<String, Object>> menuChilds, Map<String, String> appNumAndIdMap, Map<String, Set<String>> userHasPermMenus) {
        logger.debug("MainPagePlugin--menugroup--size:" + menuAppIdGroup.size());
        menuAppIdGroup.forEach((appNum, menuMap) -> {
            if (menuChilds.size() >= 100) {
                return;
            }
            if (hasPermAppNums.contains(appNum)) {
                String appId = (String)appNumAndIdMap.get(appNum);
                Set hasPermMenus = (Set)userHasPermMenus.get(appId);
                menuMap.forEach(map -> {
                    if (menuChilds.size() >= 100) {
                        return;
                    }
                    Object menuId = map.get("id");
                    if (menuId == null || CollectionUtils.isNotEmpty((Collection)hasPermMenus) && !hasPermMenus.contains(menuId.toString())) {
                        return;
                    }
                    HashMap menuChildMap = new HashMap();
                    menuChildMap.put("menuId", menuId);
                    menuChildMap.put("menuName", map.get("name"));
                    menuChildMap.put("appId", appId);
                    menuChildMap.put("appName", map.get("appName"));
                    menuChilds.add(menuChildMap);
                });
            }
        });
    }

    public void addCurrentUseAppMenu(String appId, String menuId) {
        if (StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)menuId)) {
            return;
        }
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject currentMenuObj = this.getCurrentMenuOne(userId, appId, menuId);
        if (currentMenuObj != null) {
            currentMenuObj.set("modifytime", (Object)new Date());
        } else {
            currentMenuObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_portal_current_menu");
            currentMenuObj.set("user", (Object)userId);
            currentMenuObj.set("appid", (Object)appId);
            currentMenuObj.set("menuid", (Object)menuId);
            this.clearCurrentUseMenuOverNum(userId);
        }
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{currentMenuObj});
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
    }

    private DynamicObject getCurrentMenuOne(Long userId, String appId, String menuId) {
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        String seletPros = "appid,menuid,modifytime";
        QFilter appFilter = new QFilter("appid", "=", (Object)appId);
        QFilter menuFilter = new QFilter("menuid", "=", (Object)menuId);
        return BusinessDataServiceHelper.loadSingle((String)"bos_portal_current_menu", (String)seletPros, (QFilter[])new QFilter[]{userFilter, appFilter, menuFilter});
    }

    private void clearCurrentUseMenuOverNum(Long userId) {
        int count = this.getCurrentMenuCount(userId);
        if (count > 100) {
            DynamicObjectCollection dynamicObjects = this.getTopCurrentMenuByModifyTimeDesc(userId, 12);
            List ids = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            QFilter idFilter = new QFilter("id", "not in", ids);
            QFilter userFilter = new QFilter("user", "=", (Object)userId);
            try {
                DeleteServiceHelper.delete((String)"bos_portal_current_menu", (QFilter[])new QFilter[]{userFilter, idFilter});
            }
            catch (Exception e) {
                DisCardUtil.discard();
            }
        }
    }

    private int getCurrentMenuCount(Long userId) {
        int count = 0;
        String sql = String.format("select count(*) from t_bas_portal_current_menu where fuserid = %s", userId);
        try (DataSet dataSet = DB.queryDataSet((String)"query_currentmenu", (DBRoute)DBRoute.base, (String)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                count = row.getInteger(0);
            }
        }
        return count;
    }

    private DynamicObjectCollection getTopCurrentMenuByModifyTimeDesc(Long userId, Integer top) {
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        String seletPros = "id,appid,menuid,modifytime";
        String orderBys = "modifytime desc";
        return QueryServiceHelper.query((String)"bos_portal_current_menu", (String)seletPros, (QFilter[])new QFilter[]{userFilter}, (String)orderBys, (int)top);
    }

    private List<Map<String, String>> getCurrentUseMenu(Long userId) {
        DynamicObjectCollection dynamicObjects = this.getTopCurrentMenuByModifyTimeDesc(userId, 12);
        List<Map<String, String>> currentMenuDatas = dynamicObjects.stream().map(dynamicObject -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("appId", dynamicObject.getString("appid"));
            map.put("menuId", dynamicObject.getString("menuid"));
            return map;
        }).collect(Collectors.toList());
        return currentMenuDatas;
    }

    public List<Map<String, Object>> getCurrentUseMenuData(Long userId, List<String> hasPermAppIds) {
        List<PortalMenuInfo> currentUseMenus = this.getCurrentUseMenus(userId, hasPermAppIds);
        String menuJsonStr = SerializationUtils.toJsonString(currentUseMenus);
        return SerializationUtils.fromJsonStringToList(menuJsonStr, Map.class);
    }

    public List<PortalMenuInfo> getCurrentUseMenus(Long userId, List<String> hasPermAppIds) {
        ArrayList<PortalMenuInfo> portalMenuInfos = new ArrayList<PortalMenuInfo>();
        if (CollectionUtils.isEmpty(hasPermAppIds)) {
            return portalMenuInfos;
        }
        List<Map<String, String>> currentUseMenus = this.getCurrentUseMenu(userId);
        if (CollectionUtils.isEmpty(currentUseMenus)) {
            return portalMenuInfos;
        }
        Set<String> appIds = currentUseMenus.stream().map(map -> (String)map.get("appId")).collect(Collectors.toSet());
        Set menuIds = currentUseMenus.stream().map(map -> (String)map.get("menuId")).collect(Collectors.toSet());
        List<String> markedMenus = this.getUserMarkedMenus(userId);
        Map<String, List<AppMenuInfo>> allMenuByAppIds = PortalAppMetaDataUtils.getAppIdAndAllMenuByAppIds(appIds);
        Map<String, AppMenuInfo> menuIdAndInfoMap = allMenuByAppIds.values().stream().flatMap(Collection::stream).filter(appMenuInfo -> menuIds.contains(appMenuInfo.getId())).collect(Collectors.toMap(AppMenuInfo::getId, i -> i, (k1, k2) -> k1));
        currentUseMenus.forEach(menuMap -> {
            String menuId = (String)menuMap.get("menuId");
            String appId = (String)menuMap.get("appId");
            if (StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)menuId)) {
                return;
            }
            try {
                AppMenuInfo menuInfo = (AppMenuInfo)menuIdAndInfoMap.get(menuId);
                if (menuInfo == null) {
                    return;
                }
                PortalMenuInfo portalMenuInfo = new PortalMenuInfo(menuId, menuId, menuInfo.getName().getLocaleValue(), menuInfo.getShortcutIcon(), appId, null);
                portalMenuInfo.setFavorite(markedMenus.contains(menuId));
                portalMenuInfos.add(portalMenuInfo);
            }
            catch (Exception e) {
                logger.info("getAppMenuInfo error", (Object)e);
            }
        });
        Map<String, Set<String>> userNoPermMenus = this.getHideMenuByAppIdsWithoutPerm(userId, appIds);
        List<PortalMenuInfo> filterResult = portalMenuInfos.stream().filter(portalMenuInfo -> hasPermAppIds.contains(portalMenuInfo.getAppId())).filter(portalMenuInfo -> {
            String appId = portalMenuInfo.getAppId();
            String menuId = portalMenuInfo.getMenuId();
            Set noPermMenus = (Set)userNoPermMenus.get(appId);
            return noPermMenus == null || !noPermMenus.contains(menuId);
        }).collect(Collectors.toList());
        this.addMenuGrayValid(filterResult);
        return filterResult;
    }

    public void addCurrentUseApp(String appId) {
        String currentAppStr;
        String result;
        Long userId = RequestContext.get().getCurrUserId();
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        DynamicObject currentAppObj = BusinessDataServiceHelper.loadSingle((String)"bos_portal_current_app", (String)"currentapp", (QFilter[])new QFilter[]{userFilter});
        if (currentAppObj == null) {
            currentAppObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_portal_current_app");
            currentAppObj.set("user", (Object)userId);
        }
        if ((result = this.addApp(currentAppStr = currentAppObj.getString("currentapp"), appId)) == null) {
            return;
        }
        currentAppObj.set("currentapp", (Object)result);
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{currentAppObj});
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
    }

    private String addApp(String currentAppStr, String appId) {
        List<Object> myCurrentAppList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)currentAppStr)) {
            String[] currentAppArr = currentAppStr.split(";");
            if (currentAppArr.length > 0 && currentAppArr[0].equals(appId)) {
                return null;
            }
            myCurrentAppList = Stream.of(currentAppArr).collect(Collectors.toList());
            myCurrentAppList.remove(appId);
            myCurrentAppList.add(0, appId);
        } else {
            myCurrentAppList.add(0, appId);
        }
        if (myCurrentAppList.size() > 7) {
            myCurrentAppList = myCurrentAppList.subList(0, 7);
        }
        String result = String.join((CharSequence)";", myCurrentAppList);
        return result;
    }

    public List<AppMenuInfo> getHasPermMenuByAppId(Long userId, String appId, boolean includeQingMenu) {
        HashSet<String> appIds = new HashSet<String>();
        appIds.add(appId);
        Map<String, List<AppMenuInfo>> hasPermMenuByAppId = this.getHasPermMenuByAppId(userId, appIds, includeQingMenu);
        return hasPermMenuByAppId.get(appId);
    }

    public Map<String, List<AppMenuInfo>> getHasPermMenuByAppId(Long userId, Set<String> appIds, boolean includeQingMenu) {
        Map<String, String> appNumAndIdMap = PortalAppMetaDataUtils.getAppNumAndIdMap(appIds);
        Map<String, List<AppMenuInfo>> menuByAppIds = PortalAppMetaDataUtils.getAppIdAndAllMenuByAppIds(appIds, appNumAndIdMap, includeQingMenu);
        Map<String, Set<String>> noPermMenuByAppIds = this.getNoPermMenuByAppIds(userId, appIds);
        Set<String> qingMenuParentId = null;
        if (includeQingMenu) {
            Map<String, List<AppMenuInfo>> qingMenuByAppIds = PortalAppMetaDataUtils.getQingMenuByAppIds(new ArrayList<String>(appIds));
            qingMenuParentId = this.getQingMenuParentId(menuByAppIds, appNumAndIdMap, qingMenuByAppIds);
        }
        if (qingMenuParentId == null) {
            qingMenuParentId = new HashSet<String>();
        }
        Map<String, List<AppMenuInfo>> hasPermAppMenus = PortalMenuService.getHasPermMenus(menuByAppIds, noPermMenuByAppIds, qingMenuParentId);
        return hasPermAppMenus;
    }

    private Set<String> getQingMenuParentId(Map<String, List<AppMenuInfo>> menuByAppIds, Map<String, String> appNumAndIdMap, Map<String, List<AppMenuInfo>> qingMenuByAppIds) {
        HashSet<String> qingMenuParentId = new HashSet<String>();
        try {
            for (Map.Entry<String, List<AppMenuInfo>> entry : qingMenuByAppIds.entrySet()) {
                String appNumber = entry.getKey();
                String id = appNumAndIdMap.get(appNumber);
                List<AppMenuInfo> qingMenuArray = entry.getValue();
                Set secondMenuIds = qingMenuArray.stream().filter(qing -> !((String)entry.getKey()).equals(qing.getParentId())).map(AppMenuInfo::getParentId).collect(Collectors.toSet());
                qingMenuParentId.addAll(secondMenuIds);
                if (secondMenuIds.isEmpty()) continue;
                List<AppMenuInfo> appMenuInfos = menuByAppIds.get(id);
                Set firstMenuIds = appMenuInfos.stream().filter(menu -> secondMenuIds.contains(menu.getId())).map(AppMenuInfo::getParentId).collect(Collectors.toSet());
                qingMenuParentId.addAll(firstMenuIds);
            }
        }
        catch (Exception e) {
            logger.info("getQingMenuParentId error", (Object)e);
        }
        return qingMenuParentId;
    }

    private static Map<String, List<AppMenuInfo>> getHasPermMenus(Map<String, List<AppMenuInfo>> allAppMenus, Map<String, Set<String>> noPermMenuByAppIds, Set<String> qingMenuParentId) {
        HashMap<String, List<AppMenuInfo>> hasPermAppMenus = new HashMap<String, List<AppMenuInfo>>(allAppMenus.size());
        for (Map.Entry<String, List<AppMenuInfo>> entry : allAppMenus.entrySet()) {
            Set<String> noPermMenus = noPermMenuByAppIds.get(entry.getKey());
            if (noPermMenus != null && noPermMenus.size() > 0) {
                List<AppMenuInfo> value = entry.getValue();
                List collect = value.stream().filter(Objects::nonNull).filter(v -> !noPermMenus.contains(v.getId()) || qingMenuParentId.contains(v.getId())).collect(Collectors.toList());
                if (collect == null || collect.size() <= 0) continue;
                hasPermAppMenus.put(entry.getKey(), collect);
                continue;
            }
            hasPermAppMenus.put(entry.getKey(), entry.getValue());
        }
        return hasPermAppMenus;
    }

    private Map<String, Set<String>> getAllMenuIdByAppIds(Set<String> appIds, boolean includeQingMenu) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(appIds.size());
        Map<String, List<AppMenuInfo>> allMenuByAppIds = PortalAppMetaDataUtils.getAppIdAndAllMenuByAppIds(appIds, includeQingMenu);
        if (allMenuByAppIds == null) {
            return result;
        }
        allMenuByAppIds.forEach((k, v) -> {
            Set menuIds = v.stream().map(AppMenuInfo::getId).collect(Collectors.toSet());
            result.put((String)k, menuIds);
        });
        return result;
    }

    public Map<String, Set<String>> getHideMenuByAppIdsWithoutPerm(Long userId, Set<String> appIds) {
        MenuFilterBuilder builder = new MenuFilterBuilder(userId);
        Map<String, Set<String>> blackMenuIds = builder.getBlackMenuIdsByAppIds(appIds);
        Map<String, Set<String>> hideMenuMap = builder.getHideMenuMap();
        Map<String, Set<String>> hideHelpMenuAndGrayMenu = builder.getHideHelpMenuAndGrayMenu(appIds);
        Map<String, Set<String>> bizAppHideMenuIdsByAppIds = builder.getBizAppHideMenuIdsByAppIds(appIds);
        Map<String, Set<String>> hideMenuIdsByBizAppIds = this.getHideMenuIdsByBizAppIds(userId, appIds);
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        Stream.of(blackMenuIds, hideMenuMap, hideHelpMenuAndGrayMenu, bizAppHideMenuIdsByAppIds, hideMenuIdsByBizAppIds).filter(Objects::nonNull).forEach(map -> map.forEach((k, v) -> resultMap.merge((String)k, (Set<String>)v, (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        })));
        return resultMap;
    }

    public Map<String, Set<String>> getNoPermMenuByAppIds(Long userId, Set<String> appIds) {
        MenuFilterBuilder builder = new MenuFilterBuilder(userId);
        Map<String, Set<String>> noPermMenuIds = builder.getNoPermMenuIdsByAppIds(appIds);
        Map<String, Set<String>> blackMenuIds = builder.getBlackMenuIdsByAppIds(appIds);
        Map<String, Set<String>> hideMenuMap = builder.getHideMenuMap();
        Map<String, Set<String>> hideHelpMenuAndGrayMenu = builder.getHideHelpMenuAndGrayMenu(appIds);
        Map<String, Set<String>> bizAppHideMenuIdsByAppIds = builder.getBizAppHideMenuIdsByAppIds(appIds);
        Map<String, Set<String>> hideMenuIdsByBizAppIds = this.getHideMenuIdsByBizAppIds(userId, appIds);
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        Stream.of(noPermMenuIds, blackMenuIds, hideMenuMap, hideHelpMenuAndGrayMenu, bizAppHideMenuIdsByAppIds, hideMenuIdsByBizAppIds).filter(Objects::nonNull).forEach(map -> map.forEach((k, v) -> resultMap.merge((String)k, (Set<String>)v, (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        })));
        return resultMap;
    }

    public Map<String, Set<String>> getHideMenuIdsByBizAppIds(Long userId, Set<String> appIds) {
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        Map<String, Set<String>> allMenuByAppIds = this.getAllMenuIdByAppIds(appIds, true);
        List facadeImpl = this.portalMenuFacade.getFacadeImpl();
        List<IPortalAppMenuFacade> plugins = this.getPortalAppMenuExtService();
        if (plugins != null && !plugins.isEmpty()) {
            facadeImpl.addAll(plugins);
        }
        facadeImpl.forEach(plugin -> {
            if (plugin != null) {
                Map data = null;
                try {
                    data = plugin.getHideMenuIdsByBizAppIds(userId, new HashMap(allMenuByAppIds));
                }
                catch (Exception e) {
                    logger.info("getHideMenuIdsByBizAppIds error", (Object)e);
                }
                logger.debug(String.format("plugin:%s, result:%s", plugin.getClass().getName(), JSONArray.toJSONString((Object)data)));
                if (data != null && data.size() > 0) {
                    data.forEach((k, v) -> resultMap.merge((String)k, (Set<String>)v, (v1, v2) -> {
                        v1.addAll(v2);
                        return v1;
                    }));
                }
            }
        });
        return resultMap;
    }

    private List<IPortalAppMenuFacade> getPortalAppMenuExtService() {
        List plugins = null;
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IPortalAppMenuFacade.class, (String)"BOS_SVC_PORTAL_MENU_PERM", null);
            plugins = pluginProxy.getPlugins();
        }
        catch (Exception e) {
            logger.info("getPortalSchemePermService error", (Object)e);
        }
        return plugins;
    }
}

