/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.service.IPortalSchemeExtService;
import kd.bos.portal.service.dto.CardEntityInfo;
import kd.bos.portal.service.dto.CardParams;
import kd.bos.portal.service.dto.CardResult;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class PortalSchemeService {
    private static List<String> filterCardTypeList = Stream.of("bos_card_quicklaunch", "bos_card_billstats", "bos_card_billstats_list", "bos_card_custom").collect(Collectors.toList());
    private static Log logger = LogFactory.getLog(PortalSchemeService.class);

    public Set<String> getHideCardIds(Map<String, CardResult> cardResults) {
        Set hideCardIds = null;
        if (cardResults != null) {
            hideCardIds = cardResults.values().stream().filter(cardResult -> {
                CardParams cardParams = cardResult.getCardParams();
                boolean isNeedHandle = cardResult.isNeedHandle();
                if (isNeedHandle && cardParams == null) {
                    return false;
                }
                boolean isDataEmpty = CollectionUtils.isEmpty(cardParams.getCardEntityInfos());
                boolean isQuickLaunch = "bos_card_quicklaunch".equals(cardParams.getCardType());
                return isNeedHandle && isDataEmpty && !isQuickLaunch;
            }).map(cardResult -> cardResult.getCardParams().getCardId()).collect(Collectors.toSet());
        }
        return hideCardIds;
    }

    public String hideCards(String layout, Set<String> cardIds) {
        if (CollectionUtils.isEmpty(cardIds)) {
            return layout;
        }
        List layoutList = (List)SerializationUtils.fromJsonString((String)layout, List.class);
        List filterLayoutList = layoutList.stream().filter(layoutMap -> !cardIds.contains(layoutMap.get("i").toString())).collect(Collectors.toList());
        return SerializationUtils.toJsonString(filterLayoutList);
    }

    public void filterCardConfig(Map<String, CardResult> cardResultMap, String cardId, Map<String, String> configMap) {
        block8: {
            Set hasPermMenuIds;
            String cardType;
            block7: {
                if (cardResultMap == null || configMap == null) {
                    return;
                }
                CardResult cardResult = cardResultMap.get(cardId);
                if (cardResult == null) {
                    return;
                }
                boolean isNeedHandle = cardResult.isNeedHandle();
                if (!isNeedHandle) {
                    return;
                }
                CardParams cardParams = cardResult.getCardParams();
                List<CardEntityInfo> cardEntityInfos = cardParams != null ? cardParams.getCardEntityInfos() : new ArrayList<CardEntityInfo>();
                cardType = configMap.get("cardType");
                hasPermMenuIds = cardEntityInfos.stream().map(CardEntityInfo::getMenuId).collect(Collectors.toSet());
                if (!"bos_card_billstats_list".equals(cardType)) break block7;
                Map<String, Object> billConfigInfo = CardUtils.getDetailConfigMap(configMap);
                if (billConfigInfo == null) {
                    return;
                }
                Iterator<Map.Entry<String, Object>> configIter = billConfigInfo.entrySet().iterator();
                while (configIter.hasNext()) {
                    Map.Entry<String, Object> valueObj = configIter.next();
                    Map itemMap = (Map)valueObj.getValue();
                    String billStatsMenuId = (String)itemMap.get("menuid");
                    if (hasPermMenuIds.contains(billStatsMenuId)) continue;
                    configIter.remove();
                }
                break block8;
            }
            if (!"bos_card_quicklaunch".equals(cardType)) break block8;
            Map<String, Object> configInfo = CardUtils.getDetailConfigMap(configMap);
            if (configInfo == null) {
                return;
            }
            Iterator<Map.Entry<String, Object>> configIter = configInfo.entrySet().iterator();
            while (configIter.hasNext()) {
                String menuId;
                Map.Entry<String, Object> valueObj = configIter.next();
                Map itemMap = (Map)valueObj.getValue();
                String launchType = (String)itemMap.get("launchType");
                if (!"launchType_menu".equalsIgnoreCase(launchType) || hasPermMenuIds.contains(menuId = (String)itemMap.get("cache_sel_menuId"))) continue;
                configIter.remove();
            }
        }
    }

    public List<IPortalSchemeExtService> getPortalSchemePermService() {
        List plugins = null;
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IPortalSchemeExtService.class, (String)"BOS_SVC_PORTAL_SCHEME_PERM", null);
            plugins = pluginProxy.getPlugins();
        }
        catch (Exception e) {
            logger.info("getPortalSchemePermService error", (Object)e);
        }
        return plugins;
    }

    public Map<String, CardResult> getPermFilterCardInfo(DynamicObject[] dynamicObjects) {
        List<IPortalSchemeExtService> plugins = this.getPortalSchemePermService();
        if (CollectionUtils.isEmpty(plugins)) {
            return null;
        }
        HashMap<String, CardResult> cardResultMap = new HashMap<String, CardResult>();
        ArrayList<CardParams> cardParams = new ArrayList<CardParams>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            List<CardEntityInfo> cardEntityInfos;
            Map configMap;
            String cardId = dynamicObject.getString("cardid");
            String cardType = dynamicObject.getString("cardtype");
            String configStr = dynamicObject.getString("config");
            if (StringUtils.isEmpty((String)cardId) || StringUtils.isEmpty((String)cardType)) continue;
            cardResultMap.put(cardId, new CardResult(false, new CardParams(cardId, cardType, null)));
            if (StringUtils.isEmpty((String)configStr)) continue;
            configStr = CardUtils.convertToPureJson(configStr);
            try {
                configMap = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
            }
            catch (Exception e) {
                logger.info("cardConfig parse error\uff1a", (Object)e);
                continue;
            }
            if (!filterCardTypeList.contains(cardType) || !CollectionUtils.isNotEmpty(cardEntityInfos = this.parseCardConfig(configMap))) continue;
            cardParams.add(new CardParams(cardId, cardType, cardEntityInfos));
        }
        if (cardParams.size() == 0) {
            return null;
        }
        plugins.forEach(plugin -> {
            List<CardResult> results = null;
            try {
                results = plugin.filterPortalSchemeCard(cardParams);
            }
            catch (Exception e) {
                logger.info("filterPortalSchemeCard", (Object)e);
            }
            if (CollectionUtils.isEmpty(results)) {
                return;
            }
            results.forEach(card -> this.replaceCardResultMap(cardResultMap, (CardResult)card));
        });
        return cardResultMap;
    }

    private void replaceCardResultMap(Map<String, CardResult> cardResultMap, CardResult card) {
        boolean isNeedHandle = card.isNeedHandle();
        CardParams cardData = card.getCardParams();
        if (!isNeedHandle || cardData == null) {
            return;
        }
        String cardId = cardData.getCardId();
        List<CardEntityInfo> cardEntityInfos = cardData.getCardEntityInfos();
        CardResult finalCardResult = cardResultMap.get(cardId);
        if (finalCardResult == null) {
            return;
        }
        boolean finalNeedHandle = finalCardResult.isNeedHandle();
        CardParams finalCardData = finalCardResult.getCardParams();
        if (finalNeedHandle && cardEntityInfos != null) {
            Set formNums = cardEntityInfos.stream().map(CardEntityInfo::getFormNum).collect(Collectors.toSet());
            List<CardEntityInfo> finalCardEntityInfos = finalCardData.getCardEntityInfos();
            List<CardEntityInfo> cardEntityInfoList = finalCardEntityInfos.stream().filter(cardEntityInfo -> formNums.contains(cardEntityInfo.getFormNum())).collect(Collectors.toList());
            finalCardData.setCardEntityInfos(cardEntityInfoList);
        } else {
            finalCardData.setCardEntityInfos(cardEntityInfos);
        }
        finalCardResult.setNeedHandle(isNeedHandle);
    }

    private List<CardEntityInfo> parseCardConfig(Map<String, String> configMap) {
        if (configMap == null) {
            return null;
        }
        ArrayList<CardEntityInfo> cardEntityInfos = new ArrayList<CardEntityInfo>();
        try {
            String cardType;
            switch (cardType = configMap.get("cardType")) {
                case "bos_card_custom": {
                    String customFormNum = configMap.get("cardformnum");
                    String customAppId = BizAppServiceHelp.getAppIdByFormNum((String)customFormNum);
                    cardEntityInfos.add(new CardEntityInfo(customAppId, null, customFormNum));
                    break;
                }
                case "bos_card_quicklaunch": {
                    Map<String, Object> configInfo = CardUtils.getDetailConfigMap(configMap);
                    if (configInfo == null) {
                        return null;
                    }
                    for (Object valueObj : configInfo.values()) {
                        Map itemMap = (Map)valueObj;
                        String launchType = (String)itemMap.get("launchType");
                        if (!"launchType_menu".equalsIgnoreCase(launchType)) continue;
                        String appId = (String)itemMap.get("cache_sel_appId");
                        String menuId = (String)itemMap.get("cache_sel_menuId");
                        cardEntityInfos.add(new CardEntityInfo(appId, menuId, ""));
                    }
                    break;
                }
                case "bos_card_billstats": {
                    CardEntityInfo cardEntityInfo = this.getBillStatsCardEntityInfo(configMap);
                    if (cardEntityInfo == null) break;
                    cardEntityInfos.add(cardEntityInfo);
                    break;
                }
                case "bos_card_billstats_list": {
                    Map<String, Object> billConfigInfo = CardUtils.getDetailConfigMap(configMap);
                    if (billConfigInfo == null) {
                        return null;
                    }
                    for (Object valueObj : billConfigInfo.values()) {
                        Map itemMap = (Map)valueObj;
                        CardEntityInfo cardEntityInfo1 = this.getBillStatsCardEntityInfo(itemMap);
                        if (cardEntityInfo1 == null) continue;
                        cardEntityInfos.add(cardEntityInfo1);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.info("parseCardConfig", (Object)e);
        }
        return cardEntityInfos;
    }

    private CardEntityInfo getBillStatsCardEntityInfo(Map<String, String> configMap) {
        String billStatsFormNum = configMap.get("entityid");
        String billStatsMenuId = configMap.get("menuid");
        String billStatsAppNum = configMap.get("appnum");
        try {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)billStatsAppNum);
            if (appInfo != null) {
                String billStatsAppId = appInfo.getId();
                return new CardEntityInfo(billStatsAppId, billStatsMenuId, billStatsFormNum);
            }
        }
        catch (Exception e) {
            logger.info("getBillStatsCardEntityInfo", (Object)e);
        }
        return null;
    }
}

