/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.service;

import kd.bos.base.parameter.ParameterService;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.model.BrandUpEnum;
import kd.bos.portal.service.ExtLoginConfigService;
import kd.bos.portal.util.LogoUtils;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;

public class UseLoginConfigService {
    private static Log logger = LogFactory.getLog(UseLoginConfigService.class);
    private ExtLoginConfigService extLoginConfigService;

    public UseLoginConfigService() {
        this(new ExtLoginConfigService());
    }

    public UseLoginConfigService(ExtLoginConfigService extLoginConfigService) {
        this.extLoginConfigService = extLoginConfigService;
    }

    public String getCustomLogo(String appNumber) {
        String customUrl = LogoUtils.getCustomLogo();
        if (StringUtils.isNotEmpty((String)customUrl)) {
            return customUrl;
        }
        if (StringUtils.isNotEmpty((String)appNumber) && StringUtils.isNotEmpty((String)(customUrl = this.getBrandUpLogo(appNumber)))) {
            return customUrl;
        }
        customUrl = LogoUtils.getLoginConfigLogo();
        if (StringUtils.isNotEmpty((String)customUrl)) {
            return UrlService.getCheckAuthImageUrl((String)customUrl);
        }
        try {
            customUrl = this.extLoginConfigService.getMainPageLogoData(RequestContext.get().getLang().name());
        }
        catch (Exception e) {
            logger.info("UseLoginConfigService--getMainPageLogoData error", (Object)e);
        }
        if (StringUtils.isNotEmpty((String)customUrl)) {
            return customUrl;
        }
        return LogoUtils.getDefaultLogo();
    }

    private String getBrandUpLogo(String appNumber) {
        boolean isBrandUp;
        boolean isNewPortal = ParameterService.isSupportNewPortal();
        boolean bl = isBrandUp = !isNewPortal && BrandUpEnum.getAppNumbers(appNumber) != null;
        if (isBrandUp) {
            return BrandUpEnum.getImgUrl(appNumber);
        }
        return null;
    }
}

