/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.service.bo.Version;

public class VersionService {
    private static Log logger = LogFactory.getLog(VersionService.class);
    public static final String COSMIC_BOS = "cosmic_bos";
    public static final String COSMIC_BIZ = "cosmic_biz";
    public static final String CCS_PREFIX = "constellation_";

    public static int getVersionCount() {
        String sql = "select fproductnumber from t_bas_industry_version where fproductnumber = 'cosmic_bos' or fproductnumber like 'constellation_%';";
        return (Integer)DB.query((DBRoute)DBRoute.meta, (String)sql, resultSet -> {
            int i = 0;
            boolean isCcsFirstCount = true;
            while (resultSet.next()) {
                String fproductnumber = resultSet.getString("fproductnumber");
                if (fproductnumber.startsWith(CCS_PREFIX) && isCcsFirstCount) {
                    isCcsFirstCount = false;
                    ++i;
                    continue;
                }
                if (!fproductnumber.equals(COSMIC_BOS)) continue;
                ++i;
            }
            return i;
        });
    }

    public static List<Version> getVersionInfos() {
        String sql = "select fid, fproductnumber, fversion, fupgradetime from t_bas_industry_version where fproductnumber = 'cosmic_bos' or fproductnumber like 'constellation_%';";
        ArrayList<Version> versions = new ArrayList<Version>();
        try {
            List allVersion = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, resultSet -> {
                ArrayList<Version> result = new ArrayList<Version>(resultSet.getRow());
                while (resultSet.next()) {
                    Version version = new Version();
                    version.setId(resultSet.getString("fid"));
                    version.setVersion(resultSet.getString("fversion"));
                    version.setProductNumber(resultSet.getString("fproductnumber"));
                    version.setUpgradeTime(resultSet.getDate("fupgradetime"));
                    result.add(version);
                }
                return result;
            });
            for (Version version : allVersion) {
                if (!COSMIC_BOS.equals(version.getProductNumber())) continue;
                versions.add(version);
                break;
            }
            allVersion.removeAll(versions);
            allVersion.stream().max(VersionService.versionComparator()).ifPresent(versions::add);
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u53d1\u5e03\u7248\u672c\u4fe1\u606f\u5f02\u5e38...", (Object)e);
        }
        return versions;
    }

    private static Comparator<Version> versionComparator() {
        Comparator comparator = (o1, o2) -> {
            String ver2;
            String ver1 = o1.getVersion();
            if (ver1.equals(ver2 = o2.getVersion())) {
                return 0;
            }
            String[] verArr1 = ver1.split("\\.");
            String[] verArr2 = ver2.split("\\.");
            int maxflag = 1;
            int minLen = 0;
            if (verArr1.length > verArr2.length) {
                minLen = verArr2.length;
            } else {
                minLen = verArr1.length;
                maxflag = 2;
            }
            try {
                for (int i = 0; i < minLen; ++i) {
                    if (Integer.parseInt(verArr1[i]) - Integer.parseInt(verArr2[i]) > 0) {
                        return 1;
                    }
                    if (Integer.parseInt(verArr1[i]) - Integer.parseInt(verArr2[i]) >= 0) continue;
                    return -1;
                }
                if (maxflag == 1) {
                    for (int j = minLen; j < verArr1.length; ++j) {
                        if (Integer.parseInt(verArr1[j]) <= 0) continue;
                        return 1;
                    }
                } else {
                    for (int k = minLen; k < verArr2.length; ++k) {
                        if (Integer.parseInt(verArr2[k]) <= 0) continue;
                        return -1;
                    }
                }
            }
            catch (Exception e) {
                logger.info("versionComparator error", (Object)e);
            }
            return 0;
        };
        return comparator;
    }
}

