/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.service.bo;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.util.PortalAppMetaDataUtils;
import kd.bos.portal.util.TenantUtils;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.portal.InitailVersionServiceHelper;

public class MenuFilterBuilder {
    private static Log logger = LogFactory.getLog(MenuFilterBuilder.class);
    private Long userId;
    private Boolean isAdmin;
    private List<String> hideMenuIds;
    private Map<String, List<String>> blackMenuIdMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> noPermMenuIdMap = new HashMap<String, List<String>>();
    private Boolean isGray;
    private Boolean hideHelpMenu;

    public MenuFilterBuilder(Long userId) {
        this.userId = userId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public boolean isAdmin() {
        if (this.isAdmin == null) {
            this.isAdmin = PermissionServiceHelper.isAdminUser((long)this.userId);
        }
        return this.isAdmin;
    }

    public List<String> getHideMenuIds() {
        if (this.hideMenuIds == null) {
            this.hideMenuIds = CardUtils.getHideMenus();
        }
        return this.hideMenuIds;
    }

    public List<String> getBlackMenuIds(String appId) {
        List<String> blackMenuIds = this.blackMenuIdMap.get(appId);
        if (!this.blackMenuIdMap.containsKey(appId)) {
            blackMenuIds = CardUtils.getProductBlackMenus(appId);
            this.blackMenuIdMap.put(appId, blackMenuIds);
        }
        return blackMenuIds;
    }

    public List<String> getNoPermMenuIds(String appId) {
        List noPermMenuIds = this.noPermMenuIdMap.get(appId);
        if (!this.noPermMenuIdMap.containsKey(appId)) {
            noPermMenuIds = PermissionServiceHelper.getAllNoPermMenuIdsByAppId((Long)this.userId, (String)appId);
            this.noPermMenuIdMap.put(appId, noPermMenuIds);
        }
        return noPermMenuIds;
    }

    public boolean isGray() {
        if (this.isGray == null) {
            try {
                this.isGray = LoginMCService.create().getGrayEnvironmentInfo();
            }
            catch (Exception e) {
                logger.info("check grayEnv error", (Object)e);
                return false;
            }
        }
        return this.isGray;
    }

    public boolean isHideHelpMenu() {
        if (this.hideHelpMenu == null) {
            Object showHelpMenu = BaseAppParameterServiceHelper.getParameterFromCache((String)"knowledge_search");
            this.hideHelpMenu = showHelpMenu != null && !Boolean.parseBoolean(showHelpMenu.toString());
        }
        return this.hideHelpMenu;
    }

    public static List<String> getBizAppHideMenuIds(String appId) {
        boolean isMaster;
        ArrayList<String> hideMenuIds = new ArrayList<String>();
        if ("18XR3MJ0W0ET".equals(appId) || "cts".equals(appId)) {
            boolean enableLayoutScheme = Boolean.parseBoolean(System.getProperty("layoutscheme.on"));
            if (!enableLayoutScheme) {
                hideMenuIds.add("1072471504165288960");
                return hideMenuIds;
            }
        } else if ("18XSXYEL8//U".equals(appId) || "sys".equals(appId)) {
            boolean isNewTenant = InitailVersionServiceHelper.isInitailVersion((int)6);
            if (isNewTenant) {
                hideMenuIds.add("1736897837687394304");
                return hideMenuIds;
            }
        } else if ("0YOU37+ILDX8".equals(appId) || "integ".equals(appId)) {
            boolean oemEnv = DevVerifyServiceHelper.isOEMEnv();
            if (oemEnv) {
                hideMenuIds.add("1715289043987748864");
                return hideMenuIds;
            }
        } else if (("3J+CLX26ZXMO".equals(appId) || "ctsy".equals(appId)) && !(isMaster = TenantUtils.isMasterTenant())) {
            hideMenuIds.add("1768955468132137984");
            hideMenuIds.add("1766577314382006272");
            hideMenuIds.add("1778410935900235776");
            hideMenuIds.add("1931857980592685056");
            hideMenuIds.add("1970954523043070976");
            return hideMenuIds;
        }
        return hideMenuIds;
    }

    public Map<String, Set<String>> getBlackMenuIdsByAppIds(Set<String> appIds) {
        HashMap<String, Set<String>> blackMenuIdSetMap = new HashMap<String, Set<String>>();
        if (CollectionUtils.isEmpty(appIds)) {
            return blackMenuIdSetMap;
        }
        if (appIds.size() == 1) {
            String appId2 = new ArrayList<String>(appIds).get(0);
            List<String> productBlackMenus = CardUtils.getProductBlackMenus(appId2);
            blackMenuIdSetMap.put(appId2, new HashSet<String>(productBlackMenus));
            return blackMenuIdSetMap;
        }
        try {
            Map allAppInfo = AppMetadataCache.getAllAppInfo();
            HashMap<String, String> appAndCloudIdMap = new HashMap<String, String>();
            for (AppInfo appInfo : allAppInfo.values()) {
                if (!appIds.contains(appInfo.getId())) continue;
                appAndCloudIdMap.put(appInfo.getId(), appInfo.getCloudId());
            }
            ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
            Map blackMenuAndApp = service.getBlackMenuAndApp(appAndCloudIdMap);
            if (CollectionUtils.isEmpty((Map)blackMenuAndApp)) {
                return blackMenuIdSetMap;
            }
            List blackAppIds = (List)blackMenuAndApp.get("blackAppIds");
            List blackMenus = (List)blackMenuAndApp.get("blackMenus");
            Map<String, List<AppMenuInfo>> allMenuByAppIds = PortalAppMetaDataUtils.getAppIdAndAllMenuByAppIds(new HashSet<String>(blackAppIds), false);
            appIds.forEach(appId -> {
                if (blackAppIds.contains(appId)) {
                    List appMenuInfoList = (List)allMenuByAppIds.get(appId);
                    if (!CollectionUtils.isEmpty((Collection)appMenuInfoList)) {
                        Set menuIds = appMenuInfoList.stream().map(AppMenuInfo::getId).collect(Collectors.toSet());
                        blackMenuIdSetMap.put((String)appId, menuIds);
                    }
                } else if (blackMenus != null) {
                    blackMenuIdSetMap.put((String)appId, new HashSet(blackMenus));
                }
            });
        }
        catch (Exception e) {
            logger.info("getBlackMenuAndApp error", (Object)e);
        }
        return blackMenuIdSetMap;
    }

    public Map<String, Set<String>> getNoPermMenuIdsByAppIds(Set<String> appIds) {
        Map noPermMenus = PermissionServiceHelper.getUserNoPermMenuByBatchApp((Long)this.userId, appIds);
        logger.debug("getNoPermMenuIdsByAppIds result:" + JSONArray.toJSONString((Object)noPermMenus));
        return noPermMenus;
    }

    public Map<String, Set<String>> getBizAppHideMenuIdsByAppIds(Set<String> appIds) {
        HashMap<String, Set<String>> hideMenuMap = new HashMap<String, Set<String>>();
        appIds.forEach(appId -> {
            List<String> bizAppHideMenuIds = MenuFilterBuilder.getBizAppHideMenuIds(appId);
            if (!CollectionUtils.isEmpty(bizAppHideMenuIds)) {
                hideMenuMap.put((String)appId, (Set<String>)new HashSet<String>(bizAppHideMenuIds));
            }
        });
        return hideMenuMap;
    }

    public Map<String, Set<String>> getHideHelpMenuAndGrayMenu(Set<String> appIds) {
        Map<String, List<AppMenuInfo>> allAppMenus = PortalAppMetaDataUtils.getAppIdAndAllMenuByAppIds(appIds, false);
        HashMap<String, Set<String>> hideHelpMenuAndGrayMenuMap = new HashMap<String, Set<String>>();
        allAppMenus.keySet().forEach(appId -> {
            try {
                List menusInfos = (List)allAppMenus.get(appId);
                Set hideHelpMenuAndGrayMenu = menusInfos.stream().filter(menuInfo -> {
                    String formId = menuInfo.getFormId();
                    if (this.isHideHelpMenu() && "bas_appstarted".equals(formId)) {
                        return true;
                    }
                    if ("gated_launch_user".equals(formId)) {
                        if (!this.isAdmin()) {
                            return true;
                        }
                        if (!this.isGray()) {
                            return true;
                        }
                    }
                    return false;
                }).map(AppMenuInfo::getId).collect(Collectors.toSet());
                hideHelpMenuAndGrayMenuMap.put((String)appId, hideHelpMenuAndGrayMenu);
            }
            catch (Exception e) {
                logger.info("getHideHelpMenuAndGrayMenu error", (Object)e);
            }
        });
        return hideHelpMenuAndGrayMenuMap;
    }

    public Map<String, Set<String>> getHideMenuMap() {
        HashMap<String, Set<String>> hideMenuMap = new HashMap<String, Set<String>>();
        HashSet<String> data = new HashSet<String>(CardUtils.getHideMenus());
        hideMenuMap.put("83bfebc8000037ac", data);
        hideMenuMap.put("18XSXYEL8//U", data);
        return hideMenuMap;
    }
}

