/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.service.bo;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.portal.service.factory.MenuModeFactory;
import kd.bos.portal.util.PortalUsableFuncUtil;
import org.apache.commons.lang3.StringUtils;

public class OpenPageContext {
    private String appNumber;
    private String menuId;
    private Map<String, Object> parameter;
    private IFormView mainView;
    private IFormView currentView;
    private String appName;
    private AppInfo appInfo;
    private AppMenuInfo appMenuInfo;
    private boolean isAppHome = false;
    private String formNumber;

    public OpenPageContext(String appNumber, String menuId, Map<String, Object> parameter, IFormView currentView, String customAppName) {
        this.appNumber = appNumber;
        this.appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        this.menuId = menuId;
        this.currentView = currentView;
        if (StringUtils.isBlank((CharSequence)customAppName)) {
            customAppName = OpenPageContext.getAppSelfName(currentView, appNumber);
        }
        this.appName = customAppName;
        if (StringUtils.isBlank((CharSequence)this.appName)) {
            this.appName = this.appInfo.getName().getLocaleValue();
        }
        this.mainView = this.getMainPageView(currentView);
        if (menuId != null) {
            this.appMenuInfo = AppMetadataCache.getAppMenuInfo((String)appNumber, (String)menuId);
        }
        this.initParameter(parameter);
        this.initMenuType();
    }

    private static String getAppSelfName(IFormView myappView, String appNum) {
        PortalUsableFuncUtil portalUtil = new PortalUsableFuncUtil(myappView);
        return portalUtil.getAppSelfName(appNum);
    }

    private void initParameter(Map<String, Object> map) {
        boolean result;
        String appName = this.appName;
        String appMainNumber = this.appInfo.getHomeNum();
        if (StringUtils.isBlank((CharSequence)appName)) {
            appName = this.appInfo.getNumber();
        }
        String cloudNum = this.appInfo.getCloudNum();
        String mainFormId = this.mainView.getFormShowParameter().getFormId();
        boolean bl = result = "home_page".equals(mainFormId) && !"DATA".equalsIgnoreCase(cloudNum) && !appName.endsWith(ResManager.loadKDString((String)"\u5de5\u4f5c\u53f0", (String)"OpenPageContext_1", (String)"bos-portal-plugin", (Object[])new Object[0]));
        if (result && MenuModeFactory.tileMenuModeEnable()) {
            appName = String.format(ResManager.loadKDString((String)"%1$s\u5de5\u4f5c\u53f0", (String)"OpenPageContext_0", (String)"bos-portal-plugin", (Object[])new Object[0]), appName);
        }
        if (map == null) {
            map = new HashMap<String, Object>();
            map.put("view", this.currentView);
            map.put("appmainnumber", appMainNumber);
        }
        map.put("appname", appName);
        map.put("appImageUrl", this.appInfo.getImage());
        if (this.appMenuInfo != null) {
            map.put("formnumber", this.appMenuInfo.getFormId());
            Object permItem = map.get("permItem");
            if (permItem == null) {
                map.put("permItem", this.appMenuInfo.getPermission());
            }
        }
        this.parameter = map;
    }

    private void initMenuType() {
        this.formNumber = (String)this.parameter.get("formnumber");
        String menuType = "page";
        if (StringUtils.isNotBlank((CharSequence)this.menuId) && this.appMenuInfo != null) {
            menuType = this.appMenuInfo.getMenuType();
        }
        String appMainNumber = this.appInfo.getHomeNum();
        if ("page".equals(menuType)) {
            if (StringUtils.isBlank((CharSequence)this.formNumber)) {
                this.formNumber = appMainNumber;
                this.isAppHome = true;
            } else if (this.formNumber.equals(appMainNumber)) {
                this.isAppHome = true;
            }
        }
    }

    private IFormView getMainPageView(IFormView view) {
        String rootPageId;
        IFormView mainPageView = view.getMainView();
        if (mainPageView == null && (mainPageView = view.getView(rootPageId = view.getFormShowParameter().getRootPageId())) == null) {
            throw new KDException(new ErrorCode("mainView is null", "mainView is null"), new Object[0]);
        }
        return mainPageView;
    }

    public AppInfo getAppInfo() {
        return this.appInfo;
    }

    public IFormView getMainView() {
        return this.mainView;
    }

    public IFormView getCurrentView() {
        return this.currentView;
    }

    public String getAppNumber() {
        return this.appNumber;
    }

    public String getMenuId() {
        return this.menuId;
    }

    public String getAppName() {
        return this.appName;
    }

    public Map<String, Object> getParameter() {
        return this.parameter;
    }

    public AppMenuInfo getAppMenuInfo() {
        return this.appMenuInfo;
    }

    public boolean isAppHome() {
        return this.isAppHome;
    }

    public String getFormNumber() {
        return this.formNumber;
    }
}

