/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.service.impl;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.portal.service.MenuModeServiceAbstract;
import kd.bos.portal.service.bo.OpenPageContext;

public class AppMenuModeServiceImpl
extends MenuModeServiceAbstract {
    private static AppMenuModeServiceImpl instance = new AppMenuModeServiceImpl();

    public static AppMenuModeServiceImpl getInstance() {
        return instance;
    }

    @Override
    protected String getShowFormTargetKey() {
        return "_submaintab_";
    }

    @Override
    protected void openAppMenuProcess(OpenPageContext openPageContext) {
        this.showAppWithOpenType(openPageContext);
        this.doOpenMenu(openPageContext);
        openPageContext.getMainView().getPageCache().remove("Portal_LicenseGrayNotice_" + openPageContext.getAppNumber());
    }

    @Override
    protected boolean limitOpenPageNumber(OpenPageContext openPageContext, boolean isOpenApp) {
        int count;
        if (!isOpenApp) {
            return true;
        }
        IFormView mainPageView = openPageContext.getMainView();
        IPageCache homepagePageCache = (IPageCache)mainPageView.getService(IPageCache.class);
        String homepageTabapCount = homepagePageCache.get("homepage_tabap_count");
        int n = count = homepageTabapCount == null ? 3 : Integer.parseInt(homepageTabapCount);
        if (count >= 13) {
            mainPageView.showMessage(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u540c\u65f6\u6253\u5f0010\u4e2a\u5e94\u7528\u3002", (String)"OpenPageUtils_3", (String)"bos-portal-plugin", (Object[])new Object[0]));
            openPageContext.getCurrentView().sendFormAction(mainPageView);
            return false;
        }
        return true;
    }

    @Override
    protected void showMenuPage(OpenPageContext openPageContext, FormShowParameter fsp) {
        String appNumber = openPageContext.getAppNumber();
        IFormView mainPageView = openPageContext.getMainView();
        IFormView view = openPageContext.getCurrentView();
        String appPageId = appNumber + mainPageView.getPageId();
        IFormView appPageView = mainPageView.getViewNoPlugin(appPageId);
        if (appPageView != null) {
            List pluginList;
            if (appPageView.getPageId().equalsIgnoreCase(view.getPageId())) {
                appPageView = view;
            }
            if ((pluginList = ((FormViewPluginProxy)appPageView.getService(FormViewPluginProxy.class)).getPlugIns()) != null && pluginList.size() > 0) {
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)pluginList.get(0), "close_menupage"));
            }
            if (view.getPageId().equals(appPageView.getPageId())) {
                view.showForm(fsp);
            } else {
                appPageView.showForm(fsp);
                view.sendFormAction(appPageView);
            }
        } else {
            this.showPageTips(view);
        }
    }

    private void showPageTips(IFormView view) {
        List acts = view.getActionResult();
        if (acts != null && !acts.isEmpty()) {
            HashMap<String, Object> arg = new HashMap<String, Object>(2);
            arg.put("pageId", view.getPageId());
            arg.put("actions", acts);
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction("sendDynamicFormAction", arg);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u91cd\u65b0\u767b\u5f55\u3002", (String)"OpenPageUtils_9", (String)"bos-portal-plugin", (Object[])new Object[0]));
        }
    }
}

